/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.BinaryServerRowInput;
import org.hsqldb.Database;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseScriptReader;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class BinaryDatabaseScriptReader
extends DatabaseScriptReader {
    BinaryServerRowInput rowIn = new BinaryServerRowInput();

    BinaryDatabaseScriptReader(Database database, String string) throws HsqlException, IOException {
        super(database, string);
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        this.rowIn.setSystemId(false);
        this.readSingleColumnResult(session);
    }

    protected void readSingleColumnResult(Session session) throws IOException, HsqlException {
        Result result = Result.read(this.rowIn, this.dataStreamIn);
        Record record = result.rRoot;
        while (record != null) {
            String string = (String)record.data[0];
            session.sqlExecuteDirectNoPreChecks(string);
            record = record.next;
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        String string;
        this.rowIn.setSystemId(true);
        while ((string = this.readTableInit()) != null) {
            Table table = this.db.getTable(string, session);
            int n = 0;
            n = 0;
            while (this.readRow(table)) {
                ++n;
            }
            int n2 = this.readTableTerm();
            if (n == n2) continue;
            throw Trace.error(78, 96, new Object[]{string, new Integer(n), new Integer(n2)});
        }
    }

    protected boolean readRow(Table table) throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0, this.dataStreamIn);
        if (!bl) {
            return false;
        }
        Object[] objectArray = this.rowIn.readData(table.getColumnTypes());
        table.insertNoCheck(objectArray, null, false);
        return true;
    }

    protected int readTableTerm() throws IOException, HsqlException {
        this.rowIn.reset();
        int n = 0;
        int n2 = 4;
        while (this.dataStreamIn.available() > 0 && n < n2) {
            n += this.dataStreamIn.read(this.rowIn.getBuffer(), n, n2 - n);
        }
        return this.rowIn.readInt();
    }

    protected String readTableInit() throws IOException, HsqlException {
        boolean bl = this.readRow(this.rowIn, 0, this.dataStreamIn);
        if (!bl) {
            return null;
        }
        String string = this.rowIn.readString();
        int n = this.rowIn.readIntData();
        if (n != 0) {
            throw Trace.error(78, 97, null);
        }
        return string;
    }

    boolean readRow(DatabaseRowInput databaseRowInput, int n, InputStream inputStream) throws IOException {
        databaseRowInput.reset();
        int n2 = 0;
        int n3 = 4;
        while (inputStream.available() > 0 && n2 < n3) {
            n2 += this.dataStreamIn.read(databaseRowInput.getBuffer(), n2, n3 - n2);
        }
        n3 = databaseRowInput.readInt();
        if (n3 == 0) {
            return false;
        }
        databaseRowInput.resetRow(n, n3);
        while (inputStream.available() > 0 && n2 < n3) {
            n2 += this.dataStreamIn.read(databaseRowInput.getBuffer(), n2, n3 - n2);
        }
        return true;
    }
}

