/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Binary;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.store.ValuePool;

class BinaryServerRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    BinaryServerRowOutput out;

    public BinaryServerRowInput() {
    }

    public BinaryServerRowInput(byte[] byArray) {
        super(byArray);
    }

    public BinaryServerRowInput(BinaryServerRowOutput binaryServerRowOutput) {
        super(binaryServerRowOutput.getBuffer());
        this.out = binaryServerRowOutput;
    }

    protected byte[] readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public int readType() throws IOException {
        return this.readShort();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public String readString() throws IOException {
        int n = this.readInt();
        String string = StringConverter.readUTF(this.buf, this.pos, n);
        string = ValuePool.getString(string);
        this.pos += n;
        return string;
    }

    protected boolean checkNull() throws IOException {
        byte by = this.readByte();
        return by == 0;
    }

    protected String readChar(int n) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        return ValuePool.getInt(this.readShort());
    }

    protected Integer readInteger() throws IOException, HsqlException {
        return ValuePool.getInt(this.readInt());
    }

    protected Long readBigint() throws IOException, HsqlException {
        return ValuePool.getLong(this.readLong());
    }

    protected Double readReal(int n) throws IOException, HsqlException {
        return ValuePool.getDouble(this.readLong());
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        byte[] byArray = this.readByteArray();
        int n = this.readInt();
        BigInteger bigInteger = new BigInteger(byArray);
        return ValuePool.getBigDecimal(new BigDecimal(bigInteger, n));
    }

    protected Boolean readBit() throws IOException, HsqlException {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Time readTime() throws IOException, HsqlException {
        return new Time(this.readLong());
    }

    protected Date readDate() throws IOException, HsqlException {
        return ValuePool.getDate(this.readLong());
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        return HsqlDateTime.timestampValue(this.readLong(), this.readInt());
    }

    protected Object readOther() throws IOException, HsqlException {
        return new JavaObject(this.readByteArray(), true);
    }

    protected Binary readBinary(int n) throws IOException, HsqlException {
        return new Binary(this.readByteArray(), true);
    }

    public void resetRow(int n) {
        if (this.out != null) {
            this.out.reset(n);
            this.buf = this.out.getBuffer();
        }
        super.reset();
    }

    public void resetRow(int n, int n2) throws IOException {
        if (this.out != null) {
            this.out.reset(n2);
            this.buf = this.out.getBuffer();
        }
        super.resetRow(n, n2);
    }
}

