/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.CacheFree;
import org.hsqldb.CachedRow;
import org.hsqldb.DataFileCache;
import org.hsqldb.Database;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.TextCache;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;
import org.hsqldb.lib.StopWatch;

abstract class Cache {
    static final int CACHE_TYPE_DATA = 0;
    static final int CACHE_TYPE_TEXT = 1;
    static final int CACHE_TYPE_REVERSE_TEXT = 2;
    int currentAccessCount;
    int firstAccessCount;
    protected Database dDatabase;
    protected HsqlDatabaseProperties dbProps;
    protected String sName;
    protected boolean storeOnInsert;
    boolean cacheReadonly;
    boolean fileModified;
    int cacheScale;
    int cacheSizeScale;
    int cacheFileScale;
    int cachedRowPadding = 8;
    int cachedRowType = 0;
    int rowStoreExtra;
    int cacheLength;
    int maxCacheSize;
    long maxCacheBytes;
    int multiplierMask;
    private CachedRowComparator rowComparator;
    private CachedRow[] rowTable;
    private CachedRow[] rData;
    private int[] accessCount;
    static final int FREE_POS_POS = 16;
    static final int INITIAL_FREE_POS = 32;
    static final int ROW_STORE_EXTRA_160 = 8;
    static final int ROW_STORE_EXTRA_170 = 4;
    protected ScaledRAFile rFile;
    protected int iFreePos;
    private CachedRow rFirst;
    private CachedRow rLastChecked;
    CacheFree fRoot;
    int iFreeCount;
    int iCacheSize;
    DatabaseRowInputInterface rowIn;
    DatabaseRowOutputInterface rowOut;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch makeRowTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int makeRowCount = 0;
    int saveRowCount = 0;

    static Cache newCache(String string, Database database, int n) throws HsqlException {
        switch (n) {
            case 0: {
                return new DataFileCache(string, database);
            }
            case 1: 
            case 2: {
                return new TextCache(string, database);
            }
        }
        return null;
    }

    Cache(String string, Database database) throws HsqlException {
        this.sName = string;
        this.dDatabase = database;
        this.dbProps = database.getProperties();
        this.initParams();
        this.init();
    }

    protected void initParams() throws HsqlException {
        this.cacheScale = this.dbProps.getIntegerProperty("hsqldb.cache_scale", 14, 8, 16);
        this.cacheSizeScale = this.dbProps.getIntegerProperty("hsqldb.cache_size_scale", 20, 8, 20);
        this.cacheFileScale = this.dbProps.getIntegerProperty("hsqldb.cache_file_scale", 1, 1, 8);
        if (this.cacheFileScale != 8) {
            this.cacheFileScale = 1;
        }
        Trace.printSystemOut("cache_scale: " + this.cacheScale);
        Trace.printSystemOut("cache_size_scale: " + this.cacheSizeScale);
    }

    protected void init() {
        this.cacheReadonly = this.dDatabase.filesReadOnly;
        this.cacheLength = 1 << this.cacheScale;
        this.maxCacheSize = this.cacheLength * 3;
        this.maxCacheBytes = this.cacheLength * this.cacheSizeScale;
        this.multiplierMask = this.cacheLength - 1;
        this.rowComparator = new CachedRowComparator();
        this.accessCount = new int[this.maxCacheSize];
        this.rowTable = new CachedRow[this.maxCacheSize];
        this.rData = new CachedRow[this.cacheLength];
        this.rFirst = null;
        this.rLastChecked = null;
        this.iFreePos = 0;
        this.fRoot = null;
        this.iFreeCount = 0;
        this.iCacheSize = 0;
    }

    protected void initBuffers() throws HsqlException {
        this.rowOut = DatabaseRowOutput.newDatabaseRowOutput(this.cachedRowType);
        this.rowIn = DatabaseRowInput.newDatabaseRowInput(this.cachedRowType);
        this.rowIn.setSystemId(true);
        this.rowStoreExtra = this.rowOut instanceof BinaryServerRowOutput ? 4 : 8;
    }

    abstract void open(boolean var1) throws HsqlException;

    abstract void close() throws HsqlException;

    abstract void defrag() throws HsqlException;

    abstract void closeFile() throws HsqlException;

    abstract void free(CachedRow var1) throws HsqlException;

    protected void setStorageSize(CachedRow cachedRow) throws HsqlException {
        Table table = cachedRow.getTable();
        int n = this.rowStoreExtra + 16 * table.getIndexCount();
        n += this.rowOut.getSize(cachedRow);
        cachedRow.storageSize = n = (n + this.cachedRowPadding - 1) / this.cachedRowPadding * this.cachedRowPadding;
    }

    void add(CachedRow cachedRow) throws HsqlException {
        this.fileModified = true;
        if (this.iCacheSize >= this.maxCacheSize) {
            this.cleanUp();
        }
        this.setStorageSize(cachedRow);
        cachedRow.iLastAccess = this.currentAccessCount++;
        int n = this.setFilePos(cachedRow);
        int n2 = n >> 3 & this.multiplierMask;
        CachedRow cachedRow2 = this.rData[n2];
        if (cachedRow2 == null) {
            cachedRow2 = this.rFirst;
        }
        cachedRow.insert(cachedRow2);
        try {
            if (this.storeOnInsert) {
                this.saveRow(cachedRow);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
        ++this.iCacheSize;
        this.rData[n2] = cachedRow;
        this.rFirst = cachedRow;
    }

    abstract int setFilePos(CachedRow var1) throws HsqlException;

    protected abstract CachedRow makeRow(int var1, Table var2) throws HsqlException;

    CachedRow getRow(int n, Table table) throws HsqlException {
        CachedRow cachedRow = this.getRow(n);
        if (cachedRow != null) {
            cachedRow.iLastAccess = this.currentAccessCount++;
            return cachedRow;
        }
        if (this.iCacheSize >= this.maxCacheSize) {
            this.cleanUp();
        }
        this.makeRowTimer.start();
        cachedRow = this.makeRow(n, table);
        this.makeRowTimer.stop();
        if (cachedRow == null) {
            return cachedRow;
        }
        int n2 = cachedRow.iPos >> 3 & this.multiplierMask;
        CachedRow cachedRow2 = this.rData[n2];
        if (cachedRow2 == null) {
            cachedRow2 = this.rFirst;
        }
        if (cachedRow != null) {
            cachedRow.insert(cachedRow2);
            ++this.iCacheSize;
            this.rData[n2] = cachedRow;
            this.rFirst = cachedRow;
            cachedRow.iLastAccess = this.currentAccessCount++;
        }
        return cachedRow;
    }

    private CachedRow getRow(int n) {
        CachedRow cachedRow;
        int n2 = n >> 3 & this.multiplierMask;
        CachedRow cachedRow2 = cachedRow = this.rData[n2];
        int n3 = 0;
        while (cachedRow != null) {
            n3 = cachedRow.iPos;
            if (n3 == n) {
                return cachedRow;
            }
            if ((n3 >> 3 & this.multiplierMask) != n2 || (cachedRow = cachedRow.rNext) == cachedRow2) break;
        }
        return null;
    }

    private void cleanUp() throws HsqlException {
        int n;
        int n2 = 0;
        while (n2 < this.maxCacheSize) {
            this.accessCount[n2] = this.rFirst.iLastAccess;
            this.rFirst = this.rFirst.rNext;
            ++n2;
        }
        this.firstAccessCount = n = ArrayCounter.rank(this.accessCount, this.maxCacheSize / 8, this.firstAccessCount, this.currentAccessCount, 10);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.iCacheSize) {
            if (this.rFirst.iLastAccess < n) {
                this.rowTable[n3++] = this.rFirst;
            }
            this.rFirst = this.rFirst.rNext;
            ++n4;
        }
        this.rowComparator.setType(1);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, n3 - 1);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        int n5 = 0;
        while (n5 < n3) {
            CachedRow cachedRow = this.rowTable[n5];
            try {
                if (cachedRow.hasChanged()) {
                    this.saveRow(cachedRow);
                    ++this.saveRowCount;
                }
                if (!cachedRow.isRoot()) {
                    this.remove(cachedRow);
                }
            }
            catch (Exception exception) {
                throw Trace.error(29, 98, new Object[]{exception});
            }
            this.rowTable[n5] = null;
            ++n5;
        }
        this.saveAllTimer.stop();
        int n6 = 0;
        while (n6 < n3) {
            this.rowTable[n6] = null;
            ++n6;
        }
        this.resetAccessCount();
        this.initBuffers();
    }

    private void cleanUpOld() throws HsqlException {
        int n = 0;
        while (n < this.iCacheSize) {
            this.rowTable[n] = this.rFirst;
            this.rFirst = this.rFirst.rNext;
            ++n;
        }
        this.rowComparator.setType(0);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, this.iCacheSize - 1);
        this.sortTimer.stop();
        int n2 = this.iCacheSize / 4;
        this.rowComparator.setType(1);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, n2 - 1);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        int n3 = 0;
        while (n3 < n2) {
            CachedRow cachedRow = this.rowTable[n3];
            try {
                if (cachedRow.hasChanged()) {
                    this.saveRow(cachedRow);
                    ++this.saveRowCount;
                }
                if (!cachedRow.isRoot()) {
                    this.remove(cachedRow);
                }
            }
            catch (Exception exception) {
                throw Trace.error(29, 98, new Object[]{exception});
            }
            this.rowTable[n3] = null;
            ++n3;
        }
        this.saveAllTimer.stop();
        int n4 = n2;
        while (n4 < this.rowTable.length) {
            this.rowTable[n4] = null;
            ++n4;
        }
        this.resetAccessCount();
    }

    protected void remove(Table table) throws HsqlException {
        CachedRow cachedRow = this.rFirst;
        int n = 0;
        while (n < this.iCacheSize) {
            cachedRow = cachedRow.tTable == table ? this.remove(cachedRow) : cachedRow.rNext;
            ++n;
        }
    }

    protected CachedRow remove(CachedRow cachedRow) throws HsqlException {
        int n;
        if (cachedRow == this.rLastChecked) {
            this.rLastChecked = this.rLastChecked.rNext;
            if (this.rLastChecked == cachedRow) {
                this.rLastChecked = null;
            }
        }
        if (this.rData[n = cachedRow.iPos >> 3 & this.multiplierMask] == cachedRow) {
            CachedRow cachedRow2;
            this.rFirst = cachedRow2 = cachedRow.rNext;
            if (cachedRow2 == cachedRow || (cachedRow2.iPos >> 3 & this.multiplierMask) != n) {
                cachedRow2 = null;
            }
            this.rData[n] = cachedRow2;
        }
        if (cachedRow == this.rFirst) {
            this.rFirst = this.rFirst.rNext;
            if (cachedRow == this.rFirst) {
                this.rFirst = null;
            }
        }
        --this.iCacheSize;
        return cachedRow.free();
    }

    private CachedRow getWorst() throws HsqlException {
        if (this.rLastChecked == null) {
            this.rLastChecked = this.rFirst;
            if (this.rLastChecked == null) {
                return null;
            }
        }
        CachedRow cachedRow = this.rLastChecked;
        int n = this.rLastChecked.iLastAccess;
        this.rLastChecked = this.rLastChecked.rNext;
        int n2 = 0;
        while (n2 < 5) {
            int n3 = this.rLastChecked.iLastAccess;
            if (n3 < n) {
                cachedRow = this.rLastChecked;
                n = n3;
            }
            this.rLastChecked = this.rLastChecked.rNext;
            ++n2;
        }
        return cachedRow;
    }

    private void resetAccessCount() throws HsqlException {
        if (this.currentAccessCount < 0x3FFFFFFF) {
            return;
        }
        this.currentAccessCount >>= 8;
        this.firstAccessCount >>= 8;
        int n = this.iCacheSize;
        while (n-- > 0) {
            this.rFirst.iLastAccess >>= 8;
            this.rFirst = this.rFirst.rNext;
        }
    }

    protected void saveAll() throws HsqlException {
        this.saveAllTimer.start();
        if (this.rFirst == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.iCacheSize) {
            if (this.rFirst.hasChanged) {
                this.rowTable[n++] = this.rFirst;
            }
            this.rFirst = this.rFirst.rNext;
            ++n2;
        }
        this.rowComparator.setType(1);
        if (n != 0) {
            Sort.sort(this.rowTable, this.rowComparator, 0, n - 1);
        }
        int n3 = 0;
        while (n3 < n) {
            CachedRow cachedRow = this.rowTable[n3];
            try {
                this.saveRow(cachedRow);
                ++this.saveRowCount;
                this.rowTable[n3] = null;
            }
            catch (Exception exception) {
                throw Trace.error(29, 99, new Object[]{exception});
            }
            ++n3;
        }
        this.saveAllTimer.stop();
        Trace.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRow() total row save time"));
        Trace.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
        Trace.printSystemOut(this.makeRowTimer.elapsedTimeToMessage("Cache.makeRow() total row load time"));
        Trace.printSystemOut("Cache.makeRow() total row load count = " + this.makeRowCount);
        Trace.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
    }

    protected abstract void saveRow(CachedRow var1) throws IOException, HsqlException;

    abstract void backup(String var1) throws HsqlException;

    int getFreePos() {
        return this.iFreePos;
    }

    class CachedRowComparator
    implements ObjectComparator {
        final int COMPARE_LAST_ACCESS = 0;
        final int COMPARE_POSITION = 1;
        final int COMPARE_SIZE = 2;
        private int compareType;

        CachedRowComparator() {
        }

        void setType(int n) {
            this.compareType = n;
        }

        public int compare(Object object, Object object2) {
            switch (this.compareType) {
                case 0: {
                    return ((CachedRow)object).iLastAccess - ((CachedRow)object2).iLastAccess;
                }
                case 1: {
                    return ((CachedRow)object).iPos - ((CachedRow)object2).iPos;
                }
                case 2: {
                    return ((CachedRow)object).storageSize - ((CachedRow)object2).storageSize;
                }
            }
            return 0;
        }
    }
}

