/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.PointerNode;
import org.hsqldb.Row;
import org.hsqldb.Table;

class CachedDataRow
extends CachedRow {
    CachedDataRow(Table table, Object[] objectArray) throws HsqlException {
        super(table, objectArray);
        Node node = this.nPrimaryNode;
        while (node != null) {
            ((PointerNode)node).iData = this.iPos;
            node = node.nNext;
        }
    }

    CachedDataRow(Table table, DatabaseRowInputInterface databaseRowInputInterface) throws IOException, HsqlException {
        this.tTable = table;
        this.iPos = databaseRowInputInterface.getPos();
        this.storageSize = databaseRowInputInterface.getSize();
        this.oData = databaseRowInputInterface.readData(this.tTable.getColumnTypes());
        this.setPos(this.iPos);
    }

    Row getUpdatedRow() throws HsqlException {
        return this.tTable.getRow(this.iPos, this.nPrimaryNode);
    }

    void setNewNodes() {
        int n = this.tTable.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, this.tTable);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = Node.newNode(this, n2, this.tTable);
            ++n2;
        }
    }

    void setPrimaryNode(Node node) {
        this.nPrimaryNode = node;
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, HsqlException {
        databaseRowOutputInterface.writeSize(this.storageSize);
        databaseRowOutputInterface.writeData(this.oData, this.tTable);
        databaseRowOutputInterface.writePos(this.iPos);
        this.hasChanged = false;
    }
}

