/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class CachedRow
extends Row {
    static final int NO_POS = -1;
    protected Table tTable;
    int iLastAccess;
    CachedRow rLast;
    CachedRow rNext;
    int iPos = -1;
    int storageSize;
    protected boolean hasChanged;
    protected boolean hasDataChanged;

    CachedRow() {
    }

    CachedRow(Table table, Object[] objectArray) throws HsqlException {
        this.tTable = table;
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = Node.newNode(this, n2, table);
            ++n2;
        }
        this.oData = objectArray;
        this.hasDataChanged = true;
        this.hasChanged = true;
        table.addRowToStore(this);
    }

    CachedRow(Table table, DatabaseRowInputInterface databaseRowInputInterface) throws IOException, HsqlException {
        this.tTable = table;
        this.iPos = databaseRowInputInterface.getPos();
        this.storageSize = databaseRowInputInterface.getSize();
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, databaseRowInputInterface, 0, table);
        int n2 = 1;
        while (n2 < n) {
            node = node.nNext = Node.newNode(this, databaseRowInputInterface, n2, table);
            ++n2;
        }
        this.oData = databaseRowInputInterface.readData(this.tTable.getColumnTypes());
        this.setPos(this.iPos);
    }

    void delete() throws HsqlException {
        ++Record.memoryRecords;
        this.hasChanged = false;
        this.tTable.removeRow(this);
        this.rNext = null;
        this.rLast = null;
        this.tTable = null;
        this.oData = null;
        this.nPrimaryNode = null;
    }

    void setPos(int n) {
        this.iPos = n;
        this.tTable.registerRow(this);
    }

    void setChanged() {
        this.hasChanged = true;
    }

    boolean hasChanged() {
        return this.hasChanged;
    }

    void setDataChanged() {
        this.hasDataChanged = true;
    }

    boolean hasDataChanged() {
        return this.hasDataChanged;
    }

    Table getTable() {
        return this.tTable;
    }

    boolean isRoot() throws HsqlException {
        Node node = this.nPrimaryNode;
        while (node != null) {
            Trace.doAssert(node.getBalance() != -2);
            if (node.isRoot()) {
                return true;
            }
            node = node.nNext;
        }
        return false;
    }

    Row getUpdatedRow() throws HsqlException {
        return this.tTable == null ? null : this.tTable.getRow(this.iPos, null);
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, HsqlException {
        this.writeNodes(databaseRowOutputInterface);
        if (this.hasDataChanged) {
            databaseRowOutputInterface.writeData(this.oData, this.tTable);
            databaseRowOutputInterface.writePos(this.iPos);
        }
        this.hasDataChanged = false;
    }

    private void writeNodes(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, HsqlException {
        databaseRowOutputInterface.writeSize(this.storageSize);
        Node node = this.nPrimaryNode;
        while (node != null) {
            node.write(databaseRowOutputInterface);
            node = node.nNext;
        }
        this.hasChanged = false;
    }

    void insert(CachedRow cachedRow) {
        ++Record.memoryRecords;
        if (cachedRow == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = cachedRow;
            this.rLast = cachedRow.rLast;
            cachedRow.rLast = this;
            this.rLast.rNext = this;
        }
    }

    CachedRow free() throws HsqlException {
        CachedRow cachedRow = this.rNext;
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        this.rLast = null;
        this.rNext = null;
        if (cachedRow == this) {
            return null;
        }
        return cachedRow;
    }
}

