/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

final class CompiledStatement {
    static final int UNKNOWN = 0;
    static final int INSERT_VALUES = 1;
    static final int INSERT_SELECT = 2;
    static final int UPDATE = 3;
    static final int DELETE = 4;
    static final int SELECT = 5;
    static final int CALL = 6;
    static final int DML = 7;
    static final int DQL = 8;
    static final int DDL = 9;
    Table targetTable;
    TableFilter tf;
    Expression condition;
    int[] columnMap;
    Expression[] columnValues;
    boolean[] checkColumns;
    Expression expression;
    Select select;
    Expression[] parameters;
    int[] paramTypes;
    SubQuery[] subqueries;
    int type;
    int id;
    int use;
    String sql;
    private static final Result updateCount = new Result(1);

    CompiledStatement() {
        this.clearAll();
    }

    void bind(Object[] objectArray) throws HsqlException {
        Trace.check(this.parameters != null, 5);
        int n = this.parameters.length;
        Trace.check(objectArray.length >= n, 5);
        int n2 = 0;
        while (n2 < n) {
            this.parameters[n2].bind(objectArray[n2]);
            ++n2;
        }
    }

    void clearAll() {
        this.checkColumns = null;
        this.columnMap = null;
        this.columnValues = null;
        this.condition = null;
        this.parameters = null;
        this.paramTypes = null;
        this.select = null;
        this.targetTable = null;
        this.type = 0;
        this.id = 0;
    }

    void setAsDelete(Table table, Expression expression, Expression[] expressionArray) throws HsqlException {
        this.clearAll();
        this.targetTable = table;
        this.tf = new TableFilter(table, null, false);
        if (expression != null) {
            this.condition = new Expression(expression);
            this.condition.resolve(this.tf);
            this.tf.setCondition(this.condition);
        }
        this.setParameters(expressionArray);
        this.type = 4;
    }

    void setAsUpdate(Table table, int[] nArray, Expression[] expressionArray, Expression expression, Expression[] expressionArray2) throws HsqlException {
        this.clearAll();
        this.targetTable = table;
        this.columnMap = nArray;
        this.columnValues = expressionArray;
        this.tf = new TableFilter(table, null, false);
        int n = 0;
        while (n < expressionArray.length) {
            Expression expression2 = expressionArray[n];
            if (expression2.isParam()) {
                expression2.setTableColumnAttributes(table, nArray[n]);
            } else {
                expression2.resolve(this.tf);
            }
            ++n;
        }
        if (expression != null) {
            this.condition = new Expression(expression);
            this.condition.resolve(this.tf);
            this.tf.setCondition(this.condition);
        }
        this.setParameters(expressionArray2);
        this.type = 3;
    }

    void setAsInsertValues(Table table, int[] nArray, Expression[] expressionArray, boolean[] blArray, Expression[] expressionArray2) throws HsqlException {
        this.clearAll();
        this.targetTable = table;
        this.columnMap = nArray;
        this.checkColumns = blArray;
        this.columnValues = expressionArray;
        int n = 0;
        while (n < expressionArray.length) {
            Expression expression = expressionArray[n];
            if (expression.isParam()) {
                expression.setTableColumnAttributes(table, nArray[n]);
            }
            ++n;
        }
        this.setParameters(expressionArray2);
        this.type = 1;
    }

    void setAsInsertSelect(Table table, int[] nArray, boolean[] blArray, Select select, Expression[] expressionArray) throws HsqlException {
        this.clearAll();
        this.targetTable = table;
        this.columnMap = nArray;
        this.checkColumns = blArray;
        this.select = select;
        select.resolveAll();
        this.setParameters(expressionArray);
        this.type = 2;
    }

    void setAsSelect(Select select, Expression[] expressionArray) throws HsqlException {
        this.select = select;
        select.resolveAll();
        this.setParameters(expressionArray);
        this.type = 5;
    }

    void setAsCall(Expression expression, Expression[] expressionArray) throws HsqlException {
        this.expression = expression;
        expression.resolve(null);
        expression.paramMode = 4;
        this.setParameters(expressionArray);
        this.type = 6;
    }

    private void setParameters(Expression[] expressionArray) {
        this.parameters = expressionArray;
        int[] nArray = new int[expressionArray.length];
        int n = 0;
        while (n < expressionArray.length) {
            nArray[n] = expressionArray[n].getDataType();
            ++n;
        }
        this.paramTypes = nArray;
    }

    void materializeSubQueries() throws HsqlException {
        int n = 0;
        while (n < this.subqueries.length) {
            SubQuery subQuery = this.subqueries[n];
            Table table = subQuery.table;
            Select select = subQuery.select;
            Result result = select.getResult(0);
            table.insertNoCheck(result, null);
            ++n;
        }
    }

    void dematerializeSubQueries() {
        int n = 0;
        while (n < this.subqueries.length) {
            this.subqueries[n].table.setIndexRootsNull();
            ++n;
        }
    }

    Result describeResultSet() {
        switch (this.type) {
            case 6: {
                Expression expression = this.expression;
                Result result = Result.newSingleColumnResult("@0", expression.getDataType());
                result.metaData.sClassName[0] = expression.getValueClassName();
                return result;
            }
            case 5: {
                return this.select.describeResult();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return updateCount;
            }
        }
        return new Result("Unknown Statement Type: " + this.type, "", 85);
    }

    Result describeParameters() {
        int n = this.parameters.length;
        int n2 = 0;
        Result result = Result.newParameterDescriptionResult(n);
        int n3 = 0;
        while (n3 < this.parameters.length) {
            Expression expression = this.parameters[n3];
            int n4 = n3 + n2;
            result.metaData.sName[n4] = "@" + n3 + 1;
            result.metaData.sClassName[n4] = expression.getValueClassName();
            result.metaData.colType[n4] = expression.getDataType();
            result.metaData.colSize[n4] = expression.getColumnSize();
            result.metaData.colScale[n4] = expression.getColumnScale();
            result.metaData.nullability[n4] = expression.nullability;
            result.metaData.isIdentity[n4] = expression.isIdentity;
            result.metaData.paramMode[n4] = expression.paramMode;
            ++n3;
        }
        return result;
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 5: {
                stringBuffer.append(this.select.toString());
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer);
                return stringBuffer.toString();
            }
            case 1: {
                stringBuffer.append("INSERT VALUES");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 2: {
                stringBuffer.append("INSERT SELECT");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                stringBuffer.append(this.select).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 3: {
                stringBuffer.append("UPDATE");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(stringBuffer);
                stringBuffer.append(this.tf).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 4: {
                stringBuffer.append("DELETE");
                stringBuffer.append('[').append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(stringBuffer);
                stringBuffer.append(this.tf).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
            case 6: {
                stringBuffer.append("CALL");
                stringBuffer.append('[');
                stringBuffer.append(this.expression).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(stringBuffer).append(']');
                return stringBuffer.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(StringBuffer stringBuffer) {
        stringBuffer.append("SUBQUERIES[");
        int n = 0;
        while (n < this.subqueries.length) {
            stringBuffer.append("\n[level=").append(this.subqueries[n].level).append('\n').append("hasParams=").append(this.subqueries[n].hasParams).append('\n').append("org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[n].select.hashCode())).append("]");
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendTable(StringBuffer stringBuffer) {
        stringBuffer.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendColumns(StringBuffer stringBuffer) {
        stringBuffer.append("COLUMNS=[");
        int n = 0;
        while (n < this.columnMap.length) {
            stringBuffer.append('\n').append(this.columnMap[n]).append(':').append(' ').append(this.targetTable.getColumn((int)this.columnMap[n]).columnName.name).append('[').append(this.columnValues[n]).append(']');
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendParms(StringBuffer stringBuffer) {
        stringBuffer.append("PARAMETERS=[");
        int n = 0;
        while (n < this.parameters.length) {
            stringBuffer.append('\n').append('@').append(n).append('[').append(this.parameters[n]).append(']');
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendCondition(StringBuffer stringBuffer) {
        return this.condition == null ? stringBuffer.append("CONDITION[]\n") : stringBuffer.append("CONDITION[").append(this.condition).append("]\n");
    }
}

