/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcResultSet;
import org.hsqldb.lib.HsqlArrayList;

final class CompiledStatementExecutor {
    private Session session;
    private Database database;
    private Result updateResult;
    private Result emptyResult;

    CompiledStatementExecutor(Session session) {
        this.session = session;
        this.database = session.getDatabase();
        this.updateResult = new Result(1);
        this.emptyResult = new Result(1);
    }

    Result execute(CompiledStatement compiledStatement) {
        Result result = null;
        DatabaseManager.gc();
        try {
            compiledStatement.materializeSubQueries();
            result = this.executeImpl(compiledStatement);
        }
        catch (Throwable throwable) {
            result = new Result(throwable, compiledStatement.sql);
        }
        compiledStatement.dematerializeSubQueries();
        if (result == null) {
            result = this.emptyResult;
        }
        return result;
    }

    private Result executeImpl(CompiledStatement compiledStatement) throws HsqlException {
        switch (compiledStatement.type) {
            case 5: {
                return this.executeSelectStatement(compiledStatement);
            }
            case 2: {
                return this.executeInsertSelectStatement(compiledStatement);
            }
            case 1: {
                return this.executeInsertValuesStatement(compiledStatement);
            }
            case 3: {
                return this.executeUpdateStatement(compiledStatement);
            }
            case 4: {
                return this.executeDeleteStatement(compiledStatement);
            }
            case 6: {
                return this.executeCallStatement(compiledStatement);
            }
        }
        String string = "Unknown compiled statement type: " + compiledStatement.type;
        throw Trace.error(73, string);
    }

    private Result executeCallStatement(CompiledStatement compiledStatement) throws HsqlException {
        Expression expression = compiledStatement.expression;
        Object object = expression.getValue();
        if (object instanceof Result) {
            return (Result)object;
        }
        if (object instanceof jdbcResultSet) {
            return ((jdbcResultSet)object).rResult;
        }
        Result result = Result.newSingleColumnResult("@0", expression.getDataType());
        Object[] objectArray = new Object[]{object};
        result.metaData.sClassName[0] = expression.getValueClassName();
        result.add(objectArray);
        return result;
    }

    private Result executeDeleteStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.tf;
        int n = 0;
        if (tableFilter.findFirst()) {
            Expression expression = compiledStatement.condition;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            if (expression == null) {
                do {
                    hsqlArrayList.add(tableFilter.currentRow);
                } while (tableFilter.next());
                n = table.delete(hsqlArrayList, this.session);
            } else {
                do {
                    if (!expression.test()) continue;
                    hsqlArrayList.add(tableFilter.currentRow);
                } while (tableFilter.next());
                n = table.delete(hsqlArrayList, this.session);
            }
        }
        this.updateResult.iUpdateCount = n;
        return this.updateResult;
    }

    private Result executeInsertStatement(CompiledStatement compiledStatement) throws HsqlException {
        switch (compiledStatement.type) {
            case 2: {
                return this.executeInsertSelectStatement(compiledStatement);
            }
            case 1: {
                return this.executeInsertValuesStatement(compiledStatement);
            }
        }
        String string = "Unexpected compiled statement type: " + compiledStatement.type;
        throw Trace.error(85, string);
    }

    private Result executeInsertSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        int n;
        Table table = compiledStatement.targetTable;
        Select select = compiledStatement.select;
        int[] nArray = table.getColumnTypes();
        Result result = select.getResult(this.session.getMaxRows());
        Record record = result.rRoot;
        int[] nArray2 = compiledStatement.columnMap;
        boolean[] blArray = compiledStatement.checkColumns;
        int n2 = nArray2.length;
        this.session.beginNestedTransaction();
        try {
            while (record != null) {
                Object[] objectArray = table.getNewRow(blArray);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    objectArray[n4] = nArray[n4] != result.metaData.colType[n3] ? Column.convertObject(record.data[n3], nArray[n4]) : record.data[n3];
                    ++n3;
                }
                record.data = objectArray;
                record = record.next;
            }
            n = table.insert(result, this.session);
            this.session.endNestedTransaction(false);
        }
        catch (HsqlException hsqlException) {
            this.session.endNestedTransaction(true);
            throw hsqlException;
        }
        this.updateResult.iUpdateCount = n;
        return this.updateResult;
    }

    private Result executeInsertValuesStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        Object[] objectArray = table.getNewRow(compiledStatement.checkColumns);
        int[] nArray = compiledStatement.columnMap;
        Expression[] expressionArray = compiledStatement.columnValues;
        int[] nArray2 = table.getColumnTypes();
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            int n3 = nArray[n2];
            objectArray[n3] = expression.getValue(nArray2[n3]);
            ++n2;
        }
        table.insert(objectArray, this.session);
        this.updateResult.iUpdateCount = 1;
        return this.updateResult;
    }

    private Result executeSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        return compiledStatement.select.getResult(this.session.getMaxRows());
    }

    private Result executeUpdateStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.tf;
        int n = 0;
        if (tableFilter.findFirst()) {
            Row row;
            int[] nArray = compiledStatement.columnMap;
            Expression[] expressionArray = compiledStatement.columnValues;
            Expression expression = compiledStatement.condition;
            int n2 = expressionArray.length;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            Result result = new Result(1);
            int n3 = table.getColumnCount();
            n2 = nArray.length;
            int[] nArray2 = table.getColumnTypes();
            if (expression == null) {
                do {
                    row = tableFilter.currentRow;
                    hsqlArrayList.add(row);
                    Object[] objectArray = table.getNewRow();
                    System.arraycopy(row.getData(), 0, objectArray, 0, n3);
                    int n4 = 0;
                    while (n4 < n2) {
                        int n5 = nArray[n4];
                        objectArray[n5] = expressionArray[n4].getValue(nArray2[n5]);
                        ++n4;
                    }
                    result.add(objectArray);
                } while (tableFilter.next());
            } else {
                do {
                    if (!expression.test()) continue;
                    row = tableFilter.currentRow;
                    hsqlArrayList.add(row);
                    Object[] objectArray = table.getNewRow();
                    System.arraycopy(row.getData(), 0, objectArray, 0, n3);
                    int n6 = 0;
                    while (n6 < n2) {
                        int n7 = nArray[n6];
                        objectArray[n7] = expressionArray[n6].getValue(nArray2[n7]);
                        ++n6;
                    }
                    result.add(objectArray);
                } while (tableFilter.next());
            }
            this.session.beginNestedTransaction();
            try {
                n = table.update(hsqlArrayList, result, nArray, this.session);
                this.session.endNestedTransaction(false);
            }
            catch (HsqlException hsqlException) {
                this.session.endNestedTransaction(true);
                throw hsqlException;
            }
        }
        this.updateResult.iUpdateCount = n;
        return this.updateResult;
    }
}

