/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Hashtable;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.store.ValuePool;

final class CompiledStatementManager {
    Database database;
    Hashtable sqlMap;
    IntKeyHashMap csidMap;
    IntKeyHashMap validationMap;
    private int next_cs_id;

    CompiledStatementManager(Database database) {
        this.database = database;
        this.sqlMap = new Hashtable();
        this.csidMap = new IntKeyHashMap();
        this.validationMap = new IntKeyHashMap();
        this.next_cs_id = 0;
    }

    void reset() {
        this.sqlMap.clear();
        this.csidMap.clear();
        this.validationMap.clear();
        this.next_cs_id = 0;
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long setSCN(int n, int n2, long l) {
        Long l2;
        IntKeyHashMap intKeyHashMap = (IntKeyHashMap)this.validationMap.get(n2);
        if (intKeyHashMap == null) {
            intKeyHashMap = new IntKeyHashMap();
            this.validationMap.put(n2, intKeyHashMap);
        }
        return (l2 = (Long)intKeyHashMap.put(n, ValuePool.getLong(l))) == null ? Long.MIN_VALUE : l2;
    }

    private long getSCN(int n, int n2) {
        IntKeyHashMap intKeyHashMap = (IntKeyHashMap)this.validationMap.get(n2);
        if (intKeyHashMap == null) {
            return Long.MIN_VALUE;
        }
        Long l = (Long)intKeyHashMap.get(n);
        return l == null ? Long.MIN_VALUE : l;
    }

    synchronized int getStatementID(String string) {
        CompiledStatement compiledStatement = (CompiledStatement)this.sqlMap.get(string);
        return compiledStatement == null ? Integer.MIN_VALUE : compiledStatement.id;
    }

    synchronized CompiledStatement getStatement(int n) {
        return (CompiledStatement)this.csidMap.get(n);
    }

    synchronized boolean isValid(int n, int n2) {
        return this.getSCN(n, n2) >= this.database.getDDLSCN();
    }

    synchronized long getValidated(int n, int n2) {
        return n > 0 ? this.getSCN(n, n2) : Long.MIN_VALUE;
    }

    synchronized long setValidated(int n, int n2, long l) {
        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n);
        if (compiledStatement == null) {
            return Long.MIN_VALUE;
        }
        long l2 = this.setSCN(compiledStatement.id, n2, l);
        if (l2 < 0L) {
            ++compiledStatement.use;
        }
        return l2 < 0L ? 0L : l2;
    }

    synchronized int registerStatement(CompiledStatement compiledStatement) {
        compiledStatement.id = this.nextID();
        compiledStatement.use = 0;
        this.sqlMap.put(compiledStatement.sql, compiledStatement);
        this.csidMap.put(compiledStatement.id, compiledStatement);
        return compiledStatement.id;
    }

    synchronized boolean freeStatement(int n, int n2) {
        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n);
        IntKeyHashMap intKeyHashMap = (IntKeyHashMap)this.validationMap.get(n2);
        if (compiledStatement == null || intKeyHashMap == null || intKeyHashMap.remove(n) == null) {
            return false;
        }
        --compiledStatement.use;
        if (compiledStatement.use < 1) {
            this.sqlMap.remove(compiledStatement.sql);
            this.csidMap.remove(compiledStatement.id);
        }
        return true;
    }

    synchronized void processDisconnect(int n) {
        IntKeyHashMap intKeyHashMap = (IntKeyHashMap)this.validationMap.remove(n);
        if (intKeyHashMap == null) {
            return;
        }
        Iterator iterator = intKeyHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.nextInt();
            CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n2);
            --compiledStatement.use;
            if (compiledStatement.use >= 1) continue;
            this.sqlMap.remove(compiledStatement.sql);
            this.csidMap.remove(compiledStatement.id);
        }
    }
}

