/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ConstraintCore;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;

class Constraint {
    static final int CASCADE = 0;
    static final int SET_NULL = 2;
    static final int NO_ACTION = 3;
    static final int SET_DEFAULT = 4;
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    private ConstraintCore core;
    private HsqlNameManager.HsqlName constName;
    private int iType;

    Constraint(HsqlNameManager.HsqlName hsqlName, Table table, Index index) {
        this.core = new ConstraintCore();
        this.constName = hsqlName;
        this.iType = 2;
        this.core.tMain = table;
        this.core.iMain = index;
        this.core.iColMain = ArrayUtil.arraySlice(index.getColumns(), 0, index.getVisibleColumns());
        this.core.iLen = this.core.iColMain.length;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, Constraint constraint) {
        this.constName = hsqlName;
        this.iType = 1;
        this.core = constraint.core;
    }

    Constraint(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2, Table table, Table table2, int[] nArray, int[] nArray2, Index index, Index index2, int n, int n2) throws HsqlException {
        this.core = new ConstraintCore();
        this.core.pkName = hsqlName;
        this.core.fkName = hsqlName2;
        this.constName = hsqlName2;
        this.iType = 0;
        this.core.tMain = table;
        this.core.tRef = table2;
        this.core.iColMain = nArray;
        this.core.iLen = this.core.iColMain.length;
        this.core.iColRef = nArray2;
        this.core.oColRef = new Object[this.core.iColRef.length];
        this.core.iMain = index;
        this.core.iRef = index2;
        this.core.deleteAction = n;
        this.core.updateAction = n2;
        this.setTableRows();
    }

    private Constraint() {
    }

    private void setTableRows() throws HsqlException {
        this.core.oMain = this.core.tMain.getNewRow();
        if (this.core.tRef != null) {
            this.core.oRef = this.core.tRef.getNewRow();
        }
    }

    HsqlNameManager.HsqlName getName() {
        return this.constName;
    }

    private void setName(String string, boolean bl) throws HsqlException {
        this.constName.rename(string, bl);
    }

    String getPkName() {
        return this.core.pkName == null ? null : this.core.pkName.name;
    }

    String getFkName() {
        return this.core.fkName == null ? null : this.core.fkName.name;
    }

    int getType() {
        return this.iType;
    }

    Table getMain() {
        return this.core.tMain;
    }

    Index getMainIndex() {
        return this.core.iMain;
    }

    Table getRef() {
        return this.core.tRef;
    }

    Index getRefIndex() {
        return this.core.iRef;
    }

    int getDeleteAction() {
        return this.core.deleteAction;
    }

    int getUpdateAction() {
        return this.core.updateAction;
    }

    int[] getMainColumns() {
        return this.core.iColMain;
    }

    int[] getRefColumns() {
        return this.core.iColRef;
    }

    boolean isIndexFK(Index index) {
        return !(this.iType != 0 && this.iType != 1 || this.core.iMain != index && this.core.iRef != index);
    }

    boolean isIndexUnique(Index index) {
        return this.iType == 2 && this.core.iMain == index;
    }

    boolean isEquivalent(int[] nArray, int n) {
        if (n != this.iType || this.iType != 2 || this.core.iLen != nArray.length) {
            return false;
        }
        return ArrayUtil.haveEqualSets(this.core.iColMain, nArray, this.core.iLen);
    }

    boolean isEquivalent(Table table, int[] nArray, Table table2, int[] nArray2) {
        if (this.iType != 1 || this.iType != 0) {
            return false;
        }
        if (table != this.core.tMain || table2 != this.core.tRef) {
            return false;
        }
        return ArrayUtil.areEqualSets(this.core.iColMain, nArray) && ArrayUtil.areEqualSets(this.core.iColRef, nArray2);
    }

    void replaceTable(Table table, Table table2, int n, int n2) throws HsqlException {
        if (table == this.core.tMain) {
            this.core.tMain = table2;
            this.setTableRows();
            this.core.iMain = this.core.tMain.getIndex(this.core.iMain.getName().name);
            this.core.iColMain = ArrayUtil.toAdjustedColumnArray(this.core.iColMain, n, n2);
        }
        if (table == this.core.tRef) {
            this.core.tRef = table2;
            this.setTableRows();
            if (this.core.iRef != null) {
                this.core.iRef = this.core.tRef.getIndex(this.core.iRef.getName().name);
                if (this.core.iRef != this.core.iMain) {
                    this.core.iColRef = ArrayUtil.toAdjustedColumnArray(this.core.iColRef, n, n2);
                }
            }
        }
    }

    void replaceIndex(Index index, Index index2) {
        if (index == this.core.iRef) {
            this.core.iRef = index2;
        }
        if (index == this.core.iMain) {
            this.core.iMain = index2;
        }
    }

    void checkInsert(Object[] objectArray) throws HsqlException {
        if (this.iType == 1 || this.iType == 2) {
            return;
        }
        int n = 0;
        while (n < this.core.iLen) {
            Object object = objectArray[this.core.iColRef[n]];
            if (object == null) {
                return;
            }
            this.core.oMain[this.core.iColMain[n]] = object;
            ++n;
        }
        if (this.core.iMain.find(this.core.oMain) == null) {
            if (this.core.tMain == this.core.tRef) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < this.core.iLen) {
                    if (!objectArray[this.core.iColRef[n2]].equals(objectArray[this.core.iColMain[n2]])) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    return;
                }
            }
            throw Trace.error(8, 100, new Object[]{this.core.fkName.name, this.core.tMain.getName().name});
        }
    }

    private void checkDelete(Object[] objectArray) throws HsqlException {
        Object object;
        int n = 0;
        while (n < this.core.iLen) {
            object = objectArray[this.core.iColMain[n]];
            if (object == null) {
                return;
            }
            this.core.oRef[this.core.iColRef[n]] = object;
            ++n;
        }
        object = this.core.iRef.find(this.core.oRef);
        Trace.check(object == null, 8, this.core.fkName.name, " table: ", this.core.tRef.getName().name);
    }

    Node findFkRef(Object[] objectArray, boolean bl) throws HsqlException {
        if (objectArray == null) {
            return null;
        }
        int n = 0;
        while (n < this.core.iLen) {
            Object object = objectArray[this.core.iColMain[n]];
            if (object == null) {
                return null;
            }
            this.core.oColRef[n] = object;
            ++n;
        }
        boolean bl2 = bl ? this.core.deleteAction != 3 : this.core.updateAction != 3;
        Node node = this.core.iRef.findSimple(this.core.oColRef, bl2);
        Trace.check(node == null || bl2, 8, this.core.fkName.name, " table: ", this.core.tRef.getName().name);
        return node;
    }

    Node findMainRef(Object[] objectArray) throws HsqlException {
        Object object;
        int n = 0;
        while (n < this.core.iLen) {
            object = objectArray[this.core.iColRef[n]];
            if (object == null) {
                return null;
            }
            this.core.oColRef[n] = object;
            ++n;
        }
        object = this.core.iMain.findSimple(this.core.oColRef, true);
        Trace.check(object != null, 8, this.core.fkName.name, " table: ", this.core.tRef.getName().name);
        return object;
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws HsqlException {
        block7: {
            block6: {
                if (this.iType == 2) {
                    return;
                }
                if (this.iType != 1) break block6;
                if (!ArrayUtil.haveCommonElement(nArray, this.core.iColMain, this.core.iLen)) {
                    return;
                }
                Record record = result.rRoot;
                while (record != null) {
                    if (this.core.iMain.find(record.data) == null) {
                        this.checkDelete(record.data);
                    }
                    record = record.next;
                }
                break block7;
            }
            if (this.iType != 0) break block7;
            if (!ArrayUtil.haveCommonElement(nArray, this.core.iColMain, this.core.iLen)) {
                return;
            }
            Record record = result2.rRoot;
            while (record != null) {
                this.checkInsert(record.data);
                record = record.next;
            }
        }
    }
}

