/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;

final class DINameSpace {
    private Database database;
    private static HashSet builtin = new HashSet();
    static final String DEFN_SCHEMA = "DEFINITION_SCHEMA";
    private static final String DEFN_SCHEMA_DOT = "DEFINITION_SCHEMA.";
    private static final int DEFN_SCHEMA_DOT_LEN = "DEFINITION_SCHEMA.".length();
    static final String INFO_SCHEMA = "INFORMATION_SCHEMA";
    private static final String INFO_SCHEMA_DOT = "INFORMATION_SCHEMA.";
    private static final int INFO_SCHEMA_DOT_LEN = "INFORMATION_SCHEMA.".length();
    static final String PUB_SCHEMA = "PUBLIC";
    private static final String PUB_SCHEMA_DOT = "PUBLIC.";
    private static final int PUB_SCHEMA_DOT_LEN = "PUBLIC.".length();
    private static final HsqlArrayList sysSchemas = new HsqlArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public DINameSpace(Database database) throws HsqlException {
        Trace.doAssert(database != null, "database is null");
        this.database = database;
    }

    Class classForMethodFQN(String string) {
        try {
            return this.classForName(string.substring(0, string.lastIndexOf(46)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    Class classForName(String string) throws ClassNotFoundException {
        try {
            return this.database.classLoader == null ? Class.forName(string) : this.database.classLoader.loadClass(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(noClassDefFoundError.toString());
        }
    }

    Iterator enumCatalogNames() throws HsqlException {
        return this.isReportCatalogs() ? new WrapperIterator(this.database.getPath()) : new WrapperIterator();
    }

    Iterator enumSysSchemaNames() throws HsqlException {
        return this.isReportSchemas() ? sysSchemas.iterator() : new WrapperIterator();
    }

    Iterator enumVisibleSchemaNames(Session session) throws HsqlException {
        if (!this.isReportSchemas() || session == null) {
            return new WrapperIterator();
        }
        UserManager userManager = this.database.getUserManager();
        HsqlArrayList hsqlArrayList = userManager.listVisibleUsers(session, false);
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        int n = 0;
        while (n < hsqlArrayList.size()) {
            User user = (User)hsqlArrayList.get(n);
            hsqlArrayList2.add(user.getName());
            ++n;
        }
        return new WrapperIterator(this.enumSysSchemaNames(), hsqlArrayList2.iterator());
    }

    HsqlNameManager.HsqlName findOrCreateHsqlName(String string, HashMap hashMap) {
        HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)hashMap.get(string);
        if (hsqlName == null) {
            try {
                hsqlName = this.database.nameManager.newHsqlName(string, false);
                hashMap.put(string, hsqlName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hsqlName;
    }

    Table findPubSchemaTable(String string) {
        return !this.isReportSchemas() || string == null || !string.startsWith(PUB_SCHEMA_DOT) ? null : this.database.findUserTable(string.substring(PUB_SCHEMA_DOT_LEN));
    }

    Table findUserSchemaTable(String string, Session session) {
        if (!this.isReportSchemas() || string == null || session == null) {
            return null;
        }
        String string2 = session.getUsername() + ".";
        return string.startsWith(string2) ? this.database.findUserTable(string.substring(string2.length()), session) : null;
    }

    String getCatalogName(Object object) {
        return !this.isReportCatalogs() || object == null ? null : this.database.getPath();
    }

    HashMap getInverseAliasMap() {
        HashMap hashMap = this.database.getAlias();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = hashMap.get(object);
            HsqlArrayList hsqlArrayList = (HsqlArrayList)hashMap2.get(object2);
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
                hashMap2.put(object2, hsqlArrayList);
            }
            hsqlArrayList.add(object);
        }
        return hashMap2;
    }

    static String getMethodFQN(Method method) {
        return method == null ? null : method.getDeclaringClass().getName() + '.' + method.getName();
    }

    String getSchemaName(Object object) {
        if (!this.isReportSchemas() || object == null) {
            return null;
        }
        if (object instanceof Table) {
            return ((Table)object).getSchemaName();
        }
        if (object instanceof Index) {
            Table table = this.tableForIndex((Index)object);
            return table == null ? null : table.getSchemaName();
        }
        if (object instanceof String) {
            if (Types.typeAliases.get(object, Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                return DEFN_SCHEMA;
            }
            if (this.isBuiltin((String)object)) {
                return DEFN_SCHEMA;
            }
            try {
                object = this.classForName((String)object);
            }
            catch (Exception exception) {
                return null;
            }
        }
        Class clazz = null;
        if (object instanceof Method) {
            clazz = ((Method)object).getDeclaringClass();
        } else if (object instanceof Class) {
            clazz = (Class)object;
        }
        return clazz == null ? null : (this.isBuiltin(clazz) ? DEFN_SCHEMA : PUB_SCHEMA);
    }

    boolean isBuiltin(Class clazz) {
        return clazz == null ? false : builtin.contains(clazz.getName());
    }

    boolean isBuiltin(String string) {
        return string == null ? false : builtin.contains(string);
    }

    Table tableForIndex(Index index) {
        return index == null ? null : this.tableForIndexName(index.getName().name);
    }

    Table tableForIndexName(String string) {
        HsqlNameManager.HsqlName hsqlName = this.database.indexNameList.getOwner(string);
        return this.database.findUserTable(hsqlName.name);
    }

    String withoutCatalog(String string) {
        if (!this.isReportCatalogs()) {
            return string;
        }
        String string2 = this.getCatalogName(string) + ".";
        String string3 = string.startsWith(string2) ? string.substring(string2.length()) : string;
        return string3;
    }

    String withoutDefnSchema(String string) {
        return this.isReportSchemas() && string.startsWith(DEFN_SCHEMA_DOT) ? string.substring(DEFN_SCHEMA_DOT_LEN) : string;
    }

    String withoutInfoSchema(String string) {
        return this.isReportSchemas() && string.startsWith(INFO_SCHEMA_DOT) ? string.substring(INFO_SCHEMA_DOT_LEN) : string;
    }

    Iterator enumRoutineMethods(String string, boolean bl) throws HsqlException {
        Method[] methodArray;
        Class clazz;
        HashMap hashMap = bl ? this.getInverseAliasMap() : null;
        try {
            clazz = this.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new WrapperIterator();
        }
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Exception exception) {
            methodArray = clazz.getMethods();
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList(methodArray.length);
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            int n2 = method.getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isStatic(n2)) {
                Object[] objectArray = new Object[]{method, null, "ROUTINE"};
                if (bl) {
                    objectArray[1] = hashMap.get(DINameSpace.getMethodFQN(method));
                }
                hsqlArrayList.add(objectArray);
            }
            ++n;
        }
        return hsqlArrayList.iterator();
    }

    Iterator enumAccessibleTriggerClassNames(User user) throws HsqlException {
        HashSet hashSet = new HashSet();
        HsqlArrayList hsqlArrayList = this.database.getTables();
        int n = 0;
        while (n < hsqlArrayList.size()) {
            HsqlArrayList[] hsqlArrayListArray;
            Table table = (Table)hsqlArrayList.get(n);
            if (user.isAccessible(table.getName()) && (hsqlArrayListArray = table.vTrigs) != null) {
                int n2 = 0;
                while (n2 < hsqlArrayListArray.length) {
                    HsqlArrayList hsqlArrayList2 = hsqlArrayListArray[n2];
                    if (hsqlArrayList2 != null) {
                        int n3 = hsqlArrayList2.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            TriggerDef triggerDef = (TriggerDef)hsqlArrayList2.get(n4);
                            if (triggerDef != null && triggerDef.valid && triggerDef.trig != null && user.isAccessible(table, TriggerDef.indexToRight(n4))) {
                                hashSet.add(triggerDef.trig.getClass().getName());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hashSet.iterator();
    }

    Iterator enumAccessibleTriggerMethods(Session session) throws HsqlException {
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DINameSpace.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DINameSpace.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = DINameSpace.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = this.database.getTables();
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < hsqlArrayList2.size()) {
            HsqlArrayList[] hsqlArrayListArray;
            Table table = (Table)hsqlArrayList2.get(n);
            if (session.isAccessible(table.getName()) && (hsqlArrayListArray = table.vTrigs) != null) {
                int n2 = 0;
                while (n2 < hsqlArrayListArray.length) {
                    HsqlArrayList hsqlArrayList3 = hsqlArrayListArray[n2];
                    if (hsqlArrayList3 != null) {
                        int n3 = hsqlArrayList3.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            try {
                                Class<?> clazz;
                                String string;
                                TriggerDef triggerDef = (TriggerDef)hsqlArrayList3.get(n4);
                                if (triggerDef != null && !hashSet.contains(string = (clazz = triggerDef.trig.getClass()).getName())) {
                                    hashSet.add(string);
                                    Method method = clazz.getMethod("fire", classArray);
                                    hsqlArrayList.add(new Object[]{method, null, "TRIGGER"});
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return hsqlArrayList.iterator();
    }

    Iterator enumAllAccessibleMethods(Session session, boolean bl) throws HsqlException {
        WrapperIterator wrapperIterator = new WrapperIterator();
        Iterator iterator = session.getGrantedClassNames(true).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.enumRoutineMethods(string, bl);
            wrapperIterator = new WrapperIterator(wrapperIterator, iterator2);
        }
        return new WrapperIterator(wrapperIterator, this.enumAccessibleTriggerMethods(session));
    }

    HsqlArrayList listVisibleSessions(Session session) {
        return this.database.sessionManager.listVisibleSessions(session);
    }

    boolean isReportCatalogs() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs");
    }

    boolean isReportSchemas() {
        return this.database.getProperties().isPropertyTrue("hsqldb.schemas");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sysSchemas.add(DEFN_SCHEMA);
        sysSchemas.add(INFO_SCHEMA);
        sysSchemas.add(PUB_SCHEMA);
        builtin.add("org.hsqldb.Library");
        builtin.add("org.hsqldb.DatabaseClassLoader");
        builtin.add("java.lang.Math");
    }
}

