/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.DINameSpace;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DIProcedureInfo {
    private Class clazz;
    private Class[] colClasses;
    private int[] colTypes;
    private int colOffset;
    private int colCount;
    private boolean colsResolved;
    private String csig;
    private String fqn;
    private int hnd_remarks;
    private Method method;
    private String sig;
    private DINameSpace nameSpace;
    private final HashMap typeMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$hsqldb$Binary;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$io$Serializable;

    public DIProcedureInfo(DINameSpace dINameSpace) throws HsqlException {
        this.setNameSpace(dINameSpace);
    }

    private int colOffset() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colOffset;
    }

    HsqlArrayList getAliases() {
        return (HsqlArrayList)this.nameSpace.getInverseAliasMap().get(this.getFQN());
    }

    String getCanonicalSignature() {
        if (this.csig == null) {
            this.csig = this.method.toString();
        }
        return this.csig;
    }

    Class getColClass(int n) {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colClasses[n + this.colOffset()];
    }

    int getColCount() {
        if (!this.colsResolved) {
            this.resolveCols();
        }
        return this.colCount;
    }

    Integer getColDataType(int n) {
        return ValuePool.getInt(this.getColTypeCode(n));
    }

    Integer getColLen(int n) {
        int n2;
        int n3 = this.getColTypeCode(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: {
                n2 = Integer.MAX_VALUE;
                break;
            }
            case -5: 
            case 6: 
            case 8: 
            case 91: 
            case 92: {
                n2 = 8;
                break;
            }
            case 93: {
                n2 = 12;
                break;
            }
            case 4: 
            case 7: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case -7: 
            case -6: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2 == 0 ? null : ValuePool.getInt(n2);
    }

    String getColName(int n) {
        return "@" + (n + this.colOffset());
    }

    Integer getColNullability(int n) {
        int n2 = this.getColClass(n).isPrimitive() ? 0 : 1;
        return ValuePool.getInt(n2);
    }

    String getColRemark(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = stringBuffer.append(this.getSignature()).append(this.getColName(n)).toString();
        return BundleHandler.getString(this.hnd_remarks, string);
    }

    int getColTypeCode(int n) {
        return this.colTypes[n += this.colOffset()];
    }

    Integer getColUsage(int n) {
        return (n += this.colOffset()) == 0 ? ValuePool.getInt(5) : ValuePool.getInt(1);
    }

    Class getDeclaringClass() {
        return this.clazz;
    }

    String getFQN() {
        if (this.fqn == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.fqn = stringBuffer.append(this.clazz.getName()).append('.').append(this.method.getName()).toString();
        }
        return this.fqn;
    }

    Integer getInputParmCount() {
        return ValuePool.getInt(this.method.getParameterTypes().length);
    }

    Method getMethod() {
        return this.method;
    }

    String getOrigin(String string) {
        return (this.nameSpace.isBuiltin(this.clazz) ? "BUILTIN " : "USER DEFINED ") + string;
    }

    Integer getOutputParmCount() {
        return ValuePool.getInt(0);
    }

    String getRemark() {
        return BundleHandler.getString(this.hnd_remarks, this.getSignature());
    }

    Integer getResultSetCount() {
        return this.method.getReturnType() == Void.TYPE ? ValuePool.getInt(0) : ValuePool.getInt(1);
    }

    Integer getResultType(String string) {
        int n = !"ROUTINE".equals(string) ? 0 : (this.method.getReturnType() == Void.TYPE ? 1 : 2);
        return ValuePool.getInt(n);
    }

    String getSignature() {
        if (this.sig == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?>[] classArray = this.method.getParameterTypes();
            int n = classArray.length;
            try {
                stringBuffer.append(this.method.getName()).append('(');
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(classArray[n2].getName());
                    if (n2 + 1 < n) {
                        stringBuffer.append(',');
                    }
                    ++n2;
                }
                stringBuffer.append(')');
                this.sig = stringBuffer.toString();
            }
            catch (Exception exception) {
                this.sig = null;
            }
        }
        return this.sig;
    }

    DINameSpace getNameSpace() {
        return this.nameSpace;
    }

    void setNameSpace(DINameSpace dINameSpace) throws HsqlException {
        Class clazz;
        Trace.doAssert(dINameSpace != null, "name space is null");
        this.nameSpace = dINameSpace;
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbcArray");
            this.typeMap.put(clazz, ValuePool.getInt(2003));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer n = ValuePool.getInt(-5);
        this.typeMap.put(Long.TYPE, n);
        this.typeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = DIProcedureInfo.class$("java.lang.Long")) : class$java$lang$Long, n);
        n = ValuePool.getInt(-7);
        this.typeMap.put(Boolean.TYPE, n);
        this.typeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DIProcedureInfo.class$("java.lang.Boolean")) : class$java$lang$Boolean, n);
        n = ValuePool.getInt(2004);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbcBlob");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(1);
        this.typeMap.put(Character.TYPE, n);
        this.typeMap.put(class$java$lang$Character == null ? (class$java$lang$Character = DIProcedureInfo.class$("java.lang.Character")) : class$java$lang$Character, n);
        this.typeMap.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DIProcedureInfo.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, n);
        this.typeMap.put(array$C == null ? (array$C = DIProcedureInfo.class$("[C")) : array$C, n);
        n = ValuePool.getInt(2005);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbcClob");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(70);
        this.typeMap.put(class$java$net$URL == null ? (class$java$net$URL = DIProcedureInfo.class$("java.net.URL")) : class$java$net$URL, n);
        n = ValuePool.getInt(91);
        this.typeMap.put(class$java$util$Date == null ? (class$java$util$Date = DIProcedureInfo.class$("java.util.Date")) : class$java$util$Date, n);
        this.typeMap.put(class$java$sql$Date == null ? (class$java$sql$Date = DIProcedureInfo.class$("java.sql.Date")) : class$java$sql$Date, n);
        n = ValuePool.getInt(3);
        try {
            clazz = this.nameSpace.classForName("java.math.BigDecimal");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbcDistinct");
            this.typeMap.put(clazz, ValuePool.getInt(2001));
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(8);
        this.typeMap.put(Double.TYPE, n);
        this.typeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = DIProcedureInfo.class$("java.lang.Double")) : class$java$lang$Double, n);
        n = ValuePool.getInt(6);
        this.typeMap.put(Float.TYPE, n);
        this.typeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = DIProcedureInfo.class$("java.lang.Float")) : class$java$lang$Float, n);
        n = ValuePool.getInt(4);
        this.typeMap.put(Integer.TYPE, n);
        this.typeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = DIProcedureInfo.class$("java.lang.Integer")) : class$java$lang$Integer, n);
        n = ValuePool.getInt(2000);
        this.typeMap.put(class$java$lang$Object == null ? (class$java$lang$Object = DIProcedureInfo.class$("java.lang.Object")) : class$java$lang$Object, n);
        n = ValuePool.getInt(-4);
        this.typeMap.put(array$B == null ? (array$B = DIProcedureInfo.class$("[B")) : array$B, n);
        this.typeMap.put(class$org$hsqldb$Binary == null ? (class$org$hsqldb$Binary = DIProcedureInfo.class$("org.hsqldb.Binary")) : class$org$hsqldb$Binary, n);
        n = ValuePool.getInt(-1);
        this.typeMap.put(class$java$lang$String == null ? (class$java$lang$String = DIProcedureInfo.class$("java.lang.String")) : class$java$lang$String, n);
        n = ValuePool.getInt(0);
        this.typeMap.put(Void.TYPE, n);
        this.typeMap.put(class$java$lang$Void == null ? (class$java$lang$Void = DIProcedureInfo.class$("java.lang.Void")) : class$java$lang$Void, n);
        n = ValuePool.getInt(2006);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbcRef");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(5);
        this.typeMap.put(Short.TYPE, n);
        this.typeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = DIProcedureInfo.class$("java.lang.Short")) : class$java$lang$Short, n);
        n = ValuePool.getInt(2002);
        try {
            clazz = this.nameSpace.classForName("org.hsqldb.jdbcStruct");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = ValuePool.getInt(92);
        this.typeMap.put(class$java$sql$Time == null ? (class$java$sql$Time = DIProcedureInfo.class$("java.sql.Time")) : class$java$sql$Time, n);
        n = ValuePool.getInt(93);
        this.typeMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = DIProcedureInfo.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, n);
        n = ValuePool.getInt(-6);
        this.typeMap.put(Byte.TYPE, n);
        this.typeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = DIProcedureInfo.class$("java.lang.Byte")) : class$java$lang$Byte, n);
        n = ValuePool.getInt(137);
        try {
            clazz = this.nameSpace.classForName("org.w3c.dom.Document");
            this.typeMap.put(clazz, n);
            clazz = this.nameSpace.classForName("org.w3c.dom.DocumentFragment");
            this.typeMap.put(clazz, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resolveCols() {
        Class<?> clazz = this.method.getReturnType();
        Class<?>[] classArray = this.method.getParameterTypes();
        int n = classArray.length + 1;
        this.colClasses = new Class[n];
        this.colTypes = new int[n];
        this.colClasses[0] = clazz;
        this.colTypes[0] = this.typeForClass(clazz);
        int n2 = 1;
        while (n2 < n) {
            Class<?> clazz2;
            this.colClasses[n2] = clazz2 = classArray[n2 - 1];
            this.colTypes[n2] = this.typeForClass(clazz2);
            ++n2;
        }
        this.colOffset = 0;
        this.colCount = this.method.getParameterTypes().length;
        if (clazz == Void.TYPE) {
            ++this.colOffset;
        } else {
            ++this.colCount;
        }
    }

    void setMethod(Method method) {
        this.method = method;
        this.clazz = this.method.getDeclaringClass();
        this.fqn = null;
        this.sig = null;
        this.csig = null;
        this.colsResolved = false;
        String string = this.clazz.getName().replace('.', '_');
        this.hnd_remarks = BundleHandler.getBundleHandle(string, null);
    }

    int typeForClass(Class clazz) {
        Class<?> clazz2;
        Integer n = (Integer)this.typeMap.get(clazz);
        if (n != null) {
            return n;
        }
        if (clazz.isArray() && !clazz.getComponentType().isArray()) {
            return 2003;
        }
        try {
            clazz2 = Class.forName("java.sql.Array");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2003;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = DIProcedureInfo.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz)) {
            return 2;
        }
        try {
            clazz2 = Class.forName("java.sql.Timestamp");
            if (clazz2.isAssignableFrom(clazz)) {
                return 93;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Time");
            if (clazz2.isAssignableFrom(clazz)) {
                return 93;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Date");
            if (clazz2.isAssignableFrom(clazz)) {
                return 91;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Blob");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2004;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Clob");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2005;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Ref");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2006;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz2 = Class.forName("java.sql.Struct");
            if (clazz2.isAssignableFrom(clazz)) {
                return 2002;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((class$org$hsqldb$Binary == null ? (class$org$hsqldb$Binary = DIProcedureInfo.class$("org.hsqldb.Binary")) : class$org$hsqldb$Binary).isAssignableFrom(clazz)) {
            return -4;
        }
        try {
            clazz2 = Class.forName("java.lang.CharSequence");
            if (clazz2.isAssignableFrom(clazz)) {
                return -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = DIProcedureInfo.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
            return 1111;
        }
        return 2000;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

