/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Cache;
import org.hsqldb.CacheFree;
import org.hsqldb.CachedRow;
import org.hsqldb.DataFileDefrag;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;

public class DataFileCache
extends Cache {
    private static final int MAX_FREE_COUNT = 1024;

    DataFileCache(String string, Database database) throws HsqlException {
        super(string, database);
    }

    void open(boolean bl) throws HsqlException {
        try {
            boolean bl2 = false;
            File file = new File(this.sName);
            if (file.exists() && file.length() > 16L) {
                bl2 = true;
            }
            this.rFile = ScaledRAFile.newScaledRAFile(this.sName, bl, 1, 1);
            if (bl2) {
                this.rFile.seek(16L);
                this.iFreePos = this.rFile.readInt();
            } else {
                this.iFreePos = 32;
                this.dbProps.setProperty("hsqldb.cache_version", "1.7.0");
            }
            String string = this.dbProps.getProperty("hsqldb.cache_version", "1.6.0");
            if (string.equals("1.7.0")) {
                this.cachedRowType = 1;
            }
            this.initBuffers();
        }
        catch (Exception exception) {
            Trace.throwerror(29, "error " + exception + " opening file " + this.sName);
        }
    }

    void close() throws HsqlException {
        if (this.rFile == null || this.rFile.readOnly) {
            return;
        }
        try {
            boolean bl;
            this.rFile.seek(16L);
            this.rFile.writeInt(this.iFreePos);
            this.saveAll();
            this.rFile.close();
            this.rFile = null;
            boolean bl2 = bl = new File(this.sName).length() < 32L;
            if (bl) {
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            Trace.throwerror(29, "error " + exception + " closing file " + this.sName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void defrag() throws HsqlException {
        if (this.rFile.isNio) {
            throw Trace.error(33);
        }
        this.close();
        try {
            if (!FileUtil.exists(this.sName)) {
                this.init();
                this.open(this.cacheReadonly);
                Trace.printSystemOut("opened empty chache");
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HsqlArrayList hsqlArrayList = null;
        try {
            try {
                this.open(true);
                DataFileDefrag dataFileDefrag = new DataFileDefrag();
                hsqlArrayList = dataFileDefrag.defrag(this.dDatabase, this.rFile, this.sName);
                this.closeFile();
                Trace.printSystemOut("closed old cache");
                FileUtil.renameOverwrite(this.sName + ".new", this.sName);
                String string = this.dDatabase.getPath() + ".backup";
                this.backup(string + ".new");
                FileUtil.renameOverwrite(string + ".new", string);
                this.dbProps.setProperty("hsqldb.cache_version", "1.7.0");
                int n = 0;
                while (n < hsqlArrayList.size()) {
                    int[] nArray = (int[])hsqlArrayList.get(n);
                    if (nArray != null) {
                        Trace.printSystemOut(StringUtil.getList(nArray, " ", ""));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Trace.throwerror(29, "error " + exception + " defrag file " + this.sName);
                Object var7_9 = null;
                this.init();
                this.open(this.cacheReadonly);
                if (hsqlArrayList != null) {
                    DataFileDefrag.updateTableIndexRoots(this.dDatabase.getTables(), hsqlArrayList);
                }
                Trace.printSystemOut("opened cache");
                return;
            }
            Object var7_8 = null;
            this.init();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.init();
            this.open(this.cacheReadonly);
            if (hsqlArrayList != null) {
                DataFileDefrag.updateTableIndexRoots(this.dDatabase.getTables(), hsqlArrayList);
            }
            Trace.printSystemOut("opened cache");
            throw throwable;
        }
        this.open(this.cacheReadonly);
        if (hsqlArrayList != null) {
            DataFileDefrag.updateTableIndexRoots(this.dDatabase.getTables(), hsqlArrayList);
        }
        Trace.printSystemOut("opened cache");
    }

    void closeFile() throws HsqlException {
        Trace.printSystemOut("DataFileCache.closeFile()");
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.close();
            this.rFile = null;
        }
        catch (Exception exception) {
            Trace.throwerror(29, "error " + exception + " in shutdown file " + this.sName);
        }
    }

    void free(CachedRow cachedRow) throws HsqlException {
        this.fileModified = true;
        ++this.iFreeCount;
        CacheFree cacheFree = new CacheFree();
        cacheFree.iPos = cachedRow.iPos;
        cacheFree.iLength = cachedRow.storageSize;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            cacheFree.fNext = this.fRoot;
        }
        this.fRoot = cacheFree;
        this.remove(cachedRow);
    }

    int setFilePos(CachedRow cachedRow) throws HsqlException {
        int n;
        int n2 = n = cachedRow.storageSize;
        CacheFree cacheFree = this.fRoot;
        CacheFree cacheFree2 = null;
        int n3 = this.iFreePos;
        while (cacheFree != null) {
            if (cacheFree.iLength >= n2) {
                n3 = cacheFree.iPos;
                if ((n2 = cacheFree.iLength - n2) < 32) {
                    if (cacheFree2 == null) {
                        this.fRoot = cacheFree.fNext;
                    } else {
                        cacheFree2.fNext = cacheFree.fNext;
                    }
                    --this.iFreeCount;
                    break;
                }
                cacheFree.iLength = n2;
                cacheFree.iPos += n;
                break;
            }
            cacheFree2 = cacheFree;
            cacheFree = cacheFree.fNext;
        }
        if (n3 == this.iFreePos) {
            this.iFreePos += n2;
        }
        cachedRow.setPos(n3);
        return n3;
    }

    protected CachedRow makeRow(int n, Table table) throws HsqlException {
        CachedRow cachedRow = null;
        ++this.makeRowCount;
        try {
            this.rFile.seek(n);
            int n2 = this.rFile.readInt();
            this.rowIn.resetRow(n, n2);
            this.rFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
            cachedRow = new CachedRow(table, this.rowIn);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Trace.throwerror(29, "reading file : " + iOException);
        }
        return cachedRow;
    }

    protected void saveRow(CachedRow cachedRow) throws IOException, HsqlException {
        this.rowOut.reset();
        this.rFile.seek(cachedRow.iPos);
        cachedRow.write(this.rowOut);
        this.rFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
    }

    void backup(String string) throws HsqlException {
        try {
            FileUtil.compressFile(this.sName, string);
        }
        catch (Exception exception) {
            throw Trace.error(29, "creating " + string);
        }
    }

    static void resetFreePos(String string) {
        try {
            ScaledRAFile scaledRAFile = ScaledRAFile.newScaledRAFile(string, false, 1, 0);
            scaledRAFile.seek(16L);
            scaledRAFile.writeInt(32);
            scaledRAFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

