/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.DoubleIntTable;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;

class DataFileDefrag {
    StopWatch stopw = new StopWatch();

    DataFileDefrag() {
    }

    HsqlArrayList defrag(Database database, ScaledRAFile scaledRAFile, String string) throws IOException, HsqlException {
        Trace.printSystemOut("Defrag Transfer begins");
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = database.getTables();
        ScaledRAFile scaledRAFile2 = ScaledRAFile.newScaledRAFile(string + ".new", false, 1, 0);
        scaledRAFile2.seek(32L);
        int n = 0;
        int n2 = hsqlArrayList2.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList2.get(n);
            if (table.tableType == 3) {
                int[] nArray = this.writeTableToDataFile(table, scaledRAFile2);
                hsqlArrayList.add(nArray);
            } else {
                hsqlArrayList.add(null);
            }
            Trace.printSystemOut(table.getName().name, " complete");
            ++n;
        }
        int n3 = (int)scaledRAFile2.getFilePointer();
        scaledRAFile2.seek(16L);
        scaledRAFile2.writeInt(n3);
        scaledRAFile2.close();
        int n4 = 0;
        int n5 = hsqlArrayList.size();
        while (n4 < n5) {
            int[] nArray = (int[])hsqlArrayList.get(n4);
            if (nArray != null) {
                Trace.printSystemOut(StringUtil.getList(nArray, ",", ""));
            }
            ++n4;
        }
        Trace.printSystemOut("Transfer complete: ", this.stopw.elapsedTime());
        return hsqlArrayList;
    }

    static void updateTableIndexRoots(HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList.get(n);
            if (table.tableType == 3) {
                int[] nArray = (int[])hsqlArrayList2.get(n);
                table.setIndexRoots(nArray);
            }
            ++n;
        }
    }

    int[] writeTableToDataFile(Table table, ScaledRAFile scaledRAFile) throws IOException, HsqlException {
        int n;
        Object object;
        BinaryServerRowOutput binaryServerRowOutput = new BinaryServerRowOutput();
        DoubleIntTable doubleIntTable = new DoubleIntTable(1000000);
        int[] nArray = table.getIndexRootsArray();
        Index index = table.getPrimaryIndex();
        long l = scaledRAFile.getFilePointer();
        int[] nArray2 = new int[2];
        int n2 = 0;
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        Node node = index.first();
        while (node != null) {
            object = (CachedRow)node.getRow();
            doubleIntTable.add(((CachedRow)object).iPos, (int)l);
            l += (long)((CachedRow)object).storageSize;
            if (n2 % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n2 + " " + nArray2[0] + " " + nArray2[1]);
            }
            node = index.next(node);
            ++n2;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n2 = 0;
        object = index.first();
        while (object != null) {
            CachedRow cachedRow = (CachedRow)((Node)object).getRow();
            n = (int)scaledRAFile.getFilePointer();
            binaryServerRowOutput.reset();
            binaryServerRowOutput.writeSize(cachedRow.storageSize);
            Node node2 = cachedRow.nPrimaryNode;
            while (node2 != null) {
                ((DiskNode)node2).writeTranslate(binaryServerRowOutput, doubleIntTable);
                node2 = node2.nNext;
            }
            binaryServerRowOutput.writeData(cachedRow.getData(), cachedRow.getTable());
            binaryServerRowOutput.writePos(n);
            scaledRAFile.write(binaryServerRowOutput.getOutputStream().getBuffer(), 0, binaryServerRowOutput.size());
            if (n2 % 50000 == 0) {
                Trace.printSystemOut(n2 + " rows " + this.stopw.elapsedTime());
            }
            object = index.next((Node)object);
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            n = doubleIntTable.find(0, nArray[n3]);
            if (n == -1) {
                throw Trace.error(129);
            }
            nArray[n3] = doubleIntTable.get(n, 1);
            ++n3;
        }
        Trace.printSystemOut(table.getName().name, " : table converted");
        return nArray;
    }
}

