/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.Constraint;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseObjectNames;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Library;
import org.hsqldb.Logger;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class Database {
    int databaseID;
    private String sType;
    private String sName;
    private String sPath;
    boolean isNew;
    private UserManager userManager;
    private HsqlArrayList tTable;
    DatabaseInformation dInfo;
    ClassLoader classLoader;
    private int dbState;
    Logger logger;
    boolean databaseReadOnly;
    boolean filesReadOnly;
    boolean filesInJar;
    boolean sqlEnforceSize;
    boolean sqlEnforceStrictSize;
    int sqlMonth;
    int firstIdentity;
    private HashMap hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    SessionManager sessionManager;
    private HsqlDatabaseProperties databaseProperties;
    HsqlNameManager nameManager;
    DatabaseObjectNames triggerNameList;
    DatabaseObjectNames indexNameList;
    static final int DATABASE_ONLINE = 1;
    static final int DATABASE_OPENING = 4;
    static final int DATABASE_CLOSING = 8;
    static final int DATABASE_SHUTDOWN = 16;
    static final int CLOSEMODE_IMMEDIATELY = -1;
    static final int CLOSEMODE_NORMAL = 0;
    static final int CLOSEMODE_COMPACT = 1;
    static final int CLOSEMODE_SCRIPT = 2;
    CompiledStatementManager compiledStatementManager;
    private long scn = 0L;
    private long ddl_scn = 0L;
    private long dml_scn = 0L;

    Database(String string, String string2, String string3, boolean bl) throws HsqlException {
        this.setState(16);
        this.sName = string3;
        this.sType = string;
        this.sPath = string2;
        if (this.sType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
            bl = true;
        }
        try {
            this.classLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            this.classLoader = null;
        }
        try {
            this.isNew = this.sType == "mem:" || !HsqlProperties.checkFileExists(string2, this.isFilesInJar(), this.getClass());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isNew && bl) {
            throw Trace.error(94, string + string2);
        }
        this.logger = new Logger();
        this.compiledStatementManager = new CompiledStatementManager(this);
    }

    synchronized void open() throws HsqlException {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() throws HsqlException {
        this.setState(4);
        try {
            this.isNew = this.sType == "mem:" || !HsqlProperties.checkFileExists(this.sPath, this.isFilesInJar(), this.getClass());
            this.databaseProperties = new HsqlDatabaseProperties(this);
            this.databaseProperties.load();
            this.compiledStatementManager.reset();
            this.tTable = new HsqlArrayList();
            this.userManager = new UserManager();
            this.hAlias = Library.getAliasMap();
            this.nameManager = new HsqlNameManager();
            this.triggerNameList = new DatabaseObjectNames();
            this.indexNameList = new DatabaseObjectNames();
            this.bReferentialIntegrity = true;
            User user = UserManager.createSysUser(this);
            this.sessionManager = new SessionManager(this, user);
            this.dInfo = DatabaseInformation.newDatabaseInformation(this);
            if (this.sType != "mem:") {
                this.logger.openLog(this);
            }
            if (this.isNew) {
                this.sessionManager.getSysSession().sqlExecuteDirectNoPreChecks("CREATE USER SA PASSWORD \"\" ADMIN");
            }
            this.dInfo.setWithContent(true);
        }
        catch (Throwable throwable) {
            HsqlException hsqlException;
            this.logger.closeLog(-1);
            this.logger.releaseLock();
            this.clearStructures();
            this.setState(16);
            if (!(throwable instanceof HsqlException)) {
                hsqlException = Trace.error(40, throwable.toString());
            }
            throw (HsqlException)hsqlException;
        }
        this.setState(1);
    }

    void clearStructures() {
        this.isNew = false;
        this.tTable = null;
        this.userManager = null;
        this.hAlias = null;
        this.nameManager = null;
        this.triggerNameList = null;
        this.indexNameList = null;
        this.sessionManager = null;
        this.dInfo = null;
    }

    String getType() {
        return this.sType;
    }

    String getPath() {
        return this.sPath;
    }

    HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    synchronized boolean isShutdown() {
        return this.dbState == 16;
    }

    synchronized Session connect(String string, String string2) throws HsqlException {
        User user = this.userManager.getUser(string, string2);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly);
        this.logger.logConnectUser(session, user.getName(), user.getPassword());
        return session;
    }

    void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    boolean isFilesInJar() {
        return this.filesInJar;
    }

    HsqlArrayList getTables() {
        return this.tTable;
    }

    UserManager getUserManager() {
        return this.userManager;
    }

    void setReferentialIntegrity(boolean bl) {
        this.bReferentialIntegrity = bl;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    HashMap getAlias() {
        return this.hAlias;
    }

    String getAlias(String string) {
        String string2 = (String)this.hAlias.get(string);
        return string2 == null ? string : string2;
    }

    Table getTable(String string, Session session) throws HsqlException {
        Table table = this.findUserTable(string, session);
        if (table == null) {
            table = this.dInfo.getSystemTable(string, session);
        }
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table getUserTable(String string, Session session) throws HsqlException {
        Table table = this.findUserTable(string, session);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table getUserTable(String string) throws HsqlException {
        Table table = this.findUserTable(string);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    Table findUserTable(String string) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.get(n);
            if (table.equals(string)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    Table findUserTable(String string, Session session) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table = (Table)this.tTable.get(n);
            if (table.equals(string, session)) {
                return table;
            }
            ++n;
        }
        return null;
    }

    void linkTable(Table table) throws HsqlException {
        this.tTable.add(table);
    }

    void setIgnoreCase(boolean bl) {
        this.bIgnoreCase = bl;
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    Table findUserTableForIndex(String string, Session session) {
        HsqlNameManager.HsqlName hsqlName = this.indexNameList.getOwner(string);
        if (hsqlName == null) {
            return null;
        }
        return this.findUserTable(hsqlName.name, session);
    }

    int getTableIndex(Table table) {
        int n = 0;
        int n2 = this.tTable.size();
        while (n < n2) {
            Table table2 = (Table)this.tTable.get(n);
            if (table2 == table) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void dropIndex(String string, Session session) throws HsqlException {
        Table table = this.findUserTableForIndex(string, session);
        if (table == null) {
            throw Trace.error(26, string);
        }
        table.checkDropIndex(string, null);
        session.commit();
        session.setScripting(!table.isTemp());
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.dropIndex(string);
    }

    public void finalize() {
        block4: {
            if (Trace.TRACE) {
                Trace.trace(this + ".finalize(): state: " + this.getStateString());
            }
            if (this.getState() != 1) {
                return;
            }
            try {
                this.close(-1);
            }
            catch (HsqlException hsqlException) {
                if (!Trace.TRACE) break block4;
                Trace.trace(hsqlException.toString());
            }
        }
    }

    void close(int n) throws HsqlException {
        HsqlException hsqlException = null;
        this.setState(8);
        this.sessionManager.closeAllSessions();
        this.sessionManager.clearAll();
        this.logger.closeLog(n);
        try {
            if (n == 1 && !this.filesReadOnly) {
                this.reopen();
                this.setState(8);
                this.logger.closeLog(0);
            }
        }
        catch (Throwable throwable) {
            hsqlException = throwable instanceof HsqlException ? (HsqlException)throwable : Trace.error(40, throwable.toString());
        }
        this.classLoader = null;
        this.logger.releaseLock();
        this.clearStructures();
        this.setState(16);
        DatabaseManager.removeDatabase(this);
        if (hsqlException != null) {
            throw hsqlException;
        }
    }

    void dropTempTables(Session session) {
        int n = this.tTable.size();
        while (n-- > 0) {
            Table table = (Table)this.tTable.get(n);
            if (!table.isTemp() || table.getOwnerSessionId() == session.getId()) continue;
            this.tTable.remove(n);
        }
    }

    void dropTable(String string, boolean bl, boolean bl2, Session session) throws HsqlException {
        Table table = null;
        int n = -1;
        int n2 = -1;
        Iterator iterator = null;
        Constraint constraint = null;
        Table table2 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        while (n3 < this.tTable.size()) {
            table = (Table)this.tTable.get(n3);
            if (table.equals(string, session) && bl2 == table.isView()) {
                n = n3;
                break;
            }
            table = null;
            ++n3;
        }
        if (n == -1) {
            if (bl) {
                return;
            }
            throw Trace.error(bl2 ? 53 : 22, string);
        }
        iterator = table.getConstraints().iterator();
        while (iterator.hasNext()) {
            constraint = (Constraint)iterator.next();
            if (constraint.getType() != 1) continue;
            table2 = constraint.getRef();
            bl3 = table2 != null;
            boolean bl5 = bl4 = bl3 && table.equals(table2);
            if (!bl3 || bl4) continue;
            int n4 = 0;
            while (n4 < this.tTable.size()) {
                if (table2.equals(this.tTable.get(n4))) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            if (n2 == -1) continue;
            throw Trace.error(8, 101, new Object[]{constraint.getName().name, table2.getName().name});
        }
        this.tTable.remove(n);
        this.removeExportedKeys(table);
        this.userManager.removeDbObject(table.getName());
        this.triggerNameList.removeOwner(table.tableName);
        this.indexNameList.removeOwner(table.tableName);
        table.drop();
        session.setScripting(!table.isTemp());
        session.commit();
    }

    void removeExportedKeys(Table table) {
        int n = 0;
        while (n < this.tTable.size()) {
            HsqlArrayList hsqlArrayList = ((Table)this.tTable.get(n)).getConstraints();
            int n2 = hsqlArrayList.size() - 1;
            while (n2 >= 0) {
                Constraint constraint = (Constraint)hsqlArrayList.get(n2);
                Table table2 = constraint.getRef();
                if (table == table2) {
                    hsqlArrayList.remove(n2);
                }
                --n2;
            }
            ++n;
        }
    }

    void dropTrigger(String string, Session session) throws HsqlException {
        boolean bl = this.triggerNameList.containsName(string);
        Trace.check(bl, 43, string);
        HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)this.triggerNameList.removeName(string);
        Table table = this.findUserTable(hsqlName.name, session);
        table.dropTrigger(string);
        session.setScripting(!table.isTemp());
    }

    void setMetaDirty(Result result) {
        if (result == null || result.iMode == 1 && result.iUpdateCount > 0) {
            this.nextDDLSCN();
            this.dInfo.setDirty();
        }
    }

    synchronized long getSCN() {
        return this.scn;
    }

    private synchronized void setSCN(long l) {
        this.scn = l;
    }

    private synchronized long nextSCN() {
        ++this.scn;
        return this.scn;
    }

    synchronized long getDDLSCN() {
        return this.ddl_scn;
    }

    synchronized long getDMLSCN() {
        return this.dml_scn;
    }

    synchronized long nextDDLSCN() {
        this.ddl_scn = this.nextSCN();
        return this.ddl_scn;
    }

    synchronized long nextDMLSCN() {
        this.dml_scn = this.nextSCN();
        return this.dml_scn;
    }

    private synchronized void setState(int n) {
        this.dbState = n;
    }

    synchronized int getState() {
        return this.dbState;
    }

    String getStateString() {
        int n = this.getState();
        switch (n) {
            case 8: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 4: {
                return "DATABASE_OPENING";
            }
            case 16: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }
}

