/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseScript;
import org.hsqldb.DatabaseScriptWriter;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Logger;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlStringBuffer;
import org.hsqldb.lib.StringUtil;

class DatabaseCommandInterpreter {
    protected Database database;
    protected Session session;
    static final String oldLib = "org.hsql.Library.";
    static final int oldLibLen = "org.hsql.Library.".length();
    static final String newLib = "org.hsqldb.Library.";
    static final Result emptyResult = new Result(1);
    TableWorks tableWorks = new TableWorks(null);
    Tokenizer tokenizer = new Tokenizer();
    CompiledStatement cs = new CompiledStatement();

    DatabaseCommandInterpreter(Session session) {
        this.session = session;
        this.database = session.getDatabase();
    }

    Result execute(String string) {
        DatabaseManager.gc();
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        Result result = null;
        int n = -1;
        Logger logger = this.database.logger;
        try {
            this.tokenizer.reset(string);
            Parser parser = new Parser(this.database, this.tokenizer, this.session);
            while (true) {
                this.tokenizer.setPartMarker();
                this.session.setScripting(false);
                String string2 = this.tokenizer.getString();
                if (string2.length() != 0) {
                    n = Token.get(string2);
                    if (n == 40) continue;
                    result = this.executePart(n, string2, parser);
                    if (result.iMode != 2) {
                        if (!this.session.getScripting()) continue;
                        logger.writeToLog(this.session, this.tokenizer.getLastPart());
                        continue;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            result = new Result(throwable, this.tokenizer.getLastPart());
        }
        return result == null ? emptyResult : result;
    }

    private Result executePart(int n, String string, Parser parser) throws Throwable {
        Result result = emptyResult;
        switch (n) {
            case 39: {
                this.cs = parser.compileSelectStatement(this.cs);
                Trace.doAssert(this.cs.parameters.length == 0, "direct execute with param count > 0");
                if (this.cs.select.sIntoTable == null) {
                    result = this.session.sqlExecuteCompiledNoPreChecks(this.cs);
                    break;
                }
                result = this.processSelectInto(this.cs.select);
                this.database.setMetaDirty(result);
                break;
            }
            case 21: {
                this.cs = parser.compileInsertStatement(this.cs);
                Trace.doAssert(this.cs.parameters.length == 0, "direct execute with param count > 0");
                result = this.session.sqlExecuteCompiledNoPreChecks(this.cs);
                break;
            }
            case 48: {
                this.cs = parser.compileUpdateStatement(this.cs);
                Trace.doAssert(this.cs.parameters.length == 0, "direct execute with param count > 0");
                result = this.session.sqlExecuteCompiledNoPreChecks(this.cs);
                break;
            }
            case 13: {
                this.cs = parser.compileDeleteStatement(this.cs);
                Trace.doAssert(this.cs.parameters.length == 0, "direct execute with param count > 0");
                result = this.session.sqlExecuteCompiledNoPreChecks(this.cs);
                break;
            }
            case 6: {
                this.cs = parser.compileCallStatement(this.cs);
                Trace.doAssert(this.cs.parameters.length < 1, "direct execute with param count > 0");
                result = this.session.sqlExecuteCompiledNoPreChecks(this.cs);
                break;
            }
            case 41: {
                this.processSet();
                break;
            }
            case 9: {
                this.processCommit();
                break;
            }
            case 35: {
                this.processRollback();
                break;
            }
            case 36: {
                this.processSavepoint();
                break;
            }
            case 12: {
                this.processCreate();
                this.database.setMetaDirty(null);
                break;
            }
            case 3: {
                this.processAlter();
                this.database.setMetaDirty(null);
                break;
            }
            case 15: {
                this.processDrop();
                this.database.setMetaDirty(null);
                break;
            }
            case 18: {
                this.processGrantOrRevoke(true);
                this.database.setMetaDirty(null);
                break;
            }
            case 34: {
                this.processGrantOrRevoke(false);
                this.database.setMetaDirty(null);
                break;
            }
            case 10: {
                this.processConnect();
                this.database.setMetaDirty(null);
                this.session.setScripting(true);
                break;
            }
            case 14: {
                this.processDisconnect();
                this.session.setScripting(true);
                break;
            }
            case 37: {
                result = this.processScript();
                break;
            }
            case 42: {
                this.processShutdown();
                break;
            }
            case 7: {
                this.processCheckpoint();
                break;
            }
            case 16: {
                result = this.processExplainPlan();
                break;
            }
            case 32: {
                this.processReleaseSavepoint();
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
        return result;
    }

    private Result processScript() throws IOException, HsqlException {
        String string = this.tokenizer.getString();
        if (this.tokenizer.wasValue()) {
            string = (String)this.tokenizer.getAsValue();
            DatabaseScriptWriter databaseScriptWriter = new DatabaseScriptWriter(this.database, string, true, true);
            databaseScriptWriter.writeAll();
            databaseScriptWriter.close();
            return new Result(1);
        }
        this.tokenizer.back();
        this.session.checkAdmin();
        return DatabaseScript.getScript(this.database, false);
    }

    private void processCreate() throws HsqlException {
        boolean bl;
        String string;
        block17: {
            block16: {
                this.session.checkReadWrite();
                string = this.tokenizer.getString();
                bl = false;
                if (!string.equals("TEMP")) break block16;
                bl = true;
                string = this.tokenizer.getString();
                switch (Token.get(string)) {
                    case 45: {
                        this.session.checkAdmin();
                    }
                    case 24: 
                    case 44: {
                        this.session.setScripting(false);
                        break block17;
                    }
                    default: {
                        throw Trace.error(11, string);
                    }
                }
            }
            this.session.checkAdmin();
            this.session.checkDDLWrite();
            this.session.setScripting(true);
        }
        boolean bl2 = false;
        int n = 0;
        switch (Token.get(string)) {
            case 44: {
                n = bl ? 1 : 2;
                this.processCreateTable(n);
                break;
            }
            case 24: {
                this.tokenizer.getThis("TABLE");
                n = bl ? 1 : 2;
                this.processCreateTable(n);
                break;
            }
            case 5: {
                this.tokenizer.getThis("TABLE");
                this.processCreateTable(3);
                break;
            }
            case 45: {
                this.tokenizer.getThis("TABLE");
                n = bl ? 4 : 5;
                this.processCreateTable(n);
                break;
            }
            case 50: {
                this.processCreateView();
                break;
            }
            case 46: {
                this.processCreateTrigger();
                break;
            }
            case 49: {
                this.processCreateUser();
                break;
            }
            case 2: {
                this.processCreateAlias();
                break;
            }
            case 47: {
                bl2 = true;
                this.tokenizer.getThis("INDEX");
            }
            case 20: {
                this.processCreateIndex(bl2);
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
    }

    private int[] processColumnList(Table table) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HashSet hashSet = new HashSet();
        this.tokenizer.getThis("(");
        do {
            string = this.tokenizer.getName();
            hsqlArrayList.add(string);
            hashSet.add(string);
            if (hsqlArrayList.size() == hashSet.size()) continue;
            throw Trace.error(27, 102, null);
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        int n = hsqlArrayList.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = table.getColumnNr((String)hsqlArrayList.get(n2));
            ++n2;
        }
        return nArray;
    }

    private void addIndexOn(Table table, String string, boolean bl, boolean bl2) throws HsqlException {
        if (this.database.indexNameList.containsName(string)) {
            throw Trace.error(23);
        }
        HsqlNameManager.HsqlName hsqlName = this.newIndexHsqlName(string, bl);
        int[] nArray = this.processColumnList(table);
        this.session.commit();
        this.session.setScripting(!table.isTemp());
        this.tableWorks.setTable(table);
        this.tableWorks.createIndex(nArray, hsqlName, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger() throws HsqlException {
        String string = this.tokenizer.getName();
        this.checkTriggerExists(string, false);
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        boolean bl2 = false;
        boolean bl3 = false;
        int n = TriggerDef.getDefaultQueueSize();
        String string2 = this.tokenizer.getString();
        String string3 = this.tokenizer.getString();
        this.tokenizer.getThis("ON");
        String string4 = this.tokenizer.getString();
        Table table = this.database.getTable(string4, this.session);
        this.checkIsReallyTable(table);
        this.session.setScripting(!table.isTemp());
        String string5 = this.tokenizer.getString();
        if (string5.equals("FOR")) {
            string5 = this.tokenizer.getString();
            if (!string5.equals("EACH")) throw Trace.error(12, string5);
            string5 = this.tokenizer.getString();
            if (!string5.equals("ROW")) throw Trace.error(12, string5);
            bl2 = true;
            string5 = this.tokenizer.getString();
        }
        if (string5.equals("NOWAIT")) {
            bl3 = true;
            string5 = this.tokenizer.getString();
        }
        if (string5.equals("QUEUE")) {
            n = this.tokenizer.getInt();
            string5 = this.tokenizer.getString();
        }
        if (!string5.equals("CALL")) {
            throw Trace.error(12, string5);
        }
        String string6 = this.tokenizer.getString();
        try {
            Class clazz = this.classForName(string6);
            Trigger trigger = (Trigger)clazz.newInstance();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl);
            TriggerDef triggerDef = new TriggerDef(hsqlName, string2, string3, bl2, table, trigger, "\"" + string6 + "\"", bl3, n);
            if (!triggerDef.isValid()) {
                String string7 = "parsing trigger command ";
                throw Trace.error(11, string7);
            }
            table.addTrigger(triggerDef);
            triggerDef.start();
        }
        catch (Exception exception) {
            String string8 = "loading trigger class " + exception.getMessage();
            throw Trace.error(13, string8);
        }
        this.database.triggerNameList.addName(string, table.getName());
    }

    private Column processCreateColumn(Table table) throws HsqlException {
        int n;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = true;
        String string = null;
        String string2 = this.tokenizer.getString();
        String string3 = string2;
        Trace.check(!string3.equals(""), 27, string3);
        boolean bl4 = this.tokenizer.wasQuotedIdentifier();
        String string4 = this.tokenizer.getString();
        int n5 = Types.getTypeNr(string4);
        if (string4.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
        }
        if (n5 == 12 && this.database.isIgnoreCase()) {
            n5 = 100;
        }
        string2 = this.tokenizer.getString();
        if (n5 == 8 && string2.equals("PRECISION")) {
            string2 = this.tokenizer.getString();
        }
        String string5 = "";
        if (string2.equals("(")) {
            while (!(string2 = this.tokenizer.getString()).equals(")")) {
                string5 = string5 + string2;
            }
            string2 = this.tokenizer.getString();
        }
        if ((n = string5.indexOf(",")) != -1) {
            String string6 = string5.substring(n + 1, string5.length());
            string5 = string5.substring(0, n);
            Trace.check(Types.acceptsScaleCreateParam(n5), 11);
            try {
                n4 = Integer.parseInt(string6.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        if (!StringUtil.isEmpty(string5)) {
            Trace.check(Types.acceptsPrecisionCreateParam(n5), 11);
            try {
                n3 = Integer.parseInt(string5.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        if (string2.equals("DEFAULT")) {
            string = this.processCreateDefaultValue(n5, n3);
            string2 = this.tokenizer.getString();
        } else if (string2.equals("GENERATED")) {
            this.tokenizer.getThis("BY");
            this.tokenizer.getThis("DEFAULT");
            this.tokenizer.getThis("AS");
            this.tokenizer.getThis("IDENTITY");
            this.tokenizer.getThis("(");
            this.tokenizer.getThis("START");
            this.tokenizer.getThis("WITH");
            try {
                n2 = this.tokenizer.getInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
            this.tokenizer.getThis(")");
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("NULL")) {
            string2 = this.tokenizer.getString();
        } else if (string2.equals("NOT")) {
            this.tokenizer.getThis("NULL");
            bl3 = false;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("IDENTITY")) {
            if (bl) {
                throw Trace.error(24, "IDENTITY");
            }
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getString();
        }
        if (string2.equals("PRIMARY")) {
            this.tokenizer.getThis("KEY");
            bl2 = true;
        } else {
            this.tokenizer.back();
        }
        return new Column(this.database.nameManager.newHsqlName(string3, bl4), bl3, n5, n3, n4, bl, n2, bl2, string);
    }

    private String processCreateDefaultValue(int n, int n2) throws HsqlException {
        String string;
        String string2;
        String string3 = this.tokenizer.getString();
        boolean bl = false;
        if (string3.equals("-") && this.tokenizer.getType() != 12) {
            bl = true;
            string3 = string3 + this.tokenizer.getString();
        }
        if (n == 1111 || !this.tokenizer.wasValue()) {
            throw Trace.error(46, string3);
        }
        Object object = this.tokenizer.getAsValue();
        if (bl) {
            object = Column.negate(object, n);
        }
        if (object == null) {
            return string3;
        }
        try {
            Column.convertObject(object, n);
        }
        catch (Exception exception) {
            throw Trace.error(46, string3);
        }
        DatabaseCommandInterpreter.checkBooleanDefault(string3, n);
        if ((this.database.sqlEnforceSize || this.database.sqlEnforceSize) && !(string2 = Column.convertObject(object)).equals(string = (String)Table.enforceSize(string2, n, n2, false, false))) {
            throw Trace.error(46, string3);
        }
        return string3;
    }

    public static void checkBooleanDefault(String string, int n) throws HsqlException {
        if (n != -7 || string == null) {
            return;
        }
        if ((string = string.toUpperCase()).equals("TRUE") || string.equals("FALSE")) {
            return;
        }
        if (string.equals("0") || string.equals("1")) {
            return;
        }
        throw Trace.error(46, string);
    }

    private HsqlArrayList processCreateConstraints(Table table, boolean bl, int[] nArray) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        TempConstraint tempConstraint = new TempConstraint(null, nArray, null, null, 1, 3, 3);
        HsqlNameManager.HsqlName hsqlName = null;
        hsqlArrayList.add(tempConstraint);
        if (!bl) {
            return hsqlArrayList;
        }
        int n = 0;
        do {
            string = this.tokenizer.getString();
            HsqlNameManager.HsqlName hsqlName2 = null;
            ++n;
            if (string.equals("CONSTRAINT")) {
                hsqlName2 = this.database.nameManager.newHsqlName(this.tokenizer.getName(), this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            }
            switch (Token.get(string)) {
                case 28: {
                    this.tokenizer.getThis("KEY");
                    hsqlName = hsqlName2;
                    Object object = this.processColumnList(table);
                    TempConstraint tempConstraint2 = (TempConstraint)hsqlArrayList.get(0);
                    if (tempConstraint2.localCol != null && !ArrayUtil.areEqual(tempConstraint2.localCol, object, ((int[])object).length, true)) {
                        throw Trace.error(24);
                    }
                    tempConstraint2.localCol = object;
                    tempConstraint2.name = hsqlName;
                    break;
                }
                case 47: {
                    Object object = this.processColumnList(table);
                    if (hsqlName2 == null) {
                        hsqlName2 = this.database.nameManager.newAutoName("CT");
                    }
                    tempConstraint = new TempConstraint(hsqlName2, (int[])object, null, null, 2, 3, 3);
                    hsqlArrayList.add(tempConstraint);
                    break;
                }
                case 17: {
                    Object object;
                    this.tokenizer.getThis("KEY");
                    tempConstraint = this.processCreateFK(table, hsqlName2);
                    if (tempConstraint.expCol == null) {
                        object = (TempConstraint)hsqlArrayList.get(0);
                        tempConstraint.expCol = object.localCol;
                        if (tempConstraint.expCol == null) {
                            throw Trace.error(26, 103, null);
                        }
                    }
                    this.checkFKColumnDefaults(table, tempConstraint);
                    table.checkColumnsMatch(tempConstraint.localCol, tempConstraint.expTable, tempConstraint.expCol);
                    hsqlArrayList.add(tempConstraint);
                }
            }
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hsqlArrayList;
    }

    private void processCreateTable(int n) throws HsqlException {
        Object object;
        boolean bl;
        int[] nArray;
        Table table;
        block11: {
            String string = this.tokenizer.getName();
            this.checkTableExists(string, false);
            boolean bl2 = this.tokenizer.wasQuotedIdentifier();
            table = this.newTable(n, string, bl2);
            this.tokenizer.getThis("(");
            nArray = null;
            int n2 = 0;
            bl = false;
            while (true) {
                string = this.tokenizer.getString();
                bl2 = this.tokenizer.wasQuotedIdentifier();
                switch (Token.get(string)) {
                    case 11: 
                    case 17: 
                    case 28: 
                    case 47: {
                        bl = true;
                    }
                }
                this.tokenizer.back();
                if (bl) break block11;
                object = this.processCreateColumn(table);
                table.addColumn((Column)object);
                if (((Column)object).isPrimaryKey()) {
                    Trace.check(nArray == null, 24, "column ", n2);
                    nArray = new int[]{n2};
                }
                if (!(string = this.tokenizer.getString()).equals(",")) break;
                ++n2;
            }
            if (!string.equals(")")) {
                throw Trace.error(11, string);
            }
        }
        HsqlArrayList hsqlArrayList = this.processCreateConstraints(table, bl, nArray);
        try {
            this.session.commit();
            object = (TempConstraint)hsqlArrayList.get(0);
            table.createPrimaryKey(((TempConstraint)object).name, ((TempConstraint)object).localCol, true);
            boolean bl3 = false;
            int n3 = 1;
            while (n3 < hsqlArrayList.size()) {
                object = (TempConstraint)hsqlArrayList.get(n3);
                if (((TempConstraint)object).type == 2) {
                    this.tableWorks.setTable(table);
                    this.tableWorks.createUniqueConstraint(((TempConstraint)object).localCol, ((TempConstraint)object).name);
                    table = this.tableWorks.getTable();
                }
                if (((TempConstraint)object).type == 0) {
                    this.tableWorks.setTable(table);
                    this.tableWorks.createForeignKey(((TempConstraint)object).localCol, ((TempConstraint)object).expCol, ((TempConstraint)object).name, ((TempConstraint)object).expTable, ((TempConstraint)object).deleteAction, ((TempConstraint)object).updateAction);
                    table = this.tableWorks.getTable();
                }
                ++n3;
            }
            this.database.linkTable(table);
        }
        catch (HsqlException hsqlException) {
            this.database.removeExportedKeys(table);
            throw hsqlException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TempConstraint processCreateFK(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table);
        this.tokenizer.getThis("REFERENCES");
        String string = this.tokenizer.getString();
        Table table2 = table.equals(string) ? table : this.database.getTable(string, this.session);
        int[] nArray2 = null;
        String string2 = this.tokenizer.getString();
        this.tokenizer.back();
        if (string2.equals("(")) {
            nArray2 = this.processColumnList(table2);
        } else {
            Index index = table2.getPrimaryIndex();
            if (index != null && (nArray2 = index.getColumns())[0] == table2.getColumnCount()) {
                throw Trace.error(26, 104, new Object[]{string});
            }
        }
        string2 = this.tokenizer.getString();
        int n = 3;
        int n2 = 3;
        while (string2.equals("ON")) {
            string2 = this.tokenizer.getString();
            if (n == 3 && string2.equals("DELETE")) {
                string2 = this.tokenizer.getString();
                if (string2.equals("SET")) {
                    string2 = this.tokenizer.getString();
                    if (string2.equals("DEFAULT")) {
                        n = 4;
                    } else {
                        if (!string2.equals("NULL")) throw Trace.error(11, string2);
                        n = 2;
                    }
                } else {
                    if (!string2.equals("CASCADE")) throw Trace.error(11, string2);
                    n = 0;
                }
            } else {
                if (n2 != 3 || !string2.equals("UPDATE")) throw Trace.error(11, string2);
                string2 = this.tokenizer.getString();
                if (string2.equals("SET")) {
                    string2 = this.tokenizer.getString();
                    if (string2.equals("DEFAULT")) {
                        n2 = 4;
                    } else {
                        if (!string2.equals("NULL")) throw Trace.error(11, string2);
                        n2 = 2;
                    }
                } else if (string2.equals("CASCADE")) {
                    n2 = 0;
                }
            }
            string2 = this.tokenizer.getString();
        }
        this.tokenizer.back();
        if (hsqlName != null) return new TempConstraint(hsqlName, nArray, table2, nArray2, 0, n, n2);
        hsqlName = this.database.nameManager.newAutoName("FK");
        return new TempConstraint(hsqlName, nArray, table2, nArray2, 0, n, n2);
    }

    private void processCreateView() throws HsqlException {
        String string = this.tokenizer.getName();
        int n = this.tokenizer.getPartMarker();
        this.checkViewExists(string, false);
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
        View view = new View(this.database, hsqlName);
        this.tokenizer.getThis("AS");
        this.tokenizer.setPartMarker();
        this.tokenizer.getThis("SELECT");
        Parser parser = new Parser(this.database, this.tokenizer, this.session);
        Select select = parser.parseSelect();
        if (select.sIntoTable != null) {
            throw Trace.error(22);
        }
        select.setPreProcess();
        Result result = select.getResult(1);
        view.setStatement(this.tokenizer.getLastPart());
        view.addColumns(result);
        this.session.commit();
        this.database.linkTable(view);
        this.tokenizer.setPartMarker(n);
    }

    private void processAlterTableRename(Table table) throws HsqlException {
        String string = table.getName().name;
        if (!table.equals(string, this.session)) {
            throw Trace.error(22);
        }
        this.tokenizer.getThis("TO");
        String string2 = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        this.checkTableExists(string2, false);
        this.session.commit();
        this.session.setScripting(!table.isTemp());
        table.setName(string2, bl);
    }

    private void processAlter() throws HsqlException {
        this.session.checkDDLWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        String string = this.tokenizer.getString();
        switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 44: {
                this.processAlterTable();
                break;
            }
            case 20: {
                this.processAlterIndex();
            }
        }
    }

    private void processAlterTable() throws HsqlException {
        String string = this.tokenizer.getString();
        Table table = this.database.getUserTable(string, this.session);
        this.checkIsReallyTable(table);
        this.session.setScripting(!table.isTemp());
        String string2 = this.tokenizer.getString();
        switch (Token.get(string2)) {
            default: {
                throw Trace.error(11, string2);
            }
            case 33: {
                this.processAlterTableRename(table);
                return;
            }
            case 1: {
                string2 = this.tokenizer.getString();
                switch (Token.get(string2)) {
                    case 11: {
                        this.processAlterTableAddConstraint(table);
                        return;
                    }
                    case 17: {
                        this.tokenizer.getThis("KEY");
                        this.processAlterTableAddForeignKeyConstraint(table, null);
                        return;
                    }
                    case 47: {
                        this.processAlterTableAddUniqueConstraint(table, null);
                        return;
                    }
                    default: {
                        this.tokenizer.back();
                    }
                    case 8: 
                }
                this.processAlterTableAddColumn(table);
                return;
            }
            case 15: {
                string2 = this.tokenizer.getString();
                switch (Token.get(string2)) {
                    case 11: {
                        this.processAlterTableDropConstraint(table);
                        return;
                    }
                    default: {
                        this.tokenizer.back();
                    }
                    case 8: 
                }
                this.processAlterTableDropColumn(table);
                return;
            }
            case 3: 
        }
        this.tokenizer.getThis("COLUMN");
        this.processAlterColumn(table);
    }

    private void processAlterColumn(Table table) throws HsqlException {
        String string = this.tokenizer.getString();
        Column column = table.getColumn(table.getColumnNr(string));
        String string2 = this.tokenizer.getString();
        switch (Token.get(string2)) {
            default: {
                throw Trace.error(11, string2);
            }
            case 33: {
                this.tokenizer.getThis("TO");
                this.processAlterColumnRename(table, column);
                return;
            }
            case 15: {
                this.tokenizer.getThis("DEFAULT");
                column.defaultString = null;
                return;
            }
            case 41: 
        }
        this.tokenizer.getThis("DEFAULT");
        int n = column.getType();
        int n2 = column.getSize();
        column.defaultString = this.processCreateDefaultValue(n, n2);
    }

    private void processAlterColumnRename(Table table, Column column) throws HsqlException {
        String string = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        if (table.searchColumn(string) > -1) {
            throw Trace.error(27, string);
        }
        this.session.commit();
        this.session.setScripting(!table.isTemp());
        int n = table.getColumnNr(column.columnName.name);
        table.vColumn.setKey(n, string);
        column.columnName.rename(string, bl);
    }

    private void processAlterIndex() throws HsqlException {
        this.processAlterIndexRename();
    }

    private void processDrop() throws HsqlException {
        this.session.checkReadWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        String string = this.tokenizer.getString();
        boolean bl = false;
        switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 50: {
                bl = true;
            }
            case 44: {
                this.processDropTable(bl);
                break;
            }
            case 49: {
                this.processDropUser();
                break;
            }
            case 46: {
                this.processDropTrigger();
                break;
            }
            case 20: {
                this.processDropIndex();
            }
        }
    }

    private void processGrantOrRevoke(boolean bl) throws HsqlException {
        Object object;
        String string;
        this.session.checkDDLWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        int n = 0;
        do {
            string = this.tokenizer.getString();
            n |= UserManager.getRight(string);
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals("ON")) {
            throw Trace.error(11, string);
        }
        Object object2 = null;
        string = this.tokenizer.getString();
        if (string.equals("CLASS")) {
            object2 = this.tokenizer.getString();
        } else {
            object = this.database.getTable(string, this.session);
            object2 = ((Table)object).getName();
            this.session.setScripting(!((Table)object).isTemp());
        }
        this.tokenizer.getThis("TO");
        string = this.tokenizer.getStringToken();
        object = this.database.getUserManager();
        if (bl) {
            ((UserManager)object).grant(string, object2, n);
        } else {
            ((UserManager)object).revoke(string, object2, n);
        }
    }

    private void processConnect() throws HsqlException {
        this.tokenizer.getThis("USER");
        String string = this.tokenizer.getStringToken();
        this.tokenizer.getThis("PASSWORD");
        String string2 = this.tokenizer.getStringToken();
        User user = this.database.getUserManager().getUser(string, string2);
        this.session.commit();
        this.session.setUser(user);
    }

    private void processSet() throws HsqlException {
        this.session.setScripting(true);
        String string = this.tokenizer.getString();
        block0 : switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 29: {
                this.session.checkAdmin();
                string = this.tokenizer.getString().toLowerCase();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(125);
                }
                HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
                Trace.check(!hsqlDatabaseProperties.isProtected(string), 33, string);
                String string2 = this.tokenizer.getString().toLowerCase();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(125);
                }
                hsqlDatabaseProperties.setProperty(string, string2);
                string = this.tokenizer.getString();
                break;
            }
            case 26: {
                this.session.checkDDLWrite();
                this.session.setPassword(this.tokenizer.getStringToken());
                break;
            }
            case 30: {
                this.session.commit();
                this.session.setReadOnly(this.processTrueOrFalse());
                break;
            }
            case 22: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int n = this.tokenizer.getInt();
                this.database.logger.setLogSize(n);
                break;
            }
            case 38: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                string = this.tokenizer.getString();
                int n = ArrayUtil.find(Token.LIST_SCRIPT_FORMATS, string);
                if (n == 0 || n == 1 || n == 3) {
                    this.database.logger.setScriptType(n);
                    break;
                }
                throw Trace.error(11, string);
            }
            case 19: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.database.setIgnoreCase(this.processTrueOrFalse());
                break;
            }
            case 23: {
                this.session.setScripting(false);
                int n = this.tokenizer.getInt();
                this.session.setSQLMaxRows(n);
                break;
            }
            case 4: {
                this.session.setAutoCommit(this.processTrueOrFalse());
                break;
            }
            case 44: {
                this.session.checkDDLWrite();
                Table table = this.database.getTable(this.tokenizer.getString(), this.session);
                string = this.tokenizer.getString();
                this.session.setScripting(!table.isTemp());
                switch (Token.get(string)) {
                    default: {
                        throw Trace.error(11, string);
                    }
                    case 43: {
                        if (!table.isTemp()) {
                            this.session.checkAdmin();
                        }
                        string = this.tokenizer.getString();
                        if (!this.tokenizer.wasQuotedIdentifier()) {
                            throw Trace.error(75);
                        }
                        boolean bl = false;
                        if (this.tokenizer.getString().equals("DESC")) {
                            bl = true;
                        } else {
                            this.tokenizer.back();
                        }
                        table.setDataSource(string, bl, this.session);
                        break block0;
                    }
                    case 30: {
                        this.session.checkAdmin();
                        table.setDataReadOnly(this.processTrueOrFalse());
                        break block0;
                    }
                    case 20: 
                }
                this.session.checkAdmin();
                this.tokenizer.getString();
                table.setIndexRoots((String)this.tokenizer.getAsValue());
                break;
            }
            case 31: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                this.database.setReferentialIntegrity(this.processTrueOrFalse());
                break;
            }
            case 51: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int n = 0;
                String string3 = this.tokenizer.getString();
                if (string3.equals("TRUE")) {
                    n = 60;
                } else if (string3.equals("FALSE")) {
                    n = 0;
                } else {
                    this.tokenizer.back();
                    n = this.tokenizer.getInt();
                }
                this.database.logger.setWriteDelay(n);
            }
        }
    }

    private boolean processTrueOrFalse() throws HsqlException {
        String string = this.tokenizer.getString();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, string);
    }

    private void processCommit() throws HsqlException {
        if (!this.tokenizer.getString().equals("WORK")) {
            this.tokenizer.back();
        }
        this.session.commit();
    }

    private void processRollback() throws HsqlException {
        String string = this.tokenizer.getString();
        boolean bl = false;
        if (!string.equals("WORK")) {
            if (string.equals("TO")) {
                this.tokenizer.getThis("SAVEPOINT");
                string = this.tokenizer.getString();
                bl = true;
            } else {
                this.tokenizer.back();
            }
        }
        if (bl) {
            if (string.length() == 0) {
                String string2 = "missing or zero-length savepoint name";
                throw Trace.error(11, string2);
            }
            this.session.rollbackToSavepoint(string);
        } else {
            this.session.rollback();
        }
    }

    private void processSavepoint() throws HsqlException {
        String string = this.tokenizer.getString();
        if (string.length() == 0) {
            String string2 = "missing or zero-length savepoint name";
            throw Trace.error(11, string2);
        }
        this.session.savepoint(string);
    }

    private void processShutdown() throws HsqlException {
        if (!this.session.isClosed()) {
            this.session.checkAdmin();
        }
        int n = 0;
        String string = this.tokenizer.getString();
        if (string.equals("IMMEDIATELY")) {
            n = -1;
        } else if (string.equals("COMPACT")) {
            n = 1;
        } else if (string.equals("SCRIPT")) {
            n = 2;
        } else {
            this.tokenizer.back();
        }
        this.database.close(n);
    }

    private void processCheckpoint() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        boolean bl = false;
        String string = this.tokenizer.getString();
        if (string.equals("DEFRAG")) {
            bl = true;
        }
        this.database.logger.checkpoint(bl);
    }

    private HsqlNameManager.HsqlName newIndexHsqlName(String string, boolean bl) throws HsqlException {
        return HsqlNameManager.HsqlName.isReservedIndexName(string) ? this.database.nameManager.newAutoName("USER", string) : this.database.nameManager.newHsqlName(string, bl);
    }

    private Table newTable(int n, String string, boolean bl) throws HsqlException {
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl);
        int n2 = this.session.getId();
        switch (n) {
            case 4: 
            case 5: {
                return new TextTable(this.database, hsqlName, n, n2);
            }
        }
        return new Table(this.database, hsqlName, n, n2);
    }

    private void checkIndexExists(String string, boolean bl) throws HsqlException {
        boolean bl2;
        boolean bl3 = bl2 = this.database.findUserTableForIndex(string, this.session) != null;
        if (bl2 != bl) {
            int n = bl ? 26 : 23;
            throw Trace.error(n, string);
        }
    }

    private void checkTableExists(String string, boolean bl) throws HsqlException {
        boolean bl2 = this.database.dInfo.isSystemTable(string);
        if (!bl2) {
            boolean bl3 = bl2 = this.database.findUserTable(string, this.session) != null;
        }
        if (bl2 != bl) {
            int n = bl ? 22 : 21;
            throw Trace.error(n, string);
        }
    }

    private void checkViewExists(String string, boolean bl) throws HsqlException {
        boolean bl2;
        Table table = this.database.findUserTable(string, this.session);
        boolean bl3 = table != null;
        boolean bl4 = bl2 = bl3 && table.isView();
        if (!bl3) {
            bl3 = this.database.dInfo.isSystemTable(string);
        }
        if (bl3 != bl) {
            int n = bl3 ? (bl2 ? 52 : 21) : 53;
            throw Trace.error(n, string);
        }
    }

    private void checkIsReallyTable(Table table) throws HsqlException {
        if (table.isView() || table.tableType == 0) {
            throw Trace.error(55);
        }
    }

    private void checkTriggerExists(String string, boolean bl) throws HsqlException {
        boolean bl2 = this.database.triggerNameList.containsName(string);
        if (bl2 != bl) {
            if (bl) {
                Trace.doAssert(false, string, " trigger not found");
            } else {
                Trace.doAssert(false, string, " trigger exists");
            }
        }
    }

    private void checkAddColumn(Table table, Column column) throws HsqlException {
        boolean bl = true;
        if (column.isIdentity()) {
            bl = false;
        } else if (column.isPrimaryKey()) {
            bl = false;
        } else if (!table.isEmpty()) {
            boolean bl2 = bl = column.isNullable() || column.getDefaultString() != null;
        }
        if (!bl) {
            throw Trace.error(58);
        }
    }

    private void checkFKColumnDefaults(Table table, TempConstraint tempConstraint) throws HsqlException {
        boolean bl = tempConstraint.updateAction == 4;
        boolean bl2 = bl = bl || tempConstraint.deleteAction == 4;
        if (bl) {
            int[] nArray = tempConstraint.localCol;
            int n = 0;
            while (n < nArray.length) {
                Column column = table.getColumn(nArray[n]);
                String string = column.getDefaultString();
                if (string == null) {
                    String string2 = column.columnName.name;
                    throw Trace.error(57, 105, new Object[]{string2});
                }
                ++n;
            }
        }
    }

    private void processAlterIndexRename() throws HsqlException {
        String string = this.tokenizer.getName();
        this.tokenizer.getThis("RENAME");
        this.tokenizer.getThis("TO");
        String string2 = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        Table table = this.database.findUserTableForIndex(string, this.session);
        if (table == null) {
            throw Trace.error(26, string);
        }
        this.checkIndexExists(string2, false);
        if (HsqlNameManager.HsqlName.isReservedIndexName(string)) {
            throw Trace.error(56, string);
        }
        if (HsqlNameManager.HsqlName.isReservedIndexName(string2)) {
            throw Trace.error(49, string2);
        }
        this.session.setScripting(!table.isTemp());
        this.session.commit();
        table.getIndex(string).setName(string2, bl);
        this.database.indexNameList.rename(string, string2);
    }

    private void processAlterTableAddColumn(Table table) throws HsqlException {
        int n = table.getColumnCount();
        Column column = this.processCreateColumn(table);
        this.checkAddColumn(table, column);
        String string = this.tokenizer.getString();
        if (string.equals("BEFORE")) {
            string = this.tokenizer.getName();
            n = table.getColumnNr(string);
        } else {
            this.tokenizer.back();
        }
        this.session.commit();
        this.tableWorks.setTable(table);
        this.tableWorks.addOrDropColumn(column, n, 1);
    }

    private void processAlterTableAddConstraint(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
        string = this.tokenizer.getString();
        switch (Token.get(string)) {
            default: {
                throw Trace.error(11, string);
            }
            case 17: {
                this.tokenizer.getThis("KEY");
                this.processAlterTableAddForeignKeyConstraint(table, hsqlName);
                return;
            }
            case 47: 
        }
        this.processAlterTableAddUniqueConstraint(table, hsqlName);
    }

    private void processAlterTableDropColumn(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        int n = table.getColumnNr(string);
        this.session.commit();
        this.tableWorks.setTable(table);
        this.tableWorks.addOrDropColumn(null, n, -1);
    }

    private void processAlterTableDropConstraint(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        this.session.commit();
        this.tableWorks.setTable(table);
        this.tableWorks.dropConstraint(string);
    }

    private void processCreateAlias() throws HsqlException {
        String string = this.tokenizer.getString();
        this.tokenizer.getThis("FOR");
        String string2 = DatabaseCommandInterpreter.upgradeMethodFQN(this.tokenizer.getString());
        this.database.getAlias().put(string, string2);
    }

    private void processCreateIndex(boolean bl) throws HsqlException {
        String string = this.tokenizer.getName();
        boolean bl2 = this.tokenizer.wasQuotedIdentifier();
        this.tokenizer.getThis("ON");
        Table table = this.database.getTable(this.tokenizer.getName(), this.session);
        this.addIndexOn(table, string, bl2, bl);
    }

    private void processCreateUser() throws HsqlException {
        String string = this.tokenizer.getStringToken();
        this.tokenizer.getThis("PASSWORD");
        String string2 = this.tokenizer.getStringToken();
        boolean bl = this.tokenizer.getString().equals("ADMIN");
        if (!bl) {
            this.tokenizer.back();
        }
        this.database.getUserManager().createUser(string, string2, bl);
    }

    private void processDisconnect() throws HsqlException {
        this.database.sessionManager.processDisconnect(this.session);
    }

    private void processDropTable(boolean bl) throws HsqlException {
        String string;
        String string2 = string = this.tokenizer.getString();
        boolean bl2 = false;
        if (string.equals("IF")) {
            string = this.tokenizer.getString();
            if (string.equals("EXISTS")) {
                bl2 = true;
                string2 = this.tokenizer.getString();
            } else if (string.equals("IF")) {
                this.tokenizer.getThis("EXISTS");
                bl2 = true;
            } else {
                this.tokenizer.back();
            }
        } else {
            string = this.tokenizer.getString();
            if (string.equals("IF")) {
                this.tokenizer.getThis("EXISTS");
                bl2 = true;
            } else {
                this.tokenizer.back();
            }
        }
        Table table = this.database.findUserTable(string2, this.session);
        if (table != null && !table.isTemp()) {
            this.session.checkDDLWrite();
        }
        this.database.dropTable(string2, bl2, bl, this.session);
    }

    private void processDropUser() throws HsqlException {
        this.session.checkDDLWrite();
        this.database.getUserManager().dropUser(this.tokenizer.getStringToken());
    }

    private void processDropTrigger() throws HsqlException {
        this.session.checkDDLWrite();
        this.database.dropTrigger(this.tokenizer.getString(), this.session);
    }

    private void processDropIndex() throws HsqlException {
        this.session.checkDDLWrite();
        this.database.dropIndex(this.tokenizer.getName(), this.session);
    }

    private Result processExplainPlan() throws IOException, HsqlException {
        String string;
        CompiledStatement compiledStatement;
        this.tokenizer.getThis("PLAN");
        this.tokenizer.getThis("FOR");
        Parser parser = new Parser(this.database, this.tokenizer, this.session);
        String string2 = this.tokenizer.getString();
        int n = Token.get(string2);
        Result result = Result.newSingleColumnResult("OPERATION", 12);
        switch (n) {
            case 39: {
                compiledStatement = parser.compileSelectStatement(null);
                break;
            }
            case 21: {
                compiledStatement = parser.compileInsertStatement(null);
                break;
            }
            case 48: {
                compiledStatement = parser.compileUpdateStatement(null);
                break;
            }
            case 13: {
                compiledStatement = parser.compileDeleteStatement(null);
                break;
            }
            case 6: {
                compiledStatement = parser.compileCallStatement(null);
                break;
            }
            default: {
                return result;
            }
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(compiledStatement.toString()));
        while (null != (string = lineNumberReader.readLine())) {
            result.add(new Object[]{string});
        }
        return result;
    }

    private static String upgradeMethodFQN(String string) {
        if (string.startsWith(oldLib)) {
            string = newLib + string.substring(oldLibLen);
        } else if (string.equals("java.lang.Math.abs")) {
            string = "org.hsqldb.Library.abs";
        }
        return string;
    }

    private Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.database.classLoader;
        return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
    }

    private Result processSelectInto(Select select) throws HsqlException {
        this.session.checkDDLWrite();
        Expression[] expressionArray = select.eColumn;
        int n = expressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (expressionArray[n2].getAlias().length() == 0) {
                throw Trace.error(45);
            }
            ++n2;
        }
        HsqlNameManager.HsqlName hsqlName = select.sIntoTable;
        String string = hsqlName.name;
        if (this.database.findUserTable(string, this.session) != null) {
            throw Trace.error(21, string);
        }
        Result result = select.getResult(0);
        int n3 = select.intoType;
        int n4 = this.session.getId();
        Table table = n3 == 5 ? new TextTable(this.database, hsqlName, n3, n4) : new Table(this.database, hsqlName, n3, n4);
        table.addColumns(result);
        table.createPrimaryKey();
        this.database.linkTable(table);
        if (n3 == 5) {
            try {
                String string2 = StringUtil.toLowerSubset(string, '_') + ".csv";
                table.setDataSource(string2, false, this.session);
                this.logTableDDL(table);
                table.insertNoCheck(result, this.session);
            }
            catch (HsqlException hsqlException) {
                this.database.dropTable(string, false, false, this.session);
                throw hsqlException;
            }
        } else {
            this.logTableDDL(table);
            table.insertNoCheck(result, this.session);
        }
        Result result2 = new Result(1);
        result2.iUpdateCount = result.getSize();
        return result2;
    }

    private void logTableDDL(Table table) throws HsqlException {
        if (table.isTemp()) {
            return;
        }
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer();
        DatabaseScript.getTableDDL(this.database, table, 0, null, null, hsqlStringBuffer);
        String string = DatabaseScript.getDataSource(table);
        this.database.logger.writeToLog(this.session, hsqlStringBuffer.toString());
        if (string != null) {
            this.database.logger.writeToLog(this.session, string);
        }
    }

    private void processAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table);
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT");
        }
        this.session.commit();
        this.tableWorks.setTable(table);
        this.tableWorks.createUniqueConstraint(nArray, hsqlName);
    }

    private void processAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK");
        }
        TempConstraint tempConstraint = this.processCreateFK(table, hsqlName);
        table.checkColumnsMatch(tempConstraint.localCol, tempConstraint.expTable, tempConstraint.expCol);
        this.session.commit();
        this.tableWorks.setTable(table);
        this.tableWorks.createForeignKey(tempConstraint.localCol, tempConstraint.expCol, tempConstraint.name, tempConstraint.expTable, tempConstraint.deleteAction, tempConstraint.updateAction);
    }

    private void processReleaseSavepoint() throws HsqlException {
        this.tokenizer.getThis("SAVEPOINT");
        String string = this.tokenizer.getString();
        if (string.length() == 0) {
            String string2 = "missing or zero-length savepoint name";
            throw Trace.error(11, string2);
        }
        this.session.releaseSavepoint(string);
    }

    private static class TempConstraint {
        HsqlNameManager.HsqlName name;
        int[] localCol;
        Table expTable;
        int[] expCol;
        int type;
        int deleteAction;
        int updateAction;

        TempConstraint(HsqlNameManager.HsqlName hsqlName, int[] nArray, Table table, int[] nArray2, int n, int n2, int n3) {
            this.name = hsqlName;
            this.type = n;
            this.localCol = nArray;
            this.expTable = table;
            this.expCol = nArray2;
            this.deleteAction = n2;
            this.updateAction = n3;
        }
    }
}

