/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Record;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.store.ValuePool;

class DatabaseManager {
    private static int dbIDCounter;
    private static HashMap memDatabaseMap;
    private static HashMap fileDatabaseMap;
    private static HashMap resDatabaseMap;
    private static IntKeyHashMap databaseIDMap;
    private static HashMap serverMap;
    static final String S_DOT = ".";
    static final String S_MEM = "mem:";
    static final String S_FILE = "file:";
    static final String S_RES = "res:";
    static final String S_ALIAS = "alias:";
    static final String S_HSQL = "hsql://";
    static final String S_HSQLS = "hsqls://";
    static final String S_HTTP = "http://";
    static final String S_HTTPS = "https://";
    static final String S_URL_PREFIX = "jdbc:hsqldb:";
    private static HsqlTimer timer;

    DatabaseManager() {
    }

    static Session newSession(int n, String string, String string2) throws HsqlException {
        Database database = (Database)databaseIDMap.get(n);
        return database.connect(string, string2);
    }

    static Session newSession(String string, String string2, String string3, String string4, boolean bl) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, bl);
        return database.connect(string3, string4);
    }

    private static Session getSession(int n, int n2) throws HsqlException {
        Database database = (Database)databaseIDMap.get(n);
        return database.sessionManager.getSession(n2);
    }

    static Session getSession(String string, String string2, int n) throws HsqlException {
        Database database = DatabaseManager.lookupDatabaseObject(string, string2);
        return database.sessionManager.getSession(n);
    }

    static int getDatabase(String string, String string2, Server server) throws HsqlException {
        Database database = DatabaseManager.getDatabase(string, string2, false);
        DatabaseManager.registerServer(server, database);
        return database.databaseID;
    }

    static Database getDatabase(String string, String string2, boolean bl) throws HsqlException {
        Database database;
        Database database2 = database = DatabaseManager.getDatabaseObject(string, string2, bl);
        synchronized (database2) {
            switch (database.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(string, string2) == null) {
                        DatabaseManager.addDatabaseObject(string, string2, database);
                    }
                    database.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Trace.error(1, 107, null);
                }
            }
        }
        return database;
    }

    private static synchronized Database getDatabaseObject(String string, String string2, boolean bl) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = new File(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        Database database = (Database)hashMap.get(object);
        if (database == null) {
            database = new Database(string, string2, string2, bl);
            database.databaseID = dbIDCounter;
            databaseIDMap.put(dbIDCounter, database);
            ++dbIDCounter;
            hashMap.put(object, database);
        }
        return database;
    }

    private static synchronized Database lookupDatabaseObject(String string, String string2) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = new File(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        return (Database)hashMap.get(object);
    }

    private static synchronized void addDatabaseObject(String string, String string2, Database database) throws HsqlException {
        HashMap hashMap;
        Object object = string2;
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = new File(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        databaseIDMap.put(database.databaseID, database);
        hashMap.put(object, database);
    }

    static void removeDatabase(Database database) {
        HashMap hashMap;
        int n = database.databaseID;
        String string = database.getType();
        String string2 = database.getPath();
        Object object = string2;
        DatabaseManager.notifyServers(database);
        if (string == S_FILE) {
            hashMap = fileDatabaseMap;
            object = new File(string2);
        } else {
            hashMap = string == S_RES ? resDatabaseMap : memDatabaseMap;
        }
        databaseIDMap.remove(n);
        hashMap.remove(object);
        if (databaseIDMap.isEmpty()) {
            ValuePool.resetPool();
        }
    }

    static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database database) {
        Iterator iterator = serverMap.values().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet = (HashSet)iterator.next();
            hashSet.remove(database);
            if (!hashSet.isEmpty()) continue;
            iterator.remove();
        }
    }

    private static void registerServer(Server server, Database database) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet hashSet = (HashSet)serverMap.get(server);
        hashSet.add(database);
    }

    private static void notifyServers(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            server.notify(0, database.databaseID);
        }
    }

    private static boolean isServerDB(Database database) {
        Iterator iterator = serverMap.keySet().iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            HashSet hashSet = (HashSet)serverMap.get(server);
            if (!hashSet.contains(database)) continue;
            return true;
        }
        return false;
    }

    public static HsqlProperties parseURL(String string, boolean bl) {
        String string2;
        String string3 = string.toLowerCase();
        if (bl && !string3.startsWith(S_URL_PREFIX)) {
            return null;
        }
        HsqlProperties hsqlProperties = new HsqlProperties();
        int n = bl ? S_URL_PREFIX.length() : 0;
        String string4 = null;
        int n2 = 0;
        boolean bl2 = false;
        hsqlProperties.setProperty("url", string);
        int n3 = string.indexOf(59, n);
        if (n3 < 0) {
            n3 = string.length();
        } else {
            String string5 = string3.substring(n3 + 1, string3.length());
            HsqlProperties hsqlProperties2 = HsqlProperties.delimitedArgPairsToProps(string5, "=", ";", null);
            hsqlProperties.addProperties(hsqlProperties2);
        }
        if (n3 == n + 1 && string3.startsWith(S_DOT, n)) {
            string4 = S_DOT;
        } else if (string3.startsWith(S_MEM, n)) {
            string4 = S_MEM;
        } else if (string3.startsWith(S_FILE, n)) {
            string4 = S_FILE;
        } else if (string3.startsWith(S_RES, n)) {
            string4 = S_RES;
        } else if (string3.startsWith(S_ALIAS, n)) {
            string4 = S_ALIAS;
        } else if (string3.startsWith(S_HSQL, n)) {
            string4 = S_HSQL;
            n2 = 9001;
            bl2 = true;
        } else if (string3.startsWith(S_HSQLS, n)) {
            string4 = S_HSQLS;
            n2 = 554;
            bl2 = true;
        } else if (string3.startsWith(S_HTTP, n)) {
            string4 = S_HTTP;
            n2 = 80;
            bl2 = true;
        } else if (string3.startsWith(S_HTTPS, n)) {
            string4 = S_HTTPS;
            n2 = 443;
            bl2 = true;
        }
        if (string4 == null) {
            string4 = S_FILE;
        } else if (string4 == S_DOT) {
            string4 = S_MEM;
        } else {
            n += string4.length();
        }
        hsqlProperties.setProperty("connection_type", string4);
        if (bl2) {
            String string6;
            int n4;
            int n5 = string.indexOf(47, n);
            if (n5 < n || n5 > n3) {
                n5 = n3;
            }
            if ((n4 = string.indexOf(58, n)) < n || n4 > n5) {
                n4 = n5;
            } else {
                try {
                    n2 = Integer.parseInt(string.substring(n4 + 1, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            String string7 = string3.substring(n, n4);
            int n6 = string.lastIndexOf(47, n3);
            if (n6 < n) {
                string6 = "/";
                string2 = "";
            } else if (n6 == n5) {
                string6 = "/";
                string2 = string3.substring(n6 + 1, n3);
            } else {
                string6 = string.substring(n5, n6);
                string2 = string3.substring(n6 + 1, n3);
            }
            hsqlProperties.setProperty("port", n2);
            hsqlProperties.setProperty("host", string7);
            hsqlProperties.setProperty("path", string6);
        } else {
            string2 = string4 == S_MEM ? string3.substring(n, n3).toLowerCase() : string.substring(n, n3);
        }
        hsqlProperties.setProperty("database", string2);
        return hsqlProperties;
    }

    public static void main(String[] stringArray) {
        DatabaseManager.parseURL("JDBC:hsqldb:../data/mydb.db", true);
        DatabaseManager.parseURL("JDBC:hsqldb:../data/mydb.db;ifexists=true", true);
        DatabaseManager.parseURL("JDBC:hsqldb:HSQL://localhost:9000/mydb", true);
        DatabaseManager.parseURL("JDBC:hsqldb:Http://localhost:8080/servlet/org.hsqldb.Servlet/mydb;ifexists=true", true);
        DatabaseManager.parseURL("JDBC:hsqldb:Http://localhost/servlet/org.hsqldb.Servlet/", true);
        DatabaseManager.parseURL("JDBC:hsqldb:hsql://myhost", true);
    }

    static void gc() {
        if (Record.gcFrequency > 0 && Record.memoryRecords > Record.gcFrequency) {
            if (Trace.TRACE) {
                Trace.trace("gc at " + Record.memoryRecords);
            }
            Record.memoryRecords = 0;
            System.gc();
        }
    }

    static HsqlTimer getTimer() {
        return timer;
    }

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }
}

