/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Binary;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;

abstract class DatabaseRowOutput
extends HsqlByteArrayOutputStream
implements DatabaseRowOutputInterface {
    static final int CACHED_ROW_160 = 0;
    static final int CACHED_ROW_170 = 1;
    protected boolean skipSystemId = false;

    static DatabaseRowOutputInterface newDatabaseRowOutput(int n) throws HsqlException {
        try {
            if (n == 1) {
                return new BinaryServerRowOutput();
            }
            Class<?> clazz = Class.forName("org.hsqldb.BinaryDatabaseRowOutput");
            return (DatabaseRowOutputInterface)clazz.newInstance();
        }
        catch (Exception exception) {
            throw Trace.error(66, 112, null);
        }
    }

    public DatabaseRowOutput() {
    }

    public DatabaseRowOutput(int n) {
        super(n);
    }

    public DatabaseRowOutput(byte[] byArray) {
        super(byArray);
    }

    public abstract void writePos(int var1) throws IOException;

    public abstract void writeSize(int var1) throws IOException;

    public abstract void writeType(int var1) throws IOException;

    public abstract void writeIntData(int var1) throws IOException;

    public abstract void writeIntData(int var1, int var2) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    protected void writeFieldPrefix() throws IOException {
    }

    protected abstract void writeFieldType(int var1) throws IOException;

    protected abstract void writeNull(int var1) throws IOException;

    protected abstract void writeChar(String var1, int var2) throws IOException;

    protected abstract void writeSmallint(Number var1) throws IOException, HsqlException;

    protected abstract void writeInteger(Number var1) throws IOException, HsqlException;

    protected abstract void writeBigint(Number var1) throws IOException, HsqlException;

    protected abstract void writeReal(Double var1, int var2) throws IOException, HsqlException;

    protected abstract void writeDecimal(BigDecimal var1) throws IOException, HsqlException;

    protected abstract void writeBit(Boolean var1) throws IOException, HsqlException;

    protected abstract void writeDate(Date var1) throws IOException, HsqlException;

    protected abstract void writeTime(Time var1) throws IOException, HsqlException;

    protected abstract void writeTimestamp(Timestamp var1) throws IOException, HsqlException;

    protected abstract void writeOther(JavaObject var1) throws IOException, HsqlException;

    protected abstract void writeBinary(Binary var1, int var2) throws IOException, HsqlException;

    public void writeData(Object[] objectArray, Table table) throws IOException, HsqlException {
        int[] nArray = table.getColumnTypes();
        int n = nArray.length - 1;
        this.writeData(n, nArray, objectArray, null, false);
    }

    public void writeData(int n, int[] nArray, Object[] objectArray, HashMappedList hashMappedList, boolean bl) throws IOException, HsqlException {
        int n2 = 0;
        while (n2 < n) {
            block21: {
                int n3;
                Object object;
                block20: {
                    object = objectArray[n2];
                    n3 = nArray[n2];
                    if (hashMappedList == null) break block20;
                    Column column = (Column)hashMappedList.get(n2);
                    if (bl && !column.isPrimaryKey()) break block21;
                    this.writeFieldPrefix();
                    this.writeString(column.columnName.statementName);
                }
                if (object == null) {
                    this.writeNull(n3);
                } else {
                    this.writeFieldType(n3);
                    switch (n3) {
                        case -1: 
                        case 0: 
                        case 1: 
                        case 12: 
                        case 100: {
                            this.writeChar((String)object, n3);
                            break;
                        }
                        case -6: 
                        case 5: {
                            this.writeSmallint((Number)object);
                            break;
                        }
                        case 4: {
                            this.writeInteger((Number)object);
                            break;
                        }
                        case -5: {
                            this.writeBigint((Number)object);
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            this.writeReal((Double)object, n3);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.writeDecimal((BigDecimal)object);
                            break;
                        }
                        case -7: 
                        case 16: {
                            this.writeBit((Boolean)object);
                            break;
                        }
                        case 91: {
                            this.writeDate((Date)object);
                            break;
                        }
                        case 92: {
                            this.writeTime((Time)object);
                            break;
                        }
                        case 93: {
                            this.writeTimestamp((Timestamp)object);
                            break;
                        }
                        case 1111: {
                            this.writeOther((JavaObject)object);
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            this.writeBinary((Binary)object, n3);
                            break;
                        }
                        default: {
                            throw Trace.error(20, n3);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public HsqlByteArrayOutputStream getOutputStream() {
        return this;
    }

    public abstract int getSize(CachedRow var1) throws HsqlException;
}

