/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlStringBuffer;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

class DatabaseScript {
    DatabaseScript() {
    }

    static Result getScript(Database database, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        int n2;
        HsqlStringBuffer hsqlStringBuffer;
        HsqlArrayList hsqlArrayList = database.getTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        HsqlArrayList hsqlArrayList3 = new HsqlArrayList();
        Result result = Result.newSingleColumnResult("COMMAND", 12);
        result.metaData.sTable[0] = "SYSTEM_SCRIPT";
        int n3 = 0;
        int n4 = hsqlArrayList.size();
        while (n3 < n4) {
            Table table = (Table)hsqlArrayList.get(n3);
            if (!table.isTemp() && !table.isView()) {
                int n5;
                hsqlStringBuffer = new HsqlStringBuffer(128);
                DatabaseScript.getTableDDL(database, table, n3, hsqlArrayList2, hsqlArrayList3, hsqlStringBuffer);
                DatabaseScript.addRow(result, hsqlStringBuffer.toString());
                n2 = 1;
                while (n2 < table.getIndexCount()) {
                    object4 = table.getIndex(n2);
                    if (!HsqlNameManager.HsqlName.isReservedIndexName(((Index)object4).getName().name)) {
                        hsqlStringBuffer = new HsqlStringBuffer(64);
                        hsqlStringBuffer.append("CREATE ");
                        if (((Index)object4).isUnique()) {
                            hsqlStringBuffer.append("UNIQUE ");
                        }
                        hsqlStringBuffer.append("INDEX ");
                        hsqlStringBuffer.append(((Index)object4).getName().statementName);
                        hsqlStringBuffer.append(" ON ");
                        hsqlStringBuffer.append(table.getName().statementName);
                        int[] nArray = ((Index)object4).getColumns();
                        n5 = ((Index)object4).getVisibleColumns();
                        DatabaseScript.getColumnList(table, nArray, n5, hsqlStringBuffer);
                        DatabaseScript.addRow(result, hsqlStringBuffer.toString());
                    }
                    ++n2;
                }
                if (table.isText() && table.isDataReadOnly()) {
                    hsqlStringBuffer = new HsqlStringBuffer("SET TABLE ");
                    hsqlStringBuffer.append(table.getName().statementName);
                    hsqlStringBuffer.append(" READONLY TRUE");
                    DatabaseScript.addRow(result, hsqlStringBuffer.toString());
                }
                if ((object4 = DatabaseScript.getDataSource(table)) != null) {
                    DatabaseScript.addRow(result, (String)object4);
                }
                n = 12;
                n5 = 0;
                while (n5 < n) {
                    object3 = table.vTrigs[n5];
                    int n6 = ((HsqlArrayList)object3).size();
                    int n7 = 0;
                    while (n7 < n6) {
                        hsqlStringBuffer = ((TriggerDef)((HsqlArrayList)object3).get(n7)).toBuf();
                        DatabaseScript.addRow(result, hsqlStringBuffer.toString());
                        ++n7;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        int n8 = 0;
        n2 = hsqlArrayList2.size();
        while (n8 < n2) {
            object4 = (Constraint)hsqlArrayList2.get(n8);
            hsqlStringBuffer = new HsqlStringBuffer(128);
            hsqlStringBuffer.append("ALTER TABLE ");
            hsqlStringBuffer.append(((Constraint)object4).getRef().getName().statementName);
            hsqlStringBuffer.append(" ADD ");
            DatabaseScript.getFKStatement((Constraint)object4, hsqlStringBuffer);
            DatabaseScript.addRow(result, hsqlStringBuffer.toString());
            ++n8;
        }
        int n9 = 0;
        n = hsqlArrayList.size();
        while (n9 < n) {
            Table table = (Table)hsqlArrayList.get(n9);
            if (bl && table.isIndexCached() && !table.isEmpty()) {
                DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)hsqlArrayList.get(n9)));
            }
            ++n9;
        }
        if (database.isIgnoreCase()) {
            DatabaseScript.addRow(result, "SET IGNORECASE TRUE");
        }
        HashMap hashMap = database.getAlias();
        object3 = Library.getAliasMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            object2 = (String)((HashMap)object3).get(string);
            if (object2 != null && ((String)object2).equals(string2)) continue;
            object = new HsqlStringBuffer(64);
            ((HsqlStringBuffer)object).append("CREATE ALIAS ");
            ((HsqlStringBuffer)object).append(string);
            ((HsqlStringBuffer)object).append(" FOR \"");
            ((HsqlStringBuffer)object).append(string2);
            ((HsqlStringBuffer)object).append('\"');
            DatabaseScript.addRow(result, ((HsqlStringBuffer)object).toString());
        }
        int n10 = 0;
        int n11 = hsqlArrayList.size();
        while (n10 < n11) {
            object2 = (Table)hsqlArrayList.get(n10);
            if (((Table)object2).isView()) {
                object = (View)hsqlArrayList.get(n10);
                hsqlStringBuffer = new HsqlStringBuffer(128);
                hsqlStringBuffer.append("CREATE ");
                hsqlStringBuffer.append("VIEW ");
                hsqlStringBuffer.append(((Table)object).getName().statementName);
                hsqlStringBuffer.append(" AS ");
                hsqlStringBuffer.append(((View)object).getStatement());
                DatabaseScript.addRow(result, hsqlStringBuffer.toString());
            }
            ++n10;
        }
        DatabaseScript.addRightsStatements(database, result);
        return result;
    }

    static String getIndexRootsDDL(Table table) {
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(128);
        hsqlStringBuffer.append("SET TABLE ");
        hsqlStringBuffer.append(table.getName().statementName);
        hsqlStringBuffer.append(" INDEX '");
        hsqlStringBuffer.append(table.getIndexRoots());
        hsqlStringBuffer.append('\'');
        return hsqlStringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, HsqlStringBuffer hsqlStringBuffer) {
        Object object;
        Object object2;
        hsqlStringBuffer.append("CREATE ");
        if (table.isText()) {
            hsqlStringBuffer.append("TEXT ");
        } else if (table.isCached()) {
            hsqlStringBuffer.append("CACHED ");
        }
        hsqlStringBuffer.append("TABLE ");
        hsqlStringBuffer.append(table.getName().statementName);
        hsqlStringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        int n3 = 0;
        while (n3 < n2) {
            object2 = table.getColumn(n3);
            String string = ((Column)object2).columnName.statementName;
            hsqlStringBuffer.append(string);
            hsqlStringBuffer.append(' ');
            String string2 = Types.getTypeString(((Column)object2).getType());
            hsqlStringBuffer.append(string2);
            if (((Column)object2).getSize() > 0) {
                hsqlStringBuffer.append('(');
                hsqlStringBuffer.append(((Column)object2).getSize());
                if (((Column)object2).getScale() > 0) {
                    hsqlStringBuffer.append(',');
                    hsqlStringBuffer.append(((Column)object2).getScale());
                }
                hsqlStringBuffer.append(')');
            }
            if ((object = ((Column)object2).getDefaultString()) != null) {
                boolean bl = false;
                switch (((Column)object2).getType()) {
                    case 91: 
                    case 93: {
                        bl = ((String)object).indexOf(45) != -1;
                        break;
                    }
                    case 92: {
                        bl = ((String)object).indexOf(58) != -1;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 100: {
                        bl = true;
                    }
                }
                if (bl) {
                    object = Column.createSQLString((String)object);
                }
                hsqlStringBuffer.append(" DEFAULT ");
                hsqlStringBuffer.append((String)object);
            }
            if (n3 == table.getIdentityColumn()) {
                hsqlStringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                hsqlStringBuffer.append(((Column)object2).identityStart);
                hsqlStringBuffer.append(") ");
            }
            if (!((Column)object2).isNullable()) {
                hsqlStringBuffer.append(" NOT NULL");
            }
            if (nArray.length == 1 && n3 == nArray[0] && index.getName().isReservedIndexName()) {
                hsqlStringBuffer.append(" PRIMARY KEY");
            }
            if (n3 < n2 - 1) {
                hsqlStringBuffer.append(',');
            }
            ++n3;
        }
        if (nArray.length > 1 || !index.getName().isReservedIndexName()) {
            hsqlStringBuffer.append(",CONSTRAINT ");
            hsqlStringBuffer.append(index.getName().statementName);
            hsqlStringBuffer.append(" PRIMARY KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, hsqlStringBuffer);
        }
        object2 = table.getConstraints();
        int n4 = 0;
        int n5 = ((HsqlArrayList)object2).size();
        while (n4 < n5) {
            object = (Constraint)((HsqlArrayList)object2).get(n4);
            switch (((Constraint)object).getType()) {
                case 2: {
                    hsqlStringBuffer.append(",CONSTRAINT ");
                    hsqlStringBuffer.append(((Constraint)object).getName().statementName);
                    hsqlStringBuffer.append(" UNIQUE");
                    int[] nArray2 = ((Constraint)object).getMainColumns();
                    DatabaseScript.getColumnList(((Constraint)object).getMain(), nArray2, nArray2.length, hsqlStringBuffer);
                    break;
                }
                case 0: {
                    Table table2 = ((Constraint)object).getMain();
                    int n6 = database.getTableIndex(table2);
                    if (n6 > n) {
                        if (n >= hsqlArrayList2.size()) {
                            hsqlArrayList2.setSize(n + 1);
                        }
                        hsqlArrayList2.set(n, object);
                        hsqlArrayList.add(object);
                        break;
                    }
                    hsqlStringBuffer.append(',');
                    DatabaseScript.getFKStatement((Constraint)object, hsqlStringBuffer);
                }
            }
            ++n4;
        }
        hsqlStringBuffer.append(')');
    }

    static String getDataSource(Table table) {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(128);
        hsqlStringBuffer.append("SET TABLE ");
        hsqlStringBuffer.append(table.getName().statementName);
        hsqlStringBuffer.append(" SOURCE \"");
        hsqlStringBuffer.append(string);
        hsqlStringBuffer.append('\"');
        if (bl) {
            hsqlStringBuffer.append(" DESC");
        }
        return hsqlStringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, HsqlStringBuffer hsqlStringBuffer) {
        hsqlStringBuffer.append('(');
        int n2 = 0;
        while (n2 < n) {
            hsqlStringBuffer.append(table.getColumn((int)nArray[n2]).columnName.statementName);
            if (n2 < n - 1) {
                hsqlStringBuffer.append(',');
            }
            ++n2;
        }
        hsqlStringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, HsqlStringBuffer hsqlStringBuffer) {
        hsqlStringBuffer.append("CONSTRAINT ");
        hsqlStringBuffer.append(constraint.getName().statementName);
        hsqlStringBuffer.append(" FOREIGN KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, hsqlStringBuffer);
        hsqlStringBuffer.append(" REFERENCES ");
        hsqlStringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, hsqlStringBuffer);
        if (constraint.getDeleteAction() != 3) {
            hsqlStringBuffer.append(" ON DELETE ");
            hsqlStringBuffer.append(DatabaseScript.getFKAction(constraint.getDeleteAction()));
        }
        if (constraint.getUpdateAction() != 3) {
            hsqlStringBuffer.append(" ON UPDATE ");
            hsqlStringBuffer.append(DatabaseScript.getFKAction(constraint.getUpdateAction()));
        }
    }

    private static String getFKAction(int n) {
        switch (n) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private static void addRightsStatements(Database database, Result result) {
        HashMappedList hashMappedList = database.getUserManager().getUsers();
        Iterator iterator = hashMappedList.values().iterator();
        while (iterator.hasNext()) {
            IntValueHashMap intValueHashMap;
            HsqlStringBuffer hsqlStringBuffer;
            User user = (User)iterator.next();
            String string = user.getName();
            if (!string.equals("PUBLIC")) {
                hsqlStringBuffer = new HsqlStringBuffer(128);
                hsqlStringBuffer.append("CREATE USER ");
                hsqlStringBuffer.append(string);
                hsqlStringBuffer.append(" PASSWORD ");
                hsqlStringBuffer.append('\"');
                hsqlStringBuffer.append(user.getPassword());
                hsqlStringBuffer.append('\"');
                if (user.isAdmin()) {
                    hsqlStringBuffer.append(" ADMIN");
                }
                DatabaseScript.addRow(result, hsqlStringBuffer.toString());
            }
            if ((intValueHashMap = user.getRights()) == null) continue;
            Iterator iterator2 = intValueHashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                int n = intValueHashMap.get(object, 0);
                hsqlStringBuffer = new HsqlStringBuffer(64);
                hsqlStringBuffer.append("GRANT ");
                hsqlStringBuffer.append(UserManager.getRight(n));
                hsqlStringBuffer.append(" ON ");
                if (object instanceof String) {
                    if (object.equals("java.lang.Math") || object.equals("org.hsqldb.Library")) continue;
                    hsqlStringBuffer.append("CLASS \"");
                    hsqlStringBuffer.append((String)object);
                    hsqlStringBuffer.append('\"');
                } else {
                    Table table = database.findUserTable(((HsqlNameManager.HsqlName)object).name);
                    if (table == null) continue;
                    hsqlStringBuffer.append(((HsqlNameManager.HsqlName)object).statementName);
                }
                hsqlStringBuffer.append(" TO ");
                hsqlStringBuffer.append(user.getName());
                DatabaseScript.addRow(result, hsqlStringBuffer.toString());
            }
        }
    }
}

