/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.hsqldb.BinaryDatabaseScriptReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.ZippedDatabaseScriptReader;
import org.hsqldb.lib.StringConverter;

class DatabaseScriptReader {
    DataInputStream dataStreamIn;
    Database db;
    int lineCount;
    String lastLine;
    BufferedReader d;
    String fileName;

    static DatabaseScriptReader newDatabaseScriptReader(Database database, String string, int n) throws HsqlException, IOException {
        if (n == 0) {
            return new DatabaseScriptReader(database, string);
        }
        if (n == 1) {
            return new BinaryDatabaseScriptReader(database, string);
        }
        return new ZippedDatabaseScriptReader(database, string);
    }

    DatabaseScriptReader(Database database, String string) throws HsqlException, IOException {
        this.db = database;
        this.fileName = string;
        this.openFile();
    }

    void readAll(Session session) throws IOException, HsqlException {
        this.readDDL(session);
        this.readExistingData(session);
    }

    protected void readDDL(Session session) throws IOException, HsqlException {
        block1: {
            Result result;
            do {
                this.lastLine = this.readLoggedStatement();
                if (this.lastLine == null || this.lastLine.startsWith("INSERT INTO ")) break block1;
            } while ((result = session.sqlExecuteDirectNoPreChecks(this.lastLine)) == null || result.iMode != 2);
            throw Trace.error(78, 113, new Object[]{new Integer(this.lineCount), result.mainString});
        }
    }

    protected void readExistingData(Session session) throws IOException, HsqlException {
        this.db.setReferentialIntegrity(false);
        if (this.lastLine == null) {
            this.lastLine = this.readLoggedStatement();
        }
        while (this.lastLine != null) {
            Result result = session.sqlExecuteDirectNoPreChecks(this.lastLine);
            if (result != null && result.iMode == 2) {
                throw Trace.error(78, 114, new Object[]{new Integer(this.lineCount), result.mainString});
            }
            this.lastLine = this.readLoggedStatement();
        }
        this.db.setReferentialIntegrity(true);
    }

    int getLineNumber() {
        return this.lineCount;
    }

    protected void openFile() throws IOException {
        this.dataStreamIn = this.db.isFilesInJar() ? new DataInputStream(this.getClass().getResourceAsStream(this.fileName)) : new DataInputStream(new FileInputStream(this.fileName));
        this.d = new BufferedReader(new InputStreamReader(this.dataStreamIn));
    }

    protected String readLoggedStatement() throws IOException {
        String string = this.d.readLine();
        ++this.lineCount;
        return StringConverter.asciiToUnicode(string);
    }

    void close() throws IOException {
        this.d.close();
        this.dataStreamIn.close();
    }
}

