/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.BinaryDatabaseScriptWriter;
import org.hsqldb.Database;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TextLogRowOutput;
import org.hsqldb.Trace;
import org.hsqldb.ZippedDatabaseScriptWriter;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlStringBuffer;
import org.hsqldb.lib.StopWatch;

class DatabaseScriptWriter {
    Database db;
    String outFile;
    OutputStream fileStreamOut;
    FileDescriptor outDescriptor;
    DatabaseRowOutput rowOut;
    int tableRowCount;
    StopWatch sw = new StopWatch();
    boolean includeCachedData;
    long byteCount;
    int writeDelay;
    volatile boolean needsSync;
    volatile boolean forceSync;
    volatile boolean busyWriting;
    static final int INSERT = 0;
    int sessionId;
    static byte[] BYTES_LINE_SEP;
    static final int SCRIPT_TEXT_170 = 0;
    static final int SCRIPT_BINARY_172 = 1;
    static final int SCRIPT_ZIPPED_BINARY_172 = 3;
    static final byte[] BYTES_INSERT_INTO;
    static final byte[] BYTES_VALUES;
    static final byte[] BYTES_TERM;
    static final byte[] BYTES_DELETE_FROM;
    static final byte[] BYTES_WHERE;
    static final byte[] BYTES_C_ID_INIT;
    static final byte[] BYTES_C_ID_TERM;

    static DatabaseScriptWriter newDatabaseScriptWriter(Database database, String string, boolean bl, boolean bl2, int n) throws HsqlException {
        if (n == 0) {
            return new DatabaseScriptWriter(database, string, bl, bl2);
        }
        if (n == 1) {
            return new BinaryDatabaseScriptWriter(database, string, bl, bl2);
        }
        return new ZippedDatabaseScriptWriter(database, string, bl, bl2);
    }

    DatabaseScriptWriter(Database database, String string, boolean bl, boolean bl2) throws HsqlException {
        this.initBuffers();
        File file = new File(string);
        if (file.exists()) {
            if (bl2) {
                throw Trace.error(29, string);
            }
            this.byteCount = file.length();
        }
        this.db = database;
        this.includeCachedData = bl;
        this.outFile = string;
        this.openFile();
    }

    protected void initBuffers() {
        this.rowOut = new TextLogRowOutput();
    }

    void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    synchronized void sync() {
        if (this.needsSync) {
            if (this.busyWriting) {
                this.forceSync = true;
                return;
            }
            Trace.printSystemOut("file sync interval: ", this.sw.elapsedTime());
            this.sw.zero();
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
            }
            catch (IOException iOException) {
                Trace.printSystemOut("flush() or sync() error: ", iOException.getMessage());
            }
            Trace.printSystemOut("file sync: ", this.sw.elapsedTime());
            this.sw.zero();
            this.needsSync = false;
            this.forceSync = false;
        }
    }

    void close() throws HsqlException {
        try {
            this.fileStreamOut.flush();
            this.fileStreamOut.close();
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
    }

    long size() {
        return this.byteCount;
    }

    void writeAll() throws HsqlException {
        try {
            this.writeDDL();
            this.writeExistingData();
            this.finishStream();
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
    }

    protected void openFile() throws HsqlException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outFile, true);
            this.outDescriptor = fileOutputStream.getFD();
            this.fileStreamOut = fileOutputStream;
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.outFile);
        }
    }

    protected void finishStream() throws IOException {
    }

    protected void writeDDL() throws IOException, HsqlException {
        Result result = DatabaseScript.getScript(this.db, !this.includeCachedData);
        this.writeSingleColumnResult(result);
    }

    protected void writeExistingData() throws HsqlException, IOException {
        boolean bl = false;
        HsqlArrayList hsqlArrayList = this.db.getTables();
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            Table table = (Table)hsqlArrayList.get(n);
            boolean bl2 = false;
            switch (table.tableType) {
                case 2: {
                    bl2 = true;
                    break;
                }
                case 3: {
                    bl2 = this.includeCachedData;
                    break;
                }
                case 5: {
                    boolean bl3 = bl2 = this.includeCachedData && !table.isReadOnly;
                }
            }
            if (bl2) {
                this.writeTableInit(table);
                Index index = table.getPrimaryIndex();
                Node node = index.first();
                while (node != null) {
                    this.writeRow(0, table, node.getData());
                    node = index.next(node);
                }
                this.writeTableTerm(table);
            }
            ++n;
        }
        this.writeDataTerm();
    }

    protected void writeTableInit(Table table) throws HsqlException, IOException {
    }

    protected void writeTableTerm(Table table) throws HsqlException, IOException {
        if (table.isDataReadOnly() && !table.isTemp() && !table.isText()) {
            HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer("SET TABLE ");
            hsqlStringBuffer.append(table.getName().statementName);
            hsqlStringBuffer.append(" READONLY TRUE");
            this.writeLogStatement(hsqlStringBuffer.toString(), this.sessionId);
        }
    }

    protected void writeSingleColumnResult(Result result) throws HsqlException, IOException {
        Record record = result.rRoot;
        while (record != null) {
            this.writeLogStatement((String)record.data[0], this.sessionId);
            record = record.next;
        }
    }

    protected void writeRow(int n, Table table, Object[] objectArray) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        ((TextLogRowOutput)this.rowOut).setMode(0);
        this.writeSessionId(n);
        this.rowOut.write(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_VALUES);
        this.rowOut.writeData(objectArray, table);
        this.rowOut.write(BYTES_TERM);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    void writeDeleteStatement(int n, Table table, Object[] objectArray) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        ((TextLogRowOutput)this.rowOut).setMode(1);
        this.writeSessionId(n);
        this.rowOut.write(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), objectArray, table.vColumn, table.getPrimaryKey() != null);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    protected void writeDataTerm() throws IOException {
    }

    private void writeSessionId(int n) throws IOException {
        if (n != this.sessionId) {
            this.rowOut.write(BYTES_C_ID_INIT);
            this.rowOut.writeIntData(n);
            this.rowOut.write(BYTES_C_ID_TERM);
            this.sessionId = n;
        }
    }

    void writeLogStatement(String string, int n) throws IOException, HsqlException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.writeSessionId(n);
        this.rowOut.writeString(string);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    static {
        String string = System.getProperty("line.separator", "\n");
        BYTES_LINE_SEP = string.getBytes();
        BYTES_INSERT_INTO = "INSERT INTO ".getBytes();
        BYTES_VALUES = " VALUES(".getBytes();
        BYTES_TERM = ")".getBytes();
        BYTES_DELETE_FROM = "DELETE FROM ".getBytes();
        BYTES_WHERE = " WHERE ".getBytes();
        BYTES_C_ID_INIT = "/*C".getBytes();
        BYTES_C_ID_TERM = "*/".getBytes();
    }
}

