/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.Like;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.SetFunction;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.store.ValuePool;

class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int FALSE = -4;
    static final int VALUELIST = 5;
    static final int ASTERIX = 6;
    static final int FUNCTION = 7;
    static final int PARAM = 8;
    static final int NEGATE = 10;
    static final int ADD = 11;
    static final int SUBTRACT = 12;
    static final int MULTIPLY = 13;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 62;
    static final int EXTRACT = 63;
    static final int POSITION = 64;
    static final int TRIM = 65;
    static final int SUBSTRING = 66;
    static final int NULLIF = 67;
    static final int CASE = 68;
    static final int COALESCE = 69;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int STRINGCONCAT = 105;
    static final int BETWEEN = 106;
    static final int CAST = 107;
    static final int END = 108;
    static final int IS = 109;
    static final int WHEN = 110;
    static final int THEN = 111;
    static final int ELSE = 112;
    static final int ENDWHEN = 113;
    static final int AS = 122;
    static final int FOR = 123;
    static final int FROM = 124;
    static final int BOTH = 125;
    static final int LEADING = 126;
    static final int TRAILING = 127;
    static final int YEAR = 128;
    static final int MONTH = 129;
    static final int DAY = 130;
    static final int HOUR = 131;
    static final int MINUTE = 132;
    static final int SECOND = 133;
    static final int TIMEZONE_HOUR = 134;
    static final int T_TIMEZONE_MINUTE = 135;
    static final HashSet SQL_EXTRACT_FIELD_NAMES = new HashSet();
    static final HashSet SQL_TRIM_SPECIFICATION = new HashSet();
    private static final int AGGREGATE_SELF = -1;
    private static final int AGGREGATE_NONE = 0;
    private static final int AGGREGATE_LEFT = 1;
    private static final int AGGREGATE_RIGHT = 2;
    private static final int AGGREGATE_BOTH = 3;
    int iType;
    private Expression eArg;
    private Expression eArg2;
    private int aggregateSpec = 0;
    Object oData;
    private HashMap hList;
    private boolean hListIsUpper;
    private int iDataType;
    Select sSelect;
    private Function fFunction;
    private char cLikeEscape;
    private String sCatalog;
    private String sSchema;
    private String sTable;
    private String sColumn;
    private TableFilter tFilter;
    private int iColumn;
    private boolean columnQuoted;
    private int iColumnSize;
    private int iColumnScale;
    private String sAlias;
    private boolean aliasQuoted;
    private boolean bDescending;
    private boolean isDistinctAggregate;
    private boolean isParam;
    private boolean isInJoin;
    static final Integer INTEGER_0;
    static final Integer INTEGER_1;
    int oldIType = -1;
    static final int PARAM_UNKNOWN = 0;
    static final int PARAM_IN = 1;
    static final int PARAM_IN_OUT = 2;
    static final int PARAM_OUT = 4;
    static final int NO_NULLS = 0;
    static final int NULLABLE = 1;
    static final int NULLABLE_UNKNOWN = 2;
    boolean isIdentity;
    int nullability = 2;
    boolean isWritable;
    int paramMode = 0;
    String valueClassName;

    Expression(Function function) {
        this.iType = 7;
        this.fFunction = function;
    }

    Expression(Expression expression) {
        this.iType = expression.iType;
        this.iDataType = expression.iDataType;
        this.eArg = expression.eArg;
        this.eArg2 = expression.eArg2;
        this.cLikeEscape = expression.cLikeEscape;
        this.sSelect = expression.sSelect;
        this.fFunction = expression.fFunction;
        this.checkAggregate();
    }

    Expression(Select select) {
        this.iType = 3;
        this.sSelect = select;
    }

    Expression(HsqlArrayList hsqlArrayList) {
        this.iType = 5;
        this.iDataType = 12;
        int n = hsqlArrayList.size();
        this.hList = new HashMap(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = hsqlArrayList.get(n2);
            this.hList.put(object, INTEGER_1);
            ++n2;
        }
    }

    Expression(int n, Expression expression, Expression expression2) {
        this.iType = n;
        this.eArg = expression;
        this.eArg2 = expression2;
        this.checkAggregate();
    }

    Expression(String string, String string2) {
        this.sTable = string;
        if (string2 == null) {
            this.iType = 6;
        } else {
            this.iType = 2;
            this.sColumn = string2;
        }
    }

    Expression(String string, String string2, boolean bl) {
        this.sTable = string;
        if (string2 == null) {
            this.iType = 6;
        } else {
            this.iType = 2;
            this.sColumn = string2;
            this.columnQuoted = bl;
        }
    }

    Expression(String string, Column column) {
        this.sTable = string;
        if (column == null) {
            this.iType = 6;
        } else {
            this.iType = 2;
            this.sColumn = column.columnName.name;
            this.columnQuoted = column.columnName.isNameQuoted;
            this.iDataType = column.getType();
        }
    }

    Expression(int n, Object object) {
        this.iType = 1;
        this.iDataType = n;
        this.oData = object;
    }

    Expression(int n, Object object, boolean bl) {
        this(n, object);
        this.isParam = bl;
        if (bl) {
            this.paramMode = 1;
        }
    }

    private void checkAggregate() {
        if (Expression.isAggregate(this.iType)) {
            this.aggregateSpec = -1;
        } else {
            this.aggregateSpec = 0;
            if (this.eArg != null && this.eArg.isAggregate()) {
                ++this.aggregateSpec;
            }
            if (this.eArg2 != null && this.eArg2.isAggregate()) {
                this.aggregateSpec += 2;
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        if (this.oldIType != -1) {
            stringBuffer.append("SET TRUE, WAS: ");
        }
        int n3 = this.oldIType == -1 ? this.iType : this.oldIType;
        switch (n3) {
            case 7: {
                stringBuffer.append("FUNCTION ");
                stringBuffer.append(this.fFunction);
                return stringBuffer.toString();
            }
            case 1: {
                if (this.isParam) {
                    stringBuffer.append("PARAM ");
                }
                stringBuffer.append("VALUE = ").append(this.oData);
                stringBuffer.append(", TYPE = ").append(Types.getTypeString(this.iDataType));
                return stringBuffer.toString();
            }
            case 2: {
                stringBuffer.append("COLUMN ");
                if (this.sTable != null) {
                    stringBuffer.append(this.sTable);
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.sColumn);
                return stringBuffer.toString();
            }
            case 3: {
                stringBuffer.append("QUERY ");
                stringBuffer.append(this.sSelect);
                return stringBuffer.toString();
            }
            case 4: {
                stringBuffer.append("TRUE ");
                break;
            }
            case -4: {
                stringBuffer.append("FALSE ");
                break;
            }
            case 5: {
                stringBuffer.append("VALUELIST ");
                if (this.hList == null) break;
                stringBuffer.append(this.hList);
                stringBuffer.append(' ');
                break;
            }
            case 6: {
                stringBuffer.append("* ");
                break;
            }
            case 10: {
                stringBuffer.append("NEGATE ");
                break;
            }
            case 11: {
                stringBuffer.append("ADD ");
                break;
            }
            case 12: {
                stringBuffer.append("SUBTRACT ");
                break;
            }
            case 13: {
                stringBuffer.append("MULTIPLY ");
                break;
            }
            case 14: {
                stringBuffer.append("DIVIDE ");
                break;
            }
            case 15: {
                stringBuffer.append("CONCAT ");
                break;
            }
            case 20: {
                stringBuffer.append("NOT ");
                break;
            }
            case 21: {
                stringBuffer.append("EQUAL ");
                break;
            }
            case 22: {
                stringBuffer.append("BIGGER_EQUAL ");
                break;
            }
            case 23: {
                stringBuffer.append("BIGGER ");
                break;
            }
            case 24: {
                stringBuffer.append("SMALLER ");
                break;
            }
            case 25: {
                stringBuffer.append("SMALLER_EQUAL ");
                break;
            }
            case 26: {
                stringBuffer.append("NOT_EQUAL ");
                break;
            }
            case 27: {
                stringBuffer.append("LIKE ");
                break;
            }
            case 28: {
                stringBuffer.append("AND ");
                break;
            }
            case 29: {
                stringBuffer.append("OR ");
                break;
            }
            case 30: {
                stringBuffer.append("IN ");
                break;
            }
            case 31: {
                stringBuffer.append("EXISTS ");
                break;
            }
            case 40: {
                stringBuffer.append("COUNT ");
                break;
            }
            case 41: {
                stringBuffer.append("SUM ");
                break;
            }
            case 42: {
                stringBuffer.append("MIN ");
                break;
            }
            case 43: {
                stringBuffer.append("MAX ");
                break;
            }
            case 44: {
                stringBuffer.append("AVG ");
                break;
            }
            case 60: {
                stringBuffer.append("IFNULL ");
                break;
            }
            case 61: {
                stringBuffer.append("CONVERT ");
                stringBuffer.append(Types.getTypeString(this.iDataType));
                stringBuffer.append(' ');
                break;
            }
            case 62: {
                stringBuffer.append("CASEWHEN ");
            }
        }
        if (this.isInJoin) {
            stringBuffer.append(" join");
        }
        if (this.eArg != null) {
            stringBuffer.append(" arg1=[");
            stringBuffer.append(this.eArg.toString(n + 1));
            stringBuffer.append(']');
        }
        if (this.eArg2 != null) {
            stringBuffer.append(" arg2=[");
            stringBuffer.append(this.eArg2.toString(n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    void setLikeEscape(char c) {
        this.cLikeEscape = c;
    }

    void setDataType(int n) {
        this.iDataType = n;
    }

    void setTrue() {
        if (this.oldIType == -1) {
            this.oldIType = this.iType;
        }
        this.iType = 4;
    }

    void unsetTrue() {
        if (this.oldIType != -1) {
            this.iType = this.oldIType;
        }
    }

    public boolean similarTo(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression == this) {
            return true;
        }
        return this.iType == expression.iType && Expression.similarTo(this.eArg, expression.eArg) && Expression.similarTo(this.eArg2, expression.eArg2) && Expression.equals(this.oData, expression.oData) && Expression.equals(this.hList, expression.hList) && this.iDataType == expression.iDataType && Expression.equals(this.sSelect, expression.sSelect) && Expression.equals(this.fFunction, expression.fFunction) && this.cLikeEscape == expression.cLikeEscape && Expression.equals(this.sTable, expression.sTable) && Expression.equals(this.sColumn, expression.sColumn) && this.iDataType == expression.iDataType;
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static boolean similarTo(Expression expression, Expression expression2) {
        return expression == null ? expression2 == null : expression.similarTo(expression2);
    }

    boolean canBeInGroupBy() {
        if (this.iType == 7) {
            return true;
        }
        return this.isColumn() && !this.isAggregate();
    }

    boolean canBeInOrderBy() {
        if (this.iType == 7) {
            return true;
        }
        return this.isColumn() || this.isAggregate();
    }

    private boolean isColumn() {
        switch (this.iType) {
            case 2: {
                return true;
            }
            case 10: {
                return this.eArg.isColumn();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isColumn() || this.eArg2.isColumn();
            }
        }
        return false;
    }

    boolean collectColumnName(HashSet hashSet) {
        if (this.iType == 2) {
            hashSet.add(this.sColumn);
        }
        return this.iType == 2;
    }

    void collectAllColumnNames(HashSet hashSet) {
        if (!this.collectColumnName(hashSet)) {
            if (this.eArg != null) {
                this.eArg.collectAllColumnNames(hashSet);
            }
            if (this.eArg2 != null) {
                this.eArg2.collectAllColumnNames(hashSet);
            }
        }
    }

    boolean isConstant() {
        switch (this.iType) {
            case 1: {
                return true;
            }
            case 10: {
                return this.eArg.isConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isConstant() && this.eArg2.isConstant();
            }
        }
        return false;
    }

    boolean canBeInAggregate() {
        return this.isAggregate() || this.isConstant();
    }

    boolean isAggregate() {
        return this.aggregateSpec != 0;
    }

    boolean isSelfAggregate() {
        return this.aggregateSpec == -1;
    }

    static boolean isAggregate(int n) {
        switch (n) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    boolean isConditional() {
        switch (this.iType) {
            case -4: 
            case 4: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                return true;
            }
            case 20: {
                return this.eArg.isConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isConditional() && this.eArg2.isConditional();
            }
        }
        return false;
    }

    void collectInGroupByExpressions(HsqlArrayList hsqlArrayList) {
        if (!this.isConstant() && !this.isSelfAggregate()) {
            if (this.isColumn()) {
                hsqlArrayList.add(this);
            } else {
                if (this.eArg != null) {
                    this.eArg.collectInGroupByExpressions(hsqlArrayList);
                }
                if (this.eArg2 != null) {
                    this.eArg2.collectInGroupByExpressions(hsqlArrayList);
                }
            }
        }
    }

    void setDescending() {
        this.bDescending = true;
    }

    boolean isDescending() {
        return this.bDescending;
    }

    void setAlias(String string, boolean bl) {
        this.sAlias = string;
        this.aliasQuoted = bl;
    }

    String getDefinedAlias() {
        return this.sAlias;
    }

    String getAlias() {
        String string;
        if (this.sAlias != null) {
            return this.sAlias;
        }
        if (this.iType == 1) {
            return "";
        }
        if (this.iType == 2) {
            return this.sColumn;
        }
        if (this.eArg != null && (string = this.eArg.getColumnName()).length() > 0) {
            return string;
        }
        return this.eArg2 == null ? "" : this.eArg2.getAlias();
    }

    boolean isAliasQuoted() {
        String string;
        if (this.sAlias != null) {
            return this.aliasQuoted;
        }
        if (this.iType == 2) {
            return this.columnQuoted;
        }
        if (this.eArg != null && (string = this.eArg.getColumnName()).length() > 0) {
            return this.eArg.columnQuoted;
        }
        return this.eArg2 == null ? false : this.eArg2.columnQuoted;
    }

    int getType() {
        return this.iType;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tFilter;
    }

    void checkResolved() throws HsqlException {
        Trace.check(this.iType != 2 || this.tFilter != null, 28, this.sColumn);
        if (this.eArg != null) {
            this.eArg.checkResolved();
        }
        if (this.eArg2 != null) {
            this.eArg2.checkResolved();
        }
        if (this.sSelect != null) {
            this.sSelect.checkResolved();
        }
        if (this.fFunction != null) {
            this.fFunction.checkResolved();
        }
    }

    void resolve(TableFilter tableFilter) throws HsqlException {
        Object object;
        Object object2;
        if (this.isParam) {
            return;
        }
        if (tableFilter != null && this.iType == 2) {
            int n;
            object2 = tableFilter.getName();
            if ((this.sTable == null || ((String)object2).equals(this.sTable)) && (n = ((Table)(object = tableFilter.getTable())).searchColumn(this.sColumn)) != -1) {
                Trace.check(this.tFilter == null || this.tFilter.getName().equals(object2), 28, this.sColumn);
                this.tFilter = tableFilter;
                this.iColumn = n;
                this.sTable = object2;
                this.setTableColumnAttributes((Table)object, n);
                return;
            }
        }
        if (this.eArg != null) {
            this.eArg.resolve(tableFilter);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolve(tableFilter);
        }
        if (this.sSelect != null) {
            this.sSelect.resolve(tableFilter, false);
            this.sSelect.resolve();
        }
        if (this.fFunction != null) {
            this.fFunction.resolve(tableFilter);
        }
        switch (this.iType) {
            case 7: {
                this.iDataType = this.fFunction.getReturnType();
                break;
            }
            case 3: {
                this.iDataType = this.sSelect.eColumn[0].iDataType;
                break;
            }
            case 10: {
                Trace.check(!this.eArg.isParam, 57, "it is ambiguous for a parameter marker to be the operand of a unary negation operation");
                this.iDataType = this.eArg.iDataType;
                if (!this.isFixedConstant()) break;
                this.oData = this.getValue(this.iDataType);
                this.eArg = null;
                this.iType = 1;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                Trace.check(!this.eArg.isParam || !this.eArg2.isParam, 57, "it is ambiguous for both operands of a binary aritmetic operator to be parameter markers");
                if (this.isFixedConstant()) {
                    this.iDataType = Column.getCombinedNumberType(this.eArg.iDataType, this.eArg2.iDataType, this.iType);
                    this.oData = this.getValue(this.iDataType);
                    this.eArg = null;
                    this.eArg2 = null;
                    this.iType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.iDataType = this.eArg2.iDataType;
                } else if (this.eArg2.isParam) {
                    this.eArg2.iDataType = this.eArg.iDataType;
                }
                this.iDataType = Column.getCombinedNumberType(this.eArg.iDataType, this.eArg2.iDataType, this.iType);
                break;
            }
            case 15: {
                this.iDataType = 12;
                if (this.isFixedConstant()) {
                    this.oData = this.getValue(this.iDataType);
                    this.eArg = null;
                    this.eArg2 = null;
                    this.iType = 1;
                    break;
                }
                if (this.eArg.isParam) {
                    this.eArg.iDataType = 12;
                }
                if (!this.eArg2.isParam) break;
                this.eArg2.iDataType = 12;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                Trace.check(!this.eArg.isParam || !this.eArg2.isParam, 57, "it is ambiguous for both expressions of a comparison-predicate to be parameter markers");
                if (this.isFixedConditional()) {
                    this.iType = this.test() ? 4 : -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (this.eArg.isParam) {
                    this.eArg.iDataType = this.eArg2.iDataType;
                    if (this.eArg2.iType == 2) {
                        this.eArg.setTableColumnAttributes(this.eArg2);
                    }
                } else if (this.eArg2.isParam) {
                    this.eArg2.iDataType = this.eArg.iDataType;
                    if (this.eArg.iType == 2) {
                        this.eArg2.setTableColumnAttributes(this.eArg);
                    }
                }
                this.iDataType = -7;
                break;
            }
            case 27: {
                Trace.check(!this.eArg.isParam || !this.eArg2.isParam, 57, "it is ambiguous for both expressions of a LIKE comparison-predicate to be parameter markers");
                if (this.isFixedConditional()) {
                    this.iType = this.test() ? 4 : -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else if (this.eArg.isParam) {
                    this.eArg.iDataType = 12;
                } else if (this.eArg2.isParam) {
                    this.eArg2.iDataType = 12;
                }
                this.iDataType = -7;
                break;
            }
            case 28: 
            case 29: {
                if (this.isFixedConditional()) {
                    this.iType = this.test() ? 4 : -4;
                    this.eArg = null;
                    this.eArg2 = null;
                } else {
                    if (this.eArg.isParam) {
                        this.eArg.iDataType = -7;
                    }
                    if (this.eArg2.isParam) {
                        this.eArg2.iDataType = -7;
                    }
                }
                this.iDataType = -7;
                break;
            }
            case 20: {
                if (this.isFixedConditional()) {
                    this.iType = this.test() ? 4 : -4;
                    this.eArg = null;
                } else if (this.eArg.isParam) {
                    this.eArg.iDataType = -7;
                }
                this.iDataType = -7;
                break;
            }
            case 30: {
                if (this.eArg.isParam) {
                    this.eArg.iDataType = this.eArg2.iDataType;
                }
                this.iDataType = -7;
                break;
            }
            case 31: {
                this.iDataType = -7;
                break;
            }
            case 40: {
                Trace.check(!this.eArg.isParam, 57, "it is ambiguous for a parameter marker to be the argument of a set-function-reference");
                this.iDataType = 4;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                Trace.check(!this.eArg.isParam, 57, "it is ambiguous for a parameter marker to be the argument of a set-function-reference");
                this.iDataType = SetFunction.getType(this.iType, this.eArg.iDataType);
                break;
            }
            case 61: {
                if (!this.eArg.isFixedConstant() && !this.eArg.isFixedConditional()) break;
                this.oData = this.getValue(this.iDataType);
                this.iType = 1;
                this.eArg = null;
                break;
            }
            case 60: {
                Trace.check(!this.eArg.isParam || !this.eArg2.isParam, 57, "it is ambiguous for both operands of an IFNULL operation to be parameter markers");
                if ((this.eArg.isFixedConstant() || this.eArg.isFixedConditional()) && (this.eArg2.isFixedConstant() || this.eArg2.isFixedConditional())) {
                    this.iType = 1;
                    this.oData = this.eArg.getValue(this.eArg.iDataType);
                    if (this.oData == null) {
                        this.iDataType = this.eArg2.iDataType;
                        this.oData = this.eArg2.getValue(this.iDataType);
                        break;
                    }
                    this.iDataType = this.eArg.iDataType;
                    break;
                }
                if (this.eArg.isParam || this.eArg.iDataType == 0) {
                    this.eArg.iDataType = this.eArg2.iDataType;
                } else if (this.eArg2.isParam || this.eArg2.iDataType == 0) {
                    this.eArg2.iDataType = this.eArg.iDataType;
                }
                Trace.check(this.eArg.iDataType != 0 || this.eArg.iDataType != 0, 57, "it is ambiguous for both operands of an IFNULL operation to be of type NULL");
                if (Types.isNumberType(this.eArg.iDataType) && Types.isNumberType(this.eArg2.iDataType)) {
                    this.iDataType = Column.getCombinedNumberType(this.eArg.iDataType, this.eArg2.iDataType, 11);
                    break;
                }
                if (Types.isCharacterType(this.eArg.iDataType) && Types.isCharacterType(this.eArg2.iDataType)) {
                    this.iDataType = -1;
                    break;
                }
                if (Types.isDatetimeType(this.eArg.iDataType) && Types.isDatetimeType(this.eArg2.iDataType)) {
                    this.iDataType = 93;
                    break;
                }
                Trace.check(this.eArg.iDataType == this.eArg2.iDataType, 57, "the output data type of an IFNULL operation is currently ambiguous when the input types are ", Types.getTypeString(this.eArg.iDataType), " and ", Types.getTypeString(this.eArg.iDataType));
                break;
            }
            case 62: {
                if (this.eArg2.eArg == null) break;
                if (this.eArg.isParam) {
                    this.eArg.iDataType = -7;
                }
                object2 = this.eArg2.eArg;
                object = this.eArg2.eArg2;
                Trace.check(!((Expression)object2).isParam || !((Expression)object).isParam, 57, "it is ambiguous for both the second and third operands of a CASEWHEN operation to be parameter markers");
                if (((Expression)object2).isParam || ((Expression)object2).iDataType == 0) {
                    ((Expression)object2).iDataType = ((Expression)object).iDataType;
                } else if (((Expression)object).isParam || ((Expression)object).iDataType == 0) {
                    ((Expression)object).iDataType = ((Expression)object2).iDataType;
                }
                Trace.check(((Expression)object2).iDataType != 0 || ((Expression)object).iDataType != 0, 57, "it is ambiguous for both the second and third operands of a CASEWHEN operation to be NULL");
                if (Types.isNumberType(((Expression)object2).iDataType) && Types.isNumberType(((Expression)object).iDataType)) {
                    this.iDataType = Column.getCombinedNumberType(((Expression)object2).iDataType, ((Expression)object).iDataType, 62);
                    break;
                }
                if (Types.isCharacterType(((Expression)object2).iDataType) && Types.isCharacterType(((Expression)object).iDataType)) {
                    this.iDataType = -1;
                    break;
                }
                if (Types.isDatetimeType(((Expression)object2).iDataType) && Types.isDatetimeType(((Expression)object).iDataType)) {
                    if (((Expression)object2).iDataType == ((Expression)object).iDataType) {
                        this.iDataType = ((Expression)object2).iDataType;
                        break;
                    }
                    this.iDataType = 93;
                    break;
                }
                Trace.check(((Expression)object2).iDataType == ((Expression)object).iDataType, 57, "the output data type of a CASEWHEN operation is currently ambiguous when the operand types are ", Types.getTypeString(((Expression)object2).iDataType), " and ", Types.getTypeString(((Expression)object).iDataType));
            }
        }
    }

    boolean isResolved() {
        switch (this.iType) {
            case 1: 
            case 10: {
                return true;
            }
            case 2: {
                return this.tFilter != null;
            }
        }
        return false;
    }

    static boolean isCompare(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.iType == 6) {
            return this.sTable;
        }
        if (this.iType == 2) {
            if (this.tFilter == null) {
                return this.sTable;
            }
            return this.tFilter.getTable().getName().name;
        }
        return "";
    }

    String getColumnName() {
        if (this.iType == 2) {
            if (this.tFilter == null) {
                return this.sColumn;
            }
            return this.tFilter.getTable().getColumn((int)this.iColumn).columnName.name;
        }
        return this.getAlias();
    }

    int getColumnNr() {
        return this.iColumn;
    }

    int getColumnSize() {
        return this.iColumnSize;
    }

    int getColumnScale() {
        return this.iColumnScale;
    }

    void setDistinctAggregate(boolean bl) {
        boolean bl2 = this.isDistinctAggregate = bl && this.eArg.iType != 6;
        if (this.iType == 40) {
            this.iDataType = bl ? this.iDataType : 4;
        }
    }

    void swapCondition() throws HsqlException {
        int n = 21;
        switch (this.iType) {
            case 22: {
                n = 25;
                break;
            }
            case 25: {
                n = 22;
                break;
            }
            case 24: {
                n = 23;
                break;
            }
            case 23: {
                n = 24;
                break;
            }
            case 21: {
                break;
            }
            default: {
                Trace.doAssert(false, "Expression.swapCondition");
            }
        }
        this.iType = n;
        Expression expression = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = expression;
    }

    int getDataType() {
        return this.iDataType;
    }

    Object getValue(int n) throws HsqlException {
        Object object = this.getValue();
        if (object == null || this.iDataType == n) {
            return object;
        }
        return Column.convertObject(object, n);
    }

    Object getAggregatedValue(Object objectArray) throws HsqlException {
        if (!this.isAggregate()) {
            return objectArray;
        }
        switch (this.iType) {
            case 40: {
                if (objectArray == null) {
                    return INTEGER_0;
                }
                return ((SetFunction)objectArray).getValue();
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (objectArray == null) {
                    return null;
                }
                return ((SetFunction)objectArray).getValue();
            }
            case 10: {
                return Column.negate(this.eArg.getAggregatedValue(objectArray), this.iDataType);
            }
            case 61: {
                return Column.convertObject(this.eArg.getAggregatedValue(objectArray), this.iDataType);
            }
        }
        Object object = null;
        Object object2 = null;
        switch (this.aggregateSpec) {
            case 1: {
                object = this.eArg.getAggregatedValue(objectArray);
                object2 = this.eArg2 == null ? null : this.eArg2.getValue(this.eArg.iDataType);
                break;
            }
            case 2: {
                object = this.eArg == null ? null : this.eArg.getValue(this.eArg2.iDataType);
                object2 = this.eArg2.getAggregatedValue(objectArray);
                break;
            }
            case 3: {
                if (objectArray == null) {
                    objectArray = new Object[2];
                }
                object = this.eArg.getAggregatedValue(objectArray[0]);
                object2 = this.eArg2.getAggregatedValue(objectArray[1]);
            }
        }
        switch (this.iType) {
            case 4: {
                return Boolean.TRUE;
            }
            case -4: {
                return Boolean.FALSE;
            }
            case 20: {
                Trace.doAssert(this.eArg2 == null, "Expression.getAggregatedValue.NOT");
                return (Boolean)object != false ? Boolean.FALSE : Boolean.TRUE;
            }
            case 28: {
                return (Boolean)object != false && (Boolean)object2 != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 29: {
                return (Boolean)object != false || (Boolean)object2 != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 27: {
                String string = (String)Column.convertObject(object2, 12);
                int n = this.eArg.iDataType;
                Like like = new Like(string, this.cLikeEscape, n == 100);
                String string2 = (String)Column.convertObject(object, 12);
                return like.compare(string2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 30: {
                return this.eArg2.testValueList(object, this.eArg.iDataType) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 31: {
                Result result = this.eArg.sSelect.getResult(1);
                return result.rRoot != null ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (Expression.isCompare(this.iType)) {
            int n = this.eArg.isColumn() ? this.eArg.iDataType : this.eArg2.iDataType;
            return Expression.compareValues(object, object2, n, this.iType) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object != null) {
            object = Column.convertObject(object, this.iDataType);
        }
        if (object2 != null) {
            object2 = Column.convertObject(object2, this.iDataType);
        }
        switch (this.iType) {
            case 11: {
                return Column.add(object, object2, this.iDataType);
            }
            case 12: {
                return Column.subtract(object, object2, this.iDataType);
            }
            case 13: {
                return Column.multiply(object, object2, this.iDataType);
            }
            case 14: {
                return Column.divide(object, object2, this.iDataType);
            }
            case 15: {
                return Column.concat(object, object2);
            }
        }
        Trace.check(false, 14, this.toString());
        return null;
    }

    Object getAggregatingValue(Object objectArray) throws HsqlException {
        if (!this.isAggregate()) {
            return this.getValue();
        }
        if (this.aggregateSpec == -1) {
            if (objectArray == null) {
                objectArray = new SetFunction(this.iType, this.eArg.iDataType, this.isDistinctAggregate);
            }
            Integer n = this.eArg.iType == 6 ? INTEGER_1 : this.eArg.getValue();
            ((SetFunction)objectArray).add(n);
            return objectArray;
        }
        Object object = objectArray;
        Object object2 = objectArray;
        if (this.aggregateSpec == 3) {
            if (objectArray == null) {
                objectArray = new Object[2];
            }
            object = ((Object[])objectArray)[0];
            object2 = objectArray[1];
        }
        if (this.eArg.isAggregate()) {
            object = this.eArg.getAggregatingValue(object);
        }
        if (this.eArg2 != null && this.eArg2.isAggregate()) {
            object2 = this.eArg2.getAggregatingValue(object2);
        }
        switch (this.aggregateSpec) {
            case 1: {
                objectArray = object;
                break;
            }
            case 2: {
                objectArray = object2;
                break;
            }
            case 3: {
                objectArray[0] = object;
                objectArray[1] = object2;
            }
        }
        return objectArray;
    }

    Object getValue() throws HsqlException {
        switch (this.iType) {
            case 1: {
                return this.oData;
            }
            case 2: {
                try {
                    return this.tFilter.oCurrentData[this.iColumn];
                }
                catch (NullPointerException nullPointerException) {
                    throw Trace.error(28, this.sColumn);
                }
            }
            case 7: {
                return this.fFunction.getValue();
            }
            case 3: {
                return this.sSelect.getValue(this.iDataType);
            }
            case 10: {
                return Column.negate(this.eArg.getValue(this.iDataType), this.iDataType);
            }
            case 31: {
                return this.test() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 61: {
                return this.eArg.getValue(this.iDataType);
            }
            case 62: {
                if (this.eArg.test()) {
                    return this.eArg2.eArg.getValue();
                }
                return this.eArg2.eArg2.getValue();
            }
        }
        Object object = null;
        Object object2 = null;
        if (this.eArg != null) {
            object = this.eArg.getValue(this.iDataType);
        }
        if (this.eArg2 != null) {
            object2 = this.eArg2.getValue(this.iDataType);
        }
        switch (this.iType) {
            case 11: {
                return Column.add(object, object2, this.iDataType);
            }
            case 12: {
                return Column.subtract(object, object2, this.iDataType);
            }
            case 13: {
                return Column.multiply(object, object2, this.iDataType);
            }
            case 14: {
                return Column.divide(object, object2, this.iDataType);
            }
            case 15: {
                return Column.concat(object, object2);
            }
            case 60: {
                return object == null ? object2 : object;
            }
        }
        return this.test() ? Boolean.TRUE : Boolean.FALSE;
    }

    boolean test() throws HsqlException {
        switch (this.iType) {
            case 4: {
                return true;
            }
            case -4: {
                return false;
            }
            case 20: {
                Trace.doAssert(this.eArg2 == null, "Expression.test");
                return !this.eArg.test();
            }
            case 28: {
                return this.eArg.test() && this.eArg2.test();
            }
            case 29: {
                return this.eArg.test() || this.eArg2.test();
            }
            case 27: {
                String string = (String)this.eArg2.getValue(12);
                int n = this.eArg.iDataType;
                Like like = new Like(string, this.cLikeEscape, n == 100);
                String string2 = (String)this.eArg.getValue(12);
                return like.compare(string2);
            }
            case 30: {
                return this.eArg2.testValueList(this.eArg.getValue(), this.eArg.iDataType);
            }
            case 31: {
                Result result = this.eArg.sSelect.getResult(1);
                return result.rRoot != null;
            }
        }
        Trace.check(this.eArg != null, 40);
        Object object = this.eArg.getValue();
        int n = this.eArg.iDataType;
        Trace.check(this.eArg2 != null, 40);
        Object object2 = this.eArg2.getValue(n);
        if (object == null || object2 == null) {
            if (this.iType == 21 && this.eArg.tFilter != null && this.eArg2.tFilter != null && !this.eArg.tFilter.isOuterJoin && !this.eArg2.tFilter.isOuterJoin) {
                return false;
            }
            if (this.eArg.tFilter != null) {
                if (this.eArg.tFilter.isCurrentOuter) {
                    if (this.eArg.isInJoin || this.eArg2.isInJoin) {
                        return true;
                    }
                } else {
                    this.eArg.tFilter.nonJoinIsNull = !this.eArg.isInJoin && !this.eArg2.isInJoin && object2 == null;
                }
            }
            return this.testNull(object, object2, this.iType);
        }
        return Expression.compareValues(object, object2, n, this.iType);
    }

    private static boolean compareValues(Object object, Object object2, int n, int n2) throws HsqlException {
        int n3 = Column.compare(object, object2, n);
        switch (n2) {
            case 21: {
                return n3 == 0;
            }
            case 23: {
                return n3 > 0;
            }
            case 22: {
                return n3 >= 0;
            }
            case 25: {
                return n3 <= 0;
            }
            case 24: {
                return n3 < 0;
            }
            case 26: {
                return n3 != 0;
            }
        }
        throw Trace.error(40, "Expression.test2");
    }

    boolean testNull(Object object, Object object2, int n) throws HsqlException {
        switch (n) {
            case 26: {
                return object != null || object2 != null;
            }
            case 21: 
            case 22: 
            case 25: {
                return object == null && object2 == null;
            }
        }
        return false;
    }

    private boolean testValueList(Object object, int n) throws HsqlException {
        if (this.iType == 5) {
            if (n != this.iDataType) {
                object = Column.convertObject(object, this.iDataType);
            }
            if (object != null && n == 100) {
                if (!this.hListIsUpper) {
                    HashMap hashMap = new HashMap(this.hList.size(), 1.0f);
                    Iterator iterator = this.hList.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object object2 = iterator.next();
                        hashMap.put(object2.toString().toUpperCase(), INTEGER_1);
                    }
                    this.hList = hashMap;
                    this.hListIsUpper = true;
                }
                return this.hList.containsKey(object.toString().toUpperCase());
            }
            return this.hList.containsKey(object);
        }
        if (this.iType == 3) {
            Result result = this.sSelect.getResult(0);
            result.removeDuplicates();
            Record record = result.rRoot;
            int n2 = result.metaData.colType[0];
            if (n != n2) {
                object = Column.convertObject(object, n2);
            }
            while (record != null) {
                Object object3 = record.data[0];
                if (object3 != null && Column.compare(object3, object, n2) == 0) {
                    return true;
                }
                record = record.next;
            }
            return false;
        }
        throw Trace.error(16);
    }

    boolean setForOuterJoin() {
        this.isInJoin = true;
        if (this.eArg != null && !this.eArg.setForOuterJoin()) {
            return false;
        }
        if (this.eArg2 != null && !this.eArg2.setForOuterJoin()) {
            return false;
        }
        return this.iType != 29;
    }

    void bind(Object object) throws HsqlException {
        this.oData = object;
    }

    boolean isParam() {
        return this.isParam;
    }

    boolean isFixedConstant() {
        switch (this.iType) {
            case 1: {
                return !this.isParam;
            }
            case 10: {
                return this.eArg.isFixedConstant();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
        }
        return false;
    }

    boolean isFixedConditional() {
        switch (this.iType) {
            case -4: 
            case 4: {
                return true;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return this.eArg.isFixedConstant() && this.eArg2.isFixedConstant();
            }
            case 20: {
                return this.eArg.isFixedConditional();
            }
            case 28: 
            case 29: {
                return this.eArg.isFixedConditional() && this.eArg2.isFixedConditional();
            }
        }
        return false;
    }

    boolean isProcedureCall() {
        return this.iType == 7 && this.iDataType == 0;
    }

    void setTableColumnAttributes(Expression expression) {
        this.iColumnSize = expression.iColumnSize;
        this.iColumnScale = expression.iColumnScale;
        this.isIdentity = expression.isIdentity;
        this.nullability = expression.nullability;
        this.isWritable = expression.isWritable;
        this.sCatalog = expression.sCatalog;
        this.sSchema = expression.sSchema;
    }

    void setTableColumnAttributes(Table table, int n) {
        Column column = table.getColumn(n);
        this.iDataType = column.getType();
        this.iColumnSize = column.getSize();
        this.iColumnScale = column.getScale();
        this.isIdentity = column.isIdentity();
        this.nullability = column.isNullable() && !this.isIdentity ? 1 : 0;
        this.isWritable = table.isWritable();
        this.sCatalog = table.getCatalogName();
        this.sSchema = table.getSchemaName();
    }

    String getValueClassName() {
        int n;
        int n2;
        if (this.valueClassName != null) {
            return this.valueClassName;
        }
        if (this.fFunction != null) {
            this.valueClassName = this.fFunction.getReturnClass().getName();
            return this.valueClassName;
        }
        if (this.iDataType == 100) {
            n2 = 12;
            n = 4;
        } else {
            n2 = this.iDataType;
            n = 1;
        }
        DITypeInfo dITypeInfo = new DITypeInfo();
        dITypeInfo.setTypeCode(n2);
        dITypeInfo.setTypeSub(n);
        this.valueClassName = dITypeInfo.getColStClsName();
        return this.valueClassName;
    }

    static {
        SQL_EXTRACT_FIELD_NAMES.addAll(new Object[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE"});
        SQL_TRIM_SPECIFICATION.addAll(new Object[]{"LEADING", "TRAILING", "BOTH"});
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
    }
}

