/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Hashtable;
import org.hsqldb.Binary;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.Library;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.store.ValuePool;

class Function {
    private Session cSession;
    private String sFunction;
    private Method mMethod;
    private Class cReturnClass;
    private Class[] aArgClasses;
    private int iReturnType;
    private int iArgCount;
    private int iSqlArgCount;
    private int iSqlArgStart;
    private int[] iArgType;
    private boolean[] bArgNullable;
    private Object[] oArg;
    private Expression[] eArg;
    private boolean bConnection;
    private static Hashtable methodCache = new Hashtable();
    private int fID;
    static /* synthetic */ Class class$org$hsqldb$Result;
    static /* synthetic */ Class class$org$hsqldb$jdbcResultSet;
    static /* synthetic */ Class class$java$sql$Connection;

    Function(String string, Session session, boolean bl) throws HsqlException {
        Object object;
        Object object2;
        this.cSession = session;
        this.sFunction = string;
        this.fID = Library.functionID(string);
        int n = string.lastIndexOf(46);
        Trace.check(n != -1, 11, string);
        String string2 = string.substring(0, n);
        if (bl) {
            session.check(string2, 15);
        }
        this.mMethod = (Method)methodCache.get(string);
        if (this.mMethod == null) {
            object2 = string.substring(n + 1);
            object = null;
            try {
                object = Class.forName(string2);
            }
            catch (Exception exception) {
                throw Trace.error(42, 115, new Object[]{string2, exception});
            }
            Method[] methodArray = ((Class)object).getMethods();
            n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (method.getName().equals(object2) && Modifier.isStatic(method.getModifiers())) {
                    this.mMethod = method;
                    break;
                }
                ++n;
            }
            Trace.check(this.mMethod != null, 13, object2);
            methodCache.put(string, this.mMethod);
        }
        this.cReturnClass = this.mMethod.getReturnType();
        this.iReturnType = this.cReturnClass.equals(class$org$hsqldb$Result == null ? (class$org$hsqldb$Result = Function.class$("org.hsqldb.Result")) : class$org$hsqldb$Result) || this.cReturnClass.equals(class$org$hsqldb$jdbcResultSet == null ? (class$org$hsqldb$jdbcResultSet = Function.class$("org.hsqldb.jdbcResultSet")) : class$org$hsqldb$jdbcResultSet) ? 1111 : Types.getParameterTypeNr(this.cReturnClass);
        this.aArgClasses = this.mMethod.getParameterTypes();
        this.iArgCount = this.aArgClasses.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        n = 0;
        while (n < this.aArgClasses.length) {
            object2 = this.aArgClasses[n];
            object = ((Class)object2).getName();
            if (n == 0 && object2.equals(class$java$sql$Connection == null ? Function.class$("java.sql.Connection") : class$java$sql$Connection)) {
                this.bConnection = true;
            } else {
                this.iArgType[n] = Types.getParameterTypeNr((Class)object2);
                this.bArgNullable[n] = !((Class)object2).isPrimitive();
            }
            ++n;
        }
        this.iSqlArgCount = this.iArgCount;
        if (this.bConnection) {
            --this.iSqlArgCount;
            this.iSqlArgStart = 1;
        } else {
            this.iSqlArgStart = 0;
        }
        this.eArg = new Expression[this.iArgCount];
        this.oArg = new Object[this.iArgCount];
    }

    /*
     * Unable to fully structure code
     */
    Object getValue() throws HsqlException {
        block20: {
            switch (this.fID) {
                case 22: {
                    return this.cSession.getLastIdentity();
                }
                case 9: {
                    return this.cSession.getDatabase().getPath();
                }
                case 55: {
                    return this.cSession.getUser().getName();
                }
                case 24: {
                    return this.cSession.isReadOnly() != false ? Boolean.TRUE : Boolean.FALSE;
                }
                case 15: {
                    return this.cSession.isAutoCommit() != false ? Boolean.TRUE : Boolean.FALSE;
                }
                case 25: {
                    return this.cSession.getDatabase().databaseReadOnly != false ? Boolean.TRUE : Boolean.FALSE;
                }
                case 58: {
                    return this.cSession.getDatabase().filesReadOnly != false ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            var1_1 = 0;
            if (this.bConnection) {
                this.oArg[var1_1] = this.cSession.getInternalConnection();
                ++var1_1;
            }
            while (var1_1 < this.iArgCount) {
                var2_2 = this.eArg[var1_1];
                var3_5 = null;
                if (var2_2 != null) {
                    var3_5 = var2_2.getValue(this.iArgType[var1_1]);
                }
                if (var3_5 == null && !this.bArgNullable[var1_1]) {
                    return null;
                }
                if (var3_5 instanceof JavaObject) {
                    var3_5 = ((JavaObject)var3_5).getObject();
                } else if (var3_5 instanceof Binary) {
                    var3_5 = ((Binary)var3_5).getBytes();
                }
                this.oArg[var1_1] = var3_5;
                ++var1_1;
            }
            try {
                if (this.fID == 34) {
                    return ValuePool.getInt(Library.getDateTimePart((Date)this.oArg[0], 2) + this.cSession.getDatabase().sqlMonth);
                }
                var2_2 = this.fID >= 0 ? Library.invoke(this.fID, this.oArg) : this.mMethod.invoke(null, this.oArg);
                return Column.convertObject(var2_2, this.iReturnType);
            }
            catch (Throwable var2_3) {
                var3_5 = this.sFunction;
                if (!(var2_3 instanceof InvocationTargetException)) break block20;
                ** while (var2_4 instanceof InvocationTargetException)
            }
lbl-1000:
            // 1 sources

            {
                var2_4 = ((InvocationTargetException)var2_4).getTargetException();
                var3_5 = (String)var3_5 + ": " + var2_4.toString();
                continue;
            }
lbl47:
            // 1 sources

            var3_5 = (String)var3_5 + ": " + var2_4.toString();
            throw Trace.getError(13, var3_5);
        }
        var3_5 = this.sFunction + ": " + var2_3.toString();
        throw Trace.getError(40, var3_5);
    }

    int getArgCount() {
        return this.iSqlArgCount;
    }

    void resolve(TableFilter tableFilter) throws HsqlException {
        int n = this.iSqlArgStart;
        while (n < this.iArgCount) {
            Expression expression = this.eArg[n];
            if (expression != null) {
                if (expression.isParam()) {
                    expression.setDataType(this.iArgType[n]);
                    expression.nullability = this.getArgNullability(n);
                    expression.valueClassName = this.getArgClass(n).getName();
                } else {
                    this.eArg[n].resolve(tableFilter);
                }
            }
            ++n;
        }
    }

    void checkResolved() throws HsqlException {
        int n = this.iSqlArgStart;
        while (n < this.iArgCount) {
            if (this.eArg[n] != null) {
                this.eArg[n].checkResolved();
            }
            ++n;
        }
    }

    int getArgType(int n) {
        return this.iArgType[n];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int n, Expression expression) {
        if (this.bConnection) {
            ++n;
        }
        this.eArg[n] = expression;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("=[\n");
        stringBuffer.append(this.sFunction).append("(");
        int n = this.iSqlArgStart;
        while (n < this.eArg.length) {
            stringBuffer.append("[").append(this.eArg[n]).append("]");
            ++n;
        }
        stringBuffer.append(") returns ").append(Types.getTypeString(this.getReturnType()));
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    Class getReturnClass() {
        return this.cReturnClass;
    }

    Class getArgClass(int n) {
        return this.aArgClasses[n];
    }

    int getArgNullability(int n) {
        return this.bArgNullable[n] ? 1 : 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

