/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

class GroupedResult {
    private Result result;
    int groupBegin;
    int groupEnd;
    private final boolean isGrouped;
    private final boolean isAggregated;
    private HashSet groups;
    private ResultGroup currGroup;

    GroupedResult(Select select, Result result) {
        this.result = result;
        this.groupBegin = select.iResultLen;
        this.groupEnd = this.groupBegin + select.iGroupLen;
        this.isGrouped = this.groupBegin != this.groupEnd;
        this.isAggregated = select.isAggregated;
        if (this.isGrouped) {
            this.groups = new HashSet();
        }
    }

    Object[] addRow(Object[] objectArray) {
        if (this.isGrouped) {
            ResultGroup resultGroup = new ResultGroup(objectArray);
            this.currGroup = (ResultGroup)this.groups.get(resultGroup);
            if (this.currGroup == null) {
                this.currGroup = resultGroup;
                this.groups.add(this.currGroup);
                this.result.add(objectArray);
            }
        } else if (this.currGroup == null) {
            this.currGroup = new ResultGroup(objectArray);
            this.result.add(objectArray);
        } else if (!this.isAggregated) {
            this.result.add(objectArray);
            this.currGroup.row = objectArray;
        }
        return this.currGroup.row;
    }

    int size() {
        return this.result.getSize();
    }

    Iterator iterator() {
        return this.result.iterator();
    }

    class ResultGroup {
        Object[] row;
        int hashCode;

        private ResultGroup(Object[] objectArray) {
            this.row = objectArray;
            this.hashCode = 0;
            int n = GroupedResult.this.groupBegin;
            while (n < GroupedResult.this.groupEnd) {
                if (objectArray[n] != null) {
                    this.hashCode += objectArray[n].hashCode();
                }
                ++n;
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !(object instanceof ResultGroup)) {
                return false;
            }
            ResultGroup resultGroup = (ResultGroup)object;
            int n = GroupedResult.this.groupBegin;
            while (n < GroupedResult.this.groupEnd) {
                if (!this.equals(this.row[n], resultGroup.row[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private boolean equals(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }
}

