/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Record;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;

class HsqlDatabaseProperties
extends HsqlProperties {
    private static HashSet protectedProperties = new HashSet();
    private Database database;

    HsqlDatabaseProperties(Database database) {
        super(database.getPath(), database.isFilesInJar());
        this.database = database;
        this.setProperty("sql.month", true);
        this.setProperty("sql.enforce_size", false);
        this.setProperty("sql.enforce_strict_size", false);
        this.setProperty("sql.compare_in_locale", false);
        this.setProperty("hsqldb.compatible_version", "1.6.0");
        this.setProperty("hsqldb.cache_version", "1.7.0");
        this.setProperty("hsqldb.original_version", "1.7.2");
        this.setProperty("runtime.gc_interval", "0");
        this.setProperty("hsqldb.cache_file_scale", "1");
        this.setProperty("hsqldb.cache_scale", "14");
        this.setProperty("hsqldb.log_size", "200");
        this.setProperty("hsqldb.script_format", "0");
        this.setProperty("hsqldb.first_identity", "0");
        this.setProperty("readonly", false);
        this.setProperty("modified", "no");
        this.setSystemVariables();
        this.setDatabaseVariables();
    }

    private void setSystemVariables() {
        Column.setCompareInLocal(this.isPropertyTrue("sql.compare_in_locale"));
        Record.gcFrequency = this.getIntegerProperty("runtime.gc_interval", 0);
    }

    public boolean load() throws HsqlException {
        boolean bl;
        if (this.database.getType() == "mem:") {
            return true;
        }
        try {
            bl = super.load();
        }
        catch (Exception exception) {
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
        if (!bl) {
            this.setProperty("version", "1.7.2");
            this.setProperty("hsqldb.cache_version", "1.7.0");
            this.setProperty("hsqldb.compatible_version", "1.7.2");
            this.save();
            return false;
        }
        String string = this.getProperty("hsqldb.compatible_version");
        int n = string.substring(0, 5).compareTo("1.7.2");
        Trace.check(n <= 0, 30);
        string = this.getProperty("version");
        if (string.charAt(2) == '6') {
            this.setProperty("hsqldb.cache_version", "1.6.0");
        }
        this.setProperty("hsqldb.version", "1.7.2");
        this.setSystemVariables();
        this.setDatabaseVariables();
        return true;
    }

    private void setDatabaseVariables() {
        if (this.isPropertyTrue("sql.month")) {
            this.database.sqlMonth = 1;
        }
        if (this.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.isPropertyTrue("hsqldb.files_readonly")) {
            this.database.setFilesReadOnly();
        }
        this.database.sqlEnforceSize = this.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceStrictSize = this.isPropertyTrue("sql.enforce_strict_size");
        this.database.firstIdentity = this.getIntegerProperty("hsqldb.first_identity", 0);
    }

    public void save() throws HsqlException {
        if (this.database.getType() == "mem:" || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            super.save();
        }
        catch (Exception exception) {
            throw Trace.error(29, 117, new Object[]{this.fileName, exception});
        }
    }

    boolean isProtected(String string) {
        return protectedProperties.contains(string);
    }

    public String setProperty(String string, String string2) {
        string2 = super.setProperty(string, string2);
        this.setDatabaseVariables();
        return string2;
    }

    static {
        Object[] objectArray = new String[]{"version", "hsqldb.compatible_version", "hsqldb.cache_version", "hsqldb.original_version", "hsqldb.script_format", "hsqldb.files_readonly", "readonly", "modified", "sql.compare_in_locale"};
        protectedProperties.addAll(objectArray);
    }
}

