/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hsqldb.Trace;

class HsqlDateTime {
    private static java.sql.Date today = new java.sql.Date(0L);
    static java.sql.Date tempDate = new java.sql.Date(0L);
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    static SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat sdft = new SimpleDateFormat("HH:mm:ss");
    static SimpleDateFormat sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");

    HsqlDateTime() {
    }

    static Timestamp timestampValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        if (string.indexOf(45) == -1) {
            if ((string = string.toUpperCase()).equals("NOW") || string.equals("CURRENT_TIMESTAMP")) {
                return new Timestamp(System.currentTimeMillis());
            }
            if (string.equals("CURRENT_DATE") || string.equals("TODAY") || string.equals("SYSDATE")) {
                return new Timestamp(HsqlDateTime.getToday().getTime());
            }
            throw new IllegalArgumentException(Trace.getMessage(132));
        }
        string = string + "1970-01-01 00:00:00.000000000".substring(string.length());
        return Timestamp.valueOf(string);
    }

    static Timestamp timestampValue(long l, int n) {
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n);
        return timestamp;
    }

    static java.sql.Date dateValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(133));
        }
        if (string.indexOf(45) == -1) {
            if ((string = string.toUpperCase()).equals("TODAY") || string.equals("CURRENT_DATE") || string.equals("SYSDATE")) {
                return HsqlDateTime.getToday();
            }
            throw new IllegalArgumentException(Trace.getMessage(134));
        }
        if (string.length() > sdfdPattern.length()) {
            return java.sql.Date.valueOf(string.substring(0, sdfdPattern.length()));
        }
        return java.sql.Date.valueOf(string);
    }

    static Time timeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        if (string.toUpperCase().equals("CURRENT_TIME")) {
            long l = System.currentTimeMillis() - HsqlDateTime.getToday().getTime();
            l = l / 1000L * 1000L;
            return new Time(l);
        }
        return Time.valueOf(string);
    }

    static java.sql.Date getDate(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdfdPattern);
        simpleDateFormat.setCalendar(calendar);
        Date date = simpleDateFormat.parse(string);
        return new java.sql.Date(date.getTime());
    }

    static Time getTime(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdftPattern);
        simpleDateFormat.setCalendar(calendar);
        Date date = simpleDateFormat.parse(string);
        return new Time(date.getTime());
    }

    static Timestamp getTimestamp(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdftsPattern);
        simpleDateFormat.setCalendar(calendar);
        Date date = simpleDateFormat.parse(string.substring(0, sdftsPattern.length()));
        String string2 = string.substring(sdftsPattern.length(), string.length());
        Timestamp timestamp = new Timestamp(date.getTime());
        timestamp.setNanos(Integer.parseInt(string2));
        return timestamp;
    }

    static synchronized String getTimestampString(Timestamp timestamp, Calendar calendar) throws Exception {
        sdfts.setCalendar(calendar);
        return sdfts.format(new Date(((Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000)));
    }

    static synchronized String getTimeString(Time time, Calendar calendar) throws Exception {
        sdft.setCalendar(calendar);
        return sdft.format(time);
    }

    static synchronized String getDateString(java.sql.Date date, Calendar calendar) throws Exception {
        sdfd.setCalendar(calendar);
        return sdfd.format(date);
    }

    static java.sql.Date getToday() {
        long l = System.currentTimeMillis();
        if (l - today.getTime() > 86400000L) {
            HsqlDateTime.resetToday();
        }
        return today;
    }

    static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    static void resetToTime(Calendar calendar) {
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
    }

    private static synchronized void resetToday() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        HsqlDateTime.resetToDate(gregorianCalendar);
        today = new java.sql.Date(gregorianCalendar.getTime().getTime());
    }
}

