/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlStringBuffer;
import org.hsqldb.lib.StringConverter;

class HsqlNameManager {
    private static HsqlNameManager staticManager = new HsqlNameManager();
    private static int serialNumber = 0;
    private int sysNumber = 0;

    HsqlNameManager() {
    }

    static HsqlName newHsqlSystemTableName(String string) {
        return new HsqlName(staticManager, string);
    }

    HsqlName newHsqlName(String string, boolean bl) throws HsqlException {
        return new HsqlName(this, string, bl);
    }

    HsqlName newHsqlName(String string, String string2, boolean bl) throws HsqlException {
        return new HsqlName(this, string, string2, bl);
    }

    HsqlName newHsqlName(String string) {
        return new HsqlName(this, string);
    }

    HsqlName newAutoName(String string) {
        return this.newAutoName(string, null);
    }

    HsqlName newAutoName(String string, String string2) {
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer();
        if (string != null) {
            if (string.length() != 0) {
                hsqlStringBuffer.append("SYS_");
                hsqlStringBuffer.append(string);
                hsqlStringBuffer.append('_');
                if (string2 != null) {
                    hsqlStringBuffer.append(string2);
                    hsqlStringBuffer.append('_');
                }
                hsqlStringBuffer.append(++this.sysNumber);
            }
        } else {
            hsqlStringBuffer.append(string2);
        }
        return new HsqlName(this, hsqlStringBuffer.toString());
    }

    void resetNumbering() {
        this.sysNumber = 0;
        serialNumber = 0;
    }

    static class HsqlName {
        HsqlNameManager manager;
        String name;
        boolean isNameQuoted;
        String statementName;
        private final int hashCode;

        private HsqlName(HsqlNameManager hsqlNameManager) {
            this.manager = hsqlNameManager;
            this.hashCode = serialNumber++;
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, boolean bl) throws HsqlException {
            this(hsqlNameManager);
            this.rename(string, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, String string2, boolean bl) throws HsqlException {
            this(hsqlNameManager);
            this.rename(string, string2, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string) {
            this(hsqlNameManager);
            this.name = this.statementName = string;
        }

        void rename(String string, boolean bl) throws HsqlException {
            this.name = string;
            this.statementName = string;
            this.isNameQuoted = bl;
            if (string == null || string.length() == 0) {
                throw Trace.error(74);
            }
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string, '\"', true);
            }
            if (string.startsWith("SYS_")) {
                int n = string.lastIndexOf(95) + 1;
                try {
                    int n2 = Integer.parseInt(string.substring(n));
                    if (n2 > this.manager.sysNumber) {
                        this.manager.sysNumber = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String string, String string2, boolean bl) throws HsqlException {
            HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(string);
            hsqlStringBuffer.append('_');
            hsqlStringBuffer.append(string2);
            this.rename(hsqlStringBuffer.toString(), bl);
        }

        public boolean equals(HsqlName hsqlName) {
            return this.hashCode == hsqlName.hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        static boolean isReservedIndexName(String string) {
            return string.startsWith("SYS_IDX_") || string.startsWith("SYS_PK_") || string.startsWith("SYS_REF_");
        }

        boolean isReservedIndexName() {
            return HsqlName.isReservedIndexName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object object) {
            return this.hashCode - object.hashCode();
        }
    }
}

