/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private final HsqlNameManager.HsqlName indexName;
    private final int[] colIndex;
    private final int[] colType;
    private final boolean isUnique;
    private final boolean isExact;
    private final int visibleColumns;
    private final int colIndex_0;
    private final int colType_0;
    private Node root;
    private int depth;

    Index(HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, int[] nArray2, boolean bl, int n) {
        this.indexName = hsqlName;
        this.colIndex = nArray;
        this.colType = nArray2;
        this.isUnique = bl;
        this.colIndex_0 = this.colIndex[0];
        this.colType_0 = this.colType[0];
        this.visibleColumns = n;
        this.isExact = this.colIndex.length == n;
    }

    Node getRoot() {
        return this.root;
    }

    void setRoot(Node node) {
        this.root = node;
        this.depth = 0;
    }

    HsqlNameManager.HsqlName getName() {
        return this.indexName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.indexName.rename(string, bl);
    }

    int getVisibleColumns() {
        return this.visibleColumns;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    int[] getColumns() {
        return this.colIndex;
    }

    boolean isEquivalent(Index index) {
        if (this.isUnique == index.isUnique && this.colIndex.length == index.colIndex.length) {
            int n = 0;
            while (n < this.colIndex.length) {
                if (this.colIndex[n] != index.colIndex[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    void insert(Node node) throws HsqlException {
        Node node2;
        Object[] objectArray = node.getData();
        Node node3 = node2 = this.root;
        boolean bl = true;
        int n = -1;
        while (true) {
            if (node2 == null) {
                if (node3 == null) {
                    this.root = node;
                    return;
                }
                break;
            }
            Object[] objectArray2 = node2.getData();
            n = this.compareRowUnique(objectArray, objectArray2);
            if (n == 0) {
                throw Trace.error(9, this.indexName.name);
            }
            bl = n < 0;
            node3 = node2;
            node2 = this.child(node3, bl);
        }
        this.set(node3, bl, node);
        this.balance(node3, bl);
    }

    private void balance(Node node, boolean bl) throws HsqlException {
        while (true) {
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case 1: {
                    node.setBalance(0);
                    return;
                }
                case 0: {
                    node.setBalance(-n);
                    break;
                }
                case -1: {
                    Node node2 = this.child(node, bl);
                    if (node2.getBalance() == -n) {
                        this.replace(node, node2);
                        this.set(node, bl, this.child(node2, !bl));
                        this.set(node2, !bl, node);
                        node.setBalance(0);
                        node2.setBalance(0);
                    } else {
                        Node node3 = this.child(node2, !bl);
                        this.replace(node, node3);
                        this.set(node2, !bl, this.child(node3, bl));
                        this.set(node3, bl, node2);
                        this.set(node, bl, this.child(node3, !bl));
                        this.set(node3, !bl, node);
                        int n2 = node3.getBalance();
                        node.setBalance(n2 == -n ? n : 0);
                        node2.setBalance(n2 == n ? -n : 0);
                        node3.setBalance(0);
                    }
                    return;
                }
            }
            if (node.equals(this.root)) {
                return;
            }
            bl = node.isFromLeft();
            node = node.getParent();
        }
    }

    void delete(Node node) throws HsqlException {
        Node node2;
        Node node3;
        if (node == null) {
            return;
        }
        if (node.getLeft() == null) {
            node3 = node.getRight();
        } else if (node.getRight() == null) {
            node3 = node.getLeft();
        } else {
            Node node4 = node;
            Node node5 = node = node.getLeft();
            while ((node5 = node5.getRight()) != null) {
                node = node5;
            }
            node3 = node.getLeft();
            int n = node.getBalance();
            node.setBalance(node4.getBalance());
            node4.setBalance(n);
            Node node6 = node.getParent();
            node2 = node4.getParent();
            if (node4 == this.root) {
                this.root = node;
            }
            node.setParent(node2);
            if (node2 != null) {
                if (node2.getRight().equals(node4)) {
                    node2.setRight(node);
                } else {
                    node2.setLeft(node);
                }
            }
            if (node6 == node4) {
                node4.setParent(node);
                if (node4.getLeft().equals(node)) {
                    node.setLeft(node4);
                    node.setRight(node4.getRight());
                } else {
                    node.setRight(node4);
                    node.setLeft(node4.getLeft());
                }
            } else {
                node4.setParent(node6);
                node6.setRight(node4);
                node.setRight(node4.getRight());
                node.setLeft(node4.getLeft());
            }
            node.getRight().setParent(node);
            node.getLeft().setParent(node);
            node4.setLeft(node3);
            if (node3 != null) {
                node3.setParent(node4);
            }
            node4.setRight(null);
            node = node4;
        }
        boolean bl = node.isFromLeft();
        this.replace(node, node3);
        node3 = node.getParent();
        node.delete();
        while (node3 != null) {
            node = node3;
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case -1: {
                    node.setBalance(0);
                    break;
                }
                case 0: {
                    node.setBalance(n);
                    return;
                }
                case 1: {
                    Node node7 = this.child(node, !bl);
                    int n2 = node7.getBalance();
                    if (n2 * n >= 0) {
                        this.replace(node, node7);
                        this.set(node, !bl, this.child(node7, bl));
                        this.set(node7, bl, node);
                        if (n2 == 0) {
                            node.setBalance(n);
                            node7.setBalance(-n);
                            return;
                        }
                        node.setBalance(0);
                        node7.setBalance(0);
                        node = node7;
                        break;
                    }
                    node2 = this.child(node7, bl);
                    this.replace(node, node2);
                    n2 = node2.getBalance();
                    this.set(node7, bl, this.child(node2, !bl));
                    this.set(node2, !bl, node7);
                    this.set(node, !bl, this.child(node2, bl));
                    this.set(node2, bl, node);
                    node.setBalance(n2 == n ? -n : 0);
                    node7.setBalance(n2 == -n ? n : 0);
                    node2.setBalance(0);
                    node = node2;
                }
            }
            bl = node.isFromLeft();
            node3 = node.getParent();
        }
    }

    /*
     * Unable to fully structure code
     */
    Node findSimple(Object[] var1_1, boolean var2_2) throws HsqlException {
        var3_3 = this.root;
        var5_4 = null;
        if (var1_1[0] != null) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            var6_6 = this.comparePartialRowNonUnique(var1_1, var3_3.getData());
            if (var6_6 == 0) {
                if (!var2_2) {
                    var5_4 = var3_3;
                    break;
                }
                if (var5_4 == var3_3) break;
                var5_4 = var3_3;
                var4_5 = var3_3.getLeft();
            } else {
                var4_5 = var6_6 > 0 ? var3_3.getRight() : var3_3.getLeft();
            }
            if (var4_5 == null) break;
            var3_3 = var4_5;
lbl17:
            // 2 sources

            ** while (var3_3 != null)
        }
lbl18:
        // 4 sources

        return var5_4;
    }

    Node find(Object[] objectArray) throws HsqlException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    Node findFirst(Object object, int n) throws HsqlException {
        Trace.doAssert(n == 23 || n == 21 || n == 22, "Index.findFirst");
        Node node = this.root;
        int n2 = 1;
        if (n == 23) {
            n2 = 0;
        }
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = Column.compare(object, node.getData()[this.colIndex_0], this.colType_0) >= n2;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null && Column.compare(object, node.getData()[this.colIndex_0], this.colType_0) >= n2) {
            node = this.next(node);
        }
        return node;
    }

    Node first() throws HsqlException {
        Node node;
        this.depth = 0;
        Node node2 = node = this.root;
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
            ++this.depth;
        }
        return node;
    }

    Node next(Node node) throws HsqlException {
        if (node == null) {
            return null;
        }
        Node node2 = node.getRight();
        if (node2 != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        node = node.getParent();
        while (node != null && node4.equals(node.getRight())) {
            node4 = node;
            node = node.getParent();
        }
        return node;
    }

    private Node child(Node node, boolean bl) throws HsqlException {
        return bl ? node.getLeft() : node.getRight();
    }

    private void replace(Node node, Node node2) throws HsqlException {
        if (node.equals(this.root)) {
            this.root = node2;
            if (node2 != null) {
                node2.setParent(null);
            }
        } else {
            this.set(node.getParent(), node.isFromLeft(), node2);
        }
    }

    private void set(Node node, boolean bl, Node node2) throws HsqlException {
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2.setParent(node);
        }
    }

    Node search(Object[] objectArray) throws HsqlException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRow(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    int comparePartialRowNonUnique(Object[] objectArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[0], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.visibleColumns;
        int n3 = 1;
        while (n3 < objectArray.length && n3 < n2) {
            Object object = objectArray[n3];
            if (object != null && (n = Column.compare(object, objectArray2[this.colIndex[n3]], this.colType[n3])) != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    private int compareRowNonUnique(Object[] objectArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[this.colIndex_0], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.visibleColumns;
        int n3 = 1;
        while (n3 < n2) {
            n = Column.compare(objectArray[this.colIndex[n3]], objectArray2[this.colIndex[n3]], this.colType[n3]);
            if (n != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    private int compareRow(Object[] objectArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[this.colIndex_0], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.colIndex.length;
        int n3 = 1;
        while (n3 < n2) {
            n = Column.compare(objectArray[this.colIndex[n3]], objectArray2[this.colIndex[n3]], this.colType[n3]);
            if (n != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int compareRowUnique(Object[] var1_1, Object[] var2_2) throws HsqlException {
        var3_3 = var1_1[this.colIndex_0];
        var4_4 = Column.compare(var3_3, var2_2[this.colIndex_0], this.colType_0);
        var5_5 = 1;
        if (var4_4 == 0) ** GOTO lbl13
        return var4_4;
lbl-1000:
        // 1 sources

        {
            var6_6 = var1_1[this.colIndex[var5_5]];
            var4_4 = Column.compare(var6_6, var2_2[this.colIndex[var5_5]], this.colType[var5_5]);
            if (var4_4 != 0) {
                return var4_4;
            }
            if (var6_6 == null) {
                var3_3 = null;
            }
            ++var5_5;
lbl13:
            // 2 sources

            ** while (var5_5 < this.visibleColumns)
        }
lbl14:
        // 1 sources

        if (!this.isExact && (!this.isUnique || var3_3 == null)) ** GOTO lbl21
        return 0;
lbl-1000:
        // 1 sources

        {
            var6_6 = var1_1[this.colIndex[var5_5]];
            var4_4 = Column.compare(var6_6, var2_2[this.colIndex[var5_5]], this.colType[var5_5]);
            if (var4_4 != 0) {
                return var4_4;
            }
            ++var5_5;
lbl21:
            // 2 sources

            ** while (var5_5 < this.colIndex.length)
        }
lbl22:
        // 1 sources

        return 0;
    }
}

