/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

public class Library {
    static final String[][] sNumeric = new String[][]{{"ABS", "org.hsqldb.Library.abs"}, {"ACOS", "java.lang.Math.acos"}, {"ASIN", "java.lang.Math.asin"}, {"ATAN", "java.lang.Math.atan"}, {"ATAN2", "java.lang.Math.atan2"}, {"CEILING", "java.lang.Math.ceil"}, {"COS", "java.lang.Math.cos"}, {"COT", "org.hsqldb.Library.cot"}, {"DEGREES", "java.lang.Math.toDegrees"}, {"EXP", "java.lang.Math.exp"}, {"FLOOR", "java.lang.Math.floor"}, {"LOG", "java.lang.Math.log"}, {"LOG10", "org.hsqldb.Library.log10"}, {"MOD", "org.hsqldb.Library.mod"}, {"PI", "org.hsqldb.Library.pi"}, {"POWER", "java.lang.Math.pow"}, {"RADIANS", "java.lang.Math.toRadians"}, {"RAND", "java.lang.Math.random"}, {"ROUND", "org.hsqldb.Library.round"}, {"SIGN", "org.hsqldb.Library.sign"}, {"SIN", "java.lang.Math.sin"}, {"SQRT", "java.lang.Math.sqrt"}, {"TAN", "java.lang.Math.tan"}, {"TRUNCATE", "org.hsqldb.Library.truncate"}, {"BITAND", "org.hsqldb.Library.bitand"}, {"BITOR", "org.hsqldb.Library.bitor"}, {"ROUNDMAGIC", "org.hsqldb.Library.roundMagic"}};
    static final String[][] sString = new String[][]{{"ASCII", "org.hsqldb.Library.ascii"}, {"CHAR", "org.hsqldb.Library.character"}, {"CHAR_LENGTH", "org.hsqldb.Library.length"}, {"CHARACTER_LENGTH", "org.hsqldb.Library.length"}, {"CONCAT", "org.hsqldb.Library.concat"}, {"DIFFERENCE", "org.hsqldb.Library.difference"}, {"HEXTORAW", "org.hsqldb.Library.hexToRaw"}, {"INSERT", "org.hsqldb.Library.insert"}, {"LCASE", "org.hsqldb.Library.lcase"}, {"LEFT", "org.hsqldb.Library.left"}, {"LENGTH", "org.hsqldb.Library.length"}, {"LOCATE", "org.hsqldb.Library.locate"}, {"LTRIM", "org.hsqldb.Library.ltrim"}, {"OCTECT_LENGTH", "org.hsqldb.Library.octetLength"}, {"RAWTOHEX", "org.hsqldb.Library.rawToHex"}, {"REPEAT", "org.hsqldb.Library.repeat"}, {"REPLACE", "org.hsqldb.Library.replace"}, {"RIGHT", "org.hsqldb.Library.right"}, {"RTRIM", "org.hsqldb.Library.rtrim"}, {"SOUNDEX", "org.hsqldb.Library.soundex"}, {"SPACE", "org.hsqldb.Library.space"}, {"SUBSTR", "org.hsqldb.Library.substring"}, {"SUBSTRING", "org.hsqldb.Library.substring"}, {"UCASE", "org.hsqldb.Library.ucase"}, {"LOWER", "org.hsqldb.Library.lcase"}, {"UPPER", "org.hsqldb.Library.ucase"}};
    static final String[][] sTimeDate = new String[][]{{"CURDATE", "org.hsqldb.Library.curdate"}, {"CURTIME", "org.hsqldb.Library.curtime"}, {"DAYNAME", "org.hsqldb.Library.dayname"}, {"DAY", "org.hsqldb.Library.dayofmonth"}, {"DAYOFMONTH", "org.hsqldb.Library.dayofmonth"}, {"DAYOFWEEK", "org.hsqldb.Library.dayofweek"}, {"DAYOFYEAR", "org.hsqldb.Library.dayofyear"}, {"HOUR", "org.hsqldb.Library.hour"}, {"MINUTE", "org.hsqldb.Library.minute"}, {"MONTH", "org.hsqldb.Library.month"}, {"MONTHNAME", "org.hsqldb.Library.monthname"}, {"NOW", "org.hsqldb.Library.now"}, {"QUARTER", "org.hsqldb.Library.quarter"}, {"SECOND", "org.hsqldb.Library.second"}, {"WEEK", "org.hsqldb.Library.week"}, {"YEAR", "org.hsqldb.Library.year"}};
    static final String[][] sSystem = new String[][]{{"DATABASE", "org.hsqldb.Library.database"}, {"USER", "org.hsqldb.Library.user"}, {"IDENTITY", "org.hsqldb.Library.identity"}};
    private static final Random rRandom = new Random();
    private static final double LOG10_FACTOR = 0.4342944819032518;
    static final int abs = 0;
    static final int ascii = 1;
    static final int bitand = 2;
    static final int bitor = 3;
    static final int character = 4;
    static final int concat = 5;
    static final int cot = 6;
    static final int curdate = 7;
    static final int curtime = 8;
    static final int database = 9;
    static final int dayname = 10;
    static final int dayofmonth = 11;
    static final int dayofweek = 12;
    static final int dayofyear = 13;
    static final int difference = 14;
    static final int getAutoCommit = 15;
    static final int getDatabaseMajorVersion = 16;
    static final int getDatabaseMinorVersion = 17;
    static final int getDatabaseProductName = 18;
    static final int getDatabaseProductVersion = 19;
    static final int hexToRaw = 20;
    static final int hour = 21;
    static final int identity = 22;
    static final int insert = 23;
    static final int isReadOnlyConnection = 24;
    static final int isReadOnlyDatabase = 25;
    static final int lcase = 26;
    static final int left = 27;
    static final int length = 28;
    static final int locate = 29;
    static final int log10 = 30;
    static final int ltrim = 31;
    static final int minute = 32;
    static final int mod = 33;
    static final int month = 34;
    static final int monthname = 35;
    static final int now = 36;
    static final int octetLength = 37;
    static final int pi = 38;
    static final int quarter = 39;
    static final int rand = 40;
    static final int rawToHex = 41;
    static final int repeat = 42;
    static final int replace = 43;
    static final int right = 44;
    static final int round = 45;
    static final int roundMagic = 46;
    static final int rtrim = 47;
    static final int second = 48;
    static final int sign = 49;
    static final int soundex = 50;
    static final int space = 51;
    static final int substring = 52;
    static final int truncate = 53;
    static final int ucase = 54;
    static final int user = 55;
    static final int week = 56;
    static final int year = 57;
    static final int isReadOnlyDatabaseFiles = 58;
    static final int day = 59;
    static final int position = 60;
    private static final IntValueHashMap functionMap = new IntValueHashMap(67);
    static final Double piValue = new Double(Library.pi());
    static final String prefix = "org.hsqldb.Library.";
    static final int prefixLength;

    static HashMap getAliasMap() {
        HashMap hashMap = new HashMap(83, 1.0f);
        Library.register(hashMap, sNumeric);
        Library.register(hashMap, sString);
        Library.register(hashMap, sTimeDate);
        Library.register(hashMap, sSystem);
        return hashMap;
    }

    private static void register(HashMap hashMap, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
    }

    public static synchronized double rand(Integer n) {
        if (n != null) {
            rRandom.setSeed(n.intValue());
        }
        return rRandom.nextDouble();
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double log10(double d) {
        return Library.roundMagic(Math.log(d) * 0.4342944819032518);
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d);
        int n = stringBuffer.length();
        if (n < 16) {
            return d;
        }
        char c = stringBuffer.charAt(n - 1);
        char c2 = stringBuffer.charAt(n - 2);
        char c3 = stringBuffer.charAt(n - 3);
        char c4 = stringBuffer.charAt(n - 4);
        if (c2 == '0' && c3 == '0' && c4 == '0' && c != '.') {
            stringBuffer.setCharAt(n - 1, '0');
        } else if (c2 == '9' && c3 == '9' && c4 == '9' && c != '.') {
            stringBuffer.setCharAt(n - 1, '9');
            stringBuffer.append('9');
            stringBuffer.append('9');
        }
        return Double.valueOf(stringBuffer.toString());
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static int mod(int n, int n2) {
        return n % n2;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double truncate(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = d * d2;
        return (d < 0.0 ? Math.ceil(d3) : Math.floor(d3)) / d2;
    }

    public static int bitand(int n, int n2) {
        return n & n2;
    }

    public static int bitor(int n, int n2) {
        return n | n2;
    }

    public static Integer ascii(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return ValuePool.getInt(string.charAt(0));
    }

    public static String character(int n) {
        return String.valueOf((char)n);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    public static int difference(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        string = Library.soundex(string);
        string2 = Library.soundex(string2);
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static String hexToRaw(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n % 4 != 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = (char)Integer.parseInt(string.substring(n2, n2 + 4), 16);
            stringBuffer.append(c);
            n2 += 4;
        }
        return stringBuffer.toString();
    }

    public static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    public static String lcase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        return string.substring(0, n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static Integer length(String string) {
        return string == null ? null : ValuePool.getInt(string.length());
    }

    public static Integer octetLength(String string) {
        return string == null ? null : ValuePool.getInt(string.length() * 2);
    }

    public static int locate(String string, String string2, Integer n) {
        if (string2 == null || string == null) {
            return 0;
        }
        int n2 = n == null ? 0 : n - 1;
        return string2.indexOf(string, n2 < 0 ? 0 : n2) + 1;
    }

    public static int position(String string, String string2) {
        return Library.locate(string, string2, null);
    }

    public static String ltrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n && string.charAt(n2) <= ' ') {
            ++n2;
        }
        return n2 == 0 ? string : string.substring(n2);
    }

    public static String rawToHex(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(4 * string.length());
        int n = 0;
        while (n < cArray.length) {
            String string2 = Integer.toHexString(cArray[n] & 0xFFFF);
            int n2 = string2.length();
            while (n2 < 4) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, Integer n) {
        if (string == null || n == null || n < 0) {
            return null;
        }
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer(string.length() * n2);
        while (n2-- > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string2.length();
        while (true) {
            int n3;
            if ((n3 = string.indexOf(string2, n)) == -1) break;
            stringBuffer.append(string.substring(n, n3));
            stringBuffer.append(string3);
            n = n3 + n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        n = string.length() - n;
        return string.substring(n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static String rtrim(String string) {
        int n;
        if (string == null) {
            return string;
        }
        int n2 = n = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2) == ' ') {
            --n2;
        }
        return n2 == n ? string : string.substring(0, n2 + 1);
    }

    public static String trim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length() - 1;
        while (n >= 0 && string.charAt(n) == ' ') {
            --n;
        }
        if (++n == 0) {
            return "";
        }
        int n2 = 0;
        while (n2 < n && string.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 == 0 && n == string.length()) {
            return string;
        }
        return string.substring(n2, n);
    }

    public static String soundex(String string) {
        if (string == null) {
            return string;
        }
        string = string.toUpperCase();
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < 4) {
            block19: {
                int n5;
                char c;
                block12: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block11: {
                                                c = string.charAt(n3);
                                                if ("AEIOUY".indexOf(c) == -1) break block11;
                                                n5 = 55;
                                                break block12;
                                            }
                                            if (c != 'H' && c != 'W') break block13;
                                            n5 = 56;
                                            break block12;
                                        }
                                        if ("BFPV".indexOf(c) == -1) break block14;
                                        n5 = 49;
                                        break block12;
                                    }
                                    if ("CGJKQSXZ".indexOf(c) == -1) break block15;
                                    n5 = 50;
                                    break block12;
                                }
                                if (c != 'D' && c != 'T') break block16;
                                n5 = 51;
                                break block12;
                            }
                            if (c != 'L') break block17;
                            n5 = 52;
                            break block12;
                        }
                        if (c != 'M' && c != 'N') break block18;
                        n5 = 53;
                        break block12;
                    }
                    if (c != 'R') break block19;
                    n5 = 54;
                }
                if (n4 == 0) {
                    cArray[n4++] = c;
                    n2 = n5;
                } else if (n5 <= 54) {
                    if (n5 != n2) {
                        cArray[n4++] = n5;
                        n2 = n5;
                    }
                } else if (n5 == 55) {
                    n2 = n5;
                }
            }
            ++n3;
        }
        return new String(cArray, 0, 4);
    }

    public static String space(int n) {
        if (n < 0) {
            return null;
        }
        char[] cArray = new char[n];
        while (n > 0) {
            cArray[--n] = 32;
        }
        return new String(cArray);
    }

    public static String substring(String string, int n, Integer n2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        n = --n > n3 ? n3 : n;
        int n4 = n3;
        if (n2 != null) {
            n4 = n2;
        }
        if (n + n4 > n3) {
            n4 = n3 - n;
        }
        return string.substring(n, n + n4);
    }

    public static String ucase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static java.sql.Date curdate() {
        return HsqlDateTime.getToday();
    }

    public static Time curtime() {
        return new Time(System.currentTimeMillis());
    }

    public static String dayname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
        return simpleDateFormat.format(date).toString();
    }

    static int getDateTimePart(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(n);
    }

    private static int getTimePart(Time time, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(time);
        return gregorianCalendar.get(n);
    }

    public static int dayofmonth(java.sql.Date date) {
        return Library.getDateTimePart(date, 5);
    }

    public static int dayofweek(java.sql.Date date) {
        return Library.getDateTimePart(date, 7);
    }

    public static int dayofyear(java.sql.Date date) {
        return Library.getDateTimePart(date, 6);
    }

    public static int hour(Time time) {
        return Library.getDateTimePart(time, 11);
    }

    public static int minute(Time time) {
        return Library.getDateTimePart(time, 12);
    }

    public static int month(java.sql.Date date) {
        return 0;
    }

    public static String monthname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM");
        return simpleDateFormat.format(date).toString();
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int quarter(java.sql.Date date) {
        return Library.getDateTimePart(date, 2) / 3 + 1;
    }

    public static int second(Time time) {
        return Library.getDateTimePart(time, 13);
    }

    public static int week(java.sql.Date date) {
        return Library.getDateTimePart(date, 3);
    }

    public static int year(java.sql.Date date) {
        return Library.getDateTimePart(date, 1);
    }

    public static String database(Connection connection) throws HsqlException {
        return null;
    }

    public static String user(Connection connection) throws HsqlException {
        return null;
    }

    public static int identity() throws HsqlException {
        return 0;
    }

    public static boolean getAutoCommit(Connection connection) {
        return false;
    }

    public static String getDatabaseProductName() {
        return "HSQL Database Engine";
    }

    public static String getDatabaseProductVersion() {
        return "1.7.2";
    }

    public static int getDatabaseMajorVersion() {
        return 1;
    }

    public static int getDatabaseMinorVersion() {
        return 7;
    }

    public static boolean isReadOnlyConnection(Connection connection) {
        return false;
    }

    public static boolean isReadOnlyDatabase(Connection connection) {
        return false;
    }

    public static boolean isReadOnlyDatabaseFiles(Connection connection) {
        return false;
    }

    static Object invoke(int n, Object[] objectArray) throws HsqlException {
        try {
            switch (n) {
                case 0: {
                    return new Double(Library.abs(((Number)objectArray[0]).doubleValue()));
                }
                case 1: {
                    return Library.ascii((String)objectArray[0]);
                }
                case 2: {
                    return ValuePool.getInt(Library.bitand(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 3: {
                    return ValuePool.getInt(Library.bitor(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 4: {
                    return Library.character(((Number)objectArray[0]).intValue());
                }
                case 5: {
                    return Library.concat((String)objectArray[0], (String)objectArray[1]);
                }
                case 6: {
                    return new Double(Library.cot(((Number)objectArray[0]).doubleValue()));
                }
                case 7: {
                    return Library.curdate();
                }
                case 8: {
                    return Library.curtime();
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return Library.dayname((java.sql.Date)objectArray[0]);
                }
                case 11: 
                case 59: {
                    return ValuePool.getInt(Library.dayofmonth((java.sql.Date)objectArray[0]));
                }
                case 12: {
                    return ValuePool.getInt(Library.dayofweek((java.sql.Date)objectArray[0]));
                }
                case 13: {
                    return ValuePool.getInt(Library.dayofyear((java.sql.Date)objectArray[0]));
                }
                case 14: {
                    return ValuePool.getInt(Library.difference((String)objectArray[0], (String)objectArray[1]));
                }
                case 15: {
                    return null;
                }
                case 16: {
                    return ValuePool.getInt(Library.getDatabaseMajorVersion());
                }
                case 17: {
                    return ValuePool.getInt(Library.getDatabaseMinorVersion());
                }
                case 18: {
                    return Library.getDatabaseProductName();
                }
                case 19: {
                    return Library.getDatabaseProductVersion();
                }
                case 20: {
                    return Library.hexToRaw((String)objectArray[0]);
                }
                case 21: {
                    return ValuePool.getInt(Library.hour((Time)objectArray[0]));
                }
                case 22: {
                    return null;
                }
                case 23: {
                    return Library.insert((String)objectArray[0], ((Number)objectArray[1]).intValue(), ((Number)objectArray[2]).intValue(), (String)objectArray[3]);
                }
                case 24: {
                    return null;
                }
                case 25: {
                    return null;
                }
                case 26: {
                    return Library.lcase((String)objectArray[0]);
                }
                case 27: {
                    return Library.left((String)objectArray[0], ((Number)objectArray[1]).intValue());
                }
                case 28: {
                    return Library.length((String)objectArray[0]);
                }
                case 29: {
                    return ValuePool.getInt(Library.locate((String)objectArray[0], (String)objectArray[1], (Integer)objectArray[2]));
                }
                case 30: {
                    return new Double(Library.log10(((Number)objectArray[0]).doubleValue()));
                }
                case 31: {
                    return Library.ltrim((String)objectArray[0]);
                }
                case 32: {
                    return ValuePool.getInt(Library.minute((Time)objectArray[0]));
                }
                case 33: {
                    return ValuePool.getInt(Library.mod(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 34: {
                    return ValuePool.getInt(Library.month((java.sql.Date)objectArray[0]));
                }
                case 35: {
                    return ValuePool.getString(Library.monthname((java.sql.Date)objectArray[0]));
                }
                case 36: {
                    return Library.now();
                }
                case 37: {
                    return Library.octetLength((String)objectArray[0]);
                }
                case 60: {
                    return ValuePool.getInt(Library.position((String)objectArray[0], (String)objectArray[1]));
                }
                case 38: {
                    return piValue;
                }
                case 39: {
                    return ValuePool.getInt(Library.quarter((java.sql.Date)objectArray[0]));
                }
                case 40: {
                    return new Double(Library.rand((Integer)objectArray[0]));
                }
                case 41: {
                    return Library.rawToHex((String)objectArray[0]);
                }
                case 42: {
                    return Library.repeat((String)objectArray[0], (Integer)objectArray[1]);
                }
                case 43: {
                    return Library.replace((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
                }
                case 44: {
                    return Library.right((String)objectArray[0], ((Number)objectArray[1]).intValue());
                }
                case 45: {
                    return new Double(Library.round(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).intValue()));
                }
                case 46: {
                    return new Double(Library.roundMagic(((Number)objectArray[0]).doubleValue()));
                }
                case 47: {
                    return Library.rtrim((String)objectArray[0]);
                }
                case 48: {
                    return ValuePool.getInt(Library.second((Time)objectArray[0]));
                }
                case 49: {
                    return ValuePool.getInt(Library.sign(((Number)objectArray[0]).doubleValue()));
                }
                case 50: {
                    return Library.soundex((String)objectArray[0]);
                }
                case 51: {
                    return Library.space(((Number)objectArray[0]).intValue());
                }
                case 52: {
                    return Library.substring((String)objectArray[0], ((Number)objectArray[1]).intValue(), (Integer)objectArray[2]);
                }
                case 53: {
                    return new Double(Library.truncate(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).intValue()));
                }
                case 54: {
                    return Library.ucase((String)objectArray[0]);
                }
                case 55: {
                    return null;
                }
                case 56: {
                    return ValuePool.getInt(Library.week((java.sql.Date)objectArray[0]));
                }
                case 57: {
                    return ValuePool.getInt(Library.year((java.sql.Date)objectArray[0]));
                }
                case 58: {
                    return null;
                }
            }
            throw Trace.error(20, "org.hsqldb.Library: fID: " + n);
        }
        catch (Exception exception) {
            throw Library.wrapException(exception);
        }
    }

    static HsqlException wrapException(Exception exception) {
        if (exception instanceof HsqlException) {
            return (HsqlException)exception;
        }
        return Trace.error(40, exception.toString());
    }

    static int functionID(String string) {
        return string.startsWith(prefix) ? functionMap.get((Object)string.substring(prefixLength), -1) : -1;
    }

    static {
        functionMap.put("abs", 0);
        functionMap.put("ascii", 1);
        functionMap.put("bitand", 2);
        functionMap.put("bitor", 3);
        functionMap.put("character", 4);
        functionMap.put("concat", 5);
        functionMap.put("cot", 6);
        functionMap.put("curdate", 7);
        functionMap.put("curtime", 8);
        functionMap.put("database", 9);
        functionMap.put("dayname", 10);
        functionMap.put("day", 59);
        functionMap.put("dayofmonth", 11);
        functionMap.put("dayofweek", 12);
        functionMap.put("dayofyear", 13);
        functionMap.put("difference", 14);
        functionMap.put("getAutoCommit", 15);
        functionMap.put("getDatabaseMajorVersion", 16);
        functionMap.put("getDatabaseMinorVersion", 17);
        functionMap.put("getDatabaseProductName", 18);
        functionMap.put("getDatabaseProductVersion", 19);
        functionMap.put("hexToRaw", 20);
        functionMap.put("hour", 21);
        functionMap.put("identity", 22);
        functionMap.put("insert", 23);
        functionMap.put("isReadOnlyConnection", 24);
        functionMap.put("isReadOnlyDatabase", 25);
        functionMap.put("lcase", 26);
        functionMap.put("left", 27);
        functionMap.put("length", 28);
        functionMap.put("locate", 29);
        functionMap.put("log10", 30);
        functionMap.put("ltrim", 31);
        functionMap.put("minute", 32);
        functionMap.put("mod", 33);
        functionMap.put("month", 34);
        functionMap.put("monthname", 35);
        functionMap.put("now", 36);
        functionMap.put("octetLength", 37);
        functionMap.put("pi", 38);
        functionMap.put("position", 60);
        functionMap.put("quarter", 39);
        functionMap.put("rand", 40);
        functionMap.put("rawToHex", 41);
        functionMap.put("repeat", 42);
        functionMap.put("replace", 43);
        functionMap.put("right", 44);
        functionMap.put("round", 45);
        functionMap.put("roundMagic", 46);
        functionMap.put("rtrim", 47);
        functionMap.put("second", 48);
        functionMap.put("sign", 49);
        functionMap.put("soundex", 50);
        functionMap.put("space", 51);
        functionMap.put("substring", 52);
        functionMap.put("truncate", 53);
        functionMap.put("ucase", 54);
        functionMap.put("user", 55);
        functionMap.put("week", 56);
        functionMap.put("year", 57);
        functionMap.put("isReadOnlyDatabaseFiles", 58);
        prefixLength = prefix.length();
    }
}

