/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.URL;
import org.hsqldb.Cache;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.LockFile;
import org.hsqldb.Log;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Logger {
    Log lLog;
    LockFile lf;

    Logger() {
    }

    void openLog(Database database) throws HsqlException {
        String string = database.getPath();
        if (database.isFilesInJar()) {
            this.checkFilesInJar(string);
        } else {
            this.acquireLock(string);
        }
        this.lLog = new Log(database, string);
        this.lLog.open();
    }

    boolean closeLog(int n) {
        if (this.lLog == null) {
            return true;
        }
        try {
            this.lLog.stop();
            switch (n) {
                case -1: {
                    this.lLog.shutdown();
                    break;
                }
                case 0: {
                    this.lLog.close(false, true);
                    break;
                }
                case 1: 
                case 2: {
                    this.lLog.close(true, true);
                }
            }
        }
        catch (Throwable throwable) {
            this.lLog = null;
            return false;
        }
        this.lLog = null;
        return true;
    }

    boolean hasLog() {
        return this.lLog != null;
    }

    Cache getCache() throws HsqlException {
        if (this.lLog != null) {
            return this.lLog.getCache();
        }
        return null;
    }

    void logConnectUser(Session session, String string, String string2) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.write(session, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
        }
    }

    void writeToLog(Session session, String string) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.write(session, string);
        }
    }

    void writeToLog(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeRow(session, table, objectArray);
        }
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.writeDeleteStatement(session, table, objectArray);
        }
    }

    void checkpoint(boolean bl) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.checkpoint(bl);
        }
    }

    void setLogSize(int n) {
        if (this.lLog != null) {
            this.lLog.setLogSize(n);
        }
    }

    void setScriptType(int n) throws HsqlException {
        if (this.lLog != null) {
            this.lLog.setScriptType(n);
        }
    }

    void setWriteDelay(int n) {
        if (this.lLog != null) {
            this.lLog.setWriteDelay(n);
        }
    }

    Cache openTextCache(HsqlNameManager.HsqlName hsqlName, String string, boolean bl, boolean bl2) throws HsqlException {
        return this.lLog.openTextCache(hsqlName, string, bl, bl2);
    }

    void closeTextCache(HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        this.lLog.closeTextCache(hsqlName);
    }

    void acquireLock(String string) throws HsqlException {
        if (this.lf != null) {
            return;
        }
        this.lf = LockFile.newLockFile(string + ".lck");
        boolean bl = false;
        String string2 = "";
        try {
            bl = this.lf.tryLock();
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        if (!bl) {
            throw Trace.error(1, this.lf + ": " + string2);
        }
    }

    void releaseLock() {
        block3: {
            try {
                if (this.lf != null) {
                    this.lf.tryRelease();
                }
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block3;
                Trace.printSystemOut(exception.toString());
            }
        }
        this.lf = null;
    }

    private void checkFilesInJar(String string) throws HsqlException {
        Trace.check(string != null, 29, "path is null");
        String string2 = string + ".script";
        URL uRL = this.getClass().getResource(string2);
        Trace.check(uRL != null, 29, string2, " does not exist");
        Trace.check("jar".equalsIgnoreCase(uRL.getProtocol()), 33, "wrong resource protocol: ", uRL.getProtocol());
    }
}

