/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Stack;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.View;
import org.hsqldb.lib.HsqlArrayHeap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlStringBuffer;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

class Parser {
    private Database database;
    private Tokenizer tokenizer;
    private Session session;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;
    private static IntValueHashMap tokenSet = new IntValueHashMap(37);
    HsqlArrayList parameters = new HsqlArrayList();
    private static final Expression[] noParameters;
    private static final SubQuery[] noSubqueries;
    private int subQueryLevel = 0;
    private Stack subQueryStack;
    private HsqlArrayHeap subQueryHeap;
    private static final String pamsg = "It is ambiguous to specify a parameter marker ";

    Parser(Database database, Tokenizer tokenizer, Session session) {
        this.database = database;
        this.tokenizer = tokenizer;
        this.session = session;
    }

    void checkTableWriteAccess(Table table, int n) throws HsqlException {
        this.session.checkReadWrite();
        this.session.check(table.getName(), n);
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    HsqlArrayList getColumnNames() throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        int n = 0;
        do {
            hsqlArrayList.add(this.tokenizer.getString());
            this.tokenizer.checkUnexpectedParam("parametric column identifier");
            ++n;
        } while ((string = this.tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hsqlArrayList;
    }

    void getColumnValues(Table table, Object[] objectArray, int[] nArray, int n) throws HsqlException {
        boolean bl = false;
        int n2 = 0;
        int[] nArray2 = table.getColumnTypes();
        this.tokenizer.getThis("(");
        while (n2 < n) {
            int n3 = nArray[n2];
            objectArray[n3] = this.getValue(nArray2[n3]);
            String string = this.tokenizer.getString();
            if (!string.equals(",")) {
                if (string.equals(")")) {
                    bl = true;
                    break;
                }
                throw Trace.error(11, string);
            }
            ++n2;
        }
        if (!bl || n2 != n - 1) {
            throw Trace.error(5);
        }
    }

    SubQuery parseSubquery(boolean bl) throws HsqlException {
        if (this.subQueryHeap == null) {
            this.subQueryHeap = new HsqlArrayHeap(8, new SubQuery());
        }
        if (this.subQueryStack == null) {
            this.subQueryStack = new Stack();
        }
        ++this.subQueryLevel;
        HsqlException hsqlException = null;
        Select select = null;
        SubQuery subQuery = new SubQuery();
        subQuery.level = this.subQueryLevel;
        subQuery.isView = bl;
        this.subQueryStack.push(subQuery);
        try {
            select = this.parseSelect();
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        if (hsqlException != null) {
            throw hsqlException;
        }
        this.subQueryStack.pop();
        subQuery.select = select;
        this.subQueryHeap.add(subQuery);
        --this.subQueryLevel;
        return subQuery;
    }

    Select parseSelect() throws HsqlException {
        Expression expression;
        Object object;
        Object object2;
        Select select = new Select();
        String string = this.tokenizer.getString();
        if (string.equals("LIMIT")) {
            object2 = this.tokenizer.getString();
            object = this.tokenizer.getString();
            try {
                select.limitStart = Integer.parseInt((String)object2);
                select.limitCount = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(16, "LIMIT n m");
            }
            string = this.tokenizer.getString();
        } else if (string.equals("TOP")) {
            object2 = this.tokenizer.getString();
            try {
                select.limitStart = 0;
                select.limitCount = Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(16, "TOP m");
            }
            string = this.tokenizer.getString();
        }
        if (string.equals("DISTINCT")) {
            select.isDistinctSelect = true;
        } else {
            this.tokenizer.back();
        }
        object2 = new HsqlArrayList();
        do {
            Parser.checkParamAmbiguity(!((Expression)(object = this.parseExpression())).isParam(), "as a SELECT list item");
            string = this.tokenizer.getString();
            if (string.equals("AS")) {
                ((Expression)object).setAlias(this.tokenizer.getName(), this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            } else if (this.tokenizer.wasName()) {
                ((Expression)object).setAlias(string, this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            }
            ((HsqlArrayList)object2).add(object);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            string = this.tokenizer.getString();
            if (string.equals("CACHED")) {
                select.intoType = 3;
                select.sIntoTable = this.database.nameManager.newHsqlName(this.tokenizer.getString(), this.tokenizer.wasQuotedIdentifier());
            } else if (string.equals("TEMP")) {
                select.intoType = 1;
                select.sIntoTable = this.database.nameManager.newHsqlName(this.tokenizer.getString(), this.tokenizer.wasQuotedIdentifier());
            } else if (string.equals("TEXT")) {
                select.intoType = 5;
                select.sIntoTable = this.database.nameManager.newHsqlName(this.tokenizer.getString(), this.tokenizer.wasQuotedIdentifier());
            } else {
                select.sIntoTable = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
            }
            this.tokenizer.checkUnexpectedParam("parametric table identifier");
            string = this.tokenizer.getString();
        }
        if (!string.equals("FROM")) {
            throw Trace.error(11, string);
        }
        object = null;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        hsqlArrayList.add(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tokenizer.getString()).equals("LEFT")) {
                string = this.tokenizer.getString();
                if (string.equals("OUTER")) {
                    string = this.tokenizer.getString();
                }
                Trace.check(string.equals("JOIN"), 11, string);
                hsqlArrayList.add(this.parseTableFilter(true));
                this.tokenizer.getThis("ON");
                object = this.addConditionOuter((Expression)object, this.parseExpression());
                continue;
            }
            if (string.equals("INNER")) {
                this.tokenizer.getThis("JOIN");
                hsqlArrayList.add(this.parseTableFilter(false));
                this.tokenizer.getThis("ON");
                object = this.addCondition((Expression)object, this.parseExpression());
                continue;
            }
            if (string.equals("JOIN")) {
                hsqlArrayList.add(this.parseTableFilter(false));
                this.tokenizer.getThis("ON");
                object = this.addCondition((Expression)object, this.parseExpression());
                continue;
            }
            if (!string.equals(",")) break;
            hsqlArrayList.add(this.parseTableFilter(false));
        }
        this.tokenizer.back();
        int n = hsqlArrayList.size();
        TableFilter[] tableFilterArray = new TableFilter[n];
        hsqlArrayList.toArray(tableFilterArray);
        select.tFilter = tableFilterArray;
        n = ((HsqlArrayList)object2).size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            expression = (Expression)((HsqlArrayList)object2).get(n2);
            if (expression.getType() == 6) {
                n3 = n2;
                Table table = null;
                String string2 = expression.getTableName();
                int n4 = 0;
                while (n4 < tableFilterArray.length) {
                    TableFilter tableFilter = tableFilterArray[n4];
                    expression.resolve(tableFilter);
                    if (string2 == null || string2.equals(tableFilter.getName())) {
                        table = tableFilter.getTable();
                        int n5 = table.getColumnCount();
                        int n6 = 0;
                        while (n6 < n5) {
                            Expression expression2 = new Expression(tableFilter.getName(), table.getColumn(n6));
                            ((HsqlArrayList)object2).add(n3++, expression2);
                            ++n;
                            ++n6;
                        }
                    }
                    ++n4;
                }
                Trace.check(table != null, 22, string2);
                --n;
                ((HsqlArrayList)object2).remove(n3);
            } else if (expression.getType() == 2 && expression.getTableName() == null) {
                n3 = 0;
                while (n3 < tableFilterArray.length) {
                    expression.resolve(tableFilterArray[n3]);
                    ++n3;
                }
            }
            ++n2;
        }
        select.iResultLen = n;
        string = this.tokenizer.getString();
        if (string.equals("WHERE")) {
            object = this.addCondition((Expression)object, this.parseExpression());
            string = this.tokenizer.getString();
        }
        select.eCondition = object;
        if (string.equals("GROUP")) {
            this.tokenizer.getThis("BY");
            n = 0;
            do {
                Parser.checkParamAmbiguity(!(expression = this.parseExpression()).isParam(), "as a GROUP BY list item");
                ((HsqlArrayList)object2).add(expression);
                string = this.tokenizer.getString();
                ++n;
            } while (string.equals(","));
            select.iGroupLen = n;
        }
        if (string.equals("HAVING")) {
            select.iHavingIndex = ((HsqlArrayList)object2).size();
            select.havingCondition = this.parseExpression();
            string = this.tokenizer.getString();
            ((HsqlArrayList)object2).add(select.havingCondition);
        }
        if (string.equals("ORDER")) {
            this.tokenizer.getThis("BY");
            n = 0;
            do {
                Parser.checkParamAmbiguity(!(expression = this.parseExpression()).isParam(), "as an ORDER BY list item");
                expression = Parser.checkOrderByColumns(expression, (HsqlArrayList)object2);
                string = this.tokenizer.getString();
                if (string.equals("DESC")) {
                    expression.setDescending();
                    string = this.tokenizer.getString();
                } else if (string.equals("ASC")) {
                    string = this.tokenizer.getString();
                }
                ((HsqlArrayList)object2).add(expression);
                ++n;
            } while (string.equals(","));
            select.iOrderLen = n;
        }
        n = ((HsqlArrayList)object2).size();
        select.eColumn = new Expression[n];
        ((HsqlArrayList)object2).toArray(select.eColumn);
        if (string.equals("UNION")) {
            string = this.tokenizer.getString();
            if (string.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tokenizer.back();
            }
            this.tokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (string.equals("INTERSECT")) {
            this.tokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (string.equals("EXCEPT") || string.equals("MINUS")) {
            this.tokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tokenizer.back();
        }
        return select;
    }

    private static Expression checkOrderByColumns(Expression expression, HsqlArrayList hsqlArrayList) throws HsqlException {
        if (expression.getType() == 1) {
            if (expression.getDataType() == 4) {
                int n = (Integer)expression.getValue();
                expression = (Expression)hsqlArrayList.get(n - 1);
            }
        } else if (expression.getType() == 2 && expression.getTableName() == null) {
            String string = expression.getColumnName();
            int n = 0;
            int n2 = hsqlArrayList.size();
            while (n < n2) {
                Expression expression2 = (Expression)hsqlArrayList.get(n);
                if (string.equals(expression2.getDefinedAlias())) {
                    expression = expression2;
                    break;
                }
                ++n;
            }
        }
        return expression;
    }

    private TableFilter parseTableFilter(boolean bl) throws HsqlException {
        String string = this.tokenizer.getString();
        Table table = null;
        Select select = null;
        if (string.equals("(")) {
            this.tokenizer.getThis("SELECT");
            SubQuery subQuery = this.parseSubquery(false);
            this.tokenizer.getThis(")");
            select = subQuery.select;
            select.resolveAll();
            subQuery.table = table = new Table(this.database, this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false), 0, 0);
            table.addColumns(select);
            table.createPrimaryKey();
        } else {
            boolean bl2;
            this.tokenizer.checkUnexpectedParam("parametric table identifier");
            table = this.database.getTable(string, this.session);
            boolean bl3 = bl2 = !this.isParsingView();
            if (bl2) {
                this.session.check(table.getName(), 1);
            }
            if (table.isView()) {
                String string2 = string;
                int n = this.tokenizer.getPosition();
                int n2 = this.tokenizer.getLength();
                int n3 = string.length();
                int n4 = n;
                string = this.tokenizer.getString();
                if (string.equals("AS")) {
                    string2 = this.tokenizer.getName();
                    n4 = this.tokenizer.getPosition();
                } else if (this.tokenizer.wasName()) {
                    string2 = string;
                    n4 = this.tokenizer.getPosition();
                } else {
                    this.tokenizer.back();
                }
                String string3 = this.tokenizer.getPart(0, n - n3);
                String string4 = this.tokenizer.getPart(n4, n2);
                View view = (View)table;
                String string5 = view.getStatement();
                HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(128);
                hsqlStringBuffer.append(string3);
                hsqlStringBuffer.append('(');
                hsqlStringBuffer.append(string5);
                hsqlStringBuffer.append(") ");
                hsqlStringBuffer.append(string2);
                hsqlStringBuffer.append(string4);
                this.tokenizer.setString(hsqlStringBuffer.toString(), n - n3 + 1);
                this.tokenizer.getThis("SELECT");
                SubQuery subQuery = this.parseSubquery(true);
                this.tokenizer.getThis(")");
                select = subQuery.select;
                select.resolveAll();
                subQuery.table = table = new Table(this.database, this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false), 0, 0);
                table.addColumns(select);
                table.createPrimaryKey();
            }
        }
        String string6 = null;
        string = this.tokenizer.getString();
        if (string.equals("LEFT")) {
            this.tokenizer.back();
        } else if (string.equals("AS")) {
            string6 = this.tokenizer.getName();
        } else if (this.tokenizer.wasName()) {
            string6 = string;
        } else {
            this.tokenizer.back();
        }
        TableFilter tableFilter = new TableFilter(table, string6, bl);
        tableFilter.sSelect = select;
        return tableFilter;
    }

    private Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private Expression addConditionOuter(Expression expression, Expression expression2) throws HsqlException {
        if (!expression2.setForOuterJoin()) {
            throw Trace.error(64);
        }
        return this.addCondition(expression, expression2);
    }

    private Object getValue(int n) throws HsqlException {
        int n2 = this.parameters.size();
        Expression expression = this.parseExpression();
        Trace.doAssert(n2 == this.parameters.size(), "expression has unbound parameters");
        expression.resolve(null);
        return expression.getValue(n);
    }

    private Expression parseExpression() throws HsqlException {
        this.read();
        Expression expression = this.readOr();
        this.tokenizer.back();
        return expression;
    }

    private Expression readAggregate() throws HsqlException {
        boolean bl = false;
        int n = this.iToken;
        this.read();
        if (this.tokenizer.getString().equals("DISTINCT")) {
            bl = true;
        } else {
            this.tokenizer.back();
        }
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(102);
        Expression expression2 = new Expression(n, expression, null);
        expression2.setDistinctAggregate(bl);
        return expression2;
    }

    private Expression readOr() throws HsqlException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws HsqlException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws HsqlException {
        switch (this.iToken) {
            case 20: {
                int n = this.iToken;
                this.read();
                return new Expression(n, this.readCondition(), null);
            }
            case 31: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                Trace.check(this.iToken == 103, 11);
                Expression expression = new Expression(this.parseSelect());
                this.read();
                this.readThis(102);
                return new Expression(n, expression, null);
            }
        }
        Expression expression = this.readConcat();
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        switch (this.iToken) {
            case 27: {
                this.read();
                Expression expression2 = this.readConcat();
                char c = '\u0000';
                if (this.sToken.equals("ESCAPE")) {
                    this.read();
                    Expression expression3 = this.readTerm();
                    Trace.check(expression3.getType() == 1, 7);
                    String string = (String)expression3.getValue(12);
                    if (string == null || string.length() < 1) {
                        throw Trace.error(7, string);
                    }
                    c = string.charAt(0);
                }
                expression = new Expression(27, expression, expression2);
                expression.setLikeEscape(c);
                break;
            }
            case 106: {
                this.read();
                Expression expression4 = new Expression(22, expression, this.readConcat());
                this.readThis(28);
                Expression expression5 = new Expression(25, expression, this.readConcat());
                Parser.checkParamAmbiguity(!expression4.getArg().isParam() || !expression4.getArg2().isParam(), "for both the first and second operands of a BETWEEN comparison predicate");
                Parser.checkParamAmbiguity(!expression5.getArg().isParam() || !expression5.getArg2().isParam(), "for both the first and third operands of a BETWEEN comparison predicate");
                expression = new Expression(28, expression4, expression5);
                break;
            }
            case 30: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                Expression expression6 = null;
                if (this.iToken == 103) {
                    expression6 = new Expression(this.parseSelect());
                    this.read();
                } else {
                    this.tokenizer.back();
                    HsqlArrayList hsqlArrayList = new HsqlArrayList();
                    do {
                        this.tokenizer.checkUnexpectedParam("parametric IN list item");
                        Object object = this.getValue(12);
                        if (object == null) {
                            throw Trace.error(79);
                        }
                        hsqlArrayList.add(object);
                        this.read();
                    } while (this.iToken == 104);
                    expression6 = new Expression(hsqlArrayList);
                }
                this.readThis(102);
                expression = new Expression(n, expression, expression6);
                break;
            }
            default: {
                Trace.check(!bl, 11);
                if (Expression.isCompare(this.iToken)) {
                    int n = this.iToken;
                    this.read();
                    return new Expression(n, expression, this.readConcat());
                }
                return expression;
            }
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private void readThis(int n) throws HsqlException {
        Trace.check(this.iToken == n, 11);
        this.read();
    }

    private Expression readConcat() throws HsqlException {
        Expression expression = this.readSum();
        while (this.iToken == 105) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws HsqlException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 11;
            } else {
                if (this.iToken != 10) break;
                n = 12;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws HsqlException {
        Expression expression = this.readTerm();
        while (this.iToken == 13 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws HsqlException {
        Expression expression = null;
        switch (this.iToken) {
            case 2: {
                String string = this.sToken;
                expression = new Expression(this.sTable, this.sToken);
                this.read();
                if (this.iToken != 101) break;
                boolean bl = !this.isParsingView();
                Function function = new Function(this.database.getAlias(string), this.session, bl);
                int n = function.getArgCount();
                int n2 = 0;
                this.read();
                if (this.iToken != 102) {
                    while (true) {
                        function.setArgument(n2++, this.readOr());
                        if (this.iToken != 104) break;
                        this.read();
                    }
                }
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 10: {
                int n = this.iToken;
                this.read();
                expression = new Expression(n, this.readTerm(), null);
                Parser.checkParamAmbiguity(!expression.getArg().isParam(), "as the operand of a unary \u0096 operation");
                break;
            }
            case 100: {
                this.read();
                expression = this.readTerm();
                Parser.checkParamAmbiguity(!expression.isParam(), "as the operand of a unary + operation");
                break;
            }
            case 101: {
                this.read();
                expression = this.readOr();
                if (this.iToken != 102) {
                    throw Trace.error(11, this.sToken);
                }
                this.read();
                break;
            }
            case 1: {
                expression = new Expression(this.iType, this.oData);
                this.read();
                break;
            }
            case 8: {
                expression = new Expression(0, null, true);
                this.parameters.add(expression);
                if (this.subQueryStack != null && !this.subQueryStack.isEmpty()) {
                    SubQuery subQuery = (SubQuery)this.subQueryStack.peek();
                    subQuery.hasParams = true;
                }
                this.read();
                break;
            }
            case 103: {
                expression = new Expression(this.parseSelect());
                this.read();
                break;
            }
            case 13: {
                expression = new Expression(this.sTable, (String)null);
                this.read();
                break;
            }
            case 15: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                expression = new Expression(n, expression, this.readOr());
                this.readThis(102);
                break;
            }
            case 62: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                Expression expression2 = this.readOr();
                this.readThis(104);
                expression2 = new Expression(n, expression2, this.readOr());
                expression = new Expression(n, expression, expression2);
                this.readThis(102);
                break;
            }
            case 68: {
                Expression expression3;
                int n = 62;
                this.read();
                if (this.iToken == 110) {
                    this.readThis(110);
                    expression = this.readOr();
                } else {
                    expression = this.readOr();
                    this.readThis(110);
                    expression = new Expression(21, expression, this.readOr());
                }
                this.readThis(111);
                Expression expression4 = this.readOr();
                if (this.iToken == 112) {
                    this.readThis(112);
                    expression3 = this.readOr();
                } else {
                    expression3 = new Expression(0, null);
                }
                this.readThis(113);
                expression4 = new Expression(n, expression4, expression3);
                expression = new Expression(n, expression, expression4);
                break;
            }
            case 67: {
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                Expression expression5 = new Expression(62, new Expression(0, null), expression);
                expression = new Expression(21, expression, this.readOr());
                expression = new Expression(62, expression, expression5);
                this.readThis(102);
                break;
            }
            case 60: 
            case 69: {
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                Expression expression6 = new Expression(62, this.readOr(), expression);
                expression = new Expression(21, expression, new Expression(0, null));
                expression = new Expression(62, expression, expression6);
                this.readThis(102);
                break;
            }
            case 61: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                int n3 = Types.getTypeNr(this.sToken);
                int n4 = 0;
                int n5 = 0;
                if (Types.acceptsPrecisionCreateParam(n3) && this.tokenizer.isGetThis("(")) {
                    n4 = this.tokenizer.getInt();
                    if (Types.acceptsScaleCreateParam(n3) && this.tokenizer.isGetThis(",")) {
                        n5 = this.tokenizer.getInt();
                    }
                    this.tokenizer.getThis(")");
                }
                if (expression.isParam()) {
                    expression.setDataType(n3);
                }
                expression = new Expression(n, expression, null);
                expression.setDataType(n3);
                this.read();
                this.readThis(102);
                break;
            }
            case 107: {
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(122);
                int n = Types.getTypeNr(this.sToken);
                int n6 = 0;
                int n7 = 0;
                if (Types.acceptsPrecisionCreateParam(n) && this.tokenizer.isGetThis("(")) {
                    n6 = this.tokenizer.getInt();
                    if (Types.acceptsScaleCreateParam(n) && this.tokenizer.isGetThis(",")) {
                        n7 = this.tokenizer.getInt();
                    }
                    this.tokenizer.getThis(")");
                }
                if (expression.isParam()) {
                    expression.setDataType(n);
                }
                expression = new Expression(61, expression, null);
                expression.setDataType(n);
                this.read();
                this.readThis(102);
                break;
            }
            case 63: {
                this.read();
                this.readThis(101);
                String string = this.sToken;
                if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(string)) {
                    throw Trace.error(11, this.sToken);
                }
                this.readToken();
                this.readThis(124);
                Function function = new Function(this.database.getAlias(string), this.session, false);
                function.setArgument(0, this.readOr());
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 65: {
                this.read();
                this.readThis(101);
                String string = this.sToken;
                if (Expression.SQL_TRIM_SPECIFICATION.contains(string)) {
                    this.read();
                } else {
                    string = "BOTH";
                }
                this.readThis(124);
                String string2 = string.equals("LEADING") ? "org.hsqldb.Library.ltrim" : (string.equals("TRAILING") ? "org.hsqldb.Library.rtrim" : "org.hsqldb.Library.trim");
                Function function = new Function(string2, this.session, false);
                function.setArgument(0, this.readOr());
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 64: {
                this.read();
                this.readThis(101);
                Function function = new Function("org.hsqldb.Library.position", this.session, false);
                function.setArgument(0, this.readTerm());
                this.readThis(30);
                function.setArgument(1, this.readOr());
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 66: {
                boolean bl = false;
                this.read();
                this.readThis(101);
                Function function = new Function("org.hsqldb.Library.substring", this.session, false);
                function.setArgument(0, this.readTerm());
                if (this.iToken == 124) {
                    this.readThis(124);
                } else {
                    this.readThis(104);
                    bl = true;
                }
                function.setArgument(1, this.readOr());
                Expression expression7 = null;
                if (!bl && this.iToken == 123) {
                    this.readThis(123);
                    expression7 = this.readTerm();
                } else if (bl && this.iToken == 104) {
                    this.readThis(104);
                    expression7 = this.readTerm();
                }
                function.setArgument(2, expression7);
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            default: {
                if (Expression.isAggregate(this.iToken)) {
                    expression = this.readAggregate();
                    break;
                }
                throw Trace.error(11, this.sToken);
            }
        }
        return expression;
    }

    private void read() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        if (this.tokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tokenizer.getAsValue();
            this.iType = this.tokenizer.getType();
        } else if (this.tokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tokenizer.wasLongName()) {
            this.sTable = this.tokenizer.getLongNameFirst();
            this.iToken = this.sToken.equals("*") ? 13 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else {
            this.iToken = tokenSet.get((Object)this.sToken, -1);
            if (this.iToken == -1) {
                this.iToken = 108;
            }
            switch (this.iToken) {
                case 8: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case 13: {
                    this.sTable = null;
                    break;
                }
                case 109: {
                    this.sToken = this.tokenizer.getString();
                    if (this.sToken.equals("NOT")) {
                        this.iToken = 26;
                        break;
                    }
                    this.iToken = 21;
                    this.tokenizer.back();
                    break;
                }
                default: {
                    this.iToken = 108;
                }
            }
        }
    }

    private void readToken() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.iToken = tokenSet.get((Object)this.sToken, -1);
    }

    Expression[] getParameters() {
        return this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
    }

    void clearParameters() {
        this.parameters.clear();
    }

    SubQuery[] getSubqueries() {
        if (this.subQueryHeap == null) {
            return noSubqueries;
        }
        int n = this.subQueryHeap.size();
        if (n == 0) {
            return noSubqueries;
        }
        SubQuery[] subQueryArray = new SubQuery[n];
        int n2 = 0;
        while (n2 < n) {
            subQueryArray[n2] = (SubQuery)this.subQueryHeap.remove();
            ++n2;
        }
        this.subQueryLevel = 0;
        return subQueryArray;
    }

    CompiledStatement compileStatement(CompiledStatement compiledStatement) throws HsqlException {
        String string = this.tokenizer.getString();
        int n = Token.get(string);
        switch (n) {
            case 6: {
                return this.compileCallStatement(compiledStatement);
            }
            case 13: {
                return this.compileDeleteStatement(compiledStatement);
            }
            case 21: {
                return this.compileInsertStatement(compiledStatement);
            }
            case 48: {
                return this.compileUpdateStatement(compiledStatement);
            }
            case 39: {
                return this.compileSelectStatement(compiledStatement);
            }
        }
        throw Trace.error(11, string);
    }

    CompiledStatement compileCallStatement(CompiledStatement compiledStatement) throws HsqlException {
        this.clearParameters();
        Expression expression = this.parseExpression();
        if (compiledStatement == null) {
            compiledStatement = new CompiledStatement();
        }
        compiledStatement.setAsCall(expression, this.getParameters());
        compiledStatement.subqueries = this.getSubqueries();
        return compiledStatement;
    }

    CompiledStatement compileDeleteStatement(CompiledStatement compiledStatement) throws HsqlException {
        this.clearParameters();
        this.tokenizer.getThis("FROM");
        String string = this.tokenizer.getString();
        this.tokenizer.checkUnexpectedParam("parametric table specificiation");
        Table table = this.database.getTable(string, this.session);
        this.checkTableWriteAccess(table, 2);
        string = this.tokenizer.getString();
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        if (compiledStatement == null) {
            compiledStatement = new CompiledStatement();
        }
        compiledStatement.setAsDelete(table, expression, this.getParameters());
        compiledStatement.subqueries = this.getSubqueries();
        return compiledStatement;
    }

    void getColumnValueExpressions(Table table, Expression[] expressionArray, int n) throws HsqlException {
        boolean bl = false;
        int n2 = 0;
        this.tokenizer.getThis("(");
        while (n2 < n) {
            Expression expression = this.parseExpression();
            expression.resolve(null);
            expressionArray[n2] = expression;
            String string = this.tokenizer.getString();
            if (!string.equals(",")) {
                if (string.equals(")")) {
                    bl = true;
                    break;
                }
                throw Trace.error(11, string);
            }
            ++n2;
        }
        if (!bl || n2 != n - 1) {
            throw Trace.error(5);
        }
    }

    CompiledStatement compileInsertStatement(CompiledStatement compiledStatement) throws HsqlException {
        this.clearParameters();
        this.tokenizer.getThis("INTO");
        String string = this.tokenizer.getString();
        this.tokenizer.checkUnexpectedParam("parametric table specificiation");
        Table table = this.database.getTable(string, this.session);
        this.checkTableWriteAccess(table, 4);
        string = this.tokenizer.getString();
        HsqlArrayList hsqlArrayList = null;
        boolean[] blArray = null;
        int[] nArray = table.getColumnMap();
        int n = table.getColumnCount();
        if (string.equals("(")) {
            hsqlArrayList = this.getColumnNames();
            if (hsqlArrayList.size() > n) {
                throw Trace.error(5);
            }
            n = hsqlArrayList.size();
            blArray = table.getNewColumnCheckList();
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                nArray[n2] = n3 = table.getColumnNr((String)hsqlArrayList.get(n2));
                blArray[n3] = true;
                ++n2;
            }
            string = this.tokenizer.getString();
        }
        if (string.equals("VALUES")) {
            Expression[] expressionArray = new Expression[n];
            this.getColumnValueExpressions(table, expressionArray, n);
            if (compiledStatement == null) {
                compiledStatement = new CompiledStatement();
            }
            compiledStatement.setAsInsertValues(table, nArray, expressionArray, blArray, this.getParameters());
            compiledStatement.subqueries = this.getSubqueries();
            return compiledStatement;
        }
        if (string.equals("SELECT")) {
            Select select = this.parseSelect();
            if (compiledStatement == null) {
                compiledStatement = new CompiledStatement();
            }
            compiledStatement.setAsInsertSelect(table, nArray, blArray, select, this.getParameters());
            compiledStatement.subqueries = this.getSubqueries();
            return compiledStatement;
        }
        throw Trace.error(11, string);
    }

    CompiledStatement compileSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        this.clearParameters();
        Select select = this.parseSelect();
        if (compiledStatement == null) {
            compiledStatement = new CompiledStatement();
        }
        compiledStatement.setAsSelect(select, this.getParameters());
        compiledStatement.subqueries = this.getSubqueries();
        return compiledStatement;
    }

    CompiledStatement compileUpdateStatement(CompiledStatement compiledStatement) throws HsqlException {
        int n;
        this.clearParameters();
        String string = this.tokenizer.getString();
        this.tokenizer.checkUnexpectedParam("parametric table identifier");
        Table table = this.database.getTable(string, this.session);
        this.checkTableWriteAccess(table, 8);
        this.tokenizer.getThis("SET");
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        int n2 = 0;
        string = null;
        do {
            ++n2;
            n = table.getColumnNr(this.tokenizer.getString());
            hsqlArrayList.add(ValuePool.getInt(n));
            this.tokenizer.getThis("=");
            Expression expression = this.parseExpression();
            hsqlArrayList2.add(expression);
        } while ((string = this.tokenizer.getString()).equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        int[] nArray = new int[n2];
        Expression[] expressionArray = new Expression[n2];
        n = 0;
        while (n < n2) {
            nArray[n] = (Integer)hsqlArrayList.get(n);
            expressionArray[n] = (Expression)hsqlArrayList2.get(n);
            ++n;
        }
        if (compiledStatement == null) {
            compiledStatement = new CompiledStatement();
        }
        compiledStatement.setAsUpdate(table, nArray, expressionArray, expression, this.getParameters());
        compiledStatement.subqueries = this.getSubqueries();
        return compiledStatement;
    }

    static void checkParamAmbiguity(boolean bl, String string) throws HsqlException {
        Trace.check(bl, 57, pamsg, string);
    }

    boolean isParsingView() {
        return this.subQueryStack != null && !this.subQueryStack.isEmpty() && ((SubQuery)this.subQueryStack.peek()).isView;
    }

    static {
        tokenSet.put(",", 104);
        tokenSet.put("=", 21);
        tokenSet.put("!=", 26);
        tokenSet.put("<>", 26);
        tokenSet.put("<", 24);
        tokenSet.put(">", 23);
        tokenSet.put("<=", 25);
        tokenSet.put(">=", 22);
        tokenSet.put("AND", 28);
        tokenSet.put("NOT", 20);
        tokenSet.put("OR", 29);
        tokenSet.put("IN", 30);
        tokenSet.put("EXISTS", 31);
        tokenSet.put("BETWEEN", 106);
        tokenSet.put("+", 100);
        tokenSet.put("-", 10);
        tokenSet.put("*", 13);
        tokenSet.put("/", 14);
        tokenSet.put("||", 105);
        tokenSet.put("(", 101);
        tokenSet.put(")", 102);
        tokenSet.put("SELECT", 103);
        tokenSet.put("LIKE", 27);
        tokenSet.put("COUNT", 40);
        tokenSet.put("SUM", 41);
        tokenSet.put("MIN", 42);
        tokenSet.put("MAX", 43);
        tokenSet.put("AVG", 44);
        tokenSet.put("IFNULL", 60);
        tokenSet.put("NULLIF", 67);
        tokenSet.put("CONVERT", 61);
        tokenSet.put("CAST", 107);
        tokenSet.put("CASE", 68);
        tokenSet.put("WHEN", 110);
        tokenSet.put("THEN", 111);
        tokenSet.put("ELSE", 112);
        tokenSet.put("END", 113);
        tokenSet.put("CASEWHEN", 62);
        tokenSet.put("CONCAT", 15);
        tokenSet.put("COALESCE", 69);
        tokenSet.put("EXTRACT", 63);
        tokenSet.put("POSITION", 64);
        tokenSet.put("FROM", 124);
        tokenSet.put("TRIM", 65);
        tokenSet.put("SUBSTRING", 66);
        tokenSet.put("FOR", 123);
        tokenSet.put("AS", 122);
        tokenSet.put("IS", 109);
        tokenSet.put("?", 8);
        noParameters = new Expression[0];
        noSubqueries = new SubQuery[0];
    }
}

