/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.Column;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;

class Result {
    Record rRoot;
    private Record rTail;
    private int iSize;
    private int significantColumns;
    int iMode;
    int databaseID;
    int sessionID;
    String mainString;
    String subString;
    String subSubString;
    int statementID;
    int iUpdateCount;
    ResultMetaData metaData;

    Result(int n) {
        this.iMode = n;
        if (n == 3 || n == 5 || n == 65548 || n == 6) {
            this.metaData = new ResultMetaData();
        }
    }

    Result(String string, String string2, int n) {
        this.iMode = 2;
        this.mainString = string;
        this.subString = string2;
        this.statementID = n;
        this.subSubString = "";
    }

    Result(int n, int n2) {
        this.metaData = new ResultMetaData();
        this.metaData.prepareData(n2);
        if (n == 5) {
            this.metaData.isParameterDescription = true;
            this.metaData.paramMode = new int[n2];
        }
        this.iMode = n;
        this.significantColumns = n2;
    }

    Result(int n, int[] nArray, int n2) {
        this.iMode = n;
        this.metaData = new ResultMetaData();
        this.metaData.colType = nArray;
        this.significantColumns = nArray.length;
        this.statementID = n2;
    }

    Result(DatabaseRowInputInterface databaseRowInputInterface) throws HsqlException {
        try {
            this.iMode = databaseRowInputInterface.readIntData();
            if (this.iMode == 0) {
                this.readMultiResult(databaseRowInputInterface);
                return;
            }
            this.databaseID = databaseRowInputInterface.readIntData();
            this.sessionID = databaseRowInputInterface.readIntData();
            switch (this.iMode) {
                case 7: 
                case 65545: 
                case 65610: {
                    break;
                }
                case 65555: {
                    this.setStatementType(databaseRowInputInterface.readIntData());
                    this.mainString = databaseRowInputInterface.readString();
                    break;
                }
                case 4: 
                case 65552: {
                    this.statementID = databaseRowInputInterface.readIntData();
                    break;
                }
                case 65547: {
                    this.statementID = databaseRowInputInterface.readIntData();
                    this.mainString = databaseRowInputInterface.readString();
                    break;
                }
                case 2: 
                case 65543: {
                    this.mainString = databaseRowInputInterface.readString();
                    this.subString = databaseRowInputInterface.readString();
                    this.subSubString = databaseRowInputInterface.readString();
                    this.statementID = databaseRowInputInterface.readIntData();
                    break;
                }
                case 1: {
                    this.iUpdateCount = databaseRowInputInterface.readIntData();
                    break;
                }
                case 66541: {
                    int n = databaseRowInputInterface.readIntData();
                    this.setEndTranType(n);
                    switch (n) {
                        case 2: 
                        case 4: {
                            this.mainString = databaseRowInputInterface.readString();
                        }
                    }
                    break;
                }
                case 6: 
                case 65548: {
                    if (this.iMode == 65548) {
                        this.statementID = databaseRowInputInterface.readIntData();
                    } else {
                        this.iUpdateCount = databaseRowInputInterface.readIntData();
                    }
                    int n = databaseRowInputInterface.readIntData();
                    this.metaData = new ResultMetaData();
                    this.metaData.prepareData(n);
                    this.significantColumns = n;
                    int n2 = 0;
                    while (n2 < n) {
                        this.metaData.colType[n2] = databaseRowInputInterface.readType();
                        ++n2;
                    }
                    int n3 = databaseRowInputInterface.readIntData();
                    while (n3-- > 0) {
                        this.add(databaseRowInputInterface.readData(this.metaData.colType));
                    }
                    break;
                }
                case 3: 
                case 5: {
                    this.metaData = new ResultMetaData();
                    this.metaData.isParameterDescription = this.iMode == 5;
                    this.metaData.read(databaseRowInputInterface);
                    this.significantColumns = this.metaData.sLabel.length;
                    int n = databaseRowInputInterface.readIntData();
                    while (n-- > 0) {
                        this.add(databaseRowInputInterface.readData(this.metaData.colType));
                    }
                    break;
                }
                case 66552: {
                    int n = databaseRowInputInterface.readIntData();
                    this.setConnectionAttrType(n);
                    switch (n) {
                        case 10027: {
                            this.mainString = databaseRowInputInterface.readString();
                        }
                    }
                    break;
                }
                default: {
                    throw new HsqlException("trying to use unsupported result mode: " + this.iMode, null, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
    }

    static Result newSingleColumnResult(String string, int n) {
        Result result = new Result(3, 1);
        result.metaData.sName[0] = string;
        result.metaData.sLabel[0] = string;
        result.metaData.sTable[0] = "";
        result.metaData.colType[0] = n;
        return result;
    }

    static Result newPrepareResponse(int n, Result result, Result result2) {
        Result result3 = new Result(0);
        Result result4 = new Result(4);
        result4.statementID = n;
        result3.add(new Object[]{result4});
        result3.add(new Object[]{result});
        result3.add(new Object[]{result2});
        return result3;
    }

    static Result newParameterDescriptionResult(int n) {
        Result result = new Result(5, n);
        result.metaData.isParameterDescription = true;
        result.metaData.paramMode = new int[n];
        return result;
    }

    static Result newFreeStmtRequest(int n) {
        Result result = new Result(65552);
        result.statementID = n;
        return result;
    }

    static Result newExecuteDirectRequest(String string) {
        Result result = new Result(65547);
        result.setMainString(string);
        return result;
    }

    static Result newReleaseSavepointRequest(String string) {
        Result result = new Result(66541);
        result.setMainString(string);
        result.setEndTranType(4);
        return result;
    }

    static Result newRollbackToSavepointRequest(String string) {
        Result result = new Result(66541);
        result.setMainString(string);
        result.setEndTranType(2);
        return result;
    }

    static Result newSetSavepointRequest(String string) {
        Result result = new Result(66552);
        result.setConnectionAttrType(10027);
        result.setMainString(string);
        return result;
    }

    static Result newSelectResult(Result result) {
        Result result2 = new Result(3);
        result2.significantColumns = result.significantColumns;
        result2.metaData = result.metaData;
        return result2;
    }

    int getSize() {
        return this.iSize;
    }

    void setColumnCount(int n) {
        this.significantColumns = n;
    }

    int getColumnCount() {
        return this.significantColumns;
    }

    void append(Result result) {
        if (this.rRoot == null) {
            this.rRoot = result.rRoot;
        } else {
            this.rTail.next = result.rRoot;
        }
        this.rTail = result.rTail;
        this.iSize += result.iSize;
    }

    void addAll(Result result) {
        if (result == null) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.add(record.data);
            record = record.next;
        }
    }

    void setRows(Result result) {
        if (result == null) {
            this.rRoot = null;
            this.rTail = null;
            this.iSize = 0;
        } else {
            this.rRoot = result.rRoot;
            this.rTail = result.rTail;
            this.iSize = result.iSize;
        }
    }

    void add(Object[] objectArray) {
        Record record = new Record();
        record.data = objectArray;
        if (this.rRoot == null) {
            this.rRoot = record;
        } else {
            this.rTail.next = record;
        }
        this.rTail = record;
        ++this.iSize;
    }

    void trimResult(int n, int n2) {
        Record record = this.rRoot;
        if (record == null) {
            return;
        }
        if (n >= this.iSize) {
            this.iSize = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.iSize -= n;
        int n3 = 0;
        while (n3 < n) {
            record = record.next;
            if (record == null) {
                this.iSize = 0;
                this.rRoot = this.rTail = record;
                return;
            }
            ++n3;
        }
        this.rRoot = record;
        if (n2 == 0 || n2 >= this.iSize) {
            return;
        }
        int n4 = 1;
        while (n4 < n2) {
            record = record.next;
            if (record == null) {
                return;
            }
            ++n4;
        }
        this.iSize = n2;
        record.next = null;
        this.rTail = record;
    }

    void removeDuplicates() throws HsqlException {
        this.removeDuplicates(this.significantColumns);
    }

    void removeDuplicates(int n) throws HsqlException {
        Record record;
        if (this.rRoot == null) {
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            nArray2[n2] = 1;
            ++n2;
        }
        this.sortResult(nArray, nArray2);
        Record record2 = this.rRoot;
        while ((record = record2.next) != null) {
            if (this.compareRecord(record2.data, record.data, n) == 0) {
                record2.next = record.next;
                --this.iSize;
                continue;
            }
            record2 = record;
        }
        this.rTail = record2;
        Trace.doAssert(this.rTail.next == null, "rTail not correct in Result.removeDuplicates iSize =", this.iSize);
    }

    void removeSecond(Result result) throws HsqlException {
        this.removeSecond(result, this.significantColumns);
    }

    void removeSecond(Result result, int n) throws HsqlException {
        this.removeDuplicates(n);
        result.removeDuplicates(n);
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n2 = 0;
        while (record != null && record3 != null) {
            n2 = this.compareRecord(record.data, record3.data, n);
            if (n2 == 0) {
                if (bl) {
                    this.rRoot = record2 = record.next;
                } else {
                    record2.next = record.next;
                }
                record = record.next;
                --this.iSize;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record2 = record;
            bl = false;
            record = record.next;
        }
        while (record != null) {
            record2 = record;
            record = record.next;
        }
        this.rTail = record2;
        Trace.doAssert(this.rRoot == null && this.rTail == null || this.rTail.next == null, "rTail not correct in Result.removeSecond iSize =", this.iSize);
    }

    void removeDifferent(Result result) throws HsqlException {
        this.removeDifferent(result, this.significantColumns);
    }

    void removeDifferent(Result result, int n) throws HsqlException {
        this.removeDuplicates(n);
        result.removeDuplicates(n);
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n2 = 0;
        this.iSize = 0;
        while (record != null && record3 != null) {
            n2 = this.compareRecord(record.data, record3.data, n);
            if (n2 == 0) {
                if (bl) {
                    this.rRoot = record;
                } else {
                    record2.next = record;
                }
                bl = false;
                record2 = record;
                record = record.next;
                record3 = record3.next;
                ++this.iSize;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record = record.next;
        }
        if (bl) {
            this.rRoot = null;
            record2 = null;
        } else {
            record2.next = null;
        }
        this.rTail = record2;
        Trace.doAssert(this.rRoot == null && this.rTail == null || this.rTail.next == null, "rTail not correct in Result.removeDifference iSize =", this.iSize);
    }

    void sortResult(int[] nArray, int[] nArray2) throws HsqlException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] recordArray = new Record[2];
        Record[] recordArray2 = new Record[2];
        int n = 0;
        Record record = this.rRoot;
        while (record != null) {
            Record record2 = record.next;
            record.next = recordArray[n];
            recordArray[n] = record;
            record = record2;
            n ^= 1;
        }
        int n2 = 1;
        while (recordArray[1] != null) {
            Record record3 = recordArray[0];
            Record record4 = recordArray[1];
            recordArray2[1] = null;
            recordArray2[0] = null;
            recordArray[1] = null;
            recordArray[0] = null;
            n = 0;
            while (record3 != null) {
                int n3 = n2;
                int n4 = n2;
                while (true) {
                    if (n3 == 0 || record3 == null) {
                        if (n4 == 0 || record4 == null) break;
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else if (n4 == 0 || record4 == null) {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    } else if (this.compareRecord(record3.data, record4.data, nArray, nArray2) > 0) {
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    }
                    if (recordArray[n] == null) {
                        recordArray[n] = record;
                    } else {
                        recordArray2[n].next = record;
                    }
                    recordArray2[n] = record;
                    record.next = null;
                }
                n ^= 1;
            }
            n2 <<= 1;
        }
        this.rRoot = recordArray[0];
        this.rTail = recordArray2[0];
        Trace.doAssert(this.rTail.next == null, "rTail not correct in Result.sortResult iSize =", this.iSize);
    }

    private int compareRecord(Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2) throws HsqlException {
        int n = Column.compare(objectArray[nArray[0]], objectArray2[nArray[0]], this.metaData.colType[nArray[0]]);
        if (n == 0) {
            int n2 = 1;
            while (n2 < nArray.length) {
                n = Column.compare(objectArray[nArray[n2]], objectArray2[nArray[n2]], this.metaData.colType[nArray[n2]]);
                if (n != 0) {
                    return n * nArray2[n2];
                }
                ++n2;
            }
        }
        return n * nArray2[0];
    }

    private int compareRecord(Object[] objectArray, Object[] objectArray2, int n) throws HsqlException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = Column.compare(objectArray[n2], objectArray2[n2], this.metaData.colType[n2]);
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    void getBytes(DatabaseRowOutputInterface databaseRowOutputInterface) {
    }

    byte[] getBytes() throws HsqlException {
        try {
            BinaryServerRowOutput binaryServerRowOutput = new BinaryServerRowOutput();
            this.write(binaryServerRowOutput);
            return binaryServerRowOutput.getOutputStream().toByteArray();
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, HsqlException {
        if (this.iMode == 0) {
            this.writeMulti(databaseRowOutputInterface);
            return;
        }
        int n = databaseRowOutputInterface.size();
        databaseRowOutputInterface.writeSize(0);
        databaseRowOutputInterface.writeIntData(this.iMode);
        databaseRowOutputInterface.writeIntData(this.databaseID);
        databaseRowOutputInterface.writeIntData(this.sessionID);
        switch (this.iMode) {
            case 7: 
            case 65545: 
            case 65610: {
                break;
            }
            case 65555: {
                databaseRowOutputInterface.writeIntData(this.getStatementType());
                databaseRowOutputInterface.writeString(this.mainString);
                break;
            }
            case 4: 
            case 65552: {
                databaseRowOutputInterface.writeIntData(this.statementID);
                break;
            }
            case 65547: {
                databaseRowOutputInterface.writeIntData(this.statementID);
                databaseRowOutputInterface.writeString(this.mainString);
                break;
            }
            case 2: 
            case 65543: {
                databaseRowOutputInterface.writeString(this.mainString);
                databaseRowOutputInterface.writeString(this.subString);
                databaseRowOutputInterface.writeString(this.subSubString);
                databaseRowOutputInterface.writeIntData(this.statementID);
                break;
            }
            case 1: {
                databaseRowOutputInterface.writeIntData(this.iUpdateCount);
                break;
            }
            case 66541: {
                int n2 = this.getEndTranType();
                databaseRowOutputInterface.writeIntData(n2);
                switch (n2) {
                    case 2: 
                    case 4: {
                        databaseRowOutputInterface.writeString(this.mainString);
                    }
                }
                break;
            }
            case 6: 
            case 65548: {
                databaseRowOutputInterface.writeIntData(this.iMode == 65548 ? this.statementID : this.iUpdateCount);
                int n3 = this.significantColumns;
                databaseRowOutputInterface.writeIntData(n3);
                int n4 = 0;
                while (n4 < n3) {
                    databaseRowOutputInterface.writeType(this.metaData.colType[n4]);
                    ++n4;
                }
                databaseRowOutputInterface.writeIntData(this.iSize);
                Record record = this.rRoot;
                while (record != null) {
                    databaseRowOutputInterface.writeData(n3, this.metaData.colType, record.data, null, false);
                    record = record.next;
                }
                break;
            }
            case 3: 
            case 5: {
                this.metaData.write(databaseRowOutputInterface, this.significantColumns);
                databaseRowOutputInterface.writeIntData(this.iSize);
                Record record = this.rRoot;
                while (record != null) {
                    databaseRowOutputInterface.writeData(this.significantColumns, this.metaData.colType, record.data, null, false);
                    record = record.next;
                }
                break;
            }
            case 66552: {
                int n5 = this.getConnectionAttrType();
                databaseRowOutputInterface.writeIntData(n5);
                switch (n5) {
                    case 10027: {
                        databaseRowOutputInterface.writeString(this.mainString);
                    }
                }
                break;
            }
            default: {
                throw new HsqlException("trying to use unsupported result mode: " + this.iMode, null, 0);
            }
        }
        databaseRowOutputInterface.writeIntData(databaseRowOutputInterface.size(), n);
    }

    void readMultiResult(DatabaseRowInputInterface databaseRowInputInterface) throws HsqlException, IOException {
        this.iMode = 0;
        this.databaseID = databaseRowInputInterface.readIntData();
        this.sessionID = databaseRowInputInterface.readIntData();
        int n = databaseRowInputInterface.readIntData();
        int n2 = 0;
        while (n2 < n) {
            databaseRowInputInterface.readIntData();
            this.add(new Object[]{new Result(databaseRowInputInterface)});
            ++n2;
        }
    }

    private void writeMulti(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, HsqlException {
        int n = databaseRowOutputInterface.size();
        databaseRowOutputInterface.writeSize(0);
        databaseRowOutputInterface.writeIntData(this.iMode);
        databaseRowOutputInterface.writeIntData(this.databaseID);
        databaseRowOutputInterface.writeIntData(this.sessionID);
        databaseRowOutputInterface.writeIntData(this.iSize);
        Record record = this.rRoot;
        while (record != null) {
            ((Result)record.data[0]).write(databaseRowOutputInterface);
            record = record.next;
        }
        databaseRowOutputInterface.writeIntData(databaseRowOutputInterface.size(), n);
    }

    static void write(Result result, DatabaseRowOutputInterface databaseRowOutputInterface, OutputStream outputStream) throws IOException, HsqlException {
        databaseRowOutputInterface.reset();
        result.write(databaseRowOutputInterface);
        outputStream.write(databaseRowOutputInterface.getOutputStream().getBuffer(), 0, databaseRowOutputInterface.getOutputStream().size());
        outputStream.flush();
    }

    static Result read(DatabaseRowInputInterface databaseRowInputInterface, DataInputStream dataInputStream) throws IOException, HsqlException {
        int n = dataInputStream.readInt();
        databaseRowInputInterface.resetRow(0, n);
        byte[] byArray = databaseRowInputInterface.getBuffer();
        int n2 = 4;
        while (n2 < n) {
            int n3 = dataInputStream.read(byArray, n2, n - n2);
            if (n3 < 0) {
                throw new IOException();
            }
            n2 += n3;
        }
        return new Result(databaseRowInputInterface);
    }

    Result(Throwable throwable, String string) {
        this.iMode = 2;
        if (throwable instanceof HsqlException) {
            HsqlException hsqlException = (HsqlException)throwable;
            this.subString = hsqlException.state;
            this.mainString = hsqlException.message;
            if (string != null) {
                this.mainString = this.mainString + " in statement [" + string + "]";
            }
            this.statementID = hsqlException.code;
        } else if (throwable instanceof Exception) {
            throwable.printStackTrace();
            this.subString = "S1000";
            this.mainString = Trace.getMessage(40) + " " + throwable;
            if (string != null) {
                this.mainString = this.mainString + " in statement [" + string + "]";
            }
            this.statementID = 40;
        } else if (throwable instanceof OutOfMemoryError) {
            System.gc();
            throwable.printStackTrace();
            this.subString = "S1000";
            this.mainString = "out of memory";
            this.statementID = 72;
        }
        this.subSubString = "";
    }

    int getStatementID() {
        return this.statementID;
    }

    void setStatementID(int n) {
        this.statementID = n;
    }

    String getMainString() {
        return this.mainString;
    }

    void setMainString(String string) {
        this.mainString = string;
    }

    String getSubString() {
        return this.subString;
    }

    void setMaxRows(int n) {
        this.iUpdateCount = n;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    int getConnectionAttrType() {
        return this.iUpdateCount;
    }

    void setConnectionAttrType(int n) {
        this.iUpdateCount = n;
    }

    int getEndTranType() {
        return this.iUpdateCount;
    }

    void setEndTranType(int n) {
        this.iUpdateCount = n;
    }

    int[] getUpdateCounts() {
        return this.metaData.colType;
    }

    Object[] getParameterData() {
        return this.rRoot == null ? null : this.rRoot.data;
    }

    void setParameterData(Object[] objectArray) {
        if (this.rRoot == null) {
            this.rRoot = new Record();
        }
        this.rRoot.data = objectArray;
        this.rRoot.next = null;
        this.rTail = this.rRoot;
        this.iSize = 1;
    }

    void setResultType(int n) {
        this.iMode = n;
    }

    void setStatementType(int n) {
        this.iUpdateCount = n;
    }

    int getStatementType() {
        return this.iUpdateCount;
    }

    Iterator iterator() {
        return new ResultIterator();
    }

    private class ResultIterator
    implements Iterator {
        boolean removed;
        int counter;
        Record current;
        Record last;

        private ResultIterator() {
            this.current = Result.this.rRoot;
        }

        public boolean hasNext() {
            return this.counter < Result.this.iSize;
        }

        public Object next() {
            if (this.hasNext()) {
                this.removed = false;
                if (this.counter != 0) {
                    this.last = this.current;
                    this.current = this.current.next;
                }
                ++this.counter;
                return this.current.data;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.counter <= Result.this.iSize && this.counter != 0 && !this.removed) {
                this.removed = true;
                if (this.current == Result.this.rTail) {
                    Result.this.rTail = this.last;
                }
                if (this.current == Result.this.rRoot) {
                    this.current = Result.this.rRoot = Result.this.rRoot.next;
                } else {
                    this.current = this.last;
                    this.last = null;
                    this.current.next = this.current.next.next;
                }
                Result.this.iSize--;
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }

    static class ResultMetaData {
        String[] sLabel;
        String[] sTable;
        String[] sName;
        boolean[] isLabelQuoted;
        int[] colType;
        int[] colSize;
        int[] colScale;
        String[] sCatalog;
        String[] sSchema;
        int[] nullability;
        boolean[] isIdentity;
        boolean[] isWritable;
        int[] paramMode;
        String[] sClassName;
        boolean isParameterDescription;

        ResultMetaData() {
        }

        private void prepareData(int n) {
            this.sLabel = new String[n];
            this.sTable = new String[n];
            this.sName = new String[n];
            this.isLabelQuoted = new boolean[n];
            this.colType = new int[n];
            this.colSize = new int[n];
            this.colScale = new int[n];
            this.sCatalog = new String[n];
            this.sSchema = new String[n];
            this.nullability = new int[n];
            this.isIdentity = new boolean[n];
            this.isWritable = new boolean[n];
            this.sClassName = new String[n];
        }

        int[] getParameterTypes() {
            return this.colType;
        }

        boolean isTableColumn(int n) {
            return this.sTable[n] != null && this.sTable[n].length() > 0 && this.sName[n] != null && this.sName[n].length() > 0;
        }

        private void decodeTableColumnAttrs(int n, int n2) {
            this.nullability[n2] = n & 0xF;
            this.isIdentity[n2] = (n & 0x10) != 0;
            this.isWritable[n2] = (n & 0x20) != 0;
        }

        private void writeTableColumnAttrs(DatabaseRowOutputInterface databaseRowOutputInterface, int n) throws IOException, HsqlException {
            databaseRowOutputInterface.writeIntData(this.encodeTableColumnAttrs(n));
            databaseRowOutputInterface.writeString(this.sCatalog[n] == null ? "" : this.sCatalog[n]);
            databaseRowOutputInterface.writeString(this.sSchema[n] == null ? "" : this.sSchema[n]);
        }

        private int encodeTableColumnAttrs(int n) {
            int n2 = this.nullability[n];
            if (this.isIdentity[n]) {
                n2 |= 0x10;
            }
            if (this.isWritable[n]) {
                n2 |= 0x20;
            }
            return n2;
        }

        private void readTableColumnAttrs(DatabaseRowInputInterface databaseRowInputInterface, int n) throws IOException, HsqlException {
            this.decodeTableColumnAttrs(databaseRowInputInterface.readIntData(), n);
            this.sCatalog[n] = databaseRowInputInterface.readString();
            this.sSchema[n] = databaseRowInputInterface.readString();
        }

        void read(DatabaseRowInputInterface databaseRowInputInterface) throws HsqlException, IOException {
            int n = databaseRowInputInterface.readIntData();
            this.prepareData(n);
            if (this.isParameterDescription) {
                this.paramMode = new int[n];
            }
            int n2 = 0;
            while (n2 < n) {
                this.colType[n2] = databaseRowInputInterface.readType();
                this.sLabel[n2] = databaseRowInputInterface.readString();
                this.sTable[n2] = databaseRowInputInterface.readString();
                this.sName[n2] = databaseRowInputInterface.readString();
                this.sClassName[n2] = databaseRowInputInterface.readString();
                if (this.isTableColumn(n2)) {
                    this.readTableColumnAttrs(databaseRowInputInterface, n2);
                }
                if (this.isParameterDescription) {
                    this.paramMode[n2] = databaseRowInputInterface.readIntData();
                }
                ++n2;
            }
        }

        void write(DatabaseRowOutputInterface databaseRowOutputInterface, int n) throws HsqlException, IOException {
            databaseRowOutputInterface.writeIntData(n);
            int n2 = 0;
            while (n2 < n) {
                databaseRowOutputInterface.writeType(this.colType[n2]);
                databaseRowOutputInterface.writeString(this.sLabel[n2] == null ? "" : this.sLabel[n2]);
                databaseRowOutputInterface.writeString(this.sTable[n2] == null ? "" : this.sTable[n2]);
                databaseRowOutputInterface.writeString(this.sName[n2] == null ? "" : this.sName[n2]);
                databaseRowOutputInterface.writeString(this.sClassName[n2] == null ? "" : this.sClassName[n2]);
                if (this.isTableColumn(n2)) {
                    this.writeTableColumnAttrs(databaseRowOutputInterface, n2);
                }
                if (this.isParameterDescription) {
                    databaseRowOutputInterface.writeIntData(this.paramMode[n2]);
                }
                ++n2;
            }
        }
    }
}

