/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isPreProcess;
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    private int aggregateCount;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression havingCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iHavingIndex = -1;
    int iOrderLen;
    Select sUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType = 2;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    int limitStart = 0;
    int limitCount = 0;
    private Result rResult;
    boolean isResolved = false;

    Select() {
    }

    void setPreProcess() {
        this.isPreProcess = true;
    }

    void resolve() throws HsqlException {
        int n = this.tFilter.length;
        int n2 = 0;
        while (n2 < n) {
            this.resolve(this.tFilter[n2], true);
            ++n2;
        }
    }

    void resolve(TableFilter tableFilter, boolean bl) throws HsqlException {
        if (this.eCondition != null) {
            this.eCondition.resolve(tableFilter);
            if (tableFilter != null && bl) {
                tableFilter.setCondition(this.eCondition);
            }
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].resolve(tableFilter);
            ++n2;
        }
    }

    void checkResolved() throws HsqlException {
        if (this.eCondition != null) {
            this.eCondition.checkResolved();
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].checkResolved();
            ++n2;
        }
    }

    Object getValue(int n) throws HsqlException {
        this.resolve();
        Result result = this.getResult(2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        Trace.check(n2 == 1 && n3 == 1, 17);
        Object object = result.rRoot.data[0];
        return result.metaData.colType[0] == n ? object : Column.convertObject(object, n);
    }

    private void prepareResult() throws HsqlException {
        int n;
        this.resolveAll();
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            n = this.iResultLen;
            while (n < this.iResultLen + this.iGroupLen) {
                this.eColumn[n].collectColumnName(this.groupColumnNames);
                ++n;
            }
        }
        n = this.eColumn.length;
        Result result = new Result(3, n);
        Result.ResultMetaData resultMetaData = result.metaData;
        int n2 = this.iResultLen;
        int n3 = n2 + this.iGroupLen;
        int n4 = this.iHavingIndex >= 0 ? this.iHavingIndex + 1 : n3;
        int n5 = n4 + this.iOrderLen;
        int n6 = 0;
        while (n6 < n) {
            Expression expression = this.eColumn[n6];
            resultMetaData.colType[n6] = expression.getDataType();
            resultMetaData.colSize[n6] = expression.getColumnSize();
            resultMetaData.colScale[n6] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
            }
            Trace.check(n6 < n2 || n6 >= n3 || this.eColumn[n6].canBeInGroupBy(), 68, this.eColumn[n6]);
            Trace.check(n6 != this.iHavingIndex || this.eColumn[n6].isConditional(), 69, this.eColumn[n6]);
            Trace.check(n6 < n4 || n6 >= n5 || this.eColumn[n6].canBeInOrderBy(), 70, this.eColumn[n6]);
            if (n6 < this.iResultLen) {
                resultMetaData.sLabel[n6] = expression.getAlias();
                resultMetaData.isLabelQuoted[n6] = expression.isAliasQuoted();
                resultMetaData.sTable[n6] = expression.getTableName();
                resultMetaData.sName[n6] = expression.getColumnName();
                if (resultMetaData.isTableColumn(n6)) {
                    resultMetaData.nullability[n6] = expression.nullability;
                    resultMetaData.isIdentity[n6] = expression.isIdentity;
                    resultMetaData.isWritable[n6] = expression.isWritable;
                }
                resultMetaData.sClassName[n6] = expression.getValueClassName();
            }
            ++n6;
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        if (this.iHavingIndex >= 0) {
            this.checkAggregateOrGroupByColumns(this.iHavingIndex, this.iHavingIndex + 1);
        }
        this.checkAggregateOrGroupByColumns(n4, n5);
        if (this.isDistinctSelect) {
            int n7 = n4;
            while (n7 < n5) {
                Trace.check(this.isSimilarIn(this.eColumn[n7], 0, this.iResultLen), 71, this.eColumn[n7]);
                ++n7;
            }
        }
        this.rResult = result;
    }

    private int getLimitCount(int n) {
        if (n == 0) {
            n = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = n;
        } else {
            this.limitCount = n > this.limitCount ? this.limitCount : n;
            n = this.limitCount;
        }
        boolean bl = false;
        if (n != 0 && !this.isDistinctSelect && !this.isGrouped && this.sUnion == null && this.iOrderLen == 0) {
            bl = true;
        }
        return bl ? this.limitStart + n : Integer.MAX_VALUE;
    }

    Result getResult(int n) throws HsqlException {
        Object object;
        if (this.rResult == null) {
            this.prepareResult();
        }
        Result result = Result.newSelectResult(this.rResult);
        this.buildResult(result, this.getLimitCount(n));
        if (this.isDistinctSelect) {
            result.removeDuplicates(this.iResultLen);
        }
        if (this.iOrderLen != 0) {
            object = new int[this.iOrderLen];
            int[] nArray = new int[this.iOrderLen];
            int n2 = this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
            int n3 = 0;
            while (n3 < this.iOrderLen) {
                object[n3] = n2;
                nArray[n3] = this.eColumn[n2].isDescending() ? -1 : 1;
                ++n2;
                ++n3;
            }
            result.sortResult((int[])object, nArray);
        }
        result.setColumnCount(this.iResultLen);
        result.trimResult(this.limitStart, this.limitCount);
        if (this.sUnion != null) {
            object = this.sUnion.getResult(0);
            switch (this.iUnionType) {
                case 1: {
                    result.append((Result)object);
                    result.removeDuplicates();
                    break;
                }
                case 2: {
                    result.append((Result)object);
                    break;
                }
                case 3: {
                    result.removeDifferent((Result)object);
                    break;
                }
                case 4: {
                    result.removeSecond((Result)object);
                }
            }
        }
        return result;
    }

    private void checkAggregateOrGroupByColumns(int n, int n2) throws HsqlException {
        if (n < n2) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            int n3 = n;
            while (n3 < n2) {
                this.eColumn[n3].collectInGroupByExpressions(hsqlArrayList);
                ++n3;
            }
            int n4 = 0;
            int n5 = hsqlArrayList.size();
            while (n4 < n5) {
                Expression expression = (Expression)hsqlArrayList.get(n4);
                Trace.check(this.inAggregateOrGroupByClause(expression), 67, expression);
                ++n4;
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression expression) {
        if (!this.isAggregated || expression.canBeInAggregate()) {
            return true;
        }
        if (!this.isGrouped) {
            return false;
        }
        return this.isSimilarIn(expression, this.iResultLen, this.iResultLen + this.iGroupLen) || this.allColumnsAreDefinedIn(expression, this.groupColumnNames);
    }

    private boolean isSimilarIn(Expression expression, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (expression.similarTo(this.eColumn[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean allColumnsAreDefinedIn(Expression expression, HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        expression.collectAllColumnNames(hashSet2);
        if (hashSet2.size() > 0 && hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void buildResult(Result var1_1, int var2_2) throws HsqlException {
        var3_3 = new GroupedResult(this, var1_1);
        var4_4 = this.eColumn.length;
        var5_5 = this.tFilter.length;
        var6_6 = new boolean[var5_5];
        var7_7 = new boolean[var5_5];
        var8_8 = 0;
        while (var8_8 >= 0 && !this.isPreProcess) {
            var9_9 = this.tFilter[var8_8];
            if (!var6_6[var8_8]) {
                var10_10 = var9_9.findFirst();
                var11_13 = var9_9.isOuterJoin != false && var10_10 == false && var7_7[var8_8] == false && var9_9.nonJoinIsNull == false && var9_9.nextOuter() != false ? 1 : 0;
                var7_7[var8_8] = var11_13;
                var6_6[var8_8] = var10_10;
            } else {
                var10_10 = var9_9.next();
                var11_13 = var9_9.isOuterJoin != false && var10_10 == false && var6_6[var8_8] == false && var7_7[var8_8] == false && var9_9.nonJoinIsNull == false && var9_9.nextOuter() != false ? 1 : 0;
                var7_7[var8_8] = var11_13;
                var6_6[var8_8] = var10_10;
            }
            if (!var10_10 && var11_13 == 0) {
                --var8_8;
                continue;
            }
            if (var8_8 >= var5_5 - 1) ** GOTO lbl26
            ++var8_8;
            continue;
lbl-1000:
            // 1 sources

            {
                var7_7[var8_8--] = false;
lbl26:
                // 2 sources

                ** while (var7_7[var8_8])
            }
lbl27:
            // 1 sources

            if (this.eCondition != null && !this.eCondition.test()) continue;
            var12_14 = new Object[var4_4];
            var13_15 = var3_3.groupBegin;
            while (var13_15 < var3_3.groupEnd) {
                var12_14[var13_15] = this.eColumn[var13_15].getValue();
                ++var13_15;
            }
            var12_14 = var3_3.addRow(var12_14);
            var14_16 = 0;
            while (var14_16 < var3_3.groupBegin) {
                var12_14[var14_16] = this.isAggregated != false && this.eColumn[var14_16].isAggregate() != false ? this.eColumn[var14_16].getAggregatingValue(var12_14[var14_16]) : this.eColumn[var14_16].getValue();
                ++var14_16;
            }
            var15_17 = var3_3.groupEnd;
            while (var15_17 < var4_4) {
                var12_14[var15_17] = this.isAggregated != false && this.eColumn[var15_17].isAggregate() != false ? this.eColumn[var15_17].getAggregatingValue(var12_14[var15_17]) : this.eColumn[var15_17].getValue();
                ++var15_17;
            }
            if (var3_3.size() >= var2_2) break;
        }
        if (this.isAggregated && !this.isGrouped && var3_3.size() == 0) {
            var3_3.addRow(new Object[var4_4]);
        }
        var9_9 = var3_3.iterator();
        while (var9_9.hasNext()) {
            var10_12 = (Object[])var9_9.next();
            if (this.isAggregated) {
                var11_13 = 0;
                while (var11_13 < var4_4) {
                    if (this.eColumn[var11_13].isAggregate()) {
                        var10_12[var11_13] = this.eColumn[var11_13].getAggregatedValue(var10_12[var11_13]);
                    }
                    ++var11_13;
                }
            }
            if (this.iHavingIndex < 0 || ((Boolean)var10_12[this.iHavingIndex]).booleanValue()) continue;
            var9_9.remove();
        }
    }

    void resolveAll() throws HsqlException {
        if (this.isResolved) {
            return;
        }
        this.resolve();
        this.checkResolved();
        if (this.sUnion != null) {
            if (this.sUnion.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            this.sUnion.resolveAll();
        }
        this.isResolved = true;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String toString() {
        this.preProcess();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            stringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        stringBuffer.append("start=[").append(this.limitStart).append("]\n");
        stringBuffer.append("limit=[").append(this.limitCount).append("]\n");
        stringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append("columns=[");
        int n = this.eColumn.length - this.iOrderLen;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.eColumn[n2]);
            ++n2;
        }
        stringBuffer.append("\n]\n");
        stringBuffer.append("tableFilters=[\n");
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            stringBuffer.append("[\n");
            stringBuffer.append(this.tFilter[n3]);
            stringBuffer.append("\n]");
            ++n3;
        }
        stringBuffer.append("]\n");
        stringBuffer.append("eCondition=[").append(this.eCondition).append("]\n");
        stringBuffer.append("havingCondition=[").append(this.havingCondition).append("]\n");
        stringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.sUnion != null) {
            switch (this.iUnionType) {
                case 4: {
                    stringBuffer.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" UNION ");
                    break;
                }
                case 2: {
                    stringBuffer.append(" UNION ALL ");
                    break;
                }
                default: {
                    stringBuffer.append(" UNKNOWN SET OPERATION ");
                }
            }
            stringBuffer.append("[\n").append(this.sUnion).append("]\n");
        }
        return stringBuffer.toString();
    }

    private void preProcess() {
        boolean bl = this.isPreProcess;
        this.isPreProcess = true;
        try {
            this.getResult(1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.isPreProcess = bl;
    }

    Result describeResult() {
        Result result = new Result(3, this.iResultLen);
        Result.ResultMetaData resultMetaData = result.metaData;
        int n = 0;
        while (n < this.iResultLen) {
            Expression expression = this.eColumn[n];
            resultMetaData.colType[n] = expression.getDataType();
            resultMetaData.colSize[n] = expression.getColumnSize();
            resultMetaData.colScale[n] = expression.getColumnScale();
            resultMetaData.sLabel[n] = expression.getAlias();
            resultMetaData.isLabelQuoted[n] = expression.isAliasQuoted();
            resultMetaData.sTable[n] = expression.getTableName();
            resultMetaData.sName[n] = expression.getColumnName();
            if (resultMetaData.isTableColumn(n)) {
                resultMetaData.nullability[n] = expression.nullability;
                resultMetaData.isIdentity[n] = expression.isIdentity;
                resultMetaData.isWritable[n] = expression.isWritable;
            }
            ++n;
        }
        return result;
    }
}

