/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.BinaryServerRowInput;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;

class ServerConnection
implements Runnable {
    boolean keepAlive;
    private String user;
    int dbID;
    private Session session;
    private Socket socket;
    private Server server;
    private DataInputStream dataInput;
    private OutputStream dataOutput;
    private static int mCurrentThread = 0;
    private int mThread;
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    BinaryServerRowOutput rowOut = new BinaryServerRowOutput(4096);
    BinaryServerRowInput rowIn = new BinaryServerRowInput(this.rowOut);
    Thread runnerThread;
    static /* synthetic */ Class class$org$hsqldb$ServerConnection;

    ServerConnection(Socket socket, Server server) {
        this.socket = socket;
        this.server = server;
        Class clazz = class$org$hsqldb$ServerConnection == null ? (class$org$hsqldb$ServerConnection = ServerConnection.class$("org.hsqldb.ServerConnection")) : class$org$hsqldb$ServerConnection;
        synchronized (clazz) {
            this.mThread = mCurrentThread++;
        }
        HashSet hashSet = server.serverConnSet;
        synchronized (hashSet) {
            server.serverConnSet.add(this);
        }
    }

    void signalClose() {
        this.keepAlive = false;
        if (!this.runnerThread.equals(Thread.currentThread())) {
            this.close();
        }
    }

    private void close() {
        if (this.session != null) {
            this.session.close();
        }
        this.session = null;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashSet hashSet = this.server.serverConnSet;
        synchronized (hashSet) {
            this.server.serverConnSet.remove(this);
        }
    }

    private void init() {
        this.runnerThread = Thread.currentThread();
        this.keepAlive = true;
        try {
            Result result;
            this.socket.setTcpNoDelay(true);
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
            Result result2 = Result.read(this.rowIn, this.dataInput);
            try {
                int n = ArrayUtil.find(this.server.dbAlias, result2.subSubString);
                this.dbID = this.server.dbID[n];
                this.user = result2.getMainString();
                this.server.trace(this.mThread + ":trying to connect user " + this.user);
                this.session = DatabaseManager.newSession(this.dbID, result2.getMainString(), result2.getSubString());
                result = new Result(1);
                result.databaseID = this.session.getDatabase().databaseID;
                result.sessionID = this.session.getId();
            }
            catch (HsqlException hsqlException) {
                this.session = null;
                result = new Result(hsqlException, null);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.session = null;
                result = new Result(Trace.getError(94, null), result2.subSubString);
            }
            Result.write(result, this.rowOut, this.dataOutput);
            return;
        }
        catch (Exception exception) {
            this.server.trace(this.mThread + ":couldn't connect " + this.user);
            this.close();
            return;
        }
    }

    public void run() {
        this.init();
        if (this.session != null) {
            try {
                while (this.keepAlive) {
                    Result result = Result.read(this.rowIn, this.dataInput);
                    this.server.traceRequest(this.mThread, result);
                    Result result2 = this.session.execute(result);
                    Result.write(result2, this.rowOut, this.dataOutput);
                    this.rowOut.setBuffer(this.mainBuffer);
                    this.rowIn.resetRow(this.mainBuffer.length);
                }
            }
            catch (IOException iOException) {
                this.server.trace(this.mThread + ":disconnected " + this.user);
            }
            catch (HsqlException hsqlException) {
                this.server.printStackTrace(hsqlException);
            }
            this.close();
        }
    }

    String getConnectionThreadName() {
        return "HSQLDB Connection @" + Integer.toString(this.hashCode(), 16);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

