/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CompiledStatement;
import org.hsqldb.CompiledStatementExecutor;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.Database;
import org.hsqldb.DatabaseCommandInterpreter;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.SessionInterface;
import org.hsqldb.Table;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.User;
import org.hsqldb.jdbcConnection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.store.ValuePool;

class Session
implements SessionInterface {
    private Database dDatabase;
    private User uUser;
    private HsqlArrayList tTransaction;
    private boolean isAutoCommit;
    private boolean isNestedTransaction;
    private boolean isNestedOldAutoCommit;
    private int nestedOldTransIndex;
    private boolean isReadOnly;
    private int currentMaxRows;
    private int sessionMaxRows;
    private Number iLastIdentity = ValuePool.getInt(0);
    private boolean isClosed;
    private int iId;
    private HashMappedList savepoints;
    private boolean script;
    private jdbcConnection intConnection;
    static final Result emptyUpdateCount = new Result(1);
    private final long connectTime = System.currentTimeMillis();
    DatabaseCommandInterpreter dbCommandInterpreter;
    CompiledStatementExecutor compiledStatementExecutor;
    CompiledStatementManager compiledStatementManager;
    static final int INFO_DATABASE = 0;
    static final int INFO_USER = 1;
    static final int INFO_SESSION_ID = 2;
    static final int INFO_IDENTITY = 3;
    static final int INFO_AUTOCOMMIT = 4;
    static final int INFO_DATABASE_READONLY = 5;
    static final int INFO_CONNECTION_READONLY = 6;

    public Session getSession() {
        return this;
    }

    Session(Database database, User user, boolean bl, boolean bl2, int n) {
        this.iId = n;
        this.dDatabase = database;
        this.uUser = user;
        this.tTransaction = new HsqlArrayList();
        this.savepoints = new HashMappedList(4);
        this.isAutoCommit = bl;
        this.isReadOnly = bl2;
        this.dbCommandInterpreter = new DatabaseCommandInterpreter(this);
        this.compiledStatementExecutor = new CompiledStatementExecutor(this);
        this.compiledStatementManager = database.compiledStatementManager;
    }

    public int getId() {
        return this.iId;
    }

    public void close() {
        if (!this.isClosed) {
            Database database = this.dDatabase;
            synchronized (database) {
                this.dDatabase.sessionManager.processDisconnect(this);
            }
        }
    }

    void disconnect() {
        if (this.isClosed) {
            return;
        }
        this.rollback();
        this.dDatabase.dropTempTables(this);
        this.compiledStatementManager.processDisconnect(this.iId);
        this.dDatabase = null;
        this.uUser = null;
        this.tTransaction = null;
        this.savepoints = null;
        this.intConnection = null;
        this.compiledStatementExecutor = null;
        this.compiledStatementManager = null;
        this.dbCommandInterpreter = null;
        this.iLastIdentity = null;
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void setLastIdentity(Number number) {
        this.iLastIdentity = number;
    }

    Number getLastIdentity() {
        return this.iLastIdentity;
    }

    Database getDatabase() {
        return this.dDatabase;
    }

    String getUsername() {
        return this.uUser.getName();
    }

    User getUser() {
        return this.uUser;
    }

    void setUser(User user) {
        this.uUser = user;
    }

    int getMaxRows() {
        return this.currentMaxRows;
    }

    int getSQLMaxRows() {
        return this.sessionMaxRows;
    }

    void setSQLMaxRows(int n) {
        this.currentMaxRows = this.sessionMaxRows = n;
    }

    void checkAdmin() throws HsqlException {
        this.uUser.checkAdmin();
    }

    void check(Object object, int n) throws HsqlException {
        this.uUser.check(object, n);
    }

    void checkReadWrite() throws HsqlException {
        Trace.check(!this.isReadOnly, 31);
    }

    void checkDDLWrite() throws HsqlException {
        boolean bl = this.uUser.isSys() || !this.dDatabase.filesReadOnly;
        Trace.check(bl, 31);
    }

    void setPassword(String string) {
        this.uUser.setPassword(string);
    }

    void addTransactionDelete(Table table, Object[] objectArray) throws HsqlException {
        if (!this.isAutoCommit) {
            Transaction transaction = new Transaction(true, this.isNestedTransaction, table, objectArray);
            this.tTransaction.add(transaction);
        }
    }

    void addTransactionInsert(Table table, Object[] objectArray) throws HsqlException {
        if (!this.isAutoCommit) {
            Transaction transaction = new Transaction(false, this.isNestedTransaction, table, objectArray);
            this.tTransaction.add(transaction);
        }
    }

    public void setAutoCommit(boolean bl) {
        if (bl != this.isAutoCommit) {
            this.commit();
            this.isAutoCommit = bl;
        }
    }

    public void commit() {
        if (!this.tTransaction.isEmpty()) {
            try {
                this.dDatabase.logger.writeToLog(this, "COMMIT");
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.tTransaction.clear();
        }
        this.savepoints.clear();
    }

    public void rollback() {
        int n = this.tTransaction.size();
        Database database = this.dDatabase;
        synchronized (database) {
            while (n-- > 0) {
                Transaction transaction = (Transaction)this.tTransaction.get(n);
                transaction.rollback(this);
            }
        }
        if (!this.tTransaction.isEmpty()) {
            try {
                this.dDatabase.logger.writeToLog(this, "ROLLBACK");
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.tTransaction.clear();
        }
        this.savepoints.clear();
    }

    void savepoint(String string) throws HsqlException {
        this.savepoints.remove(string);
        this.savepoints.add(string, ValuePool.getInt(this.tTransaction.size()));
        try {
            this.dDatabase.logger.writeToLog(this, "SAVEPOINT " + string);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void rollbackToSavepoint(String string) throws HsqlException {
        int n = this.savepoints.getIndex(string);
        Trace.check(n >= 0, 44, string);
        Integer n2 = (Integer)this.savepoints.get(n);
        n = n2;
        int n3 = this.tTransaction.size() - 1;
        while (n3 >= n) {
            Transaction transaction = (Transaction)this.tTransaction.get(n3);
            transaction.rollback(this);
            this.tTransaction.remove(n3);
            --n3;
        }
        this.releaseSavepoint(string);
        try {
            this.dDatabase.logger.writeToLog(this, "ROLLBACK TO SAVEPOINT " + string);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void releaseSavepoint(String string) throws HsqlException {
        int n = this.savepoints.getIndex(string);
        Trace.check(n >= 0, 44, string);
        while (this.savepoints.size() > n) {
            this.savepoints.remove(this.savepoints.size() - 1);
        }
    }

    void beginNestedTransaction() throws HsqlException {
        Trace.doAssert(!this.isNestedTransaction, "beginNestedTransaction");
        this.isNestedOldAutoCommit = this.isAutoCommit;
        this.isAutoCommit = false;
        this.nestedOldTransIndex = this.tTransaction.size();
        this.isNestedTransaction = true;
    }

    void endNestedTransaction(boolean bl) throws HsqlException {
        Trace.doAssert(this.isNestedTransaction, "endNestedTransaction");
        if (bl) {
            int n = this.tTransaction.size();
            while (n-- > this.nestedOldTransIndex) {
                Transaction transaction = (Transaction)this.tTransaction.get(n);
                transaction.rollback(this);
            }
        }
        this.isNestedTransaction = false;
        this.isAutoCommit = this.isNestedOldAutoCommit;
        if (this.isAutoCommit) {
            this.tTransaction.setSize(this.nestedOldTransIndex);
        }
    }

    public void setReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.dDatabase.databaseReadOnly) {
            throw Trace.error(31);
        }
        this.isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    boolean isNestedTransaction() {
        return this.isNestedTransaction;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    void setScripting(boolean bl) {
        this.script = bl;
    }

    boolean getScripting() {
        return this.script;
    }

    String getAutoCommitStatement() {
        return this.isAutoCommit ? "SET AUTOCOMMIT TRUE" : "SET AUTOCOMMIT FALSE";
    }

    jdbcConnection getInternalConnection() throws HsqlException {
        if (this.intConnection == null) {
            this.intConnection = new jdbcConnection(this);
        }
        return this.intConnection;
    }

    boolean isAdmin() {
        return this.uUser.isAdmin();
    }

    long getConnectTime() {
        return this.connectTime;
    }

    int getTransactionSize() {
        return this.tTransaction.size();
    }

    boolean isAccessible(Object object) throws HsqlException {
        return this.uUser.isAccessible(object);
    }

    HashSet getGrantedClassNames(boolean bl) {
        return this.isAdmin() ? this.dDatabase.getUserManager().getGrantedClassNames() : this.uUser.getGrantedClassNames(bl);
    }

    /*
     * Unable to fully structure code
     */
    private CompiledStatement sqlCompileStatement(String var1_1, int var2_2) throws HsqlException {
        var3_3 = new Tokenizer(var1_1);
        var5_4 = new Parser(this.dDatabase, var3_3, this);
        var4_5 = var3_3.getString();
        var6_6 = Token.get(var4_5);
        var8_7 = true;
        switch (var6_6) {
            case 39: {
                var7_8 = var5_4.compileSelectStatement(null);
                break;
            }
            case 21: {
                var7_8 = var5_4.compileInsertStatement(null);
                break;
            }
            case 48: {
                var7_8 = var5_4.compileUpdateStatement(null);
                break;
            }
            case 13: {
                var7_8 = var5_4.compileDeleteStatement(null);
                break;
            }
            case 6: {
                if (var2_2 != 6) {
                    throw Trace.error(38, "not a CALL statement");
                }
                var7_8 = var5_4.compileCallStatement(null);
                break;
            }
            default: {
                var8_7 = false;
                var7_8 = null;
            }
        }
        if (var8_7) ** GOTO lbl31
        throw Trace.error(11, var4_5);
lbl-1000:
        // 1 sources

        {
            var4_5 = var3_3.getString();
            Trace.check(var4_5.length() == 0 || var4_5.equals(";") != false, 11, var4_5);
lbl31:
            // 2 sources

            ** while (var3_3.getPosition() < var3_3.getLength())
        }
lbl32:
        // 1 sources

        var7_8.sql = var1_1;
        return var7_8;
    }

    public Result execute(Result result) {
        try {
            Trace.doAssert(!this.isNestedTransaction);
            Trace.check(!this.isClosed, 33, "Session is closed");
        }
        catch (Throwable throwable) {
            return new Result(throwable, null);
        }
        int n = result.iMode;
        Database database = this.dDatabase;
        synchronized (database) {
            if (this.sessionMaxRows == 0) {
                this.currentMaxRows = result.iUpdateCount;
            }
            DatabaseManager.gc();
            switch (n) {
                case 65548: {
                    Result result2 = this.sqlExecute(result);
                    return result2;
                }
                case 9: {
                    Result result3 = this.sqlExecuteBatch(result);
                    return result3;
                }
                case 65547: {
                    Result result4 = this.sqlExecuteDirectNoPreChecks(result.getMainString());
                    return result4;
                }
                case 8: {
                    Result result5 = this.sqlExecuteBatchDirect(result);
                    return result5;
                }
                case 65555: {
                    Result result6 = this.sqlPrepare(result.getMainString(), result.getStatementType());
                    return result6;
                }
                case 65552: {
                    Result result7 = this.sqlFreeStatement(result.getStatementID());
                    return result7;
                }
                case 7: {
                    Result result8 = this.getAttributes();
                    return result8;
                }
                case 6: {
                    Result result9 = this.setAttributes(result);
                    return result9;
                }
                case 66541: {
                    Object object;
                    switch (result.getEndTranType()) {
                        case 0: {
                            this.commit();
                            break;
                        }
                        case 1: {
                            this.rollback();
                            break;
                        }
                        case 4: {
                            try {
                                object = result.getMainString();
                                this.releaseSavepoint((String)object);
                                break;
                            }
                            catch (Throwable throwable) {
                                Result result10 = new Result(throwable, null);
                                return result10;
                            }
                        }
                        case 2: {
                            try {
                                this.rollbackToSavepoint(result.getMainString());
                                break;
                            }
                            catch (Throwable throwable) {
                                Result result11 = new Result(throwable, null);
                                return result11;
                            }
                        }
                    }
                    object = emptyUpdateCount;
                    return object;
                }
                case 66552: {
                    switch (result.getConnectionAttrType()) {
                        case 10027: {
                            try {
                                this.savepoint(result.getMainString());
                                break;
                            }
                            catch (Throwable throwable) {
                                Result result12 = new Result(throwable, null);
                                return result12;
                            }
                        }
                    }
                    Result result13 = emptyUpdateCount;
                    return result13;
                }
                case 65545: {
                    this.close();
                    Result result14 = emptyUpdateCount;
                    return result14;
                }
            }
            String string = "operation type:" + n;
            Result result15 = new Result(string, "s1000", 73);
            return result15;
        }
    }

    synchronized Result sqlExecuteDirect(String string) {
        try {
            Trace.doAssert(!this.isNestedTransaction);
            Trace.check(!this.isClosed, 33, "Session is closed");
            Database database = this.dDatabase;
            synchronized (database) {
                Trace.check(!this.dDatabase.isShutdown(), 4);
                Result result = this.dbCommandInterpreter.execute(string);
                return result;
            }
        }
        catch (Throwable throwable) {
            return new Result(throwable, null);
        }
    }

    Result sqlExecuteDirectNoPreChecks(String string) {
        return this.dbCommandInterpreter.execute(string);
    }

    synchronized Result sqlExecuteCompiled(CompiledStatement compiledStatement) {
        try {
            Trace.doAssert(!this.isNestedTransaction);
            Trace.check(!this.isClosed, 33, "Session is closed");
            Database database = this.dDatabase;
            synchronized (database) {
                Trace.check(!this.dDatabase.isShutdown(), 4);
                Result result = this.compiledStatementExecutor.execute(compiledStatement);
                return result;
            }
        }
        catch (Throwable throwable) {
            return new Result(throwable, null);
        }
    }

    Result sqlExecuteCompiledNoPreChecks(CompiledStatement compiledStatement) {
        return this.compiledStatementExecutor.execute(compiledStatement);
    }

    private Result sqlPrepare(String string, int n) {
        CompiledStatement compiledStatement = null;
        int n2 = this.compiledStatementManager.getStatementID(string);
        if (n2 > 0 && this.compiledStatementManager.isValid(n2, this.iId)) {
            compiledStatement = this.compiledStatementManager.getStatement(n2);
            Result result = compiledStatement.describeResultSet();
            Result result2 = compiledStatement.describeParameters();
            return Result.newPrepareResponse(n2, result, result2);
        }
        try {
            compiledStatement = this.sqlCompileStatement(string, n);
        }
        catch (Throwable throwable) {
            return new Result(throwable, string);
        }
        if (n2 <= 0) {
            n2 = this.compiledStatementManager.registerStatement(compiledStatement);
        }
        this.compiledStatementManager.setValidated(n2, this.iId, this.dDatabase.getDDLSCN());
        Result result = compiledStatement.describeResultSet();
        Result result3 = compiledStatement.describeParameters();
        return Result.newPrepareResponse(n2, result, result3);
    }

    private Result sqlExecuteBatch(Result result) {
        Result result2;
        int n = result.getStatementID();
        CompiledStatement compiledStatement = this.compiledStatementManager.getStatement(n);
        if (compiledStatement == null) {
            String string = "Statement not prepared for csid: " + n;
            return new Result(string, "22019", 74);
        }
        if (!this.compiledStatementManager.isValid(n, this.iId)) {
            result2 = this.sqlPrepare(compiledStatement.sql, compiledStatement.type);
            if (result2.iMode == 2) {
                return result2;
            }
        }
        Expression[] expressionArray = compiledStatement.parameters;
        int n2 = 0;
        int[] nArray = new int[result.getSize()];
        Record record = result.rRoot;
        result2 = new Result(65548, nArray, 0);
        Result result3 = new Result(2);
        while (record != null) {
            Object[] objectArray = record.data;
            Result result4 = result3;
            try {
                int n3 = 0;
                while (n3 < expressionArray.length) {
                    expressionArray[n3].bind(objectArray[n3]);
                    ++n3;
                }
                result4 = this.compiledStatementExecutor.execute(compiledStatement);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            switch (result4.iMode) {
                case 1: {
                    nArray[n2++] = result4.iUpdateCount;
                    break;
                }
                case 3: {
                    nArray[n2++] = -2;
                    break;
                }
                default: {
                    nArray[n2++] = -3;
                }
            }
            record = record.next;
        }
        return result2;
    }

    private Result sqlExecuteBatchDirect(Result result) {
        int n = 0;
        int[] nArray = new int[result.getSize()];
        Record record = result.rRoot;
        Result result2 = new Result(65548, nArray, 0);
        Result result3 = new Result(2);
        while (record != null) {
            String string = (String)record.data[0];
            Result result4 = result3;
            try {
                result4 = this.dbCommandInterpreter.execute(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            switch (result4.iMode) {
                case 1: {
                    nArray[n++] = result4.iUpdateCount;
                    break;
                }
                case 3: {
                    nArray[n++] = -2;
                    break;
                }
                default: {
                    nArray[n++] = -3;
                }
            }
            record = record.next;
        }
        return result2;
    }

    private Result sqlExecute(Result result) {
        int n = result.getStatementID();
        Object[] objectArray = result.getParameterData();
        CompiledStatement compiledStatement = this.compiledStatementManager.getStatement(n);
        if (compiledStatement == null) {
            String string = "Statement not prepared for csid: " + n;
            return new Result(string, "22019", 74);
        }
        if (!this.compiledStatementManager.isValid(n, this.iId)) {
            Result result2 = this.sqlPrepare(compiledStatement.sql, compiledStatement.type);
            if (result2.iMode == 2) {
                return result2;
            }
        }
        Expression[] expressionArray = compiledStatement.parameters;
        try {
            int n2 = 0;
            while (n2 < expressionArray.length) {
                expressionArray[n2].bind(objectArray[n2]);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            return new Result(throwable, compiledStatement.sql);
        }
        return this.compiledStatementExecutor.execute(compiledStatement);
    }

    private Result sqlFreeStatement(int n) {
        boolean bl = this.compiledStatementManager.freeStatement(n, this.iId);
        Result result = new Result(1);
        if (bl) {
            result.iUpdateCount = 1;
        }
        return result;
    }

    Result getAttributes() {
        Result result = new Result(3, 7);
        result.metaData.sTable = new String[]{"", "", "", "", "", "", ""};
        result.metaData.sLabel = result.metaData.sTable;
        result.metaData.sName = result.metaData.sTable;
        result.metaData.colType = new int[]{12, 12, 4, this.iLastIdentity instanceof Long ? -5 : 4, 16, 16, 16};
        Object[] objectArray = new Object[]{this.dDatabase.getPath(), this.getUsername(), ValuePool.getInt(this.iId), this.iLastIdentity, ValuePool.getBoolean(this.isAutoCommit), ValuePool.getBoolean(this.dDatabase.databaseReadOnly), ValuePool.getBoolean(this.isReadOnly)};
        result.add(objectArray);
        return result;
    }

    Result setAttributes(Result result) {
        Object[] objectArray = result.rRoot.data;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object != null) {
                try {
                    switch (n) {
                        case 4: {
                            this.setAutoCommit((Boolean)object);
                            break;
                        }
                        case 6: {
                            this.setReadOnly((Boolean)object);
                        }
                    }
                }
                catch (HsqlException hsqlException) {
                    return new Result(hsqlException, null);
                }
            }
            ++n;
        }
        return emptyUpdateCount;
    }
}

