/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.User;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

public class SessionManager {
    int sessionIdCount;
    private IntKeyHashMap sessionMap = new IntKeyHashMap();
    Session sysSession;

    public SessionManager(Database database, User user) {
        this.sysSession = this.newSession(database, user, false);
    }

    Session newSession(Database database, User user, boolean bl) {
        Session session = new Session(database, user, true, bl, this.sessionIdCount);
        this.sessionMap.put(this.sessionIdCount, session);
        ++this.sessionIdCount;
        return session;
    }

    Session getSysSession() {
        return this.sysSession;
    }

    void closeAllSessions() {
        Iterator iterator = this.sessionMap.values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session == this.sysSession) continue;
            iterator.remove();
            session.disconnect();
        }
    }

    Result processDisconnect(Session session) {
        this.sessionMap.remove(session.getId());
        session.disconnect();
        return new Result(1);
    }

    void clearAll() {
        this.sessionMap.clear();
    }

    HsqlArrayList listVisibleSessions(Session session) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl = session.isAdmin();
        int n = session.getId();
        Iterator iterator = this.sessionMap.values().iterator();
        while (iterator.hasNext()) {
            Session session2 = (Session)iterator.next();
            if (!bl && session2.getId() != n) continue;
            hsqlArrayList.add(session2);
        }
        return hsqlArrayList;
    }

    Session getSession(int n) {
        return (Session)this.sessionMap.get(n);
    }
}

