/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Cache;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlStringBuffer;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.store.ValuePool;

class Table {
    static final int SYSTEM_TABLE = 0;
    static final int TEMP_TABLE = 1;
    static final int MEMORY_TABLE = 2;
    static final int CACHED_TABLE = 3;
    static final int TEMP_TEXT_TABLE = 4;
    static final int TEXT_TABLE = 5;
    static final int VIEW = 6;
    static final int SYSTEM_VIEW = 7;
    static final String DEFAULT_PK = "";
    HashMappedList vColumn;
    HsqlArrayList vIndex;
    int[] iPrimaryKey;
    int iIndexCount;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    boolean needsRowID;
    int[] nullRowIDCols;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    HsqlArrayList vConstraint;
    HsqlArrayList[] vTrigs;
    private int[] colTypes;
    private int[] colSizes;
    private boolean[] colNullable;
    private String[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    private boolean isSystem;
    private boolean isText;
    private boolean isView;
    boolean sqlEnforceSize;
    boolean sqlEnforceStrictSize;
    protected int iColumnCount;
    protected int iVisibleColumns;
    protected Database database;
    protected Cache cache;
    protected HsqlNameManager.HsqlName tableName;
    protected int tableType;
    protected int ownerSessionId;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;
    HashSet constraintPath = new HashSet();

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceSize;
        this.sqlEnforceStrictSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(database.firstIdentity);
        this.rowIdSequence = new NumberSequence(0L);
        switch (n) {
            case 0: {
                this.isTemp = true;
                break;
            }
            case 1: {
                this.isTemp = true;
                this.ownerSessionId = n2;
                break;
            }
            case 3: {
                this.cache = database.logger.getCache();
                if (this.cache != null) {
                    this.isCached = true;
                    break;
                }
                n = 2;
                break;
            }
            case 4: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.isCached = true;
                this.ownerSessionId = n2;
                break;
            }
            case 5: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.isCached = true;
                break;
            }
            case 6: {
                this.isView = true;
            }
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.iPrimaryKey = null;
        this.identityColumn = -1;
        this.vColumn = new HashMappedList();
        this.vIndex = new HsqlArrayList();
        this.vConstraint = new HsqlArrayList();
        this.vTrigs = new HsqlArrayList[12];
        int n3 = 0;
        while (n3 < 12) {
            this.vTrigs[n3] = new HsqlArrayList();
            ++n3;
        }
        if (database.filesReadOnly && this.checkTableFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(String string, Session session) {
        if (this.isTemp && session.getId() != this.ownerSessionId) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    final boolean isText() {
        return this.isText;
    }

    final boolean isTemp() {
        return this.isTemp;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.filesReadOnly && this.checkTableFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean checkTableFileBased() {
        return this.isCached | this.isText;
    }

    int getOwnerSessionId() {
        return this.ownerSessionId;
    }

    protected void setDataSource(String string, boolean bl, Session session) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.vConstraint.add(constraint);
    }

    HsqlArrayList getConstraints() {
        return this.vConstraint;
    }

    Index getConstraintIndexForColumns(int[] nArray, boolean bl) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, bl)) {
            return this.getPrimaryIndex();
        }
        int n = 0;
        int n2 = this.vConstraint.size();
        while (n < n2) {
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (constraint.getType() == 2 && ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, bl)) {
                return constraint.getMainIndex();
            }
            ++n;
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = this.vConstraint.size();
        while (n < n2) {
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (constraint.isEquivalent(table, nArray, this, nArray2)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    Constraint getAutoIndexConstraintForColumns(int[] nArray) {
        int n = 0;
        int n2 = this.vConstraint.size();
        while (n < n2) {
            Index index;
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (constraint.getType() == 0 && !(index = constraint.getRefIndex()).isUnique() && index.getName().isReservedIndexName() && ArrayUtil.areEqual(nArray, index.getColumns(), index.getVisibleColumns(), false)) {
                return constraint;
            }
            ++n;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = n;
        int n4 = this.vConstraint.size();
        while (n3 < n4) {
            Constraint constraint = (Constraint)this.vConstraint.get(n3);
            if (constraint.getType() == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void addColumn(String string, int n) throws HsqlException {
        Column column = new Column(this.database.nameManager.newHsqlName(string, false), true, n, 0, 0, false, 0, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws HsqlException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.iColumnCount;
        }
        Trace.doAssert(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.add(column.columnName.name, column);
        ++this.iColumnCount;
        ++this.iVisibleColumns;
    }

    void addColumns(Result result) throws HsqlException {
        int n = result.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            Column column = new Column(this.database.nameManager.newHsqlName(result.metaData.sLabel[n2], result.metaData.isLabelQuoted[n2]), true, result.metaData.colType[n2], result.metaData.colSize[n2], result.metaData.colScale[n2], false, 0, false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = select.eColumn[n2];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, 0, false, null);
            this.addColumn(column);
            ++n2;
        }
    }

    HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType, this.ownerSessionId);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= this.iColumnCount || nArray2[n] >= table.iColumnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[n]).getType() != table.getColumn(nArray2[n]).getType()) {
                throw Trace.error(57);
            }
            ++n;
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws HsqlException {
        int[] nArray;
        Table table = this.duplicate();
        int n3 = 0;
        while (n3 < this.iVisibleColumns + 1) {
            block10: {
                block8: {
                    block9: {
                        if (n3 != n) break block8;
                        if (n2 <= 0) break block9;
                        table.addColumn(column);
                        break block8;
                    }
                    if (n2 < 0) break block10;
                }
                if (n3 == this.iVisibleColumns) break;
                table.addColumn(this.getColumn(n3));
            }
            ++n3;
        }
        int[] nArray2 = nArray = this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, false);
        table.vConstraint = this.vConstraint;
        int n4 = 1;
        while (n4 < this.getIndexCount()) {
            Index index;
            Index index2 = this.getIndex(n4);
            if (!(string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null)) {
                throw Trace.error(123);
            }
            ++n4;
        }
        table.vTrigs = this.vTrigs;
        return table;
    }

    void updateConstraints(Table table, int n, int n2) throws HsqlException {
        int n3 = 0;
        int n4 = this.vConstraint.size();
        while (n3 < n4) {
            Constraint constraint = (Constraint)this.vConstraint.get(n3);
            constraint.replaceTable(table, this, n, n2);
            ++n3;
        }
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = this.vColumn.getIndex(string);
        return n == this.iVisibleColumns ? -1 : n;
    }

    Index getPrimaryIndex() {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    int[] getPrimaryKey() {
        return this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    private void setBestRowIdentifiers() {
        int[] nArray = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndexForColumn = new int[this.vColumn.size()];
        this.nullRowIDCols = new int[this.vColumn.size()];
        int n3 = 0;
        while (n3 < this.bestIndexForColumn.length) {
            this.bestIndexForColumn[n3] = -1;
            this.nullRowIDCols[n3] = -1;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.vIndex.size()) {
            Index index = (Index)this.vIndex.get(n4);
            int[] nArray2 = index.getColumns();
            int n5 = index.getVisibleColumns();
            if (n4 != 0 || this.getPrimaryKey() != null) {
                if (this.bestIndexForColumn[nArray2[0]] == -1) {
                    this.bestIndexForColumn[nArray2[0]] = n4;
                }
                if (index.isUnique()) {
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n5) {
                        if (!this.colNullable[nArray2[n7]]) {
                            ++n6;
                        } else {
                            this.nullRowIDCols[nArray2[n7]] = nArray2[n7];
                        }
                        ++n7;
                    }
                    if (n6 == n5) {
                        if (nArray == null || n != n2 || n5 < n) {
                            nArray = nArray2;
                            n = n5;
                            n2 = n5;
                            bl = true;
                        }
                    } else if (!(bl || nArray != null && n5 >= n && n6 <= n2)) {
                        nArray = nArray2;
                        n = n5;
                        n2 = n6;
                    }
                }
            }
            ++n4;
        }
        this.bestRowIdentifierCols = nArray == null || n == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n);
        this.bestRowIdentifierStrict = bl;
        ArrayUtil.sortArray(this.nullRowIDCols);
        int n8 = ArrayUtil.findNot(this.nullRowIDCols, -1);
        this.nullRowIDCols = n8 == -1 ? null : ArrayUtil.arraySlice(this.nullRowIDCols, 0, n8);
        this.needsRowID = this.getPrimaryKey() == null;
    }

    Index getIndexForColumn(int n) throws HsqlException {
        int n2 = this.bestIndexForColumn[n];
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            if (ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) && (!bl || index.isUnique())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int[] getIndexRootsArray() {
        int[] nArray = new int[this.iIndexCount];
        int n = 0;
        while (n < this.iIndexCount) {
            Node node = this.getIndex(n).getRoot();
            nArray[n] = node != null ? node.getKey() : -1;
            ++n;
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(string);
        hsqlStringBuffer.append(' ');
        hsqlStringBuffer.append(this.identitySequence.peek());
        return hsqlStringBuffer.toString();
    }

    void setIndexRootsNull() {
        int n = 0;
        while (n < this.iIndexCount) {
            this.getIndex(n).setRoot(null);
            ++n;
        }
        this.identitySequence.reset(this.database.firstIdentity);
    }

    void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        int n = 0;
        while (n < this.iIndexCount) {
            int n2 = nArray[n];
            CachedRow cachedRow = null;
            if (n2 != -1) {
                cachedRow = this.cache.getRow(n2, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(n);
            }
            this.getIndex(n).setRoot(node);
            ++n;
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached, 22);
        int[] nArray = new int[this.iIndexCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3;
            int n4 = string.indexOf(32, n);
            nArray[n2] = n3 = Integer.parseInt(string.substring(n, n4));
            n = n4 + 1;
            ++n2;
        }
        this.setIndexRoots(nArray);
        this.identitySequence.reset(Long.parseLong(string.substring(n)));
    }

    Index getNextIndex(Index index) {
        int n = 0;
        if (index != null) {
            while (n < this.iIndexCount && this.getIndex(n) != index) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        Trace.doAssert(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        Column column = new Column(this.database.nameManager.newAutoName(DEFAULT_PK), false, 4, 0, 0, false, 0, nArray == null, null);
        this.addColumn(column);
        --this.iVisibleColumns;
        if (nArray == null) {
            nArray = new int[]{this.iVisibleColumns};
        } else {
            int n = 0;
            while (n < nArray.length) {
                if (bl) {
                    this.getColumn(nArray[n]).setNullable(false);
                }
                this.getColumn(nArray[n]).setPrimaryKey(true);
                ++n;
            }
        }
        this.iPrimaryKey = nArray;
        HsqlNameManager.HsqlName hsqlName2 = hsqlName != null ? hsqlName : this.database.nameManager.newHsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexStructure(nArray, hsqlName2, true, true);
        this.colTypes = new int[this.iColumnCount];
        this.colDefaults = new String[this.iVisibleColumns];
        this.colSizes = new int[this.iVisibleColumns];
        this.colNullable = new boolean[this.iVisibleColumns];
        this.defaultColumnMap = new int[this.iVisibleColumns];
        int n = 0;
        while (n < this.iColumnCount) {
            column = this.getColumn(n);
            this.colTypes[n] = column.getType();
            if (n < this.iVisibleColumns) {
                this.hasDefaultValues = this.hasDefaultValues || column.getDefaultString() != null;
                this.colDefaults[n] = column.getDefaultString();
                this.colSizes[n] = column.getSize();
                this.colNullable[n] = column.isNullable() || column.isIdentity();
                this.defaultColumnMap[n] = n;
            }
            if (column.isIdentity()) {
                this.identitySequence.reset(column.identityStart);
            }
            ++n;
        }
        this.setBestRowIdentifiers();
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), index.isUnique(), false);
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl) throws HsqlException {
        Index index = this.createIndexStructure(nArray, hsqlName, bl, false);
        Index index2 = this.getPrimaryIndex();
        Node node = index2.first();
        int n = 0;
        try {
            while (node != null) {
                Row row = node.getRow();
                Node node2 = Node.newNode(row, this.iIndexCount - 1, this);
                Node node3 = row.getNode(this.iIndexCount - 2);
                node3.nNext = node2;
                index.insert(node2);
                node = index2.next(node);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n = 72;
        }
        catch (HsqlException hsqlException) {
            n = 9;
        }
        Node node4 = node;
        node = index2.first();
        while (node != node4) {
            int n2 = this.iIndexCount - 2;
            Node node5 = node;
            while (n2-- > 0) {
                node5 = node5.nNext;
            }
            node5.nNext = null;
            node = index2.next(node);
        }
        this.vIndex.remove(this.iIndexCount - 1);
        this.iIndexCount = this.vIndex.size();
        this.setBestRowIdentifiers();
        throw Trace.error(n);
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2) throws HsqlException {
        Trace.doAssert(this.iPrimaryKey != null, "createIndex");
        int n = nArray.length;
        int n2 = bl2 ? 0 : this.iPrimaryKey.length;
        int[] nArray2 = new int[n + n2];
        int[] nArray3 = new int[n + n2];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = this.getColumn(nArray2[n3]).getType();
            ++n3;
        }
        if (!bl2) {
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n + n4] = this.iPrimaryKey[n4];
                nArray3[n + n4] = this.getColumn(this.iPrimaryKey[n4]).getType();
                ++n4;
            }
        }
        if (nArray2[0] == this.iVisibleColumns) {
            n = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl, n);
        this.vIndex.add(index);
        this.iIndexCount = this.vIndex.size();
        this.setBestRowIdentifiers();
        return index;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = 0;
        int n2 = this.vConstraint.size();
        while (n < n2) {
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (hashSet == null || !hashSet.contains(constraint)) {
                if (constraint.isIndexFK(index)) {
                    throw Trace.error(50, string);
                }
                if (constraint.isIndexUnique(index)) {
                    throw Trace.error(56, string);
                }
            }
            ++n;
        }
    }

    boolean isEmpty() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.iVisibleColumns];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.iVisibleColumns];
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    Object[] getNewRow(boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.iColumnCount];
        if (blArray != null && this.hasDefaultValues) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                String string = this.colDefaults[n];
                if (!blArray[n] && string != null) {
                    objectArray[n] = Column.convertObject(string, this.colTypes[n]);
                }
                ++n;
            }
        }
        return objectArray;
    }

    void dropIndex(String string) throws HsqlException {
        Index index;
        int n = 1;
        while (n < this.getIndexCount()) {
            index = this.getIndex(n);
            if (index.getName().name.equals(string)) {
                this.vIndex.remove(n);
                this.iIndexCount = this.vIndex.size();
                this.setBestRowIdentifiers();
                break;
            }
            ++n;
        }
        index = this.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            int n2 = n - 1;
            Node node2 = node;
            while (n2-- > 0) {
                node2 = node2.nNext;
            }
            node2.nNext = node2.nNext.nNext;
            node = index.next(node);
        }
    }

    void moveData(Table table, int n, int n2) throws HsqlException {
        Object object;
        Object object2 = null;
        if (n2 > 0) {
            object = this.getColumn(n);
            object2 = Column.convertObject(((Column)object).getDefaultString(), ((Column)object).getType());
        }
        object = table.getPrimaryIndex();
        Node node = ((Index)object).first();
        while (node != null) {
            Object[] objectArray = node.getData();
            Object[] objectArray2 = this.getNewRow();
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object2, n, n2);
            this.insertNoCheck(objectArray2, null, false);
            node = ((Index)object).next(node);
        }
        table.drop();
    }

    int insert(Result result, Session session) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.checkNullColumns(record.data);
            record = record.next;
        }
        record = result.rRoot;
        this.fireAll(3);
        while (record != null) {
            this.insertRow(record.data, session);
            record = record.next;
            ++n;
        }
        this.fireAll(0);
        return n;
    }

    void insert(Object[] objectArray, Session session) throws HsqlException {
        this.checkNullColumns(objectArray);
        this.fireAll(3);
        this.insertRow(objectArray, session);
        this.fireAll(0);
    }

    private void insertRow(Object[] objectArray, Session session) throws HsqlException {
        this.fireAll(9, null, objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = 0;
            int n2 = this.vConstraint.size();
            while (n < n2) {
                ((Constraint)this.vConstraint.get(n)).checkInsert(objectArray);
                ++n;
            }
        }
        this.insertNoCheck(objectArray, session, true);
        this.fireAll(6, null, objectArray);
    }

    void insertNoCheck(Result result, Session session) throws HsqlException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = record.data[n2];
                ++n2;
            }
            this.insertNoCheck(objectArray, session, true);
            record = record.next;
        }
    }

    void insertNoCheck(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        this.setIdentityColumn(objectArray, session);
        if (session != null) {
            this.enforceFieldValueLimits(objectArray);
        }
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (session != null) {
            session.addTransactionInsert(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeToLog(session, this, objectArray);
        }
    }

    void insertNoCheckRollback(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeToLog(session, this, objectArray);
        }
    }

    protected void insertNoChange(CachedDataRow cachedDataRow) throws HsqlException {
        Object[] objectArray = cachedDataRow.getData();
        this.checkNullColumns(objectArray);
        this.setIdentityColumn(objectArray, null);
        this.indexRow(cachedDataRow);
    }

    protected void checkNullColumns(Object[] objectArray) throws HsqlException {
        int n = 0;
        while (n < this.iVisibleColumns) {
            if (objectArray[n] == null && !this.colNullable[n]) {
                Trace.throwerror(10, "column: " + this.getColumn((int)n).columnName.name + " table: " + this.tableName.name);
            }
            ++n;
        }
    }

    protected void setIdentityColumn(Object[] objectArray, Session session) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null) {
                session.setLastIdentity(number);
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                if (this.colSizes[n] != 0 && objectArray[n] != null) {
                    objectArray[n] = Table.enforceSize(objectArray[n], this.colTypes[n], this.colSizes[n], true, this.sqlEnforceStrictSize);
                }
                ++n;
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (this.colSizes[n2] != 0 && objectArray[n2] != null) {
                    objectArray[n2] = Table.enforceSize(objectArray[n2], this.colTypes[n2], this.colSizes[n2], true, this.sqlEnforceStrictSize);
                }
                ++n;
            }
        }
    }

    static Object enforceSize(Object object, int n, int n2, boolean bl, boolean bl2) throws HsqlException {
        if (n2 == 0) {
            return object;
        }
        switch (n) {
            case 1: {
                return Table.padOrTrunc((String)object, n2, bl, bl2);
            }
            case 12: {
                return Table.padOrTrunc((String)object, n2, false, bl2);
            }
        }
        return object;
    }

    static String padOrTrunc(String string, int n, boolean bl, boolean bl2) throws HsqlException {
        if (bl2 && StringUtil.rTrimSize(string) > n) {
            throw Trace.error(124);
        }
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        HsqlStringBuffer hsqlStringBuffer = new HsqlStringBuffer(n);
        hsqlStringBuffer.append(string);
        if (bl) {
            int n2 = string.length();
            while (n2 < n) {
                hsqlStringBuffer.append(' ');
                ++n2;
            }
        }
        return hsqlStringBuffer.toString();
    }

    void fireAll(int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.vTrigs[n];
        int n2 = 0;
        int n3 = hsqlArrayList.size();
        while (n2 < n3) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n2);
            triggerDef.pushPair(objectArray, objectArray2);
            ++n2;
        }
    }

    void fireAll(int n) {
        this.fireAll(n, null, null);
    }

    void addTrigger(TriggerDef triggerDef) {
        this.vTrigs[triggerDef.vectorIndx].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            HsqlArrayList hsqlArrayList = this.vTrigs[n2];
            int n3 = hsqlArrayList.size() - 1;
            while (n3 >= 0) {
                TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                if (triggerDef.name.name.equals(string)) {
                    hsqlArrayList.remove(n3);
                    triggerDef.terminate();
                }
                --n3;
            }
            ++n2;
        }
    }

    void checkCascadeDelete(Row row, Session session, boolean bl, HashSet hashSet) throws HsqlException {
        int n = 0;
        int n2 = this.vConstraint.size();
        while (n < n2) {
            Node node;
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (constraint.getType() == 1 && constraint.getRef() != null && (node = constraint.findFkRef(row.getData(), true)) != null) {
                Object object;
                boolean bl2;
                Table table = constraint.getRef();
                boolean bl3 = bl2 = table.getNextConstraintIndex(0, 1) != -1;
                if (!bl && !bl2) {
                    return;
                }
                Result result = new Result(3);
                Index index = constraint.getRefIndex();
                int[] nArray = constraint.getMainColumns();
                int[] nArray2 = constraint.getRefColumns();
                Object[] objectArray = new Object[nArray.length];
                ArrayUtil.copyColumnValues(row.getData(), nArray, objectArray);
                Object object2 = node;
                while (!((Node)object2).isDeleted() && index.comparePartialRowNonUnique(objectArray, ((Node)object2).getData()) == 0) {
                    object2 = ((Node)object2).getUpdatedNode();
                    object = index.next((Node)object2);
                    if (constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4) {
                        int n3;
                        Object[] objectArray2 = table.getNewRow();
                        System.arraycopy(((Node)object2).getData(), 0, objectArray2, 0, objectArray2.length);
                        if (constraint.getDeleteAction() == 2) {
                            n3 = 0;
                            while (n3 < nArray2.length) {
                                objectArray2[nArray2[n3]] = null;
                                ++n3;
                            }
                        } else {
                            n3 = 0;
                            while (n3 < nArray2.length) {
                                objectArray2[nArray2[n3]] = Column.convertObject(table.getColumn(nArray2[n3]).getDefaultString(), table.getColumn(nArray2[n3]).getType());
                                ++n3;
                            }
                        }
                        if (bl2 && hashSet.add(constraint)) {
                            table.checkCascadeUpdate(((Node)object2).getRow(), objectArray2, session, nArray2, null, bl, hashSet);
                            hashSet.remove(constraint);
                            object2 = ((Node)object2).getUpdatedNode();
                            Object object3 = object = object == null ? null : ((Node)object).getUpdatedNode();
                        }
                        if (bl && (table != this || ((Node)object2).getRow() != row.getUpdatedRow())) {
                            result.add(objectArray2);
                        }
                    } else if (bl2) {
                        if (table != this) {
                            if (hashSet.add(constraint)) {
                                table.checkCascadeDelete(((Node)object2).getRow(), session, bl, hashSet);
                                hashSet.remove(constraint);
                                object2 = ((Node)object2).getUpdatedNode();
                                object = object == null ? null : ((Node)object).getUpdatedNode();
                            }
                        } else {
                            Row row2 = row = row == null ? null : row.getUpdatedRow();
                            if (((Node)object2).getRow() != row) {
                                table.checkCascadeDelete(((Node)object2).getRow(), session, bl, hashSet);
                                object2 = ((Node)object2).getUpdatedNode();
                                Object object4 = object = object == null ? null : ((Node)object).getUpdatedNode();
                            }
                        }
                    }
                    if (bl && !((Node)object2).isDeleted()) {
                        table.deleteNoRefCheck(((Node)object2).getRow(), session);
                    }
                    if (object == null) break;
                    object2 = object;
                }
                if (bl) {
                    object = result.rRoot;
                    while (object != null) {
                        table.insertNoCheck(((Record)object).data, session, true);
                        object = ((Record)object).next;
                    }
                }
            }
            ++n;
        }
    }

    void checkCascadeUpdate(Row row, Object[] objectArray, Session session, int[] nArray, Table table, boolean bl, HashSet hashSet) throws HsqlException {
        int n = 0;
        while (n < this.vConstraint.size()) {
            Object object;
            int[] nArray2;
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if ((table == null || constraint.getMain() != table) && (nArray2 = ArrayUtil.commonElements(nArray, constraint.getRefColumns())) != null) {
                    object = constraint.findMainRef(objectArray);
                }
            } else if (constraint.getType() == 1 && constraint.getRef() != null && (nArray2 = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) != null) {
                Node node;
                object = constraint.getMainColumns();
                int[] nArray3 = constraint.getRefColumns();
                boolean bl2 = true;
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    if (!row.getData()[object[n2]].equals(objectArray[object[n2]])) {
                        bl2 = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl2 && (node = constraint.findFkRef(row.getData(), false)) != null) {
                    Object object2;
                    Table table2 = constraint.getRef();
                    boolean bl3 = table2.getNextConstraintIndex(0, 1) != -1;
                    Index index = constraint.getRefIndex();
                    Object[] objectArray2 = new Object[((Object)object).length];
                    Object[] objectArray3 = new Object[nArray3.length];
                    ArrayUtil.copyColumnValues(row.getData(), (int[])object, objectArray2);
                    ArrayUtil.copyColumnValues(objectArray, nArray3, objectArray3);
                    Result result = new Result(3);
                    Object object3 = node;
                    while (index.comparePartialRowNonUnique(objectArray2, ((Node)object3).getData()) == 0) {
                        int n3;
                        object3 = ((Node)object3).getUpdatedNode();
                        object2 = index.next((Node)object3);
                        Object[] objectArray4 = table2.getNewRow();
                        System.arraycopy(((Node)object3).getData(), 0, objectArray4, 0, objectArray4.length);
                        if (constraint.getUpdateAction() == 2) {
                            n3 = 0;
                            while (n3 < nArray3.length) {
                                objectArray4[nArray3[n3]] = null;
                                ++n3;
                            }
                        } else if (constraint.getUpdateAction() == 4) {
                            n3 = 0;
                            while (n3 < nArray3.length) {
                                objectArray4[nArray3[n3]] = Column.convertObject(table2.getColumn(nArray3[n3]).getDefaultString(), table2.getColumn(nArray3[n3]).getType());
                                ++n3;
                            }
                            if (hashSet.add(constraint)) {
                                table2.checkCascadeUpdate(((Node)object3).getRow(), objectArray4, session, nArray3, null, bl, hashSet);
                                hashSet.remove(constraint);
                            }
                        } else {
                            n3 = 0;
                            while (n3 < ((Object)object).length) {
                                objectArray4[nArray3[n3]] = objectArray[object[n3]];
                                ++n3;
                            }
                            if (hashSet.add(constraint)) {
                                table2.checkCascadeUpdate(((Node)object3).getRow(), objectArray4, session, nArray2, this, bl, hashSet);
                                hashSet.remove(constraint);
                            }
                        }
                        if (bl) {
                            result.add(objectArray4);
                            table2.deleteNoRefCheck(((Node)object3).getData(), session);
                            if (table2 == this) {
                                object2 = constraint.findFkRef(row.getData(), false);
                            }
                        }
                        if (object2 == null) break;
                        object3 = object2;
                    }
                    if (bl) {
                        object2 = result.rRoot;
                        while (object2 != null) {
                            table2.insertNoCheck(((Record)object2).data, session, true);
                            object2 = ((Record)object2).next;
                        }
                    }
                }
            }
            ++n;
        }
    }

    int delete(HsqlArrayList hsqlArrayList, Session session) throws HsqlException {
        Row row;
        boolean bl = false;
        int n = 0;
        while (n < hsqlArrayList.size()) {
            row = (Row)hsqlArrayList.get(n);
            this.delete(row, session, false);
            ++n;
        }
        this.fireAll(4);
        int n2 = 0;
        while (n2 < hsqlArrayList.size()) {
            row = (Row)hsqlArrayList.get(n2);
            this.delete(row, session, true);
            ++n2;
        }
        this.fireAll(1);
        return hsqlArrayList.size();
    }

    private void delete(Row row, Session session, boolean bl) throws HsqlException {
        if (this.database.isReferentialIntegrity()) {
            this.constraintPath.clear();
            this.checkCascadeDelete(row, session, bl, this.constraintPath);
        }
        if (bl && !row.isDeleted()) {
            this.deleteNoRefCheck(row, session);
        }
    }

    private void deleteNoRefCheck(Object[] objectArray, Session session) throws HsqlException {
        this.fireAll(10, objectArray, null);
        this.deleteNoCheck(objectArray, session, true);
        this.fireAll(7, objectArray, null);
    }

    private void deleteNoRefCheck(Row row, Session session) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(10, objectArray, null);
        this.deleteNoCheck(row, session, true);
        this.fireAll(7, objectArray, null);
    }

    private void deleteNoCheck(Row row, Session session, boolean bl) throws HsqlException {
        Object[] objectArray = row.getData();
        row = row.getUpdatedRow();
        int n = this.iIndexCount - 1;
        while (n >= 0) {
            Node node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row = row.getUpdatedRow();
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    void deleteNoCheck(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        Node node = this.getIndex(0).search(objectArray);
        Row row = node.getRow();
        int n = this.iIndexCount - 1;
        while (n >= 0) {
            node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row = row.getUpdatedRow();
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    void deleteNoCheckRollback(Object[] objectArray, Session session, boolean bl) throws HsqlException {
        Node node = this.getIndex(0).search(objectArray);
        Row row = node.getRow();
        int n = this.iIndexCount - 1;
        while (n >= 0) {
            node = row.getNode(n);
            this.getIndex(n).delete(node);
            --n;
        }
        row = row.getUpdatedRow();
        row.delete();
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    int update(HsqlArrayList hsqlArrayList, Result result, int[] nArray, Session session) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (n < hsqlArrayList.size()) {
            Row row = (Row)hsqlArrayList.get(n);
            this.enforceFieldValueLimits(record.data, nArray);
            this.setIdentityColumn(record.data, null);
            if (this.database.isReferentialIntegrity()) {
                this.constraintPath.clear();
                this.checkCascadeUpdate(row, record.data, session, nArray, null, false, this.constraintPath);
            }
            record = record.next;
            ++n;
        }
        this.fireAll(5);
        record = result.rRoot;
        int n2 = 0;
        while (n2 < hsqlArrayList.size()) {
            Row row = (Row)hsqlArrayList.get(n2);
            hsqlArrayList.set(n2, row.getData());
            this.constraintPath.clear();
            this.checkCascadeUpdate(row, record.data, session, nArray, null, true, this.constraintPath);
            this.deleteNoCheck(row, session, true);
            record = record.next;
            ++n2;
        }
        record = result.rRoot;
        int n3 = 0;
        while (n3 < hsqlArrayList.size()) {
            Object[] objectArray = (Object[])hsqlArrayList.get(n3);
            this.fireAll(11, objectArray, record.data);
            this.insertNoCheck(record.data, session, true);
            this.fireAll(8, objectArray, record.data);
            record = record.next;
            ++n3;
        }
        this.fireAll(2);
        return hsqlArrayList.size();
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName().name)) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = 0;
        int n2 = this.vConstraint.size();
        while (n < n2) {
            Constraint constraint = (Constraint)this.vConstraint.get(n);
            if (constraint.getName().name.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        if (n >= 0) {
            return (Constraint)this.vConstraint.get(n);
        }
        return null;
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.get(n);
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return (Index)this.vIndex.get(n);
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isCached) {
            return this.cache.getRow(n, this);
        }
        return null;
    }

    void addRowToStore(Row row) throws HsqlException {
        if (this.isCached && this.cache != null) {
            this.cache.add((CachedRow)row);
        } else if (this.needsRowID) {
            row.getData()[this.iVisibleColumns] = ValuePool.getInt((int)this.rowIdSequence.getValue());
        }
    }

    void registerRow(CachedRow cachedRow) {
        if (this.needsRowID) {
            cachedRow.getData()[this.iVisibleColumns] = new Integer(cachedRow.iPos);
        }
    }

    void removeRow(CachedRow cachedRow) throws HsqlException {
        if (this.cache != null) {
            this.cache.free(cachedRow);
        }
    }

    /*
     * Unable to fully structure code
     */
    void indexRow(Row var1_1) throws HsqlException {
        block4: {
            var2_2 = 0;
            try {
                var3_3 = null;
                while (var2_2 < this.iIndexCount) {
                    var3_3 = var1_1.getNextNode(var3_3);
                    this.getIndex(var2_2).insert(var3_3);
                    ++var2_2;
                }
                break block4;
            }
            catch (HsqlException var3_4) {
                --var2_2;
                ** while (var2_2 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                var4_5 = var1_1.getNode(var2_2);
                this.getIndex(var2_2).delete(var4_5);
                --var2_2;
                continue;
            }
lbl17:
            // 1 sources

            var1_1.delete();
            throw var3_4;
        }
    }

    void clearAllRows() throws HsqlException {
        Trace.check(this.isTemp, 73);
        this.setIndexRootsNull();
    }

    void drop() throws HsqlException {
        if (this.cache != null && !this.isEmpty()) {
            this.cache.remove(this);
        }
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.filesReadOnly || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        if (this.database == null || this.database.getProperties().isPropertyTrue("hsqldb.catalogs")) {
            return null;
        }
        return this.database.getPath();
    }

    String getSchemaName() {
        if (this.database == null || this.database.getProperties().isPropertyTrue("hsqldb.schemas")) {
            return null;
        }
        if (this.tableType == 0) {
            return "DEFINITION_SCHEMA";
        }
        if (this.tableType == 7) {
            return "INFORMATION_SCHEMA";
        }
        if (this.isTemp) {
            Session session = this.database.sessionManager.getSession(this.ownerSessionId);
            return session != null && session.getId() == this.ownerSessionId ? session.getUsername() : null;
        }
        return "PUBLIC";
    }
}

