/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class TableFilter {
    static final int CONDITION_NONE = -1;
    static final int CONDITION_UNORDERED = 0;
    static final int CONDITION_START_END = 1;
    static final int CONDITION_START = 2;
    static final int CONDITION_END = 3;
    private Table tTable;
    Select sSelect;
    private String sAlias;
    private Index iIndex;
    private Node nCurrent;
    private Object[] oEmptyData;
    private Expression eStart;
    private Expression eEnd;
    Expression eAnd;
    boolean isOuterJoin;
    Object[] oCurrentData;
    Row currentRow;
    boolean nonJoinIsNull;
    boolean isCurrentOuter;

    TableFilter(Table table, String string, boolean bl) {
        this.tTable = table;
        this.sAlias = string != null ? string : table.getName().name;
        this.isOuterJoin = bl;
        this.oEmptyData = this.tTable.getNewRow();
    }

    String getName() {
        return this.sAlias;
    }

    Table getTable() {
        return this.tTable;
    }

    static final int toConditionType(int n) {
        switch (n) {
            case 26: 
            case 27: 
            case 30: {
                return 0;
            }
            case 21: {
                return 1;
            }
            case 22: 
            case 23: {
                return 2;
            }
            case 24: 
            case 25: {
                return 3;
            }
        }
        return -1;
    }

    void setCondition(Expression expression) throws HsqlException {
        int n = expression.getType();
        Expression expression2 = expression.getArg();
        Expression expression3 = expression.getArg2();
        if (n == 28) {
            this.setCondition(expression2);
            this.setCondition(expression3);
            return;
        }
        int n2 = TableFilter.toConditionType(n);
        if (n2 == -1) {
            return;
        }
        if (expression2.getFilter() == this && expression2.getFilter() == expression3.getFilter()) {
            n2 = 0;
        } else if (expression2.getFilter() != this) {
            if (expression3.getFilter() == this && n2 != 0) {
                expression.swapCondition();
                this.setCondition(expression);
                return;
            }
            return;
        }
        Trace.doAssert(expression2.getFilter() == this, "setCondition");
        if (!expression3.isResolved()) {
            return;
        }
        if (n2 == 0) {
            this.addAndCondition(expression);
            return;
        }
        int n3 = expression2.getColumnNr();
        Index index = this.tTable.getIndexForColumn(n3);
        if (index == null || this.iIndex != index && this.iIndex != null) {
            this.addAndCondition(expression);
            return;
        }
        this.iIndex = index;
        switch (n2) {
            case 1: {
                if (this.eStart != null || this.eEnd != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eEnd = this.eStart = new Expression(expression);
                break;
            }
            case 2: {
                if (this.eStart != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eStart = new Expression(expression);
                break;
            }
            case 3: {
                if (this.eEnd != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eEnd = new Expression(expression);
            }
        }
        expression.setTrue();
    }

    boolean findFirst() throws HsqlException {
        if (this.iIndex == null) {
            this.iIndex = this.tTable.getPrimaryIndex();
        }
        if (this.eStart == null) {
            this.nCurrent = this.iIndex.first();
        } else {
            int n = this.eStart.getArg().getDataType();
            Object object = this.eStart.getArg2().getValue(n);
            this.nCurrent = this.iIndex.findFirst(object, this.eStart.getType());
        }
        while (this.nCurrent != null) {
            this.oCurrentData = this.nCurrent.getData();
            this.currentRow = this.nCurrent.getRow();
            if (this.eEnd != null && !this.eEnd.test()) break;
            this.nonJoinIsNull = false;
            this.isCurrentOuter = false;
            if (this.eAnd == null || this.eAnd.test()) {
                return true;
            }
            this.nCurrent = this.iIndex.next(this.nCurrent);
        }
        this.oCurrentData = this.oEmptyData;
        this.currentRow = null;
        return false;
    }

    boolean next() throws HsqlException {
        this.nCurrent = this.iIndex.next(this.nCurrent);
        while (this.nCurrent != null) {
            this.oCurrentData = this.nCurrent.getData();
            this.currentRow = this.nCurrent.getRow();
            if (this.eEnd != null && !this.eEnd.test()) break;
            this.nonJoinIsNull = false;
            this.isCurrentOuter = false;
            if (this.eAnd == null || this.eAnd.test()) {
                return true;
            }
            this.nCurrent = this.iIndex.next(this.nCurrent);
        }
        this.oCurrentData = this.oEmptyData;
        this.currentRow = null;
        return false;
    }

    boolean nextOuter() throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = true;
        this.oCurrentData = this.oEmptyData;
        this.currentRow = null;
        return this.eAnd == null || this.eAnd.test();
    }

    private void addAndCondition(Expression expression) {
        Expression expression2;
        Expression expression3 = new Expression(expression);
        this.eAnd = this.eAnd == null ? expression3 : (expression2 = new Expression(28, this.eAnd, expression3));
        expression.setTrue();
    }

    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Index index = this.iIndex;
        Index index2 = this.tTable.getPrimaryIndex();
        int[] nArray = this.tTable.getPrimaryKey();
        boolean bl2 = false;
        boolean bl3 = bl = this.eStart == null && this.eEnd == null;
        if (index == null) {
            index = index2;
        }
        if (index == index2 && nArray == null) {
            bl2 = true;
            bl = true;
        }
        stringBuffer.append(super.toString()).append('\n');
        stringBuffer.append("table=[").append(this.tTable.getName().name).append("]\n");
        stringBuffer.append("alias=[").append(this.sAlias).append("]\n");
        stringBuffer.append("access=[").append(bl ? "FULL SCAN" : "INDEX PRED").append("]\n");
        stringBuffer.append("index=[");
        stringBuffer.append(index == null ? null : index.getName().name);
        stringBuffer.append(bl2 ? "[HIDDEN]]\n" : "]\n");
        stringBuffer.append("bOuterJoin=[").append(this.isOuterJoin).append("]\n");
        stringBuffer.append("eStart=[").append(this.eStart).append("]\n");
        stringBuffer.append("eEnd=[").append(this.eEnd).append("]\n");
        stringBuffer.append("eAnd=[").append(this.eAnd).append("]\n");
        stringBuffer.append("sSelect=[").append(this.sSelect).append("]");
        return stringBuffer.toString();
    }
}

