/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;

class TableWorks {
    private Table table;

    TableWorks(Table table) {
        this.table = table;
    }

    Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }

    void createForeignKey(int[] nArray, int[] nArray2, HsqlNameManager.HsqlName hsqlName, Table table, int n, int n2) throws HsqlException {
        Index index;
        if (this.table.getConstraint(hsqlName.name) != null) {
            throw Trace.error(60);
        }
        if (this.table.getConstraintForColumns(table, nArray2, nArray) != null) {
            throw Trace.error(60);
        }
        if (table.isTemp() != this.table.isTemp()) {
            throw Trace.error(47, "both tables must be permanent or temporary");
        }
        int n3 = this.table.database.getTableIndex(this.table) - this.table.database.getTableIndex(table);
        Index index2 = index = n3 == 0 ? table.getConstraintIndexForColumns(nArray2, true) : table.getIndexForColumns(nArray2, true);
        if (index == null) {
            throw Trace.error(26, "needs unique index on referenced columns of " + table.getName().statementName);
        }
        Index index3 = this.table.getConstraintIndexForColumns(nArray, false);
        HsqlNameManager.HsqlName hsqlName2 = this.table.database.nameManager.newAutoName("IDX");
        index3 = this.createIndex(nArray, hsqlName2, false);
        hsqlName2 = this.table.database.nameManager.newAutoName("REF", hsqlName.name);
        Constraint constraint = new Constraint(hsqlName2, hsqlName, table, this.table, nArray2, nArray, index, index3, n, n2);
        this.table.addConstraint(constraint);
        table.addConstraint(new Constraint(hsqlName2, constraint));
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl) throws HsqlException {
        Index index;
        if (this.table.isEmpty() || this.table.isIndexingMutable()) {
            index = this.table.createIndex(nArray, hsqlName, bl);
        } else {
            Table table = this.table.moveDefinition(null, null, this.table.getColumnCount(), 0);
            index = table.createIndexStructure(nArray, hsqlName, bl, false);
            table.moveData(this.table, this.table.getColumnCount(), 0);
            table.updateConstraints(this.table, this.table.getColumnCount(), 0);
            int n = this.table.database.getTableIndex(this.table);
            this.table.database.getTables().set(n, table);
            this.table = table;
        }
        this.table.database.indexNameList.addName(index.getName().name, this.table.getName());
        return index;
    }

    void createUniqueConstraint(int[] nArray, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        Object object;
        HsqlArrayList hsqlArrayList = this.table.getConstraints();
        int n = 0;
        int n2 = hsqlArrayList.size();
        while (n < n2) {
            object = (Constraint)hsqlArrayList.get(n);
            if (((Constraint)object).isEquivalent(nArray, 2) || ((Constraint)object).getName().name.equals(hsqlName.name)) {
                throw Trace.error(60);
            }
            ++n;
        }
        object = this.table.database.nameManager.newAutoName("IDX");
        Index index = this.createIndex(nArray, (HsqlNameManager.HsqlName)object, true);
        Constraint constraint = new Constraint(hsqlName, this.table, index);
        this.table.addConstraint(constraint);
        this.resetAutoIndex(index);
    }

    void resetAutoIndex(Index index) throws HsqlException {
        Constraint constraint = this.table.getAutoIndexConstraintForColumns(index.getColumns());
        if (constraint == null) {
            return;
        }
        Index index2 = constraint.getRefIndex();
        constraint.replaceIndex(index2, index);
        this.dropIndex(index2.getName().name);
    }

    void dropIndex(String string) throws HsqlException {
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(string);
        } else {
            Table table = this.table.moveDefinition(string, null, this.table.getColumnCount(), 0);
            table.moveData(this.table, this.table.getColumnCount(), 0);
            table.updateConstraints(this.table, this.table.getColumnCount(), 0);
            int n = this.table.database.getTableIndex(this.table);
            this.table.database.getTables().set(n, table);
            this.table = table;
        }
        this.table.database.indexNameList.removeName(string);
    }

    void addOrDropColumn(Column column, int n, int n2) throws HsqlException {
        if (this.table.isText()) {
            throw Trace.error(73);
        }
        Table table = this.table.moveDefinition(null, column, n, n2);
        table.moveData(this.table, n, n2);
        table.updateConstraints(this.table, n, n2);
        int n3 = this.table.database.getTableIndex(this.table);
        this.table.database.getTables().set(n3, table);
        this.table = table;
    }

    void dropConstraint(String string) throws HsqlException {
        int n = this.table.getConstraintIndex(string);
        Constraint constraint = this.table.getConstraint(string);
        HashSet hashSet = new HashSet();
        if (constraint == null) {
            throw Trace.error(61, string + " in table: " + this.table.getName().name);
        }
        hashSet.add(constraint);
        if (constraint.getType() == 1) {
            throw Trace.error(59);
        }
        if (constraint.getType() == 0) {
            Index index;
            int n2;
            Table table;
            block12: {
                table = constraint.getMain();
                Constraint constraint2 = table.getConstraint(constraint.getPkName());
                hashSet.add(constraint2);
                n2 = table.getConstraintIndex(constraint.getPkName());
                Index index2 = constraint2.getMainIndex();
                if (index2.getName().isReservedIndexName()) {
                    boolean bl = false;
                    try {
                        table.checkDropIndex(index2.getName().name, hashSet);
                        bl = true;
                        TableWorks tableWorks = new TableWorks(table);
                        tableWorks.dropIndex(index2.getName().name);
                        if (table == this.table) {
                            this.table = tableWorks.getTable();
                        }
                    }
                    catch (HsqlException hsqlException) {
                        if (!bl) break block12;
                        throw hsqlException;
                    }
                }
            }
            if ((index = constraint.getRefIndex()).getName().isReservedIndexName()) {
                try {
                    this.table.checkDropIndex(index.getName().name, hashSet);
                    this.dropIndex(index.getName().name);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
            table.vConstraint.remove(n2);
            this.table.vConstraint.remove(n);
        } else if (constraint.getType() == 2) {
            this.table.checkDropIndex(constraint.getMainIndex().getName().name, hashSet);
            this.dropIndex(constraint.getMainIndex().getName().name);
            this.table.vConstraint.remove(n);
        }
    }
}

