/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Binary;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.HsqlException;
import org.hsqldb.JavaObject;
import org.hsqldb.lib.StringConverter;

class TextLogRowOutput
extends DatabaseRowOutput {
    static final byte[] BYTES_NULL = "NULL".getBytes();
    static final byte[] BYTES_TRUE = "TRUE".getBytes();
    static final byte[] BYTES_FALSE = "FALSE".getBytes();
    static final byte[] BYTES_AND = " AND ".getBytes();
    static final int MODE_DELETE = 1;
    static final int MODE_INSERT = 0;
    private boolean isWritten;
    private int logMode;

    TextLogRowOutput() {
    }

    void setMode(int n) {
        this.logMode = n;
    }

    protected void writeFieldPrefix() throws IOException {
        if (this.logMode == 1 && this.isWritten) {
            this.write(BYTES_AND);
        }
    }

    protected void writeChar(String string, int n) throws IOException {
        this.write(39);
        StringConverter.unicodeToAscii(this, string, true);
        this.write(39);
    }

    protected void writeReal(Double d, int n) throws IOException, HsqlException {
        this.writeBytes(Column.createSQLString(d));
    }

    protected void writeSmallint(Number number) throws IOException, HsqlException {
        this.writeBytes(number.toString());
    }

    public void writePos(int n) throws IOException {
    }

    protected void writeTime(Time time) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(time.toString());
        this.write(39);
    }

    protected void writeBinary(Binary binary, int n) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(StringConverter.byteToHex(binary.getBytes()));
        this.write(39);
    }

    public void writeType(int n) throws IOException {
    }

    public void writeSize(int n) throws IOException {
    }

    protected void writeDate(Date date) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(date.toString());
        this.write(39);
    }

    public int getSize(CachedRow cachedRow) throws HsqlException {
        return 0;
    }

    protected void writeInteger(Number number) throws IOException, HsqlException {
        this.writeBytes(number.toString());
    }

    protected void writeBigint(Number number) throws IOException, HsqlException {
        this.writeBytes(number.toString());
    }

    protected void writeNull(int n) throws IOException {
        if (this.logMode == 1) {
            this.write(61);
        } else if (this.isWritten) {
            this.write(44);
        }
        this.isWritten = true;
        this.write(BYTES_NULL);
    }

    protected void writeOther(JavaObject javaObject) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(StringConverter.byteToHex(javaObject.getBytes()));
        this.write(39);
    }

    public void writeString(String string) throws IOException {
        StringConverter.unicodeToAscii(this, string, false);
    }

    protected void writeBit(Boolean bl) throws IOException, HsqlException {
        this.write(bl != false ? BYTES_TRUE : BYTES_FALSE);
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, HsqlException {
        this.writeBytes(bigDecimal.toString());
    }

    protected void writeFieldType(int n) throws IOException {
        if (this.logMode == 1) {
            this.write(61);
        } else if (this.isWritten) {
            this.write(44);
        }
        this.isWritten = true;
    }

    public void writeIntData(int n, int n2) throws IOException {
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, HsqlException {
        this.write(39);
        this.writeBytes(timestamp.toString());
        this.write(39);
    }

    public void writeIntData(int n) throws IOException {
        this.writeBytes(Integer.toString(n));
    }

    public void reset() {
        super.reset();
        this.isWritten = false;
    }
}

