/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;

class Types {
    static final int ARRAY = 2003;
    static final int BIGINT = -5;
    static final int BINARY = -2;
    static final int BIT = -7;
    static final int BLOB = 2004;
    static final int BOOLEAN = 16;
    static final int CHAR = 1;
    static final int CLOB = 2005;
    static final int DATALINK = 70;
    static final int DATE = 91;
    static final int DECIMAL = 3;
    static final int DISTINCT = 2001;
    static final int DOUBLE = 8;
    static final int FLOAT = 6;
    static final int INTEGER = 4;
    static final int JAVA_OBJECT = 2000;
    static final int LONGVARBINARY = -4;
    static final int LONGVARCHAR = -1;
    static final int NULL = 0;
    static final int NUMERIC = 2;
    static final int OTHER = 1111;
    static final int REAL = 7;
    static final int REF = 2006;
    static final int SMALLINT = 5;
    static final int STRUCT = 2002;
    static final int TIME = 92;
    static final int TIMESTAMP = 93;
    static final int TINYINT = -6;
    static final int VARBINARY = -3;
    static final int VARCHAR = 12;
    static final int XML = 137;
    static final int TYPE_SUB_DEFAULT = 1;
    static final int TYPE_SUB_IDENTITY = 2;
    static final int TYPE_SUB_IGNORECASE = 4;
    static final int[][] ALL_TYPES = new int[][]{{2003, 1}, {-5, 1}, {-5, 2}, {-2, 1}, {-7, 1}, {2004, 1}, {16, 1}, {1, 1}, {2005, 1}, {70, 1}, {91, 1}, {3, 1}, {2001, 1}, {8, 1}, {6, 1}, {4, 1}, {4, 2}, {2000, 1}, {-4, 1}, {-1, 1}, {0, 1}, {2, 1}, {1111, 1}, {7, 1}, {2006, 1}, {5, 1}, {2002, 1}, {92, 1}, {93, 1}, {-6, 1}, {-3, 1}, {12, 1}, {12, 4}, {137, 1}};
    static final int SQL_CHARACTER = 1;
    static final int SQL_CHAR = 1;
    static final int SQL_NUMERIC = 2;
    static final int SQL_DECIMAL = 3;
    static final int SQL_DEC = 3;
    static final int SQL_INTEGER = 4;
    static final int SQL_INT = 4;
    static final int SQL_SMALLINT = 5;
    static final int SQL_FLOAT = 6;
    static final int SQL_REAL = 7;
    static final int SQL_DOUBLE = 8;
    static final int SQL_CHARACTER_VARYING = 12;
    static final int SQL_CHAR_VARYING = 12;
    static final int SQL_VARCHAR = 12;
    static final int SQL_BOOLEAN = 16;
    static final int SQL_USER_DEFINED_TYPE = 17;
    static final int SQL_ROW = 19;
    static final int SQL_REF = 20;
    static final int SQL_BIGINT = 25;
    static final int SQL_BINARY_LARGE_OBJECT = 30;
    static final int SQL_BLOB = 30;
    static final int SQL_CHARACTER_LARGE_OBJECT = 40;
    static final int SQL_CLOB = 40;
    static final int SQL_ARRAY = 50;
    static final int SQL_MULTISET = 55;
    static final int SQL_DATE = 91;
    static final int SQL_TIME = 92;
    static final int SQL_TIMESTAMP = 93;
    static final int SQL_TIME_WITH_TIME_ZONE = 94;
    static final int SQL_TIMESTAMP_WITH_TIME_ZONE = 95;
    static final int SQL_INTERVAL_YEAR = 101;
    static final int SQL_INTERVAL_MONTH = 102;
    static final int SQL_INTERVAL_DAY = 103;
    static final int SQL_INTERVAL_HOUR = 104;
    static final int SQL_INTERVAL_MINUTE = 105;
    static final int SQL_INTERVAL_SECOND = 106;
    static final int SQL_INTERVAL_YEAR_TO_MONTH = 107;
    static final int SQL_INTERVAL_DAY_TO_HOUR = 108;
    static final int SQL_INTERVAL_DAY_TO_MINUTE = 109;
    static final int SQL_INTERVAL_DAY_TO_SECOND = 110;
    static final int SQL_INTERVAL_HOUR_TO_MINUTE = 111;
    static final int SQL_INTERVAL_HOUR_TO_SECOND = 112;
    static final int SQL_INTERVAL_MINUTE_TO_SECOND = 113;
    static final int SQL_BIT_VARYING = 15;
    static final int SQL_DATALINK = 70;
    static final int SQL_UDT = 17;
    static final int SQL_UDT_LOCATOR = 18;
    static final int SQL_BLOB_LOCATOR = 31;
    static final int SQL_CLOB_LOCATOR = 41;
    static final int SQL_ARRAY_LOCATOR = 51;
    static final int SQL_MULTISET_LOCATOR = 56;
    static final int SQL_ALL_TYPES = 0;
    static final int SQL_DATETIME = 9;
    static final int SQL_INTERVAL = 10;
    static final int SQL_XML = 137;
    static final int SQL_DISTINCT = 1;
    static final int SQL_SCTRUCTURED = 2;
    static final int VARCHAR_IGNORECASE = 100;
    static IntValueHashMap typeAliases = new IntValueHashMap(67, 1.0f);
    static IntKeyHashMap typeNames;
    static IntValueHashMap javaTypeNames;
    private static HashSet illegalParameterClasses;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$hsqldb$Binary;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;

    Types() {
    }

    static int getTypeNr(String string) throws HsqlException {
        int n = typeAliases.get((Object)string, Integer.MIN_VALUE);
        Trace.check(n != Integer.MIN_VALUE, 16, string);
        return n;
    }

    static String getTypeString(int n) {
        return (String)typeNames.get(n);
    }

    static int getParameterTypeNr(Class clazz) throws HsqlException {
        Trace.doAssert(clazz != null, "c is null");
        if (Void.TYPE.equals(clazz)) {
            return 0;
        }
        String string = clazz.getName();
        String string2 = "Unsupported parameter/return value class: ";
        if (illegalParameterClasses.contains(clazz)) {
            throw Trace.error(16, string2 + string);
        }
        int n = typeAliases.get((Object)string, Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            if (clazz.isArray()) {
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                if (clazz.isPrimitive() || (class$java$io$Serializable == null ? (class$java$io$Serializable = Types.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
                    n = 1111;
                }
            } else if ((class$java$io$Serializable == null ? (class$java$io$Serializable = Types.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
                n = 1111;
            }
        }
        Trace.check(n != Integer.MIN_VALUE, 16, string2, string);
        return n;
    }

    static int getWidestTypeNrNoConvert(Object object) {
        if (object == null) {
            return 0;
        }
        int n = Types.getWidestTypeNrNoConvert(object.getClass());
        if (n == 4) {
            int n2 = ((Number)object).intValue();
            if (n2 >= -128 && n2 <= 127) {
                n = -6;
            } else if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
                n = 5;
            }
        }
        return n;
    }

    static int getWidestTypeNrNoConvert(Class clazz) {
        if (clazz == null || Void.TYPE.equals(clazz)) {
            return 0;
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = Types.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(clazz)) {
            return -7;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
            return -1;
        }
        if ((class$org$hsqldb$Binary == null ? (class$org$hsqldb$Binary = Types.class$("org.hsqldb.Binary")) : class$org$hsqldb$Binary).equals(clazz)) {
            return -4;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = Types.class$("java.lang.Integer")) : class$java$lang$Integer).equals(clazz)) {
            return 4;
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = Types.class$("java.lang.Long")) : class$java$lang$Long).equals(clazz)) {
            return -5;
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = Types.class$("java.lang.Double")) : class$java$lang$Double).equals(clazz)) {
            return 8;
        }
        if ((class$java$sql$Date == null ? (class$java$sql$Date = Types.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(clazz)) {
            return 91;
        }
        if ((class$java$sql$Time == null ? (class$java$sql$Time = Types.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(clazz)) {
            return 92;
        }
        if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Types.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(clazz)) {
            return 93;
        }
        if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Types.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(clazz)) {
            return 3;
        }
        return 1111;
    }

    static boolean areSimilar(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (Types.isNumberType(n)) {
            return Types.isNumberType(n2);
        }
        if (Types.isCharacterType(n)) {
            return Types.isCharacterType(n2);
        }
        if (Types.isBinaryType(n)) {
            return Types.isBinaryType(n2);
        }
        return false;
    }

    static boolean haveSameInternalRepresentation(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (Types.isCharacterType(n)) {
            return Types.isCharacterType(n2);
        }
        if (Types.isBinaryType(n)) {
            return Types.isBinaryType(n2);
        }
        switch (n) {
            case -6: 
            case 4: 
            case 5: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 2: 
            case 3: {
                switch (n2) {
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    static boolean promotesWithoutConversion(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (Types.isCharacterType(n)) {
            return Types.isCharacterType(n2);
        }
        if (Types.isBinaryType(n)) {
            return Types.isBinaryType(n2);
        }
        switch (n) {
            case -6: {
                switch (n2) {
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (n2) {
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 2: 
            case 3: {
                switch (n2) {
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    static boolean isNumberType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    static boolean isExactNumberType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    static boolean isStrictlyIntegralNumberType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    static boolean isApproximateNumberType(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    static boolean isCharacterType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    static boolean isBinaryType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    static boolean isDatetimeType(int n) {
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    static boolean acceptsPrecisionCreateParam(int n) {
        switch (n) {
            case -3: 
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 12: 
            case 100: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    static int numericPrecisionCreateParamRadix(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 10;
            }
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    static boolean acceptsScaleCreateParam(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        typeAliases.put("INTEGER", 4);
        typeAliases.put("INT", 4);
        typeAliases.put("int", 4);
        typeAliases.put("java.lang.Integer", 4);
        typeAliases.put("IDENTITY", 4);
        typeAliases.put("DOUBLE", 8);
        typeAliases.put("double", 8);
        typeAliases.put("java.lang.Double", 8);
        typeAliases.put("FLOAT", 6);
        typeAliases.put("REAL", 7);
        typeAliases.put("VARCHAR", 12);
        typeAliases.put("java.lang.String", 12);
        typeAliases.put("CHAR", 1);
        typeAliases.put("CHARACTER", 1);
        typeAliases.put("LONGVARCHAR", -1);
        typeAliases.put("VARCHAR_IGNORECASE", 100);
        typeAliases.put("DATE", 91);
        typeAliases.put("java.sql.Date", 91);
        typeAliases.put("TIME", 92);
        typeAliases.put("java.sql.Time", 92);
        typeAliases.put("TIMESTAMP", 93);
        typeAliases.put("java.sql.Timestamp", 93);
        typeAliases.put("DATETIME", 93);
        typeAliases.put("DECIMAL", 3);
        typeAliases.put("java.math.BigDecimal", 3);
        typeAliases.put("NUMERIC", 2);
        typeAliases.put("BIT", -7);
        typeAliases.put("boolean", -7);
        typeAliases.put("java.lang.Boolean", -7);
        typeAliases.put("TINYINT", -6);
        typeAliases.put("byte", -6);
        typeAliases.put("java.lang.Byte", -6);
        typeAliases.put("SMALLINT", 5);
        typeAliases.put("short", 5);
        typeAliases.put("java.lang.Short", 5);
        typeAliases.put("BIGINT", -5);
        typeAliases.put("long", -5);
        typeAliases.put("java.lang.Long", -5);
        typeAliases.put("BINARY", -2);
        typeAliases.put("[B", -2);
        typeAliases.put("VARBINARY", -3);
        typeAliases.put("LONGVARBINARY", -4);
        typeAliases.put("OTHER", 1111);
        typeAliases.put("OBJECT", 1111);
        typeAliases.put("java.lang.Object", 1111);
        typeAliases.put("NULL", 0);
        typeAliases.put("void", 0);
        typeAliases.put("java.lang.Void", 0);
        typeNames = new IntKeyHashMap(37);
        typeNames.put(0, "NULL");
        typeNames.put(4, "INTEGER");
        typeNames.put(8, "DOUBLE");
        typeNames.put(100, "VARCHAR_IGNORECASE");
        typeNames.put(12, "VARCHAR");
        typeNames.put(1, "CHAR");
        typeNames.put(-1, "LONGVARCHAR");
        typeNames.put(91, "DATE");
        typeNames.put(92, "TIME");
        typeNames.put(3, "DECIMAL");
        typeNames.put(-7, "BIT");
        typeNames.put(-6, "TINYINT");
        typeNames.put(5, "SMALLINT");
        typeNames.put(-5, "BIGINT");
        typeNames.put(7, "REAL");
        typeNames.put(6, "FLOAT");
        typeNames.put(2, "NUMERIC");
        typeNames.put(93, "TIMESTAMP");
        typeNames.put(-2, "BINARY");
        typeNames.put(-3, "VARBINARY");
        typeNames.put(-4, "LONGVARBINARY");
        typeNames.put(1111, "OBJECT");
        illegalParameterClasses = new HashSet(13);
        illegalParameterClasses.add(Byte.TYPE);
        illegalParameterClasses.add(Short.TYPE);
        illegalParameterClasses.add(Float.TYPE);
        illegalParameterClasses.add(class$java$lang$Byte == null ? (class$java$lang$Byte = Types.class$("java.lang.Byte")) : class$java$lang$Byte);
        illegalParameterClasses.add(class$java$lang$Short == null ? (class$java$lang$Short = Types.class$("java.lang.Short")) : class$java$lang$Short);
        illegalParameterClasses.add(class$java$lang$Float == null ? (class$java$lang$Float = Types.class$("java.lang.Float")) : class$java$lang$Float);
    }
}

