/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;

class View
extends Table {
    String sStatement = "";

    View(Database database, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        super(database, hsqlName, 6, 0);
        this.isReadOnly = true;
    }

    void addColumns(Result result) throws HsqlException {
        int n = 0;
        while (n < result.getColumnCount()) {
            String string = result.metaData.sTable[n];
            Table table = this.database.findUserTable(string);
            if (table != null && table.isTemp()) {
                throw Trace.error(22);
            }
            if (result.metaData.sLabel[n] == null) {
                result.metaData.sLabel[n] = "COL_" + String.valueOf(n);
            }
            ++n;
        }
        super.addColumns(result);
        this.iVisibleColumns = this.iColumnCount;
    }

    void setStatement(String string) throws HsqlException {
        int n;
        String string2;
        Tokenizer tokenizer = new Tokenizer(string);
        do {
            n = tokenizer.getPosition();
        } while ((string2 = tokenizer.getString()).length() != 0 || tokenizer.wasValue());
        this.sStatement = string.substring(0, n).trim();
    }

    String getStatement() {
        return this.sStatement;
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        throw Trace.error(55);
    }
}

