/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Server;
import org.hsqldb.resources.BundleHandler;

public class WebServer
extends Server {
    static int webBundleHandle = BundleHandler.getBundleHandle("webserver", null);

    public WebServer() {
        super(0);
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length > 0 && (string = stringArray[0]) != null && string.startsWith("-?")) {
            Server.printHelp("webserver.help");
            return;
        }
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        hsqlProperties.setPropertyIfNotExists("server.no_system_exit", "false");
        WebServer webServer = new WebServer();
        String string2 = webServer.getDefaultPropertiesPath();
        webServer.print("Invoked from main() method");
        webServer.print("Loading properties from [" + string2 + "]");
        if (!webServer.putPropertiesFromFile(string2)) {
            webServer.print("Could not load properties from file");
            webServer.print("Using cli/default properties only");
        }
        webServer.setProperties(hsqlProperties);
        webServer.start();
    }

    public int getDefaultPort(boolean bl) {
        return bl ? 443 : 80;
    }

    public String getDefaultPropertiesPath() {
        return new File("webserver").getAbsolutePath();
    }

    public String getDefaultWebPage() {
        return this.serverProperties.getProperty("server.default_page");
    }

    public String getHelpString() {
        return BundleHandler.getString(Server.serverBundleHandle, "webserver.help");
    }

    public String getProductName() {
        return "HSQLDB web server";
    }

    public String getProtocol() {
        return this.isTls() ? "HTTPS" : "HTTP";
    }

    public String getWebRoot() {
        return this.serverProperties.getProperty("server.root");
    }
}

