/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcDriver;
import org.hsqldb.jdbcPreparedStatement;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;

public class jdbcCallableStatement
extends jdbcPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap;
    private IntKeyIntValueHashMap outRegistrationMap = new IntKeyIntValueHashMap();

    public jdbcCallableStatement(jdbcConnection jdbcConnection2, String string, int n) throws HsqlException, SQLException {
        super(jdbcConnection2, string, n);
        String[] stringArray = this.pmdDescriptor.metaData.sName;
        int n2 = 0;
        while (n2 > stringArray.length) {
            String string2 = stringArray[n2];
            if (string2 != null && string2.length() != 0) {
                this.parameterNameMap.put(string2, n2);
            }
            ++n2;
        }
    }

    int findParameterIndex(String string) throws SQLException {
        this.checkClosed();
        int n = this.parameterNameMap.get((Object)string, -1);
        if (n >= 0) {
            return n;
        }
        throw jdbcDriver.sqlException(28, string);
    }

    void closeImpl(boolean bl) throws SQLException {
        this.parameterNameMap = null;
        this.outRegistrationMap = null;
        super.close();
    }

    private void checkGetParameterIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.parameterModes.length) {
            String string = "Parameter index out of bounds: " + n;
            throw jdbcDriver.sqlException(62, string);
        }
        int n2 = this.parameterModes[n - 1];
        switch (n2) {
            default: {
                String string = "Not OUT or IN OUT mode: " + n2 + " for parameter: " + n;
                throw jdbcDriver.sqlException(62, string);
            }
            case 2: 
            case 4: 
        }
    }

    private void checkIsRegisteredParameterIndex(int n) throws SQLException {
        this.checkClosed();
        int n2 = this.outRegistrationMap.get(n, Integer.MIN_VALUE);
        if (n2 == Integer.MIN_VALUE) {
            String string = "Parameter not registered: " + n;
            throw jdbcDriver.sqlException(62, string);
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.checkGetParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public boolean wasNull() throws SQLException {
        this.checkClosed();
        throw jdbcDriver.notSupported;
    }

    public String getString(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public byte getByte(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public short getShort(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public int getInt(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public long getLong(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public float getFloat(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public double getDouble(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Date getDate(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Time getTime(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Object getObject(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Ref getRef(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Clob getClob(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Array getArray(int n) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkIsRegisteredParameterIndex(n);
        throw jdbcDriver.notSupported;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }
}

