/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.Trace;
import org.hsqldb.jdbcDriver;
import org.hsqldb.lib.AsciiStringInputStream;

public class jdbcClob
implements Clob {
    private String data;

    jdbcClob(String string) throws SQLException {
        this.data = string;
    }

    public InputStream getAsciiStream() throws SQLException {
        return new AsciiStringInputStream(this.data);
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.data);
    }

    public String getSubString(long l, int n) throws SQLException {
        try {
            return this.data.substring((int)l, n);
        }
        catch (Exception exception) {
            throw jdbcDriver.sqlException(Trace.error(40, exception.getMessage()));
        }
    }

    public long position(String string, long l) throws SQLException {
        try {
            return this.data.indexOf(string, (int)l);
        }
        catch (Exception exception) {
            throw jdbcDriver.sqlException(Trace.error(40, exception.getMessage()));
        }
    }

    public long position(Clob clob, long l) throws SQLException {
        try {
            return this.position(clob.getSubString(0L, (int)clob.length()), l);
        }
        catch (Exception exception) {
            throw jdbcDriver.sqlException(Trace.error(40, exception.getMessage()));
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public int setString(long l, String string) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public long length() throws SQLException {
        return this.data.length();
    }

    public void truncate(long l) throws SQLException {
        try {
            this.data = this.data.substring(0, (int)l);
        }
        catch (Exception exception) {
            throw jdbcDriver.sqlException(Trace.error(40, exception.getMessage()));
        }
    }
}

