/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HTTPClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.jdbcCallableStatement;
import org.hsqldb.jdbcDatabaseMetaData;
import org.hsqldb.jdbcDriver;
import org.hsqldb.jdbcPreparedStatement;
import org.hsqldb.jdbcStatement;
import org.hsqldb.lib.StringUtil;

public class jdbcConnection
implements Connection {
    HsqlProperties connProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    boolean isClosed;
    private SQLWarning rootWarning;
    private Object rootWarning_mutex = new Object();

    public Statement createStatement() throws SQLException {
        this.checkClosed();
        jdbcStatement jdbcStatement2 = new jdbcStatement(this, 1003);
        return jdbcStatement2;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, string, 1003);
            return jdbcPreparedStatement2;
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            jdbcCallableStatement jdbcCallableStatement2 = new jdbcCallableStatement(this, string, 1003);
            return jdbcCallableStatement2;
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.length() == 0 || string.indexOf(123) == -1) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string);
        int n4 = 0;
        while (n4 < n2) {
            char c = stringBuffer.charAt(n4);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        break;
                    }
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (c != '{') break;
                    stringBuffer.setCharAt(n4++, ' ');
                    n4 = StringUtil.skipSpaces(string, n4);
                    if (string.regionMatches(true, n4, "fn ", 0, 3) || string.regionMatches(true, n4, "oj ", 0, 3) || string.regionMatches(true, n4, "ts ", 0, 3)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "d ", 0, 2) || string.regionMatches(true, n4, "t ", 0, 2)) {
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "call ", 0, 5)) {
                        n4 += 4;
                    } else if (string.regionMatches(true, n4, "?= call ", 0, 8)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                        n4 += 5;
                    } else if (string.regionMatches(true, n4, "escape ", 0, 7)) {
                        n4 += 6;
                    } else {
                        String string2 = "Unknown JDBC escape sequence: {" + string.substring(--n4);
                        throw new SQLException(string2, "S0010", 62);
                    }
                    ++n3;
                    n = 3;
                    break;
                }
                case 1: 
                case 4: {
                    if (c != '\'') break;
                    --n;
                    break;
                }
                case 2: 
                case 5: {
                    if (c != '\"') break;
                    n -= 2;
                    break;
                }
                case 3: {
                    if (c == '\'') {
                        n = 4;
                        break;
                    }
                    if (c == '\"') {
                        n = 5;
                        break;
                    }
                    if (c == '}') {
                        stringBuffer.setCharAt(n4, ' ');
                        n = --n3 == 0 ? 0 : 3;
                        break;
                    }
                    if (c != '{') break;
                    stringBuffer.setCharAt(n4++, ' ');
                    if (string.regionMatches(true, n4, "fn ", 0, 3) || string.regionMatches(true, n4, "oj ", 0, 3) || string.regionMatches(true, n4, "ts ", 0, 3)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "d ", 0, 2) || string.regionMatches(true, n4, "t ", 0, 2)) {
                        stringBuffer.setCharAt(n4++, ' ');
                    } else if (string.regionMatches(true, n4, "call ", 0, 5)) {
                        n4 += 4;
                    } else if (string.regionMatches(true, n4, "?= call ", 0, 8)) {
                        stringBuffer.setCharAt(n4++, ' ');
                        stringBuffer.setCharAt(n4++, ' ');
                        n4 += 5;
                    } else if (string.regionMatches(true, n4, "escape ", 0, 7)) {
                        n4 += 6;
                    } else {
                        String string3 = "Unknown JDBC escape sequence: {" + string.substring(--n4);
                        throw new SQLException(string3, "S0010", 62);
                    }
                    ++n3;
                    n = 3;
                }
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public void commit() throws SQLException {
        try {
            this.sessionProxy.commit();
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.sessionProxy.rollback();
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.sessionProxy.close();
        this.sessionProxy = null;
        this.rootWarning = null;
        this.connProperties = null;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new jdbcDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.sessionProxy.setReadOnly(bl);
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.sessionProxy.isReadOnly();
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.checkClosed();
    }

    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        if (n != 1) {
            throw jdbcDriver.notSupported;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 1;
    }

    public SQLWarning getWarnings() throws SQLException {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.checkClosed();
            SQLWarning sQLWarning = this.rootWarning;
            return sQLWarning;
        }
    }

    public void clearWarnings() throws SQLException {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.checkClosed();
            this.rootWarning = null;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        jdbcStatement jdbcStatement2 = new jdbcStatement(this, n);
        return jdbcStatement2;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        try {
            jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, string, n);
            return jdbcPreparedStatement2;
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        try {
            jdbcCallableStatement jdbcCallableStatement2 = new jdbcCallableStatement(this, string, n);
            return jdbcCallableStatement2;
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        throw jdbcDriver.notSupported;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        throw jdbcDriver.notSupported;
    }

    jdbcConnection(HsqlProperties hsqlProperties) throws SQLException {
        boolean bl;
        String string = hsqlProperties.getProperty("user");
        String string2 = hsqlProperties.getProperty("password");
        boolean bl2 = hsqlProperties.isPropertyTrue("ifexists");
        String string3 = hsqlProperties.getProperty("connection_type");
        String string4 = hsqlProperties.getProperty("host");
        int n = hsqlProperties.getIntegerProperty("port", 0);
        String string5 = hsqlProperties.getProperty("path");
        String string6 = hsqlProperties.getProperty("database");
        boolean bl3 = bl = string3 == "hsqls://" || string3 == "https://";
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        try {
            if (string3 == "file:" || string3 == "mem:" || string3 == "res:") {
                this.sessionProxy = DatabaseManager.newSession(string3, string6, string, string2, bl2);
            } else if (string3 == "hsql://" || string3 == "hsqls://") {
                this.sessionProxy = new HSQLClientConnection(string4, n, string5, string6, bl, string, string2);
            } else if (string3 == "http://" || string3 == "https://") {
                this.sessionProxy = new HTTPClientConnection(string4, n, string5, string6, bl, string, string2);
            }
            this.connProperties = hsqlProperties;
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    jdbcConnection(Session session) throws HsqlException {
        this.isInternal = true;
        this.sessionProxy = session;
    }

    public void finalize() {
        block2: {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                if (!Trace.TRACE) break block2;
                Trace.trace(sQLException.toString());
            }
        }
    }

    String getURL() throws SQLException {
        this.checkClosed();
        return this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw jdbcDriver.sqlException(2);
        }
    }

    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    void clearWarningsNoCheck() {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    int xlateRSType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: {
                return n;
            }
            case 1005: {
                String string = "TYPE_SCROLL_SENSITIVE => TYPE_SCROLL_SENSITIVE";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1004;
            }
        }
        String string = "ResultSet type: " + n;
        throw jdbcDriver.sqlException(62, string);
    }

    int xlateRSConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: {
                return n;
            }
            case 1008: {
                String string = "CONCUR_UPDATABLE => CONCUR_READ_ONLY";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1007;
            }
        }
        String string = "ResultSet concurrency: " + n;
        throw jdbcDriver.sqlException(62, string);
    }

    int xlateRSHoldability(int n) throws SQLException {
        switch (n) {
            case 1: {
                return n;
            }
            case 2: {
                String string = "CLOSE_CURSORS_AT_COMMIT => HOLD_CURSORS_OVER_COMMIT";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1;
            }
        }
        String string = "ResultSet holdability: " + n;
        throw jdbcDriver.sqlException(62, string);
    }
}

