/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbcConnection;

public class jdbcDriver
implements Driver {
    static final int MAJOR = 1;
    static final int MINOR = 7;
    static final int REVISION = 2;
    static final String VERSION = "1.7.2";
    static final String PRODUCT = "HSQL Database Engine";
    static final SQLException notSupported;
    static final SQLException notSupportedJDBC3;

    static final void throwError(HsqlException hsqlException) throws SQLException {
        throw new SQLException(hsqlException.message, hsqlException.state, hsqlException.code);
    }

    static final void throwError(Result result) throws SQLException {
        throw new SQLException(result.getMainString(), result.getSubString(), result.getStatementID());
    }

    static final SQLException sqlException(HsqlException hsqlException) {
        return new SQLException(hsqlException.message, hsqlException.state, hsqlException.code);
    }

    static final SQLException sqlException(int n) {
        return jdbcDriver.sqlException(Trace.error(n));
    }

    static final SQLException sqlException(int n, String string) {
        return jdbcDriver.sqlException(Trace.error(n, string));
    }

    static final SQLException sqlException(int n, int n2, Object[] objectArray) {
        return jdbcDriver.sqlException(Trace.error(n, n2, objectArray));
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        return jdbcDriver.getConnection(string, properties);
    }

    static Connection getConnection(String string, Properties properties) throws SQLException {
        HsqlProperties hsqlProperties = DatabaseManager.parseURL(string, true);
        if (hsqlProperties == null) {
            throw new SQLException(Trace.getMessage(62));
        }
        hsqlProperties.addProperties(properties);
        return new jdbcConnection(hsqlProperties);
    }

    public boolean acceptsURL(String string) {
        return string != null && string.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length());
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        String[] stringArray = new String[]{"true", "false"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[4];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.value = properties.getProperty("user");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.value = properties.getProperty("password");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
        driverPropertyInfo.value = properties.getProperty("get_column_name", "true");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("ifexists", null);
        driverPropertyInfo.value = properties.getProperty("ifexists");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("toupper_column_name", null);
        driverPropertyInfo.value = properties.getProperty("toupper_column_name");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 7;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        block2: {
            notSupported = jdbcDriver.sqlException(Trace.error(20));
            notSupportedJDBC3 = jdbcDriver.sqlException(Trace.error(20, "JDBC3"));
            try {
                DriverManager.registerDriver(new jdbcDriver());
            }
            catch (Exception exception) {
                if (!Trace.TRACE) break block2;
                Trace.trace(exception.getMessage());
            }
        }
    }
}

