/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.hsqldb.Binary;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcDriver;
import org.hsqldb.jdbcResultSet;
import org.hsqldb.jdbcResultSetMetaData;
import org.hsqldb.jdbcStatement;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.store.ValuePool;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    protected Object[] parameterValues;
    protected int[] parameterTypes;
    protected int[] parameterModes;
    protected Result rsmdDescriptor;
    protected Result pmdDescriptor;
    protected jdbcResultSetMetaData rsmd;
    protected Object pmd;
    protected String sql;
    protected int statementID;
    protected int compiledStatementType;
    protected boolean isRowCount;

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
    }

    public synchronized boolean execute() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        if (this.compiledStatementType == 0) {
            return super.execute(this.sql);
        }
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
        if (this.resultIn.iMode == 2) {
            jdbcDriver.throwError(this.resultIn);
        }
        return this.resultIn.iMode == 3;
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(false);
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
        if (this.resultIn.iMode == 2) {
            jdbcDriver.throwError(this.resultIn);
        } else if (this.resultIn.iMode != 3) {
            String string = "Expected but did not recieve a result set";
            throw jdbcDriver.sqlException(85, string);
        }
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties);
    }

    public synchronized int executeUpdate() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.checkIsRowCount(true);
        if (this.compiledStatementType == 0) {
            return super.executeUpdate(this.sql);
        }
        this.resultIn = null;
        try {
            this.resultOut.setParameterData(this.parameterValues);
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
        if (this.resultIn.iMode == 2) {
            jdbcDriver.throwError(this.resultIn);
        } else if (this.resultIn.iMode != 1) {
            String string = "Expected but did not recieve a row update count";
            throw jdbcDriver.sqlException(85, string);
        }
        return this.resultIn.getUpdateCount();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, null, n2, false);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, bl ? Boolean.TRUE : Boolean.FALSE, -7, false);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, ValuePool.getInt(by), -6, false);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, ValuePool.getInt(s), 5, false);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, ValuePool.getInt(n2), 4, false);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, ValuePool.getLong(l), -5, false);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, ValuePool.getDouble(Double.doubleToLongBits(f)), 8, false);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, ValuePool.getDouble(Double.doubleToLongBits(d)), 8, false);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, bigDecimal, 3, true);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, string, -1, true);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, byArray == null ? null : new Binary(byArray), -4, false);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, date, 91, true);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, time, 92, false);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, timestamp, 93, false);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (inputStream == null) {
            String string = "input stream is null";
            throw jdbcDriver.sqlException(62, string);
        }
        String string = null;
        try {
            string = StringConverter.inputStreamToString(inputStream);
        }
        catch (IOException iOException) {
            throw jdbcDriver.sqlException(81);
        }
        this.setParameter(n, string, -1, true);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (inputStream == null) {
            String string = "input stream is null";
            throw jdbcDriver.sqlException(62, string);
        }
        int n3 = n2 / 2;
        int n4 = 0;
        char[] cArray = new char[n3];
        try {
            while (n4 < n3) {
                int n5;
                int n6 = inputStream.read();
                if (n6 != -1 && (n5 = inputStream.read()) != -1) {
                    cArray[n4] = (char)(n6 << 8 | n5);
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw jdbcDriver.sqlException(19);
        }
        String string = new String(cArray, 0, n4);
        this.setParameter(n, string, -1, true);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (inputStream == null) {
            String string = "input stream is null";
            throw jdbcDriver.sqlException(62, string);
        }
        byte[] byArray = new byte[n2];
        try {
            n3 = inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw jdbcDriver.sqlException(34, iOException.getMessage());
        }
        if (n3 < n2) {
            byte[] byArray2 = byArray;
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        this.setParameter(n, new Binary(byArray), -4, false);
    }

    public synchronized void clearParameters() throws SQLException {
        this.checkClosed();
        ArrayUtil.fillArray(this.parameterValues, null);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public void setObject(int n, Object object) throws SQLException {
        boolean bl;
        int n2;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (object == null) {
            n2 = 0;
            bl = false;
        } else if (object instanceof byte[]) {
            object = new Binary((byte[])object);
            n2 = -4;
            bl = false;
        } else {
            n2 = Types.getWidestTypeNrNoConvert(object);
            bl = true;
        }
        this.setParameter(n, object, n2, bl);
    }

    public synchronized void addBatch() throws SQLException {
        this.checkClosed();
        this.checkAddBatch();
        int n = this.parameterValues.length;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n);
        this.batchResultOut.add(objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (reader == null) {
            String string = "reader is null";
            throw jdbcDriver.sqlException(62, string);
        }
        char[] cArray = new char[n2];
        try {
            n3 = reader.read(cArray);
            if (n3 == -1) {
                throw new IOException("End of stream with no data read");
            }
        }
        catch (IOException iOException) {
            throw jdbcDriver.sqlException(19, iOException.toString());
        }
        this.setParameter(n, new String(cArray, 0, n3), -1, true);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkClosed();
        this.checkSetParameterIndex(n);
        throw jdbcDriver.notSupportedJDBC3;
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (blob == null) {
            this.setParameter(n, null, -4, false);
            return;
        }
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l;
            throw jdbcDriver.sqlException(34, string);
        }
        int n2 = (int)l;
        byte[] byArray = new byte[n2];
        try {
            n2 = blob.getBinaryStream().read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw jdbcDriver.sqlException(34, iOException.getMessage());
        }
        if ((long)n2 < l) {
            byte[] byArray2 = byArray;
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        this.setParameter(n, new Binary(byArray), -4, false);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        int n2;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (clob == null) {
            this.setParameter(n, null, -1, true);
            return;
        }
        long l = clob.length();
        if (l > Integer.MAX_VALUE) {
            String string = "Maximum Clob input character length exceeded: " + l;
            throw jdbcDriver.sqlException(34, string);
        }
        char[] cArray = new char[(int)l];
        try {
            n2 = clob.getCharacterStream().read(cArray);
            if (n2 == -1) {
                throw new IOException("End of stream with no data read");
            }
        }
        catch (IOException iOException) {
            throw jdbcDriver.sqlException(19, iOException.toString());
        }
        this.setParameter(n, new String(cArray, 0, n2), -1, true);
    }

    public void setArray(int n, Array array) throws SQLException {
        int n2;
        Object object;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        Object object2 = object = array == null ? null : array.getArray();
        if (object == null) {
            n2 = 0;
        } else if (object instanceof byte[]) {
            object = new Binary((byte[])object);
            n2 = -4;
        } else {
            n2 = 1111;
        }
        this.setParameter(n, object, n2, false);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.isRowCount) {
            return null;
        }
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this.rsmdDescriptor, this.connection.connProperties);
        }
        return this.rsmd;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        String string;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (date == null) {
            string = null;
        } else {
            try {
                string = HsqlDateTime.getDateString(date, calendar);
            }
            catch (Exception exception) {
                throw jdbcDriver.sqlException(7, exception.getMessage());
            }
        }
        this.setParameter(n, string, -1, true);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        String string;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (time == null) {
            string = null;
        } else {
            try {
                string = HsqlDateTime.getTimeString(time, calendar);
            }
            catch (Exception exception) {
                throw jdbcDriver.sqlException(7, exception.getMessage());
            }
        }
        this.setParameter(n, string, -1, true);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        String string;
        this.checkSetParameterIndex(n);
        this.checkClosed();
        if (timestamp == null) {
            string = null;
        } else {
            try {
                string = HsqlDateTime.getTimestampString(timestamp, calendar);
            }
            catch (Exception exception) {
                throw jdbcDriver.sqlException(7, exception.getMessage());
            }
        }
        this.setParameter(n, string, -1, true);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkSetParameterIndex(n);
        this.checkClosed();
        this.setParameter(n, null, n2, false);
    }

    jdbcPreparedStatement(jdbcConnection jdbcConnection2, String string, int n) throws HsqlException, SQLException {
        super(jdbcConnection2, n);
        string = jdbcConnection2.nativeSQL(string);
        this.compiledStatementType = jdbcPreparedStatement.guessCompiledStatementType(string);
        if (this.compiledStatementType == 0) {
            this.isRowCount = true;
            this.parameterModes = new int[0];
            this.parameterTypes = this.parameterModes;
            this.parameterValues = new Object[0];
            this.sql = string;
            return;
        }
        this.resultOut.setResultType(65555);
        this.resultOut.setMainString(string);
        this.resultOut.setStatementType(this.compiledStatementType);
        Result result = this.connection.sessionProxy.execute(this.resultOut);
        if (result.iMode == 2) {
            jdbcDriver.throwError(result);
        }
        Iterator iterator = result.iterator();
        try {
            Object[] objectArray = (Object[])iterator.next();
            this.statementID = ((Result)objectArray[0]).getStatementID();
            objectArray = (Object[])iterator.next();
            this.rsmdDescriptor = (Result)objectArray[0];
            this.isRowCount = this.rsmdDescriptor.iMode == 1;
            objectArray = (Object[])iterator.next();
            this.pmdDescriptor = (Result)objectArray[0];
            this.parameterTypes = this.pmdDescriptor.metaData.getParameterTypes();
            this.parameterValues = new Object[this.parameterTypes.length];
            this.parameterModes = this.pmdDescriptor.metaData.paramMode;
        }
        catch (Exception exception) {
            throw Trace.error(40, exception.toString());
        }
        this.resultOut = new Result(65548, this.parameterTypes, this.statementID);
        this.batchResultOut = new Result(9, this.parameterTypes, this.statementID);
        this.sql = string;
    }

    protected void checkIsRowCount(boolean bl) throws SQLException {
        if (bl != this.isRowCount) {
            String string = "Statement does not generate a " + (bl ? "row count" : "result set");
            throw jdbcDriver.sqlException(38, string);
        }
    }

    protected void checkSetParameterIndex(int n) throws SQLException {
        if (n < 1 || n > this.parameterValues.length) {
            String string = "parameter index out of range: " + n;
            throw jdbcDriver.sqlException(62, string);
        }
        int n2 = this.parameterModes[n - 1];
        switch (n2) {
            default: {
                String string = "Not IN or IN OUT mode: " + n2 + " for parameter: " + n;
                throw jdbcDriver.sqlException(62, string);
            }
            case 1: 
            case 2: 
        }
    }

    private static boolean promotesWithoutConversion(int n, int n2) {
        return n == 1111 || n2 == 1111 ? false : Types.promotesWithoutConversion(n, n2);
    }

    protected synchronized void setParameter(int n, Object object, int n2, boolean bl) throws SQLException {
        boolean bl2;
        --n;
        if (object == null) {
            this.parameterValues[n] = null;
            return;
        }
        int n3 = this.parameterTypes[n];
        boolean bl3 = bl2 = !jdbcPreparedStatement.promotesWithoutConversion(n2, n3);
        if (bl2) {
            try {
                object = Column.convertObject(object, n3);
            }
            catch (HsqlException hsqlException) {
                jdbcDriver.throwError(hsqlException);
            }
        }
        this.parameterValues[n] = this.isNetConn || !bl2 && !bl ? object : ValuePool.getObject(object);
    }

    public void addBatch(String string) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public boolean execute(String string) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public int executeUpdate(String string) throws SQLException {
        throw jdbcDriver.notSupported;
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        HsqlException hsqlException = null;
        try {
            if (!this.connection.isClosed) {
                this.connection.sessionProxy.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        this.parameterValues = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.rsmdDescriptor = null;
        this.pmdDescriptor = null;
        this.rsmd = null;
        this.pmd = null;
        super.close();
        if (hsqlException != null) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuffer.append("[closed]");
            return stringBuffer.toString();
        }
        stringBuffer.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuffer.append(", parameters=[");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append('[');
                stringBuffer.append(objectArray[n]);
                stringBuffer.append("], ");
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void checkAddBatch() throws SQLException {
        if (this.compiledStatementType == 0) {
            String string = "prepared DDL statements do not support batch execution";
            throw jdbcDriver.sqlException(38, string);
        }
    }

    static int guessCompiledStatementType(String string) throws SQLException {
        if (string == null) {
            return 0;
        }
        Tokenizer tokenizer = new Tokenizer(string);
        int n = -1;
        try {
            n = Token.get(tokenizer.getString());
        }
        catch (HsqlException hsqlException) {
            jdbcDriver.throwError(hsqlException);
        }
        switch (n) {
            case 13: 
            case 21: 
            case 48: {
                return 7;
            }
            case 39: {
                return 8;
            }
            case 6: {
                return 6;
            }
        }
        return 0;
    }
}

