/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.DITypeInfo;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbcColumnMetaData;
import org.hsqldb.jdbcDriver;
import org.hsqldb.jdbcResultSet;

public class jdbcResultSetMetaData
implements ResultSetMetaData {
    public static final int MIN_DISPLAY_SIZE = 1;
    public static final int MAX_DISPLAY_SIZE = 255;
    public static final int MAX_SCAN = 512;
    private jdbcColumnMetaData[] columnMetaData;
    private int columnCount;
    private boolean useColumnName;
    private static final boolean TRACE = false;

    jdbcResultSetMetaData(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        this.init(jdbcResultSet2, hsqlProperties);
    }

    jdbcResultSetMetaData(Result result, HsqlProperties hsqlProperties) throws SQLException {
        this.init(result, hsqlProperties);
    }

    void init(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        if (jdbcResultSet2 == null) {
            throw jdbcDriver.sqlException(40, 119, null);
        }
        this.init(jdbcResultSet2.rResult, hsqlProperties);
    }

    void init(Result result, HsqlProperties hsqlProperties) throws SQLException {
        if (result == null) {
            throw jdbcDriver.sqlException(40, 120, null);
        }
        if (result.iMode != 3) {
            return;
        }
        this.columnCount = result.getColumnCount();
        this.useColumnName = hsqlProperties.isPropertyTrue("get_column_name");
        this.columnMetaData = new jdbcColumnMetaData[this.columnCount];
        Result.ResultMetaData resultMetaData = result.metaData;
        DITypeInfo dITypeInfo = new DITypeInfo();
        int n = 0;
        while (n < this.columnCount) {
            Integer n2;
            int n3;
            jdbcColumnMetaData jdbcColumnMetaData2;
            this.columnMetaData[n] = jdbcColumnMetaData2 = new jdbcColumnMetaData();
            jdbcColumnMetaData2.catalogName = resultMetaData.sCatalog[n] == null ? "" : resultMetaData.sCatalog[n];
            jdbcColumnMetaData2.schemaName = resultMetaData.sSchema[n] == null ? "" : resultMetaData.sSchema[n];
            jdbcColumnMetaData2.tableName = resultMetaData.sTable[n] == null ? "" : resultMetaData.sTable[n];
            jdbcColumnMetaData2.columnName = resultMetaData.sName[n] == null ? "" : resultMetaData.sName[n];
            jdbcColumnMetaData2.columnLabel = resultMetaData.sLabel[n] == null ? "" : resultMetaData.sLabel[n];
            jdbcColumnMetaData2.columnType = resultMetaData.colType[n];
            jdbcColumnMetaData2.columnTypeName = Types.getTypeString(jdbcColumnMetaData2.columnType);
            jdbcColumnMetaData2.columnClassName = resultMetaData.sClassName[n];
            jdbcColumnMetaData2.isWritable = resultMetaData.isWritable[n];
            jdbcColumnMetaData2.isReadOnly = !jdbcColumnMetaData2.isWritable;
            jdbcColumnMetaData2.isAutoIncrement = resultMetaData.isIdentity[n];
            jdbcColumnMetaData2.isNullable = resultMetaData.nullability[n];
            int n4 = jdbcColumnMetaData2.columnType;
            if (jdbcColumnMetaData2.columnType == 100) {
                n4 = 12;
                n3 = 4;
            } else {
                n3 = jdbcColumnMetaData2.isAutoIncrement ? 2 : 1;
            }
            dITypeInfo.setTypeCode(n4);
            dITypeInfo.setTypeSub(n3);
            if (jdbcColumnMetaData2.columnClassName == null || jdbcColumnMetaData2.columnClassName.length() == 0) {
                jdbcColumnMetaData2.columnClassName = dITypeInfo.getColStClsName();
            }
            jdbcColumnMetaData2.precision = (n2 = dITypeInfo.getPrecision()) == null ? 0 : n2;
            Boolean bl = dITypeInfo.isUnsignedAttribute();
            jdbcColumnMetaData2.isSigned = bl != null && bl == false;
            Boolean bl2 = dITypeInfo.isCaseSensitive();
            jdbcColumnMetaData2.isCaseSensitive = bl2 != null && bl2 != false;
            Integer n5 = dITypeInfo.getSearchability();
            jdbcColumnMetaData2.isSearchable = n5 != null && n5 != 0;
            jdbcColumnMetaData2.columnDisplaySize = dITypeInfo.getMaxDisplaySize();
            if (jdbcColumnMetaData2.columnDisplaySize > 0 && jdbcColumnMetaData2.columnDisplaySize <= 1) {
                jdbcColumnMetaData2.columnDisplaySize = 1;
            } else if (jdbcColumnMetaData2.columnDisplaySize > 255) {
                int n6 = 0;
                int n7 = 1;
                Record record = result.rRoot;
                while (record != null && n6 < 512) {
                    int n8;
                    String string = null;
                    try {
                        string = (String)Column.convertObject(record.data[n], 1);
                    }
                    catch (Exception exception) {
                        break;
                    }
                    int n9 = n8 = string == null ? 3 : string.length();
                    if (n8 >= 255) {
                        n7 = 255;
                        break;
                    }
                    if (n8 > n7) {
                        n7 = n8;
                    }
                    ++n6;
                    record = record.next;
                }
                jdbcColumnMetaData2.columnDisplaySize = n7;
            }
            ++n;
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isAutoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isCaseSensitive;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isSearchable;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isCurrency;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isNullable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isSigned;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnDisplaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnLabel;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumn(n);
        return this.useColumnName ? this.columnMetaData[n].columnName : this.columnMetaData[--n].columnLabel;
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].schemaName;
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].precision;
    }

    public int getScale(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].scale;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].tableName;
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].catalogName;
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumn(n);
        int n2 = this.columnMetaData[--n].columnType;
        return n2 == 100 ? 12 : n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnTypeName;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isReadOnly;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isWritable;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].isDefinitelyWritable;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnMetaData[--n].columnClassName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.columnCount == 0) {
            stringBuffer.append("[columnCount=0]");
            return stringBuffer.toString();
        }
        stringBuffer.append('[');
        int n = 0;
        while (n < this.columnCount) {
            stringBuffer.append('\n');
            stringBuffer.append("   column_");
            stringBuffer.append(n + 1);
            stringBuffer.append('=');
            stringBuffer.append(this.columnMetaData[n]);
            if (n + 1 < this.columnCount) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            ++n;
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw jdbcDriver.sqlException(28, String.valueOf(n));
        }
    }
}

