/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.jdbcConnection;
import org.hsqldb.jdbcDriver;
import org.hsqldb.jdbcResultSet;

public class jdbcStatement
implements Statement {
    private boolean isClosed;
    private boolean isEscapeProcessing = true;
    protected jdbcConnection connection;
    protected int iMaxRows;
    protected Result resultIn;
    protected int rsType = 1003;
    protected Result resultOut = new Result(65547);
    protected Result batchResultOut = new Result(8);
    protected final boolean isNetConn;

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties);
    }

    public int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        if (this.resultIn == null || this.resultIn.iMode == 3) {
            throw new SQLException("executeUpdate() cannot be used with this statement");
        }
        if (this.resultIn.iMode == 2) {
            jdbcDriver.throwError(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
    }

    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.iMaxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkClosed();
        this.iMaxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.checkClosed();
    }

    public void cancel() throws SQLException {
        this.checkClosed();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    public boolean execute(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        return this.resultIn.iMode == 3;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultIn == null || this.resultIn.iMode != 3 ? null : new jdbcResultSet(this, this.resultIn, this.connection.connProperties);
    }

    public int getUpdateCount() throws SQLException {
        return this.resultIn == null || this.resultIn.iMode == 3 ? -1 : this.resultIn.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        this.resultIn = null;
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        if (n != 1000) {
            throw jdbcDriver.notSupported;
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkClosed();
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.batchResultOut.add(new Object[]{string});
    }

    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batchResultOut.setRows(null);
    }

    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        if (this.batchResultOut.getSize() == 0) {
            throw jdbcDriver.sqlException(62, "Empty batch");
        }
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
        }
        catch (HsqlException hsqlException) {
            this.batchResultOut.setRows(null);
            throw jdbcDriver.sqlException(hsqlException);
        }
        this.batchResultOut.setRows(null);
        int[] nArray = this.resultIn.getUpdateCounts();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == -3) {
                throw new BatchUpdateException(nArray);
            }
            ++n;
        }
        return nArray;
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    jdbcStatement(jdbcConnection jdbcConnection2, int n) {
        this.connection = jdbcConnection2;
        this.rsType = n;
        this.isNetConn = jdbcConnection2.sessionProxy instanceof HSQLClientConnection;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw jdbcDriver.sqlException(126);
        }
        if (this.connection.isClosed) {
            throw jdbcDriver.sqlException(2);
        }
    }

    private void fetchResult(String string) throws SQLException {
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.resultIn = null;
        this.resultOut.setMainString(string);
        this.resultOut.setMaxRows(this.iMaxRows);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            if (this.resultIn.iMode == 2) {
                throw new HsqlException(this.resultIn);
            }
        }
        catch (HsqlException hsqlException) {
            throw jdbcDriver.sqlException(hsqlException);
        }
    }
}

