/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlArrayList
extends BaseList
implements HsqlList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    private Object[] elementData;

    public HsqlArrayList() {
        this.elementData = new Object[10];
    }

    public HsqlArrayList(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        this.elementData = n == 0 ? new Object[1] : new Object[n];
        this.elementCount = 0;
    }

    public void add(int n, Object object) {
        if (n > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + ">" + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        int n2 = this.elementCount;
        while (n2 > n) {
            this.elementData[n2] = this.elementData[n2 - 1];
            --n2;
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public boolean add(Object object) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = object;
        ++this.elementCount;
        return true;
    }

    public Object get(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        return this.elementData[n];
    }

    public Object remove(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        Object object = this.elementData[n];
        int n2 = n;
        while (n2 < this.elementCount - 1) {
            this.elementData[n2] = this.elementData[n2 + 1];
            ++n2;
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        return object;
    }

    public Object set(int n, Object object) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        Object[] objectArray = new Object[(int)((float)this.elementData.length * 2.0f)];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementData.length);
        this.elementData = objectArray;
        objectArray = null;
    }

    public void trim() {
        Object[] objectArray = null;
        objectArray = this.elementCount == 0 ? new Object[1] : new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
        objectArray = null;
    }

    public void clear() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public void setSize(int n) {
        if (n < this.elementCount) {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = null;
                ++n2;
            }
        }
        this.elementCount = n;
        while (this.elementCount > this.elementData.length) {
            this.increaseCapacity();
        }
    }

    public Object toArray(Object object) {
        if (Array.getLength(object) < this.elementCount) {
            object = Array.newInstance(object.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, object, 0, this.elementCount);
        return object;
    }

    public void remove(Object object) {
        int n = 0;
        while (n < this.elementCount) {
            if (object == null && this.elementData[n] == null || object.equals(this.elementData[n])) {
                this.remove(n);
                return;
            }
            ++n;
        }
    }
}

